package code;
 /** 
 *  Used to store meta information about a stored byte range 
 **/ 
public class MetaBody{

 /** 
 *  Data members 
 **/ 
  private ObjId objId;
  private long offset;
  private long length;

 /** 
 *  Constructor 
 **/ 
  public
  MetaBody(ObjId objId, long offset, long length){
    this.objId = objId;
    this.offset = offset;
    this.length = length;
  }

 /** 
 *  Return the object ID 
 **/ 
  public ObjId
  getObjId(){
    return(this.objId);
  }

 /** 
 *  Return the offset 
 **/ 
  public long
  getOffset(){
    return(this.offset);
  }

 /** 
 *  Return the length 
 **/ 
  public long
  getLength(){
    return(this.length);
  }

 /** 
 *  equals -- compares two meta bodies 
 **/ 
  public boolean
  equals(Object o) {
    if(!(o instanceof MetaBody)) {
      return false;
    }

    MetaBody other = (MetaBody) o;
    if(this.objId.equals(other.objId) &&
       this.offset == other.offset &&
       this.length == other.length){
      return true;
    }
    
    return false;
  }
  
 /** 
 *  toString 
 **/ 
  public String toString(){
    return "(" + this.objId.toString() + ", " + this.offset + ", " + this.length + ")";
  }
}
