package code;
//package utils.junit;

import junit.textui.TestRunner;
import junit.framework.*;
import java.io.ObjectOutputStream;
import java.io.ObjectInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
/**
 * TBD: Update class name
 */
public class MultiObjPreciseInvUnit extends TestCase {
  public static final String TEST_ALL_TEST_TYPE = "UNIT";
  
  /**
   * Basic constructor - called by the test runners.
   * TBD: Update constructor name to match class
   */
  public MultiObjPreciseInvUnit (final String s) {
    super (s);
  }

  /*
   * Fixtures are run before and after each test case
   * to set up environment in which tests must run.
   */
  protected void setUp() throws Exception{
    super.setUp();
    /* 
     * TBD: Insert other fixture code here
     * e.g., this.objectUnderTest = new ClassToBeTested(...);
     */
  }

  protected void tearDown() throws Exception{
    /* 
     * TBD: Insert other fixture cleanup code here
     */
    super.tearDown();
  }

 /** 
 *  Test simple methods
 
 **/ 
 public void
  test1(){
    AcceptStamp as1 = null;
    AcceptStamp rtAS1 = null;
    MOITBoundEntry[] be1 = null;
    MultiObjInvalTarget moit1 = null;
    MultiObjPreciseInv mopi1 = null;
    ObjInvalTarget[] invs = null;
    ObjInvalTarget[] dels = null;

    invs = new ObjInvalTarget[1];
    invs[0] = new ObjInvalTarget(new ObjId("/a"), 10, 10);
    dels = new ObjInvalTarget[0];
    moit1 = new MultiObjInvalTarget(invs, dels);
    as1 = new AcceptStamp(100, new NodeId(1));
    rtAS1 = new AcceptStamp(200, new NodeId(1));
    be1 = new MOITBoundEntry[1];
    be1[0] = new MOITBoundEntry(invs[0],
                                1.0,
                                new ImmutableBytes(new byte[10]));
    mopi1 = new MultiObjPreciseInv(moit1, as1, rtAS1, false, be1);
    assert(!mopi1.isEmbargoed());
    assert(mopi1.getAcceptStamp().equals(new AcceptStamp(100, new NodeId(1))));
    assert(mopi1.getRTAcceptStamp().getNodeId().equals(new NodeId(1)));
    assert(mopi1.getRTAcceptStamp().getLocalClock() == 200);
    assert(mopi1.getMultiObjInvalTarget().equals(moit1));
    assert(mopi1.getInvalTarget() == moit1);
    assert(mopi1.getStartVV().includes(as1));
    assert(mopi1.getEndVV().includes(as1));
    assert(mopi1.getRTVV().includes(rtAS1));
    assert(mopi1.getOneWriterSubsetFrom(new NodeId(1), 100) == mopi1);
    assert(mopi1.getOneWriterSubsetFrom(new NodeId(1), 200) == null);
    assert(mopi1.isBound());
    assert(mopi1.isPrecise());
    assert(!mopi1.isDelete());
    assert(mopi1.getStart() == 100);
    assert(mopi1.getEnd() == 100);
    assert(mopi1.getReal() == 200);
    assert(mopi1.getNodeId().equals(new NodeId(1)));
    assert(mopi1.cloneChopStartTime(100).equals(mopi1));
    assert(mopi1.cloneChopEndTime(100).equals(mopi1));
    assert(mopi1.equals(mopi1));
  }

 /** 
 *  Test cloneIntersectInvaltargetChopStartEnd()
 
 **/ 
  public void
  test2(){
    AcceptStamp as1 = null;
    AcceptStamp as2 = null;
    AcceptStamp rtAS1 = null;
    MOITBoundEntry[] be1 = null;
    MultiObjInvalTarget moit1 = null;
    MultiObjPreciseInv mopi1 = null;
    MultiObjPreciseInv mopi2 = null;
    ObjInvalTarget[] invs = null;
    ObjInvalTarget[] dels = null;
    ImpreciseInv ipi1 = null;
    HierInvalTarget hit1 = null;
    AcceptVV startVV1 = null;
    AcceptVV endVV1 = null;
    AcceptStamp[] asArr1 = null;
    AcceptStamp[] asArr2 = null;
    GeneralInv gi1 = null;
    InvalTarget it1 = null;
    SingleWriterImpreciseInv swii1 = null;

    // Test1: Expect a PreciseInv from cloneIntersectInvaltargetChopStartEnd()
    invs = new ObjInvalTarget[1];
    invs[0] = new ObjInvalTarget(new ObjId("/a"), 10, 10);
    dels = new ObjInvalTarget[0];
    moit1 = new MultiObjInvalTarget(invs, dels);
    as1 = new AcceptStamp(100, new NodeId(1));
    rtAS1 = new AcceptStamp(200, new NodeId(1));
    be1 = new MOITBoundEntry[1];
    be1[0] = new MOITBoundEntry(invs[0],
                                1.0,
                                new ImmutableBytes(new byte[10]));
    mopi1 = new MultiObjPreciseInv(moit1, as1, rtAS1, false, be1);

    hit1 = HierInvalTarget.makeHierInvalTarget("/a");
    asArr1 = new AcceptStamp[2];
    asArr1[0] = new AcceptStamp(100, new NodeId(1));
    asArr1[1] = new AcceptStamp(100, new NodeId(2));
    startVV1 = new AcceptVV(asArr1);
    endVV1 = new AcceptVV(asArr1);
    ipi1 = new ImpreciseInv(hit1, startVV1, endVV1);
    // Expect a PreciseInv in return
    gi1 = mopi1.cloneIntersectInvaltargetChopStartEnd(ipi1);
    asArr2 = new AcceptStamp[1];
    asArr2[0] = new AcceptStamp(100, new NodeId(1));
    assert(gi1.getStartVV().equals(new AcceptVV(asArr2)));
    assert(gi1.getEndVV().equals(new AcceptVV(asArr2)));
    assert(gi1 instanceof PreciseInv);
    assert(((PreciseInv)gi1).getObjInvalTarget().equals(invs[0]));
    assert(mopi1.equals(mopi1));

    // Test2: Expect an ImpreciseInv from
    //   cloneIntersectInvaltargetChopStartEnd()
    invs = new ObjInvalTarget[1];
    invs[0] = new ObjInvalTarget(new ObjId("/a"), 10, 10);
    dels = new ObjInvalTarget[1];
    dels[0] = new ObjInvalTarget(new ObjId("/a/b"), 20, 30);
    moit1 = new MultiObjInvalTarget(invs, dels);
    as1 = new AcceptStamp(100, new NodeId(1));
    rtAS1 = new AcceptStamp(200, new NodeId(1));
    be1 = new MOITBoundEntry[1];
    be1[0] = new MOITBoundEntry(invs[0],
                                1.0,
                                new ImmutableBytes(new byte[10]));
    mopi1 = new MultiObjPreciseInv(moit1, as1, rtAS1, false, be1);

    hit1 = HierInvalTarget.makeHierInvalTarget("/a:/a/*");
    asArr1 = new AcceptStamp[2];
    asArr1[0] = new AcceptStamp(100, new NodeId(1));
    asArr1[1] = new AcceptStamp(100, new NodeId(2));
    startVV1 = new AcceptVV(asArr1);
    endVV1 = new AcceptVV(asArr1);
    ipi1 = new ImpreciseInv(hit1, startVV1, endVV1);
    // Expect an ImpreciseInv in return
    gi1 = mopi1.cloneIntersectInvaltargetChopStartEnd(ipi1);
    assert(gi1 instanceof SingleWriterImpreciseInv);
    it1 = ((SingleWriterImpreciseInv)gi1).getInvalTarget();
    assert(it1.equals(HierInvalTarget.makeHierInvalTarget("/a:/a/b")));

    // Test3: Expect a MOPI from cloneIntersectInvaltargetChopStartEnd()
    invs = new ObjInvalTarget[1];
    invs[0] = new ObjInvalTarget(new ObjId("/a"), 10, 10);
    dels = new ObjInvalTarget[1];
    dels[0] = new ObjInvalTarget(new ObjId("/a/b"), 20, 30);
    moit1 = new MultiObjInvalTarget(invs, dels);
    as1 = new AcceptStamp(100, new NodeId(1));
    rtAS1 = new AcceptStamp(200, new NodeId(1));
    be1 = new MOITBoundEntry[0];
    mopi1 = new MultiObjPreciseInv(moit1, as1, rtAS1, false, be1);

    mopi2 = new MultiObjPreciseInv(moit1, as1, rtAS1, false, be1);
    gi1 = mopi1.cloneIntersectInvaltargetChopStartEnd(mopi2);
    asArr2 = new AcceptStamp[1];
    asArr2[0] = new AcceptStamp(100, new NodeId(1));
    assert(gi1.getStartVV().equals(new AcceptVV(asArr2)));
    assert(gi1.getEndVV().equals(new AcceptVV(asArr2)));
    assert(gi1 instanceof MultiObjPreciseInv);
    assert(((MultiObjPreciseInv)gi1).getInvalTarget().equals(moit1));
  }

  //-------------------------------------------------------------------------
  // Test newUnion()
  //-------------------------------------------------------------------------
  public void
  test3(){
    MultiObjPreciseInv mopi1 = null;
    MultiObjPreciseInv mopi2 = null;
    ObjInvalTarget[] invs = null;
    ObjInvalTarget[] dels = null;
    MultiObjInvalTarget moit1 = null;
    AcceptStamp as1 = null;
    AcceptStamp as2 = null;
    AcceptStamp rtAS1 = null;
    AcceptStamp rtAS2 = null;
    MOITBoundEntry[] be1 = null;
    GeneralInv gi1 = null;
    SubscriptionSet ss1 = null;
    HierInvalTarget hit1 = null;
    HierInvalTarget hit2 = null;
    AcceptStamp[] asArr1 = null;
    AcceptStamp[] asArr2 = null;
    ImpreciseInv ipi1 = null;
    AcceptVV avv1 = null;
    AcceptVV avv2 = null;

    // Test 1: newUnion of MOPI and MOPI (should be HierInvalTarget)
    invs = new ObjInvalTarget[1];
    invs[0] = new ObjInvalTarget(new ObjId("/a"), 10, 10);
    dels = new ObjInvalTarget[0];
    moit1 = new MultiObjInvalTarget(invs, dels);
    as1 = new AcceptStamp(100, new NodeId(1));
    rtAS1 = new AcceptStamp(200, new NodeId(1));
    be1 = new MOITBoundEntry[0];
    mopi1 = new MultiObjPreciseInv(moit1, as1, rtAS1, false, be1);

    as2 = new AcceptStamp(100, new NodeId(2));
    rtAS2 = new AcceptStamp(200, new NodeId(2));
    mopi2 = new MultiObjPreciseInv(moit1, as2, rtAS2, false, be1);
    ss1 = SubscriptionSet.makeSubscriptionSet(":/*");
    gi1 = mopi1.newUnion(mopi2, ss1);
    assert(gi1 instanceof ImpreciseInv);
    assert(gi1.getInvalTarget() instanceof HierInvalTarget);
    hit1 = (HierInvalTarget)gi1.getInvalTarget();
    assert(hit1.getChildren().size() == 1);
    assert(hit1.getChild("a") != null);

    // Test 2: newUnion of MOPI and HierInvalTarget
    invs = new ObjInvalTarget[1];
    invs[0] = new ObjInvalTarget(new ObjId("/a/b"), 10, 10);
    dels = new ObjInvalTarget[0];
    moit1 = new MultiObjInvalTarget(invs, dels);
    as1 = new AcceptStamp(100, new NodeId(1));
    rtAS1 = new AcceptStamp(200, new NodeId(1));
    be1 = new MOITBoundEntry[0];
    mopi1 = new MultiObjPreciseInv(moit1, as1, rtAS1, false, be1);

    hit1 = HierInvalTarget.makeHierInvalTarget("/a/*");
    asArr1 = new AcceptStamp[1];
    asArr1[0] = new AcceptStamp(100, new NodeId(1));
    asArr2 = new AcceptStamp[1];
    asArr2[0] = new AcceptStamp(200, new NodeId(1));
    avv1 = new AcceptVV(asArr1);
    avv2 = new AcceptVV(asArr2);
    ipi1 = new ImpreciseInv(hit1, avv1, avv2, avv2);
    ss1 = SubscriptionSet.makeSubscriptionSet(":/*");
    gi1 = mopi1.newUnion(ipi1, ss1);
    assert(gi1 instanceof ImpreciseInv);
    hit2 = (HierInvalTarget)gi1.getInvalTarget();
    assert(gi1.getStartVV().equals(avv1));
    assert(gi1.getEndVV().equals(avv2));
    assert(hit2.getChildren().size() == 1);
    assert(hit2.getChild("a") != null);
  }

  //-------------------------------------------------------------------------
  // Test getBEIntersection()
  //-------------------------------------------------------------------------
  public void
  test4(){
    MOITBoundEntry[] moitBE1 = null;
    MOITBoundEntry[] moitBE2 = null;
    MOITBoundEntry[] moitBE3 = null;

    moitBE1 = new MOITBoundEntry[2];
    moitBE2 = new MOITBoundEntry[2];
    moitBE1[0] = new MOITBoundEntry(new ObjInvalTarget(new ObjId("/a"),
                                                       10,
                                                       10),
                                    5.6,
                                    new ImmutableBytes(new byte[10]));
    moitBE1[1] = new MOITBoundEntry(new ObjInvalTarget(new ObjId("/b"),
                                                       20,
                                                       10),
                                    5.6,
                                    new ImmutableBytes(new byte[10]));
    moitBE2[0] = new MOITBoundEntry(new ObjInvalTarget(new ObjId("/c"),
                                                       30,
                                                       10),
                                    6.8,
                                    new ImmutableBytes(new byte[10]));
    moitBE2[1] = new MOITBoundEntry(new ObjInvalTarget(new ObjId("/b"),
                                                       20,
                                                       10),
                                    8.9,
                                    new ImmutableBytes(new byte[10]));
    moitBE3 = MultiObjPreciseInv.getBEIntersection(moitBE1, moitBE2);
    assert(moitBE3.length == 1);
    /*
      for(int i = 0; i < moitBE3.length; i++){
      System.out.println("" + moitBE3[i].getObjInvalTarget() +
      ", " + moitBE3[i].getPriority() +
      ", " + moitBE3[i].getImmutableBytes().getLength());
      }
    */
    assert(moitBE3[0].equals(moitBE1[1]));
  }

 /** 
 *  Test the constructor that accepts an array MultiWriteEntry
 
 **/ 
  public void
  test5(){
    MultiWriteEntry[] mwe = null;
    MultiObjInvalTarget moit1 = null;
    MultiObjPreciseInv mopi1 = null;
    MultiObjPreciseInv mopi2 = null;
    ObjInvalTarget[] invs = null;
    ObjInvalTarget[] dels = null;
    MOITBoundEntry[] be1 = null;
    // Test 1
    mwe = new MultiWriteEntry[1];
    mwe[0] = new MultiWriteEntry(new ObjId("/a"),
                                 10,
                                 10,
                                 2.6,
                                 new ImmutableBytes(new byte[10]),
                                 true,
                                 false);
    mopi1 = new MultiObjPreciseInv(mwe, 
                                   new AcceptStamp(100, new NodeId(1)),
                                   new AcceptStamp(200, new NodeId(1)),
                                   false);
    invs = new ObjInvalTarget[1];
    invs[0] = new ObjInvalTarget(new ObjId("/a"), 10, 10);
    dels = new ObjInvalTarget[0];
    moit1 = new MultiObjInvalTarget(invs, dels);
    assert(!mopi1.isEmbargoed());
    assert(mopi1.getInvalTarget().equals(moit1));
    assert(mopi1.getAcceptStamp().equals(new AcceptStamp(100, new NodeId(1))));
    assert(mopi1.getRTAcceptStamp().equals(new AcceptStamp(200,
                                                           new NodeId(1))));
    assert(moit1.equals(mopi1.getInvalTarget()));
    assert(mopi1.getInvalTarget().equals(moit1));
    assert(mopi1.isBound());
    assert(!mopi1.isDelete());

    // Test 2
    mwe = new MultiWriteEntry[4];
    mwe[0] = new MultiWriteEntry(new ObjId("/a"),
                                 10,
                                 10,
                                 2.6,
                                 new ImmutableBytes(new byte[10]),
                                 true,
                                 false);
    mwe[1] = new MultiWriteEntry(new ObjId("/b"),
                                 20,
                                 30,
                                 4.8,
                                 new ImmutableBytes(new byte[30]),
                                 false,
                                 true);
    mwe[2] = new MultiWriteEntry(new ObjId("/c"),
                                 5,
                                 30,
                                 8.6,
                                 new ImmutableBytes(new byte[30]),
                                 false,
                                 false);
    mwe[3] = new MultiWriteEntry(new ObjId("/d"),
                                 40,
                                 30,
                                 8.6,
                                 new ImmutableBytes(new byte[30]),
                                 true,
                                 false);
    mopi1 = new MultiObjPreciseInv(mwe, 
                                   new AcceptStamp(100, new NodeId(1)),
                                   new AcceptStamp(200, new NodeId(1)),
                                   false);

    // Build an equivalent MOIT
    invs = new ObjInvalTarget[3];
    invs[0] = new ObjInvalTarget(new ObjId("/a"), 10, 10);
    invs[1] = new ObjInvalTarget(new ObjId("/c"), 5, 30);
    invs[2] = new ObjInvalTarget(new ObjId("/d"), 40, 30);
    dels = new ObjInvalTarget[1];
    dels[0] = new ObjInvalTarget(new ObjId("/b"), 20, 30);
    moit1 = new MultiObjInvalTarget(invs, dels);

    // Build an equivalent MOITBoundEntries[]
    be1 = new MOITBoundEntry[2];
    be1[0] = new MOITBoundEntry(new ObjInvalTarget(new ObjId("/a"), 10, 10),
                                2.6,
                                new ImmutableBytes(new byte[10]));
    be1[1] = new MOITBoundEntry(new ObjInvalTarget(new ObjId("/d"), 40, 30),
                                8.6,
                                new ImmutableBytes(new byte[30]));
    mopi2 = new MultiObjPreciseInv(moit1,
                                   new AcceptStamp(100, new NodeId(1)),
                                   new AcceptStamp(200, new NodeId(1)),
                                   false,
                                   be1);
    assert(mopi1.equals(mopi2));
    assert(mopi2.equals(mopi1));
  }

 /** 
 *  Test hasBoundEntry()
 
 **/ 
  public void
  test6(){
    MultiObjInvalTarget moit1 = null;
    ObjInvalTarget[] invs = null;
    ObjInvalTarget[] dels = null;
    MOITBoundEntry[] be1 = null;
    MultiObjPreciseInv mopi1 = null;

    // Test 1
    invs = new ObjInvalTarget[1];
    invs[0] = new ObjInvalTarget(new ObjId("/a"), 10, 10);
    dels = new ObjInvalTarget[0];
    moit1 = new MultiObjInvalTarget(invs, dels);
    be1 = new MOITBoundEntry[1];
    be1[0] = new MOITBoundEntry(new ObjInvalTarget(new ObjId("/a"), 10, 10),
                                5.6,
                                new ImmutableBytes(new byte[10]));
    mopi1 = new MultiObjPreciseInv(moit1,
                                   new AcceptStamp(100, new NodeId(1)),
                                   new AcceptStamp(200, new NodeId(1)),
                                   false,
                                   be1);
    assert(mopi1.hasBoundEntry(new ObjInvalTarget(new ObjId("/a"), 10, 10)));
    assert(!mopi1.hasBoundEntry(new ObjInvalTarget(new ObjId("/b"), 5, 5)));
    assert(!mopi1.hasBoundEntry(new ObjInvalTarget(new ObjId("/a"), 10, 20)));

    // Test 2
    invs = new ObjInvalTarget[3];
    invs[0] = new ObjInvalTarget(new ObjId("/a"), 10, 10);
    invs[1] = new ObjInvalTarget(new ObjId("/b"), 20, 5);
    invs[2] = new ObjInvalTarget(new ObjId("/c"), 25, 20);
    dels = new ObjInvalTarget[0];
    moit1 = new MultiObjInvalTarget(invs, dels);
    be1 = new MOITBoundEntry[2];
    be1[0] = new MOITBoundEntry(new ObjInvalTarget(new ObjId("/a"), 10, 10),
                                5.6,
                                new ImmutableBytes(new byte[10]));
    be1[1] = new MOITBoundEntry(new ObjInvalTarget(new ObjId("/b"), 5, 5),
                                7.8,
                                new ImmutableBytes(new byte[5]));
    mopi1 = new MultiObjPreciseInv(moit1,
                                   new AcceptStamp(100, new NodeId(1)),
                                   new AcceptStamp(200, new NodeId(1)),
                                   false,
                                   be1);
    assert(mopi1.hasBoundEntry(new ObjInvalTarget(new ObjId("/a"), 10, 10)));
    assert(mopi1.hasBoundEntry(new ObjInvalTarget(new ObjId("/b"), 5, 5)));
    assert(!mopi1.hasBoundEntry(new ObjInvalTarget(new ObjId("/a"), 10, 20)));
    assert(!mopi1.hasBoundEntry(new ObjInvalTarget(new ObjId("/c"), 7, 3)));
  }

 /** 
 *  Test cloneRemoveBoundEntry(), cloneUnbound()
 
 **/ 
  public void
  test7(){
    MultiObjInvalTarget moit1 = null;
    ObjInvalTarget[] invs = null;
    ObjInvalTarget[] dels = null;
    MOITBoundEntry[] be1 = null;
    MultiObjPreciseInv mopi1 = null;
    MultiObjPreciseInv mopi2 = null;
    MultiObjPreciseInv mopi3 = null;

    // Test 1
    invs = new ObjInvalTarget[1];
    invs[0] = new ObjInvalTarget(new ObjId("/a"), 10, 10);
    dels = new ObjInvalTarget[0];
    moit1 = new MultiObjInvalTarget(invs, dels);
    be1 = new MOITBoundEntry[1];
    be1[0] = new MOITBoundEntry(new ObjInvalTarget(new ObjId("/a"), 10, 10),
                                5.6,
                                new ImmutableBytes(new byte[10]));
    mopi1 = new MultiObjPreciseInv(moit1,
                                   new AcceptStamp(100, new NodeId(1)),
                                   new AcceptStamp(200, new NodeId(1)),
                                   false,
                                   be1);
    mopi2 = mopi1.cloneRemoveBoundEntry(new ObjInvalTarget(new ObjId("/a"),
                                                           10,
                                                           10));
    assert(!mopi2.isBound());
    assert(mopi1.hasBoundEntry(new ObjInvalTarget(new ObjId("/a"), 10, 10)));
    assert(!mopi2.hasBoundEntry(new ObjInvalTarget(new ObjId("/a"), 10, 10)));
    assert(!mopi1.hasBoundEntry(new ObjInvalTarget(new ObjId("/b"), 5, 5)));
    assert(!mopi2.hasBoundEntry(new ObjInvalTarget(new ObjId("/b"), 5, 5)));
    assert(!mopi1.hasBoundEntry(new ObjInvalTarget(new ObjId("/a"), 10, 20)));
    assert(!mopi2.hasBoundEntry(new ObjInvalTarget(new ObjId("/a"), 10, 20)));

    mopi3 = mopi1.cloneUnbound();
    assert(mopi1.getInvalTarget().equals(mopi3.getInvalTarget()));
    assert(mopi1.getAcceptStamp().equals(mopi3.getAcceptStamp()));
    assert(mopi1.getRTAcceptStamp().equals(mopi3.getRTAcceptStamp()));
    assert(mopi1.isEmbargoed() == mopi3.isEmbargoed());
    assert(mopi3.getBoundEntriesDangerous().length == 0);
    assert(!mopi3.isBound());

    // Test 2
    invs = new ObjInvalTarget[3];
    invs[0] = new ObjInvalTarget(new ObjId("/a"), 10, 10);
    invs[1] = new ObjInvalTarget(new ObjId("/b"), 20, 5);
    invs[2] = new ObjInvalTarget(new ObjId("/c"), 25, 20);
    dels = new ObjInvalTarget[0];
    moit1 = new MultiObjInvalTarget(invs, dels);
    be1 = new MOITBoundEntry[2];
    be1[0] = new MOITBoundEntry(new ObjInvalTarget(new ObjId("/a"), 10, 10),
                                5.6,
                                new ImmutableBytes(new byte[10]));
    be1[1] = new MOITBoundEntry(new ObjInvalTarget(new ObjId("/b"), 5, 5),
                                7.8,
                                new ImmutableBytes(new byte[5]));
    mopi1 = new MultiObjPreciseInv(moit1,
                                   new AcceptStamp(100, new NodeId(1)),
                                   new AcceptStamp(200, new NodeId(1)),
                                   false,
                                   be1);
    mopi2 = mopi1.cloneRemoveBoundEntry(new ObjInvalTarget(new ObjId("/b"),
                                                           5,
                                                           5));
    assert(mopi2.getBoundEntriesDangerous().length == 1);
    assert(mopi1.hasBoundEntry(new ObjInvalTarget(new ObjId("/a"), 10, 10)));
    assert(mopi1.hasBoundEntry(new ObjInvalTarget(new ObjId("/b"), 5, 5)));
    assert(mopi2.hasBoundEntry(new ObjInvalTarget(new ObjId("/a"), 10, 10)));
    assert(!mopi2.hasBoundEntry(new ObjInvalTarget(new ObjId("/b"), 5, 5)));
    assert(!mopi1.hasBoundEntry(new ObjInvalTarget(new ObjId("/a"), 10, 20)));
    assert(!mopi1.hasBoundEntry(new ObjInvalTarget(new ObjId("/c"), 7, 3)));

    mopi3 = mopi1.cloneUnbound();
    assert(mopi1.getInvalTarget().equals(mopi3.getInvalTarget()));
    assert(mopi1.getAcceptStamp().equals(mopi3.getAcceptStamp()));
    assert(mopi1.getRTAcceptStamp().equals(mopi3.getRTAcceptStamp()));
    assert(mopi1.isEmbargoed() == mopi3.isEmbargoed());
    assert(mopi3.getBoundEntriesDangerous().length == 0);
    assert(!mopi3.isBound());
  }

 /** 
 *  Test makeBodyMsgArray
 
 **/ 
  public void
  test8(){
    ObjInvalTarget[] invs = null;
    ObjInvalTarget[] dels = null;
    MultiObjInvalTarget moit1 = null;
    MOITBoundEntry[] be1 = null;
    MultiObjPreciseInv mopi1 = null;
    BodyMsg bodyMsgs[] = null;
    ObjInvalTarget oit1 = null;
    ObjInvalTarget oit2 = null;

    invs = new ObjInvalTarget[3];
    invs[0] = new ObjInvalTarget(new ObjId("/a"), 10, 10);
    invs[1] = new ObjInvalTarget(new ObjId("/b"), 20, 5);
    invs[2] = new ObjInvalTarget(new ObjId("/c"), 25, 20);
    dels = new ObjInvalTarget[0];
    moit1 = new MultiObjInvalTarget(invs, dels);
    be1 = new MOITBoundEntry[2];
    be1[0] = new MOITBoundEntry(new ObjInvalTarget(new ObjId("/a"), 10, 10),
                                5.6,
                                new ImmutableBytes(new byte[10]));
    be1[1] = new MOITBoundEntry(new ObjInvalTarget(new ObjId("/b"), 5, 5),
                                7.8,
                                new ImmutableBytes(new byte[5]));
    mopi1 = new MultiObjPreciseInv(moit1,
                                   new AcceptStamp(100, new NodeId(1)),
                                   new AcceptStamp(200, new NodeId(1)),
                                   false,
                                   be1);
    bodyMsgs = mopi1.makeBodyMsgArray();
    assert(bodyMsgs.length == 2);
    oit1 = new ObjInvalTarget(new ObjId("/a"), 10, 10);
    oit2 = new ObjInvalTarget(new ObjId("/b"), 5, 5);
    assert(((bodyMsgs[0].getObjInvalTarget().equals(oit1)) &&
            (bodyMsgs[1].getObjInvalTarget().equals(oit2))) ||
           ((bodyMsgs[0].getObjInvalTarget().equals(oit2)) &&
            (bodyMsgs[1].getObjInvalTarget().equals(oit1))));
  }

 /** 
 *  Test serialization/deserialization
 
 **/ 
  public void
  test9(){
    AcceptStamp as1 = null;
    AcceptStamp rtAS1 = null;
    MOITBoundEntry[] be1 = null;
    MultiObjInvalTarget moit1 = null;
    MultiObjPreciseInv mopi1 = null;
    MultiObjPreciseInv mopi2 = null;
    ObjInvalTarget[] invs = null;
    ObjInvalTarget[] dels = null;
    ByteArrayInputStream bais = null;
    ByteArrayOutputStream baos = null;
    byte[] data = null;

    try{
      invs = new ObjInvalTarget[1];
      invs[0] = new ObjInvalTarget(new ObjId("/a"), 10, 10);
      dels = new ObjInvalTarget[0];
      moit1 = new MultiObjInvalTarget(invs, dels);
      as1 = new AcceptStamp(100, new NodeId(1));
      rtAS1 = new AcceptStamp(200, new NodeId(1));
      be1 = new MOITBoundEntry[1];
      be1[0] = new MOITBoundEntry(invs[0],
                                  1.0,
                                  new ImmutableBytes(new byte[10]));
      mopi1 = new MultiObjPreciseInv(moit1, as1, rtAS1, false, be1);
      baos = new ByteArrayOutputStream();
      mopi1.writeSelf(baos);
      baos.flush();
      data = baos.toByteArray();
      bais = new ByteArrayInputStream(data);
      mopi2 = new MultiObjPreciseInv(bais);
      assert(mopi1 != mopi2);
      assert(mopi1.equals(mopi2));
    }catch(IOException e){
      e.printStackTrace();
      assert false : ("" + e);
    }
  }
  
  /*
   * "new TestSuite(Class c)" constructs a test suite
   * containg every method whose name begins with "test"
   * 
   * TBD: update class name
   */
  public static Test suite(){
    TestSuite suite = new TestSuite(MultiObjPreciseInvUnit.class);
    return suite;
  }


  /*
   * main() lets us run just this set of unit tests
   * from the comand line (you can also invoke 
   * the testrunner on this class and it will find
   * the suite())
   *
   * TBD: update class name
   */
  public static void main(String s[]) {
    String name = "MultiObjPreciseInvUnit";
    System.err.print(name + " self test begins...");
    TestRunner tr = new TestRunner();
    tr.doRun(suite());
    System.err.println(name + " self test succeeds");
  }

}

//---------------------------------------------------------------------------
/* $Log$*/
//---------------------------------------------------------------------------
