package code;
 /** 
 *  Represent a bounded list of items to be performed 
 **/ 
import java.util.*;

 /** 
 *  Represent an entry in the list 
 **/ 
class MTListItem{

 /** 
 *  Data members 
 **/ 
  private Object value;
  private MTListItem next;

 /** 
 *  Constructor 
 **/ 
  public
  MTListItem(Object o){ 
    this.value = o;
    this.next = null;
  }

 /** 
 *  Return the value 
 **/ 
  public Object
  getValue() { 
    return(this.value);
  }

 /** 
 *  Return the next item 
 **/ 
  public MTListItem
  getNext(){
    return(this.next);
  }

 /** 
 *  Set the value of the "next" field 
 **/ 
  public void
  setNext(MTListItem to){
    this.next = to;
  }
}

 /** 
 *  Represent the list 
 **/ 
public class MTList{

 /** 
 *  Constants 
 **/ 
  public final static int INFINITE_NUM_ENTRIES = -1;

 /** 
 *  Data members 
 **/ 
  private MTListItem head;
  private MTListItem tail;
  private int maxNumEntries;
  private int numEntries; // Used for debugging

 /** 
 *  Constructor 
 **/ 
  public
  MTList(int newMaxNumEntries){
    this.head = null;
    this.tail = null;
    this.numEntries = 0;
    this.maxNumEntries = newMaxNumEntries;
  }

 /** 
 *  Return the next object 
 **/ 
  public synchronized Object
  getNext(){
    MTListItem item = null;

    while(head == null){
      try{
        this.wait();
      }catch(InterruptedException e){
        System.err.print("MTList: Get: interrupted in wait.\n");
      }
    }

    item = this.head;
    this.head = this.head.getNext();
    this.numEntries--;
    return(item.getValue());
  }

 /** 
 *  Add an item to the end of the list 
 **/ 
  public synchronized boolean
  add(Object toadd){
    MTListItem item = null;
    boolean added = false;

    if((this.maxNumEntries == INFINITE_NUM_ENTRIES) ||
       (this.numEntries < this.maxNumEntries)){
      item = new MTListItem(toadd);
      if(head == null){
        this.head = this.tail = item;
      }else{
        this.tail.setNext(item);
        this.tail = item;
      }
      this.numEntries++;
      added = true;
      this.notifyAll();
    }else{
      added = false;
    }
    return(added);
  }

 /** 
 *  Return the number of entries in the list 
 *  Note: Currently only used for debugging 
 **/ 
  public synchronized int
  getNumEntries(){
    if (this.numEntries > 50){//something might go wrong
      assert head!=null;
      NFSItem headItem = (NFSItem)(head.getValue());
      NFSItem tailItem = (NFSItem)(tail.getValue());
      System.err.println("MTList has " + numEntries + " items with head = " + headItem.toString());
      System.err.println("MTList has " + numEntries + " items with tail = " + tailItem.toString());
    }
    return(this.numEntries);
  }
}

