package code;
interface NFSConsts {
    public long NFS_PORT = 2049;
    public long NFS_VERS = 2;
    public long NFS_PROG = 100003;
    
    // nfs procedures
    public long NFS_NULL = 0;
    public long NFS_GETATTR = 1;
    public long NFS_SETATTR = 2;
    public long NFSPROC_ROOT = 3;
    public long NFS_LOOKUP = 4;
    public long NFSPROC_READLINK = 5;
    public long NFS_READ = 6;
    public long NFSPROC_WRITECACHE = 7;
    public long NFS_WRITE = 8;
    public long NFS_CREATE = 9;
    public long NFS_REMOVE = 10;
    public long NFS_RENAME = 11;
    public long NFSPROC_LINK = 12;
    public long NFSPROC_SYMLINK = 13;
    public long NFS_MKDIR = 14;
    public long NFS_RMDIR = 15;
    public long NFS_READDIR = 16;
    public long NFS_STATFS = 17;

    // nfs reply codes
    public long NFS_OK = 0;
    public long NFSERR_PERM = 1;
    public long NFSERR_NOENT = 2;
    public long NFSERR_IO = 5;
    public long NFSERR_NXIO = 6;
    public long NFSERR_ACCES = 13;
    public long NFSERR_EXIST = 17;
    public long NFSERR_NODEV = 19;
    public long NFSERR_NOTDIR = 20;
    public long NFSERR_ISDIR = 21;
    public long NFSERR_FBIG = 27;
    public long NFSERR_NOSPC = 28;
    public long NFSERR_ROFS = 30;
    public long NFSERR_NAMETOOLONG = 63;
    public long NFSERR_NOTEMPTY = 66;
    public long NFSERR_DQUOT = 69;
    public long NFSERR_STALE = 70;
    public long NFSERR_WFLUSH = 99;

    // boolean types
    public long NFS_TRUE = 1;
    public long NFS_FALSE = 0;
    
    // file types - values for the ftype field in the attributes struct
    public long FT_NFNON = 0;
    public long FT_NFREG = 1;
    public long FT_NFDIR = 2;
    public long FT_NFBLK = 3;
    public long FT_NFCHR = 4;
    public long FT_NFLNK = 5;
};

