package code;
import java.io.*;

class NFSIO implements NFSConsts, RPCConsts{

 /** 
 *  Data members 
 **/ 
  private Handle handles;
  private TimeMapper tm;
  private NFS2FS pfs;

 /** 
 *  Constructor 
 **/ 
  public
  NFSIO(NFS2FS newPFS, Handle h, TimeMapper t) {
    this.pfs = newPFS;
    this.handles = h;
    this.tm = t;
  }

 /** 
 *  Write data to a file 
 **/ 
  public XDRPacket
  Write(long xid, XDRPacket packet, XDRPacketCache packetCache, int threadNum)
    throws NFSException{
    fhandle fh = null;
    attrstat result = null;
    long beginOffset = 0;
    long offset = 0;
    long totalCount = 0;
    long dataLen = 0;
    byte[] data = null;
    XDRPacket replyPacket = null;

    fh = this.readFHandle(packet);
    beginOffset = packet.GetLong();
    offset = packet.GetLong();
    totalCount = packet.GetLong();

    // next comes the data which is a long of size and the bytes.
    dataLen = packet.GetLong();
    data = new byte[(int)dataLen];
    packet.GetNextBytes(data);
    /*
      System.out.println("NFSIO: " + threadNum +
      " Calling write(" + fh +
      ", " + beginOffset +
      ", " + offset +
      ", " + totalCount + ")");
    */
    result = this.pfs.write(fh, beginOffset, offset, totalCount, data);
    /*
      System.out.println("NFSIO: " + threadNum +
      " Called write(" + fh +
      ", " + beginOffset +
      ", " + offset +
      ", " + totalCount + ")");
    */

    if(result.getStatus() != stat.NFS_OK){
      throw new NFSException(xid, result.getStatus());
    }

    // create the reply packet
    if(packetCache != null){
    replyPacket = packetCache.find(128);
    }else{
      replyPacket = new XDRPacket(128);
    }
    replyPacket.Reset();
    replyPacket.AddReplyHeader(xid);
    replyPacket.AddLong(NFS_OK);
    this.emitAttributes(replyPacket, result.getAttributes());
    return replyPacket;

    /*
    String fileName = null;

    try {

    } catch (IOException e) {
      System.err.println("Exception writing " + fileName + " - " + e);
      throw new NFSException(xid, NFSERR_IO);
    } catch (SecurityException e) {
      throw new NFSException(xid, NFSERR_PERM);
    }
    */
  }

 /** 
 *  Read data from a file 
 **/ 
  public XDRPacket
  Read(long xid, XDRPacket packet, XDRPacketCache packetCache)
    throws NFSException{
    readargs args = null;
    readres result = null;
    int numberRead = 0;
    XDRPacket replyPacket = null;
    byte[] data = null;

    args = this.readReadArgs(packet);
    result = this.pfs.read(args);

    if(result.getStatus() != stat.NFS_OK){
      throw new NFSException(xid, result.getStatus());
    }

    // put together the reply packet; this will copy the read
    //   data which is a little inefficient
    data = result.getData();
    
    // create the reply packet
    if(packetCache != null){
      replyPacket = packetCache.find(128 + data.length);
    }else{
      replyPacket = new XDRPacket(128);
    }
    
    //add by zjd
    replyPacket.Reset();

    replyPacket.AddReplyHeader(xid);
    replyPacket.AddLong(NFS_OK);
    this.emitAttributes(replyPacket, result.getAttributes());
    replyPacket.AddData(data.length, data);

    return(replyPacket);

    /*
      try {
      // collect data out of the packet
      fhandle fh = new fhandle(packet);
      long offset = packet.GetLong();
      long count = packet.GetLong();
      long totalCount = packet.GetLong(); // not used

      // do the operation
      String fileName = handles.Lookup(fh.Handle());
      if (fileName == null)
      throw new NFSException(xid, NFSERR_STALE);
      // XXX Comment out read lines to improve performance
      // System.out.print("Read(" + fileName + ", " + count + ", " + 
      //		     offset + ")\n");

      if (count <= 0) {
      System.err.println("\tRead: invalid value for count " + count);
      throw new NFSException(xid, NFSERR_IO);
      }

      FileInputStream fd = new FileInputStream(fileName);
      fd.skip(offset);
      byte [] readbuf = new byte[(int) count];
      int numberRead = fd.read(readbuf);
      fd.close();
      // XXX comment out prints to improve performance
      // System.err.println("Read: got " + numberRead + " bytes");

      // Make sure something was read in
      if (numberRead < 0) {
      System.err.println("\tRead error: number read is " 
      + numberRead);
      numberRead = 0;
      }

      // load in file attributes.
      fattr fa = new fattr(handles, tm);
      fa.Load(fileName);

      // put together the reply packet, this will copy the read
      //   data which is a little inefficient
      XDRPacket reply = packetCache.find(128 + numberRead);
      reply.AddReplyHeader(xid);
      reply.AddLong(NFS_OK);
      fa.Emit(reply);
      reply.AddData(numberRead, readbuf);

      return reply;

      } catch(FileNotFoundException e) {
      throw new NFSException(xid, NFSERR_NOENT);
      } catch(IOException e) {
      throw new NFSException(xid, NFSERR_IO);
      }
    */
  }

 /** 
 *  Get a new XDRPacket 
 **/ 
  public XDRPacket
  getXDRPacket(int desiredSize){
    return new XDRPacket(desiredSize);
  }

 /** 
 *  Read the fhandle from the packet 
 **/ 
  private fhandle
  readFHandle(XDRPacket packet){
    fhandle fh = null;
    byte[] handleBytes = null;

    handleBytes = new byte[fhandle.FHSIZE];
    packet.GetNextBytes(handleBytes);
    fh = fhandle.makeHandleDangerous(handleBytes);
    handleBytes = null; // Release the pointer to avoid trouble
    return(fh);
  }

 /** 
 *  Read the readargs from the packet 
 **/ 
  private readargs
  readReadArgs(XDRPacket packet){
    fhandle fh = null;
    long offset = 0;
    long count = 0;
    long totalCount = 0;
    readargs args = null;

    fh = this.readFHandle(packet);
    offset = packet.GetLong();
    count = packet.GetLong();
    totalCount = packet.GetLong();
    args = new readargs(fh, offset, count, totalCount);
    return(args);
  }

 /** 
 *  Write out the time to the packet 
 **/ 
  private void
  emitTimeval(XDRPacket packet, timeval time){
    packet.AddLong(time.getSeconds());
    packet.AddLong(time.getUSeconds());
  }

 /** 
 *  Write out attributes to the packet 
 **/ 
  private void
  emitAttributes(XDRPacket packet, fattr attr){
    packet.AddLong(attr.getType());
    packet.AddLong(attr.getMode());
    packet.AddLong(attr.getNLink());
    packet.AddLong(attr.getUID());
    packet.AddLong(attr.getGID());
    packet.AddLong(attr.getSize());
    packet.AddLong(attr.getBlockSize());
    packet.AddLong(attr.getRDev());
    packet.AddLong(attr.getBlocks());
    packet.AddLong(attr.getFSID());
    packet.AddLong(attr.getFileId());
    this.emitTimeval(packet, attr.getATime());
    this.emitTimeval(packet, attr.getMTime());
    this.emitTimeval(packet, attr.getCTime());
  }
}
