package code;
 /** 
 *  NFS Multi-Threaded handler: Spawn off threads that make parallel calls 
 *  into the single-threaded NFS handler 
 **/ 

public class NFSMTHandler extends rpcHandler implements RPCConsts, NFSConsts{

 /** 
 *  Constants 
 **/ 
  private final static boolean PRINT_PERIODIC_NUM_ENTRIES = false;
  private final static int MAX_NUM_QUEUED_PACKETS = 2;
  public static final boolean PRINT_THREAD_PRIORITY = true;
 /** 
 *  Data members 
 **/ 
  private MTList packetq;
  private NFSHandler handler;

 /** 
 *  Constructor 
 **/ 
  public
  NFSMTHandler(NFS2FS fs,
               Handle handles,
               PathMapper pm, FileSystemInfo fsi, 
               TimeMapper tm){
    // tell parent about me
    super(NFS_PROG, NFS_VERS);

    handler = new NFSHandler(fs, handles, pm, fsi, tm);
    packetq = new MTList(MAX_NUM_QUEUED_PACKETS);
    if(PRINT_PERIODIC_NUM_ENTRIES){
      (new Thread(new NFSMTPrintThread(packetq), "NFSMTPrintThread")).start();
    }

    // AMOL Change: Use only two threads
    // ZJD Change: Use only 1 thread
    Thread t = null;
    Env.dprintln(NFSMTHandler.PRINT_THREAD_PRIORITY, "MAX " + Thread.MAX_PRIORITY);
    Env.dprintln(NFSMTHandler.PRINT_THREAD_PRIORITY, "MIN " + Thread.MIN_PRIORITY);
    Env.dprintln(NFSMTHandler.PRINT_THREAD_PRIORITY, "NORM " + Thread.NORM_PRIORITY);
    for(int i = 0; i < 10; i++){
      NFSOperation op = new NFSOperation(packetq, handler, i + 1);
      t = new Thread(op, "NFSOperationThread-"+i);
      //t.setPriority(Thread.MAX_PRIORITY);
      t.start();
      Env.dprintln(NFSMTHandler.PRINT_THREAD_PRIORITY, "NFSOperationThread-"+i + " priority=" + t.getPriority());
      
    }
  }

 /** 
 *  Main method of this class 
 **/ 
  public void
  Run(UDPPacketPort port,
      long xid,
      long procedure,
      XDRPacket packet){
    NFSItem item = new NFSItem(port, xid, procedure, packet);
    // System.out.println("NFSMTHandler adding item to queue xid=" + xid);
    this.packetq.add(item);
  }
}

 /** 
 *  Periodically  print the number of entries in the packet queue 
 **/ 
class NFSMTPrintThread implements Runnable{

 /** 
 *  Data members 
 **/ 
  private MTList list;

 /** 
 *  Constructor 
 **/ 
  public
  NFSMTPrintThread(MTList newList){
    this.list = newList;
  }

 /** 
 *  Main thread method 
 **/ 
  public void
  run(){
    try{
      while(true){
        Thread.sleep(10000); // 10 seconds
        Env.dprinterrln(true,
                        "NFSMTHandler: " + Thread.currentThread().getName() +
                        " has " + this.list.getNumEntries() +
                        " elements");
      }
    }catch(InterruptedException e){
      Env.dprinterrln(true, "" + e);
    }
  }
}
