package code;
public class NFSOperation implements Runnable, NFSConsts, RPCConsts{

 /** 
 *  Data members 
 **/ 
  private MTList input;
  private NFSHandler handler;
  private int threadNum;

 /** 
 *  Constructor 
 **/ 
  public
  NFSOperation(MTList inputq, NFSHandler nfsh, int newThreadNum){
    this.input = inputq;
    this.handler = nfsh;
    this.threadNum = newThreadNum;
  }
    
 /** 
 *  Main thread method 
 **/ 
  public void
  run(){
    NFSItem next = null;
    for(;;){
      // System.out.print("thread waiting on nfs item queue\n");
      next = (NFSItem)input.getNext();

      //System.out.println("NFSOperation got item from queue xid=" + 
      //  next.xid);
      this.handler.Run(next.port,
                       next.xid,
                       next.procedure,
                       next.packet,
                       this.threadNum);
      next = null;
    }
  }
}
