package code;
 /** 
 *  Collect packets from the socket and put them into a queue 
 **/ 
import java.net.*;

//
// Get the next packet from the network asynchronously, so it will be ready
//   for the main thread as soon as it is needed.
//

public class PacketCollector implements Runnable{

 /** 
 *  Data members 
 **/ 
  private MTList packets;      // List of PacketCollects with packets ready
  private UDPPacketPort socket;
  private DatagramPacket packet;
  private boolean packetDone = true;
 /** 
 *  Constructor 
 **/ 
  public
  PacketCollector(UDPPacketPort udpport, MTList tolist){ 
    this.socket = udpport;
    this.packets = tolist;
  }
    
 /** 
 *  Main thread method 
 **/ 
  public synchronized void
  run(){
    byte[] buf = new byte[10240]; // bigger than max nfs packet
    for(;;){
      // Get the next packet from the network - only let one thread
      //   at a time read from the socket.
      assert packetDone;
      packet = this.socket.GetPacket(buf);
      // if the packet is something, add this to the list and wait
      //   for the rpcmanager to process with it and say Done().
      if(packet != null){
        this.packets.add(this);
	packetDone = false;
	while (!packetDone){
	  try{
	    this.wait(); // wait for the packet handler to use this packet
	  }catch(InterruptedException e){
	    System.err.print("packet collector: interrupted wait\n");
	  }
	}
      }
    }
  }
    
 /** 
 *  Signal that this thread is finished 
 **/ 
  public synchronized void
  signalDone(){
    // let the rpc manager notify this thread that the packet is done and
    //   can be reused.
    packetDone = true;
    this.notifyAll();
  }

  /*

  //-------------------------------------------------------------------------
  // Get the next packet collector thread
  //-------------------------------------------------------------------------
  public PacketCollector
  get(){
    Object o = packets.getNext();
    if(o instanceof PacketCollector){
      return(PacketCollector)o;
    }

    System.err.print("PacketCollector Get: packet queue contains"
                     + " non-packet\n");
    return null;
  }
  */
    
 /** 
 *  accessor method 
 **/ 
  public synchronized DatagramPacket
  getPacket(){
    assert packetDone == false;
    return(this.packet);
  }
}
