package code;
 /** 
 *  Collect packets from the socket and put them into a queue 
 **/ 
import java.net.*;

//
// Get the next packet from the network asynchronously, so it will be ready
//   for the main thread as soon as it is needed.
//

public class PacketReceiver implements Runnable{

 /** 
 *  Data members 
 **/ 
  private MTList packetList;      // List of PacketCollects with packets ready
  private UDPPacketPort socket;
  private boolean dbg = false;  
    
 /** 
 *  Constructor 
 **/ 
  public
  PacketReceiver(UDPPacketPort udpport, MTList tolist){ 
    this.socket = udpport;
    this.packetList = tolist;
  }
    
 /** 
 *  Main thread method 
 **/ 
  public void
  run(){
    byte[] buf = null;
    DatagramPacket packet;
    boolean addRet;
    while(true){
      // Get the next packet from the network - only let one thread
      //   at a time read from the socket.
      buf = new byte[10240]; // bigger than max nfs packet
      packet = this.socket.GetPacket(buf);
      // if the packet is something, add this to the list and wait
      //   for the rpcmanager to process with it and say Done().
      assert (packet != null);
      
      addRet=this.packetList.add(packet);
      Env.dprintln(dbg, "PacketReceiver::addRet: " + addRet);
    }
    
  }
    
  
  /*

  //-------------------------------------------------------------------------
  // Get the next packet collector thread
  //-------------------------------------------------------------------------
  public PacketReceiver
  get(){
    Object o = packets.getNext();
    if(o instanceof PacketReceiver){
      return(PacketReceiver)o;
    }

    System.err.print("PacketReceiver Get: packet queue contains"
                     + " non-packet\n");
    return null;
  }
  */
    
}
