package code;
import java.net.*;
import java.io.*;

class XDRPacket implements RPCConsts, NFSConsts {
  static private boolean DBG = false;
  static private boolean dbgOutOfMem = false;
  static private boolean SHOWDATA = false;
    // data contents of the packet
    byte data[];
    int  len;
    int  position;

    // store information about where the packet came from
    InetAddress source;
    int port;
    
    // control debugging output
    boolean debug = false;
    
    XDRPacket(DatagramPacket input) {
	data = input.getData();
	len = input.getLength();
	position = 0;
	source = input.getAddress();
	port = input.getPort();
    };
    
  
    XDRPacket(int size) {
	len = size; 
	data = new byte[len];
	position = 0;
    }
  

    
 /** 
 *  add by zjd 
 **/ 
  XDRPacket(byte[] data, 
	    int len, 
	    int position, 
	    InetAddress source, 
	    int port){
    this.data = data;
    this.len = len;
    this.position = position;
    this.source = source;
    this.port = port;
    
  }
  

  public XDRPacket cloneMe(){
    //copy the data
    byte[] clonedata = new byte[data.length];
    for(int i=0; i < data.length; i++){
      clonedata[i] = data[i];
    }
    return new XDRPacket(clonedata, len, position, source, port);
  }

  

  /*
  //----------------------------------------------------------------
  // add by zjd
  // for test purpose
  //----------------------------------------------------------------
  XDRPacket(byte[] inputdata, int inputlen){
    data = new byte[inputdata.length];
    for(int i=0; i < inputdata.length; i++){
      data[i] = inputdata[i];
    }
    
    len = inputlen;
    position = 0;
  }
  */
    byte [] Data() { return data; }
    int  Length() { return position; }
    public int  CurrentPosition() { return Length(); }
    InetAddress Source() { return source; }
    int Port() { return port; }

    public void Reset() { position = 0; };

    // unpack the next long from an XDR packet
    public long GetLong() {
	long result = 0;
	for (int i = 0; i < 4; i++) {
	    long next = (long) data[position + i];
	    if (next < 0)  {
		// make sure it is positive
		next += 256;
	    }
	    result *= 256;
	    result += next;
	}

	position += 4;
	return result;
    };

    public String GetString() {
      Env.dprintln(DBG, "GetString:position= " + position + "data size = " + data.length);
     	long strlen = GetLong();
	Env.dprintln(DBG, "String len = " + strlen);
	int iStrLen = (int)strlen;
	Env.dprintln(DBG, "(int) strlen = " + iStrLen);
	char [] buf = new char[(int) strlen];
	Env.dprintln(DBG, "allocate mem succeeds");
	for (int i = 0; i < strlen; i++) 
	    buf[i] = (char) data[i + position];
	String result = new String(buf);
	
	Advance(strlen);
	Env.dprintln(DBG, "GetString after :position= " + position + "str size = " + strlen);
	return result;
    };

    public void AddLong(long l) {
	for (int i = 0; i < 4; i++) {
	    long rem = l % 256;
	    l = l / 256;

	    if (rem > 128)
		rem -= 256;
	    data[position + (3 - i)] = (byte) rem;
	}
	position += 4;
    };
    
    public long AddString(String s) {
	long length = (long) s.length();

	AddLong(length);
	for (long l = 0; l < length; l++)
	    data[(int) l + position] = (byte) s.charAt((int) l);
	Advance(length);
	
	return 4 + 4 * ((length + 3) / 4);
    }

    public long AddData(int len, byte [] toadd) {
	AddLong(len);
	System.arraycopy(toadd, 0, data, position, len);

	Advance(len);
	return 0;
    };
    public long AddData(byte [] toadd) {
	return AddData(toadd.length, toadd);
    };

    // copy the unprocessed data object starting at the current position in
    //   the buffer into the byte array.  Assume that the array is big enough.
    public long GetData(byte [] buffer) {
	long plen = GetLong(); // how much data is in the packet
	if (plen + position >= data.length) {
	    System.err.print("GetData: packet is too small\n");
	    return -1;
	}

	// try to copy the data into the buffer
	System.arraycopy(data, position, buffer, 0, (int) plen);

	Advance(plen);
	return plen;
    };

  // Fill the passed-in array with the next buffer.length bytes
  public void
  GetNextBytes(byte[] buffer){
    System.arraycopy(this.data, this.position, buffer, 0, buffer.length);
    this.Advance(buffer.length);
  }

  // Fill the next buffer.length bytes with the passed-in array
  public void
  AddNextBytes(byte[] buffer) {
    System.arraycopy(buffer, 0, data, position, buffer.length);
    this.Advance(buffer.length);
  }

    
    // Add the standard procedure you requested was called reply header
    public void AddReplyHeader(long xid) {
	AddLong(xid);
	AddLong(RPCReply);
	AddLong(RPCMsgAccepted);
	AddNullAuthentication();
	AddLong(RPCSuccess);
    }

    public void AddNullAuthentication() {
	AddLong(0); /* the type */
	AddLong(0); /* the length */
    };
    
    public void ReadAuthentication() {
	long type = GetLong();
	long length = GetLong();
	Advance(length);
    };
    
    public void Advance(long length) {
	long words = (length + 3) / 4;
	long delta = 4 * words;
	position += (int) delta;
    }

 /** 
 *  return the String representation of the request packet 
 **/ 
  public String toRequestString(int procedure){
    //XDRPacket clonePacket = new XDRPacket(this.data, this.data.length);
    //clonePacket.Reset();
    
    //memorize original position
    int originalPos = position;
    this.Reset();
    RPCCallHeader rpch=this.advanceRPCCallHeader();
    assert (int)(rpch.getProc()) == procedure: "original=" + rpch.getProc() 
      + " expected=" + procedure;
    this.ReadAuthentication();
    this.ReadAuthentication();
    String ret = "-->:<";
    fhandle fh = null;
    byte[] handleBytes = null;
    long l;
    byte[] resultdata=null;
    switch((int) procedure) {
    case (int) NFS_NULL:
      
      break;
    case (int) NFS_GETATTR:
      ret = ret + " fhandle= " + this.getFHandle().toString();
      
      break;
    case (int) NFS_SETATTR:
      ret = ret + "sattrargs=" + this.getSattrArgs().toString();

      break;
    case (int) NFS_LOOKUP:
      Env.dprintln(dbgOutOfMem, "start read lookup packet");
      ret = ret + "diropargs=" + this.getDirOpArgs().toString();
      break;
    case (int) NFS_READ:
      ret = ret + "readargs=" + this.getReadArgs().toString();
      break;
    case (int) NFS_WRITE:
      ret = ret + " fhandle= " + this.getFHandle().toString();
      ret = ret + " beginoffset = " + this.GetLong();
      ret = ret + " offset= " + this.GetLong();
      ret = ret + " totalCount= " + this.GetLong();
      if(SHOWDATA){
	l = this.GetLong();
	ret = ret + " len = " + l;
	resultdata = new byte[(int)l];
	this.GetNextBytes(resultdata);
	ret = ret + " data = " + new String(resultdata);
	resultdata = null;
      }else{
	ret = ret + "data [...]";
      }
      break;
    case (int) NFS_CREATE:
      ret = ret + " createargs=" + this.getCreateArgs().toString();
      break;
    case (int) NFS_REMOVE:
      ret = ret + "diropargs=" + this.getDirOpArgs().toString();
      break;
    case (int) NFS_RENAME:
      ret = ret + "renameargs=" + this.getRenameArgs().toString();
      break;
    case (int) NFS_MKDIR:
      ret = ret + " createargs=" + this.getCreateArgs().toString();
      break;
    case (int) NFS_RMDIR:
      ret = ret + "diropargs=" + this.getDirOpArgs().toString();
      break;
    case (int) NFS_READDIR:
      ret = ret + "diropargs=" + this.getReadDirArgs().toString();
      break;
    case (int) NFS_STATFS:
      ret = ret + " fhandle= " + this.getFHandle().toString();
      break;
    default:
      ret = ret + ("Unsupported NFS procedure called (" 
		       + procedure + ") from "
		       + this.Source().getHostAddress() + "\n");
      
    }
    position = originalPos;
    ret += ">";
    return ret;
  }

  public RPCCallHeader advanceRPCCallHeader(){
    assert position == 0;
    long xid = GetLong();
    long type = GetLong();
    long rpcvers = GetLong();
    long prog = GetLong();
    long vers = GetLong();
    long proc = GetLong();
    
    return new RPCCallHeader(xid, type, rpcvers, prog, vers, proc);
  }

  public renameargs getRenameArgs(){
    diropargs fromArgs = null;
    diropargs toArgs = null;
    renameargs args = null;

    fromArgs = getDirOpArgs();
    toArgs = getDirOpArgs();
    args = new renameargs(fromArgs, toArgs);
    return(args);
  }

  public createargs getCreateArgs(){
    createargs args = null;
    diropargs dirOpArgs = null;
    sattr attr = null;

    dirOpArgs = getDirOpArgs();
    attr = getSattr();
    args = new createargs(dirOpArgs, attr);

    return(args);
  }

 /** 
 * get Attribute --reverse of NFSDir.emitAttributes 
 **/ 
  public fattr getfattr(){
    return new fattr(GetLong(),//type
		     GetLong(),//mode
		     GetLong(),//NLink()
		     GetLong(),//UID
		     GetLong(),//GID
		     GetLong(),//Size
		     GetLong(),//BlockSize
		     GetLong(),//RDev
		     GetLong(),//Blocks
		     GetLong(),//fsid
		     GetLong(),//fileid
		     getTimeval(),//ATime
		     getTimeval(),//MTime
		     getTimeval());//CTime
  }
  
 /** 
 * get Timeval --reverse of NFSDir.emitTimeval() 
 **/ 
  public timeval getTimeval(){
    return new timeval(GetLong(), GetLong());
  }

  public fhandle getFHandle(){
    fhandle fh = null;
    byte[] handleBytes = null;

    handleBytes = new byte[fhandle.FHSIZE];
    GetNextBytes(handleBytes);
    fh = fhandle.makeHandleDangerous(handleBytes);
    handleBytes = null; // Release the pointer to avoid trouble
    return(fh);
  }

  public sattr getSattr(){
    long mode = 0;
    long uid = 0;
    long gid = 0;
    long size = 0;
    timeval atime = null;
    timeval mtime = null;
    sattr attr = null;

    mode = GetLong();
    uid = GetLong();
    gid = GetLong();
    size = GetLong();
    atime = getTimeval();
    mtime = getTimeval();
    attr = new sattr(mode, uid, gid, size, atime, mtime);
    return(attr);
  }

  public sattrargs getSattrArgs(){
    sattrargs args = new sattrargs(getFHandle(), getSattr());
    return args;
  }

  public diropargs getDirOpArgs(){
    Env.dprintln(dbgOutOfMem, "XDRPacket::getDirOpArgs");
    fhandle fh = null;
    String name = null;
    diropargs args = null;

    Env.dprintln(dbgOutOfMem, "XDRPacket::getDirOpArgs before getFHandle");
    fh = getFHandle();
    Env.dprintln(dbgOutOfMem, "fh: " + fh);
    name = GetString();
    Env.dprintln(dbgOutOfMem, "name: " + name);
    args = new diropargs(fh, name);
    return(args);
  }

  public readdirargs getReadDirArgs(){
    fhandle fh = null;
    long cookie = 0;
    long count = 0;
    readdirargs args = null;

    fh = getFHandle();
    cookie = GetLong();
    count = GetLong();
    args = new readdirargs(fh, cookie, count);
    return(args);
  }

  public readargs getReadArgs(){
    fhandle fh = null;
    long offset = 0;
    long count = 0;
    long totalCount = 0;
    readargs args = null;

    fh = getFHandle();
    offset = GetLong();
    count = GetLong();
    totalCount = GetLong();
    args = new readargs(fh, offset, count, totalCount);
    return(args);
  }

  public void verifyHead(long expectedxid, long expectedtype){
    int currentPos = position;
    position = 0;
    long thisxid = GetLong();
    long thistype = GetLong();
    assert thisxid == expectedxid:"thisxid="+thisxid + ", expectedxid= " + expectedxid;
    assert thistype == expectedtype:"thistype=" + thistype + ", expectedtype=" + expectedtype;
    position = currentPos;
  }

 /** 
 *  return the String representation of the result packet 
 **/ 
  public String toResultString(int procedure){
    //XDRPacket clonePacket = new XDRPacket(this.data, this.data.length);
    //clonePacket.Reset();
    int originalPos = position;
    this.Reset();

    String ret = "<--:<";
    byte[] resultdata = null;
    long l;
    fattr fa;
    //replyheader  -- see AddReplyHeader()
    ret = ret + " xid = "+ this.GetLong();
    ret = ret + " RPCReply = " + this.GetLong();
    ret = ret + " RPCMsgAccepted = " + this.GetLong();
    ret = ret + " NullAuthentication = " + this.GetLong() + this.GetLong();
    ret = ret + " RPCSuccess = " + this.GetLong();

    switch((int) procedure) {
    case (int) NFS_NULL:
      
      break;
    case (int) NFS_GETATTR:
      ret = ret + " Status= " + this.GetLong();
      ret = ret + " fattr= " + this.getfattr().toString();
      
      break;
    case (int) NFS_SETATTR:
      ret = ret + " Status= " + this.GetLong();
      ret = ret + this.getfattr().toString();

      break;
    case (int) NFS_LOOKUP:
      ret = ret + " Status= " + this.GetLong();
      ret = ret + " fh= " + this.getFHandle().toString();
      ret = ret + " fattr= " + this.getfattr().toString();

      break;
    case (int) NFS_READ:
      ret = ret + " Status= " + this.GetLong();
      fa = this.getfattr();
      ret = ret + " fattr= " + fa.toString();
      if(SHOWDATA){
	l = this.GetLong();
	resultdata = new byte[(int)l];
	this.GetNextBytes(resultdata);
	ret = ret + " data[" + new String(resultdata) + "]";
	resultdata = null;
      }else{
	ret = ret + " data[...].";
      }
      break;
    case (int) NFS_WRITE:
      ret = ret + " Status= " + this.GetLong();
      ret = ret + " fattr= " + this.getfattr().toString();
      break;
    case (int) NFS_CREATE:
      ret = ret + " Status= " + this.GetLong();
      ret = ret + "fh= " + this.getFHandle();
      ret = ret + " attr= " + this.getfattr();
      break;
    case (int) NFS_REMOVE:
      ret = ret + " Status= " + this.GetLong();
      break;
    case (int) NFS_RENAME:
      ret = ret + " Status= " + this.GetLong();
      break;
    case (int) NFS_MKDIR:
      ret = ret + " Status= " + this.GetLong();
      ret = ret + "fh= " + this.getFHandle();
      ret = ret + " attr= " + this.getfattr();
      break;
    case (int) NFS_RMDIR:
      ret = ret + " Status= " + this.GetLong();
      break;
    case (int) NFS_READDIR:
      ret = ret + " Status= " + this.GetLong();
      ret = ret + " direntrys[omit]";
      break;
    case (int) NFS_STATFS:
      ret = ret + " Status= " + this.GetLong();
      ret = ret + " Tsize= " + this.GetLong();
      ret = ret + " Bsize= " + this.GetLong();
      ret = ret + " Blocks= " + this.GetLong();
      ret = ret + " BFree= " + this.GetLong();
      ret = ret + " BAvail= " + this.GetLong();
      
      break;
    default:
      System.err.print("Unsupported NFS procedure called (" 
		       + procedure + ") from "
		       + this.Source().getHostAddress() + "\n");
      assert false;
    }
    
    position = originalPos;
    ret += ">";
    return ret;
  }
  
}

 /** 
/**
 *  RPCCallHeader
 *  
 *    Representation of RPCCall XDRPacket header
 */
 **/ 
class RPCCallHeader implements RPCConsts, NFSConsts{
  long xid, type, rpcvers, prog, vers, proc;
  
  public RPCCallHeader(long xid, long type, long rpcvers, long prog, long vers, long proc){
    this.xid = xid;
    this.type = type;
    this.rpcvers = rpcvers;
    this.prog = prog;
    this.vers = vers;
    this.proc = proc;
  }
  
  public long getXid(){
    return xid;
  }

  public long getType(){
    return type;
  }

  public long getRpcvers(){
    return rpcvers;
  }

  public long getProg(){
    return prog;
  }
  
  public long getVers(){
    return vers;
  }
  
  public long getProc(){
    return proc;
  }
   
  public String toString(){
    return "RPCCallHeader:<xid=" + xid + ", type=" + type + ", rpcvers=" + rpcvers
      + ", prog=" + prog + ", vers=" + vers + ", proc=" + proc + ">";
  }
  
}

