package code;
import java.util.*;

public class XDRPacketCache {
  static final boolean dbg = false;  
  Hashtable cache;
    int attempts;
    int hits;
  long memSize = 0;
    XDRPacketCache() {
        cache = new Hashtable();
        attempts = 0;
        hits = 0;
    }

    void add(XDRPacket item) {
        Integer key = new Integer(item.Data().length);
        Vector bucket = (Vector) cache.get(key);
        if (bucket == null) {
            bucket = new Vector();
            cache.put(key, bucket);
        }
        bucket.add(item);
	memSize += item.Data().length;
    }

    XDRPacket find(int desiredLen) {
        attempts++;
        
        Integer key = new Integer(desiredLen);
        Vector bucket = (Vector) cache.get(key);
        XDRPacket result = null;
        
        // make sure the packet is reinitialized
        if (bucket != null && bucket.size() > 0) {
            hits++;
            // get the last item out of the bucket
            synchronized(bucket) {
                int idx = bucket.size() - 1;
                result = (XDRPacket) bucket.get(bucket.size() - 1);
                bucket.removeElementAt(idx);
            }
            result.Reset();
	    memSize -= desiredLen;
        }
        else {
            result = new XDRPacket(desiredLen);
        }

        // print performance information
        if (((attempts % 100) == 0) && (attempts != 0)) {
	  Env.dprintln(dbg, "XDRPacketCache(memSize=" + memSize+"): " + attempts + " attempts with "
		       + hits + " hits for hit rate of: "
		       + ((double) hits / (double) attempts));
        }
        return result;
    }
}
