package code;
import java.util.*;

class XIDCache implements Runnable {
  static final boolean dbg = false;
  Hashtable items;
  int MAX_ITEM = 100;
  int totItems = 0;
  long gcPeriodMS = 10 * 100; // number of ms between runs of the gc
  long packetLifetimeMS = 30 * 100; // time in ms that a packet stays in cache
  // zjd:
  // "packetLifetimeMS is sensitive to performance when the server's performance can not catch up
  // client's timeout. The redundant requests waste cpu cycles and  result in poor throughput(useful
  // throughput for client).
  // set it a little bit longer than latency
  // 
  
    XIDCache() {
     
	items = new Hashtable();
        // start the garbage collector 
        Thread thd = new Thread(this);
        thd.start();
	totItems = 0;
    }
    
    // start a new xid in the queue
    boolean Start(long xid) {
      //deprecated by zjd
      //not thread safe
      //logic moved inside synchronized find(xid)
      assert false;

	if (Find(xid) != null) {
	    Env.dprintln(dbg, "Start xid=" + xid + " already queued\n");
	    return false;
	}
	
	// make a new xid queue item that isn't complete
	XIDCacheItem qi = new XIDCacheItem();
	qi.xid = xid;
	qi.timeInQueueMS = System.currentTimeMillis();
	qi.inprogress = true;
	qi.packet = null;
	
	// and put it in the queue
	Add(qi);
	return true;
    }
    
    // set the reply packet for this xid and turn off inprogress
    synchronized boolean SetPacket(long xid, XDRPacket packet) {
	XIDCacheItem qi = Find(xid);
	if (qi == null) {
	    Env.dprintln(dbg, "SetPacket xid=" + xid + " not found\n");
	    return false;
	}
	qi.inprogress = false;
	qi.timeInQueueMS = System.currentTimeMillis();//have it stay for a while
	qi.packet = packet;
	return true;
    }

    synchronized boolean Add(XIDCacheItem qi) {
      //items.put(new Long(qi.xid), qi);

      //start zjd -- original see above
      //limit the size of the Hashtable
      if(items.size()< MAX_ITEM){
        // put this item into the hashtable
	items.put(new Long(qi.xid), qi);
	totItems++;
	return true;
      }else{
	
	Env.dprintln(dbg, "warnning, XIDCache full and drops new request");
	return false;
      }
      //end zjd
    }
    
  synchronized XIDCacheItem Find(long xid) {
    XIDCacheItem ret = (XIDCacheItem) items.get(new Long(xid));
    
    //add by zjd
    if (ret == null){
      // make a new xid queue item that isn't complete
      XIDCacheItem qi = new XIDCacheItem();
      qi.xid = xid;
      qi.timeInQueueMS = System.currentTimeMillis();
      qi.inprogress = true;
      qi.packet = null;
      
      // and put it in the queue
      Add(qi);
    }
    //end by zjd
    return ret;
  }

    //
    // The XIDCache garbage collector runs in its own thread, sleeping for
    //   a while then removing items that are more than a certain number of
    //   seconds old.
    //

    // run forever sleeping for a 10 seconds then removing old items from
    //   the table
  synchronized void Clean() {
    for (;;) {
      try {
	wait(gcPeriodMS);
      }
      catch(InterruptedException ie) {
	Env.dprintln(dbg, "XIDCache:Clean: wait interrupted");
      }
      
      long currentTime = System.currentTimeMillis();
      Env.dprintln(dbg, "XIDCache gc running: " + items.size()
			 + " items in the XID cache: myowncount="+totItems);
      
      Enumeration keys = items.keys();
      Enumeration elements = items.elements();
      while (keys.hasMoreElements()) {
	Long key = (Long) keys.nextElement();
	XIDCacheItem item = (XIDCacheItem) elements.nextElement();
	
	  // see if this item needs to be removed from the cache
	long timeInQueue = currentTime - item.timeInQueueMS;
	//add the inprogress check by zjd
	// so that the client retry will be filtered
	//
	if(items.size()>=50){
	  if (!item.inprogress &&(timeInQueue > packetLifetimeMS)){
	    items.remove(key);
	    totItems--;
	  }
        }
      }
    
      long endTime = System.currentTimeMillis();
      Env.dprintln(dbg, "XIDCache: gc took " + (endTime - currentTime)
			 + "ms to run");
    }
  }


    public void run() {
        Clean();
        Env.dprintln(dbg, "Warning: XIDCache garbage collector exited.");
        Env.dprintln(dbg, "  Don't expect the system to keep running very long");
    }
    
    public static void main(String args[]) {
	XIDCache q = new XIDCache();

	for (int i = 0; i < 1000; i++ ) {
	    q.Start(i);
	}
	q.Clean();
	try {
	    Thread.currentThread().sleep(1000);
	} catch (InterruptedException e) {
	  Env.dprintln(dbg, "XIDCache:main: thread sleep was interrupted.");
	}
	q.Clean();

	XIDCacheItem qi = q.Find(36);
	if (qi == null) 
            System.out.print("no item 36 found\n");
	else
            qi.Print();
    }
    			
    class XIDCacheItem {
        long xid;
        long timeInQueueMS; // time it has been in the queue
        boolean inprogress; // is this packet in progress or done
        XDRPacket packet;
    
        void Print() {
            System.out.print("XIDCacheItem(xid=" + xid + ", timeInQueue="
                             + timeInQueueMS + ", inprogress=" + inprogress
                             + ")\n");
        }
    }
}
