package code;
//
// Copyright 1997, 1998 Steven James Procter
// All rights under copyright reserved.
//  
// Everyone is granted permission to copy, modify and redistribute this code.
// Modification or redistribution for profit is expressely disallowed.
// The copyright notice and this notice must be preserved on all copies.
// 
// This software is distributed as-is.  No warranty of merchantability or
// fitness for any purpose is stated or implied.
// 
// It is my intention that anyone be able to use this software but not
// incorporate it or any part of it into any product or any software which
// is sold without first obtaining a licensing agreement from me the author.
// 
// 							Steven James Procter
// 							steven@void.org
// 							March 1997
//
import java.io.File;

class nfs implements NFSConsts, MountdConsts, RPCConsts { 

  boolean useNFSRPCManager = true;
  rpcManager rpcmanager; // rpc packet dispatcher
  MountdHandler mountd;  // class to get and dispatch mountd requests
  NFSMTHandler nfs;	   // like mountdhandler for NFS requests
  Thread pmThread = null;// the portmapper thread 
  // parameters
  String cacheFileName = "test" + File.separatorChar + "cache";
  String exportsFileName = "test" + File.separatorChar + "exports";
  boolean runPortmap = true; // run portmapper in another thread?
  NFS2FS fs = null;

  // 
  // Prepare to run the NFS server.  The server is actually started with
  //   the method Run(), but this loads in all of the information and
  //   prepares everything to run.
  //
  public
  nfs(PathMapper pm, TimeMapper tm, FileSystemInfo fsi, String args[]){
  
    if(ProcessArguments(args) == false)
      return;
    if(StartPortmapper() == false)
      return;

    //
    // Create the RPC manager and register the request handlers for the
    //   services this RPC manager will provide, MOUNTD and NFS.
    //
    if(useNFSRPCManager){
	rpcmanager = new NFSRPCManager((int)NFS_PORT);
    }else{
      rpcmanager = new rpcManager((int) NFS_PORT);
    }
    // Create the handle cache.  This is the list of file name to
    //   handle mappings used to make the NFS fhandle.
    Handle handles = new Handle("cache", pm);

    // create the handler for NFS calls
    assert fs != null;
    nfs = new NFSMTHandler(fs, handles, pm, fsi, tm);
    rpcmanager.RegisterHandler(nfs);
    PortmapRegister nfsreg = new PortmapRegister(nfs.Program(),
                                                 nfs.Version(),
                                                 UDPProto, NFS_PORT);

    // load in the exports file - if it doesn't exist all mount
    //   requests will be refused
    Exports exports = new Exports(exportsFileName, pm);
    System.out.println("reading exports file");
    if (exports.ReadExports() == false) {
      System.err.println("!!! Warning: no exports file" +
                         " - no mounts will be allowed.");
    }
    System.out.println("  done");

    // create and register a mountd handler
    mountd = new MountdHandler(handles, exports, pm);
    rpcmanager.RegisterHandler(mountd);
    PortmapRegister mdreg = new PortmapRegister(mountd.Program(),
                                                mountd.Version(),
                                                UDPProto, NFS_PORT);
  }

  //
  // process the command line arguments.  Mainly this collects parameters
  //   from the user and sets flags (like runPortmap or exportsFileName).
  //
  boolean ProcessArguments(String args[]) {
    
    for(int i = 0; i < args.length; i++){
      if(args[i].equals("-p")){
        runPortmap = false;
      }else if(args[i].equals("-c")){
        if (i + 1 >= args.length) {
          System.err.println("Too few arguments for -c");
          Usage();
          return false;
        }
        i++;
        cacheFileName = args[i];
      }else if (args[i].equals("-e")) {
        if (i + 1 >= args.length) {
          System.err.println("Too few arguments for -e");
          Usage();
          return false;
        }
        i++;
        cacheFileName = args[i];
      }else if(args[i].equalsIgnoreCase("ramdisk")){
        // create a practi NFS2FS instance for NFS handler
        PRACTIFSLocalInterface pli;
        NodeId myNodeId = null;

        if((i + 2) >= args.length){
          System.err.println("Too few arguments for ramdisk");
          Usage();
          return(false);
        }else{
          String configFileName; // Name of the configuration file

          configFileName = args[i + 1];
          try{
            myNodeId = new NodeId(Integer.parseInt(args[i + 2]));
          }catch(NumberFormatException e){
            System.err.println("Self node ID must be an integer");
            return(false);
          }
        }
        i += 2;

        pli = new FakePRACTIFSLocalInterface(myNodeId);
        fs = new PRACTIFS(pli, true);
      }else if(args[i].equalsIgnoreCase("practi")){
        String configFileName; // Name of the configuration file
        NodeId myNodeId; // My own node ID
	boolean noSyncLog;
	boolean cleanDb;

        if((i + 4) >= args.length){
          System.err.println("Too few arguments for practi");
          Usage();
          return(false);
        }else{
          configFileName = args[i + 1];
          try{
            myNodeId = new NodeId(Integer.parseInt(args[i + 2]));
          }catch(NumberFormatException e){
            System.err.println("Self node ID must be an integer");
            return(false);
          }
        
	 
	  if (args[i+3].equalsIgnoreCase("false") ){
	    cleanDb = false;
	  }else if (args[i+3].equalsIgnoreCase("true") ){
	    cleanDb = true;
	  }else{
	    Usage();
	    return false;
	  }

	  
	  if (args[i+4].equalsIgnoreCase("false") ){
	    noSyncLog = false;
	  }else if (args[i+4].equalsIgnoreCase("true") ){
	    noSyncLog = true;
	  }else{
	    Usage();
	    return false;
	  }
	}
        i += 4;
    
        // create a practi NFS2FS instance for NFS handler
        PRACTIFSLocalInterface pli;
        
        URANode uraNode = new URANode(configFileName,
                                      myNodeId,
                                      Controller.NULL_CONTROLLER,
                                      cleanDb, noSyncLog, 
				      false, //logging LocalInterface operation
				      "test/LIOp.log");
        LocalInterface li = uraNode.getLocalInterface();
        pli = new PRACTIFSLocalInterface(li, myNodeId);
        fs = new PRACTIFS(pli, true); // Always make root, always bound
     /* 
      }else if (args[i].equalsIgnoreCase("pangaea")){
        //[pangaea configFile p2ConfigFile myNodeId clearDB overlogFile nodeMapFile]
        String configFile, p2ConfigFile, overlogFile, nodeMapFile; // Name of the configuration file
        NodeId myNodeId; // My own node ID
        boolean clearDB = true;
	boolean noSyncLog;

        if((i + 7) >= args.length){
          System.err.println("Too few arguments for pangaea");
          Usage();
          return(false);
        }else{
          configFile = args[i + 1];
          p2ConfigFile = args[i + 2];
          
          try{
            myNodeId = new NodeId(Integer.parseInt(args[i + 3]));
          }catch(NumberFormatException e){
            System.err.println("Self node ID must be an integer");
            return(false);
          }
          if (args[i+4].equalsIgnoreCase("false") ){
            clearDB = false;
          }else if (args[i+4].equalsIgnoreCase("true") ){
            clearDB = true;
          }else{
            Usage();
            return false;
          }
          

          overlogFile = args[i + 5];
          nodeMapFile = args[i + 6];
	  
	  if (args[i+7].equalsIgnoreCase("false") ){
            noSyncLog = false;
          }else if (args[i+7].equalsIgnoreCase("true") ){
            noSyncLog = true;
          }else{
            Usage();
            return false;
          }
          
        }
        i += 7;
	
	//create the config file for expt1
	String prefix = "test"+File.separatorChar + "tmp.pfsexpt1";
	CreateConfigForExpt1.makeConfigs(prefix);
        // create a pangaea NFS2FS instance for NFS handler
        PangaeaURAOverlogNode uraNode = new PangaeaURAOverlogNode(prefix+".config",
                                                                  prefix +".p2config",
                                                                  myNodeId,
                                                                  clearDB,
                                                                  overlogFile,
                                                                  prefix+".map",
								  noSyncLog);
        fs = uraNode.getFS();
        
      }

      else if (args[i].equalsIgnoreCase("tierstore")){
        //[pangaea configFile p2ConfigFile myNodeId clearDB overlogFile nodeMapFile]
        String configFile, p2ConfigFile, overlogFile, nodeMapFile; // Name of the configuration file
        NodeId myNodeId; // My own node ID
        boolean clearDB = true;
	boolean noSyncLog;

        if((i + 7) >= args.length){
          System.err.println("Too few arguments for tierstore");
          Usage();
          return(false);
        }else{
          configFile = args[i + 1];
          p2ConfigFile = args[i + 2];
          
          try{
            myNodeId = new NodeId(Integer.parseInt(args[i + 3]));
          }catch(NumberFormatException e){
            System.err.println("Self node ID must be an integer");
            return(false);
          }
          if (args[i+4].equalsIgnoreCase("false") ){
            clearDB = false;
          }else if (args[i+4].equalsIgnoreCase("true") ){
            clearDB = true;
          }else{
            Usage();
            return false;
          }
          

          overlogFile = args[i + 5];
          nodeMapFile = args[i + 6];
	  
	  if (args[i+7].equalsIgnoreCase("false") ){
            noSyncLog = false;
          }else if (args[i+7].equalsIgnoreCase("true") ){
            noSyncLog = true;
          }else{
            Usage();
            return false;
          }
          
        }
        i += 7;
    
        // create a pangaea NFS2FS instance for NFS handler
        TierStoreURAOverlogNode uraNode = new TierStoreURAOverlogNode(configFile,
                                                                  p2ConfigFile,
                                                                  myNodeId,
                                                                  clearDB,
                                                                  overlogFile,
                                                                  nodeMapFile,
								  noSyncLog);
        fs = uraNode.getFS();
        
      }

      else if (args[i].equalsIgnoreCase("bayou")){
        //[bayou configFile p2ConfigFile myNodeId clearDB overlogFile nodeMapFile]
        String configFile, p2ConfigFile, overlogFile, nodeMapFile; // Name of the configuration file
        NodeId myNodeId; // My own node ID
        boolean clearDB = true;

        if((i + 6) >= args.length){
          System.err.println("Too few arguments for bayou");
          Usage();
          return(false);
        }else{
          configFile = args[i + 1];
          p2ConfigFile = args[i + 2];
          
          try{
            myNodeId = new NodeId(Integer.parseInt(args[i + 3]));
          }catch(NumberFormatException e){
            System.err.println("Self node ID must be an integer");
            return(false);
          }
          if (args[i+4].equalsIgnoreCase("false") ){
            clearDB = false;
          }else if (args[i+4].equalsIgnoreCase("true") ){
            clearDB = true;
          }else{
            Usage();
            return false;
          }
          
          overlogFile = args[i + 5];
          nodeMapFile = args[i + 6];
        }
        i += 6;
    
        // create a pangaea NFS2FS instance for NFS handler
        BayouNode bayouNode = new BayouNode(configFile,
					    p2ConfigFile,
					    myNodeId,
					    clearDB,
					    overlogFile,
					    nodeMapFile);
        try {
          bayouNode.start();
          fs = bayouNode.getFS();
        }catch(Exception e) {
          System.err.println("Could not start Bayou Node");
          e.printStackTrace();
          return false;
        }
                                                        
      }else if (args[i].equalsIgnoreCase("chainRep")){
        //[bayou configFile p2ConfigFile myNodeId clearDB overlogFile nodeMapFile]
        String configFile, p2ConfigFile, overlogFile, nodeMapFile; // Name of the configuration file
        NodeId myNodeId; // My own node ID
        boolean clearDB = true;

        if((i + 6) >= args.length){
          System.err.println("Too few arguments for chainRep");
          Usage();
          return(false);
        }else{
          configFile = args[i + 1];
          p2ConfigFile = args[i + 2];
          
          try{
            myNodeId = new NodeId(Integer.parseInt(args[i + 3]));
          }catch(NumberFormatException e){
            System.err.println("Self node ID must be an integer");
            return(false);
          }
          if (args[i+4].equalsIgnoreCase("false") ){
            clearDB = false;
          }else if (args[i+4].equalsIgnoreCase("true") ){
            clearDB = true;
          }else{
            Usage();
            return false;
          }
          
          overlogFile = args[i + 5];
          nodeMapFile = args[i + 6];
        }
        i += 6;
    
        // create a ChainRepNode 
        ChainReplicationNode chainRepNode = new ChainReplicationNode(configFile,
                                                                     p2ConfigFile,
                                                                     myNodeId,
                                                                     clearDB,
                                                                     overlogFile,
                                                                     nodeMapFile,
                                                                     true, // nfs
                                                                     false); // disable vol for now
        try {
          chainRepNode.start();
          fs = chainRepNode.getFS();
        }catch(Exception e) {
          System.err.println("Could not start ChainRep Node");
          e.printStackTrace();
          return false;
        }
       */                                                         
      }else{
        Usage();
        return false;
      }
    }

    
    return true;
  }

    // print out a usage message
    void Usage() {
	System.err.println("Usage: ntnfs [-p]\n" + 
			   " [-c cache-file-name]\n" +
			   " [-e exports-file-name]\n" +
                           " [ramdisk configfile mynodeid\n" +
			   " | practi configFile myNodeId cleanDB noSyncLog\n" +
                           " | pangaea configFile p2ConfigFile myNodeId clearDB overlogFileName nodeMapFile noSyncLog]\n" +
			   " | tierstore configFile p2ConfigFile myNodeId clearDB overlogFileName nodeMapFile noSyncLog]\n" +
			   " | bayou configFile p2ConfigFile myNodeId clearDB overlogFileName nodeMapFile]\n" +
" | bayou configFile p2ConfigFile myNodeId clearDB overlogFileName nodeMapFile]\n");
    }
    
    //
    // If the portmapper is to run in this process, create a thread for it and
    //   start it in that thread.
    //
    boolean StartPortmapper() {
	if (runPortmap) {
	    System.out.println("Starting portmapper.");
	    portmap pmap = new portmap();
	    pmThread = new Thread(pmap);
	    pmThread.start();

	    // give the portmap thread a little time to run
	    try {
		Thread.currentThread().sleep(3 * 1000);
	    } catch(InterruptedException e) {
		System.err.println("portmapper thread sleep interrupted");
		return false;
	    }
	}

	return true;
    };

  // Start getting and processing packets.  This procedure should not return.
  void Run() {
    // get packets and dispatch them forever
    rpcmanager.MainLoop();
  };
    
    public static void main(String args[]) {
	System.err.println("You cannot run NFS directly.  You need to specify");
	System.err.println("which platform you want to run on by starting the");
	System.err.println("NFS for that platform.  Currently supported are:");
	System.err.println("\tPlatform\tStart up command");
	System.err.println("\t--------\t----------------");
	System.err.println("\twindows 95\tjava win95nfs");
	System.err.println("\twindows NT\tjava ntnfs");
	System.err.println("\tunix\t\tjava unixnfs");
    };
};
