 /** 
 *  Represent the data structures used by the NFS COMMIT 3 call 
 **/ 

 /** 
 *  Represent the arguments to the NFS COMMIT 3 call 
 **/ 
class COMMIT3args{

 /** 
 *  Data members 
 **/ 
  private final NFS_nfs_fh3 file;
  private final long offset;
  private final int count;

 /** 
 *  Constructor 
 **/ 
  public
  COMMIT3args(NFS_nfs_fh3 newFile, long newOffset, int newCount){
    this.file = newFile;
    this.offset = newOffset;
    this.count = newCount;
  }

 /** 
 *  Return the file handle 
 **/ 
  public NFS_nfs_fh3
  getFile(){
    return(this.file);
  }

 /** 
 *  Return the offset 
 **/ 
  public long
  getOffset(){
    return(this.offset);
  }

 /** 
 *  Return the count 
 **/ 
  public int
  getCount(){
    return(this.count);
  }

 /** 
 *  Return true if "obj" equals "this" 
 **/ 
  public final boolean
  equals(Object obj){
    boolean eq = false;
    COMMIT3args args = null;

    // 2 Java-declared fields, 3 self-declared field
    assert(this.getClass().getDeclaredFields().length == 5);
    if(obj instanceof COMMIT3args){
      args = (COMMIT3args)obj;
      eq = (this.file.equals(args.file) &&
            (this.offset == args.offset) &&
            (this.count == args.count));
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Compute and return a hashcode for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 3 self-declared field
    assert(this.getClass().getDeclaredFields().length == 5);
    code = (this.file.hashCode() ^
            (new Long(this.offset)).hashCode() ^
            (new Integer(this.count)).hashCode());

    return(code);
  }
}

 /** 
 *  Represent the results of  NFS COMMIT 3 call if successful 
 **/ 
class COMMIT3resok{

 /** 
 *  Data members 
 **/ 
  private final NFS_wcc_data fileWCC;
  private final NFS_writeverf3 verf;

 /** 
 *  Constructor 
 **/ 
  public
  COMMIT3resok(NFS_wcc_data newFileWCC, NFS_writeverf3 newVerf){
    this.fileWCC = newFileWCC;
    this.verf = newVerf;
  }

 /** 
 *  Return the file weak-cache-consistency data 
 **/ 
  public NFS_wcc_data
  getFileWCC(){
    return(this.fileWCC);
  }

 /** 
 *  Return the write verification token 
 **/ 
  public NFS_writeverf3
  getVerf(){
    return(this.verf);
  }

 /** 
 *  Return true if "obj" equals "this" 
 **/ 
  public final boolean
  equals(Object obj){
    boolean eq = false;
    COMMIT3resok resok = null;

    // 2 Java-declared fields, 2 self-declared field
    assert(this.getClass().getDeclaredFields().length == 4);
    if(obj instanceof COMMIT3resok){
      resok = (COMMIT3resok)obj;
      eq = this.fileWCC.equals(resok.fileWCC) && this.verf.equals(resok.verf);
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Compute and return a hashcode for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 2 self-declared field
    assert(this.getClass().getDeclaredFields().length == 4);
    code = this.fileWCC.hashCode() ^ this.verf.hashCode();

    return(code);
  }
}

 /** 
 *  Represent the results of  NFS COMMIT 3 call if unsuccessful 
 **/ 
class COMMIT3resfail{

 /** 
 *  Data members 
 **/ 
  private final NFS_wcc_data fileWCC;

 /** 
 *  Constructor 
 **/ 
  public
  COMMIT3resfail(NFS_wcc_data newFileWCC){
    this.fileWCC = newFileWCC;
  }

 /** 
 *  Return the file weak-cache-consistency data 
 **/ 
  public NFS_wcc_data
  getFileWCC(){
    return(this.fileWCC);
  }

 /** 
 *  Return true if "obj" equals "this" 
 **/ 
  public final boolean
  equals(Object obj){
    boolean eq = false;
    COMMIT3resfail resfail = null;

    // 2 Java-declared fields, 1 self-declared field
    assert(this.getClass().getDeclaredFields().length == 3);
    if(obj instanceof COMMIT3resfail){
      resfail = (COMMIT3resfail)obj;
      eq = this.fileWCC.equals(resfail.fileWCC);
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Compute and return a hashcode for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 1 self-declared field
    assert(this.getClass().getDeclaredFields().length == 3);
    code = this.fileWCC.hashCode();

    return(code);
  }
}

 /** 
 *  Represent the results to the NFS 3 COMMIT call 
 **/ 
class COMMIT3res implements Immutable{

 /** 
 *  Data members 
 **/ 
  private final int status;
  private final COMMIT3resok resok;
  private final COMMIT3resfail resfail;

 /** 
 *  Constructor 
 **/ 
  public
  COMMIT3res(int newStatus,
             COMMIT3resok newResOk,
             COMMIT3resfail newResFail){
    this.status = newStatus;
    this.resok = newResOk;
    this.resfail = newResFail;
    assert(((this.status == NFS_nfsstat3.NFS3_OK) && (this.resok != null)) ||
           ((this.status != NFS_nfsstat3.NFS3_OK) && (this.resfail != null)));
  }

 /** 
 *  Return the status 
 **/ 
  public int
  getStatus(){
    return(this.status);
  }

 /** 
 *  Return the result data if successful 
 **/ 
  public
  COMMIT3resok getResOk(){
    assert(this.status == NFS_nfsstat3.NFS3_OK);
    return(this.resok);
  }

 /** 
 *  Return the result data if the call failed 
 **/ 
  public
  COMMIT3resfail getResFail(){
    assert(this.status != NFS_nfsstat3.NFS3_OK);
    return(this.resfail);
  }

 /** 
 *  Return true if "obj" equals "this" 
 **/ 
  public final boolean
  equals(Object obj){
    boolean eq = false;
    COMMIT3res res = null;

    // 2 Java-declared fields, 3 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 5);
    if(obj instanceof COMMIT3res){
      res = (COMMIT3res)obj;
      if(this.status == res.status){
        if(this.status == NFS_nfsstat3.NFS3_OK){
          eq = this.resok.equals(res.resok);
        }else{
          eq = this.resfail.equals(res.resfail);
        }
      }else{
        eq = false;
      }
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Compute and return a hashcode for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 3 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 5);
    if(this.status == NFS_nfsstat3.NFS3_OK){
      code = (new Integer(this.status)).hashCode() ^ this.resok.hashCode();
    }else{
      code = (new Integer(this.status)).hashCode() ^ this.resfail.hashCode();
    }
    return(code);
  }
}

 /** 
 *  Used for testing 
 **/ 
public class COMMIT3{

 /** 
 *  Used for testing 
 **/ 
  public static void
  main(String[] argv){
    Env.verifyAssertEnabled();
    System.err.println("COMMIT3 self test...");
    COMMIT3.testCOMMIT3args();
    COMMIT3.testCOMMIT3resok();
    COMMIT3.testCOMMIT3resfail();
    COMMIT3.testCOMMIT3res();
    System.err.println("...COMMIT3 self test succeeds");
    System.exit(0);
  }

 /** 
 *  Test the COMMIT3args class 
 **/ 
  private static void
  testCOMMIT3args(){
    COMMIT3args args1 = null;
    COMMIT3args args2 = null;
    COMMIT3args args3 = null;

    // Test 1
    args1 = new COMMIT3args(NFS_nfs_fh3.makeAllZeroHandle(), 10, 20);
    assert(args1.getFile().equals(NFS_nfs_fh3.makeAllZeroHandle()));
    assert(args1.getOffset() == 10);
    assert(args1.getCount() == 20);
    assert(args1.equals(args1));

    // Test 2
    args2 = new COMMIT3args(NFS_nfs_fh3.makeAllZeroHandle(), 70, 45);
    assert(args2.getFile().equals(NFS_nfs_fh3.makeAllZeroHandle()));
    assert(args2.getOffset() == 70);
    assert(args2.getCount() == 45);
    assert(args2.equals(args2));
    assert(!args2.equals(args1));
    assert(!args1.equals(args2));
    assert(args2.hashCode() != args1.hashCode());

    // Test 3
    args3 = new COMMIT3args(NFS_nfs_fh3.makeAllZeroHandle(), 10, 20);
    assert(args3.getFile().equals(NFS_nfs_fh3.makeAllZeroHandle()));
    assert(args3.getOffset() == 10);
    assert(args3.getCount() == 20);
    assert(args3.equals(args3));
    assert(args3.equals(args1));
    assert(args1.equals(args3));
    assert(!args3.equals(args2));
    assert(!args2.equals(args3));
    assert(args3.hashCode() == args1.hashCode());
    assert(args3.hashCode() != args2.hashCode());
  }

 /** 
 *  Test the COMMIT3resok class 
 **/ 
  private static void
  testCOMMIT3resok(){
    COMMIT3resok resok1 = null;
    COMMIT3resok resok2 = null;
    COMMIT3resok resok3 = null;
    NFS_wcc_data data1 = null;
    NFS_wcc_data data2 = null;
    NFS_pre_op_attr pre_attr1 = null;
    NFS_pre_op_attr pre_attr2 = null;
    NFS_post_op_attr post_attr1 = null;

    // Test 1
    pre_attr1 = new NFS_pre_op_attr(true,
                                    new
                                    NFS_wcc_attr(54,
                                                 new NFS_nfstime3(78, 80),
                                                 new NFS_nfstime3(23, 12)));
    post_attr1 = new NFS_post_op_attr(true,
                                      new NFS_fattr3(NFS_ftype3.NF3REG,
                                                     36,
                                                     63,
                                                     71,
                                                     85,
                                                     (72L << 32) + 83L,
                                                     (81L << 32) + 66L,
                                                     new NFS_specdata3(55, 49),
                                                     (22L << 32) + 68L,
                                                     (99L << 32) + 163L,
                                                     new NFS_nfstime3(43, 7),
                                                     new NFS_nfstime3(31, 48),
                                                     new NFS_nfstime3(12, 8)));
    data1 = new NFS_wcc_data(pre_attr1, post_attr1);
    resok1 = new COMMIT3resok(data1, new NFS_writeverf3(new byte[8]));
    assert(resok1.getFileWCC().equals(data1));
    assert(resok1.getVerf().equals(new NFS_writeverf3(new byte[8])));
    assert(resok1.equals(resok1));

    // Test 2
    pre_attr2 = new NFS_pre_op_attr(true,
                                    new
                                    NFS_wcc_attr(4563,
                                                 new NFS_nfstime3(78, 80),
                                                 new NFS_nfstime3(23, 12)));
    data2 = new NFS_wcc_data(pre_attr2, post_attr1);
    resok2 = new COMMIT3resok(data2, new NFS_writeverf3(new byte[8]));
    assert(resok2.getFileWCC().equals(data2));
    assert(resok2.getVerf().equals(new NFS_writeverf3(new byte[8])));
    assert(resok2.equals(resok2));
    assert(!resok2.equals(resok1));
    assert(!resok1.equals(resok2));
    assert(resok2.hashCode() != resok1.hashCode());

    // Test 3
    resok3 = new COMMIT3resok(data1, new NFS_writeverf3(new byte[8]));
    assert(resok3.getFileWCC().equals(data1));
    assert(resok3.getVerf().equals(new NFS_writeverf3(new byte[8])));
    assert(resok3.equals(resok3));
    assert(resok3.equals(resok1));
    assert(resok1.equals(resok3));
    assert(!resok3.equals(resok2));
    assert(!resok2.equals(resok3));
    assert(resok3.hashCode() == resok1.hashCode());
    assert(resok3.hashCode() != resok2.hashCode());
  }

 /** 
 *  Test the COMMIT3resfail class 
 **/ 
  private static void
  testCOMMIT3resfail(){
    COMMIT3resfail resfail1 = null;
    COMMIT3resfail resfail2 = null;
    COMMIT3resfail resfail3 = null;
    NFS_pre_op_attr pre_attr1 = null;
    NFS_pre_op_attr pre_attr2 = null;
    NFS_post_op_attr post_attr1 = null;

    // Test 1
    pre_attr1 = new NFS_pre_op_attr(true,
                                    new
                                    NFS_wcc_attr(54,
                                                 new NFS_nfstime3(78, 80),
                                                 new NFS_nfstime3(23, 12)));
    post_attr1 = new NFS_post_op_attr(true,
                                      new NFS_fattr3(NFS_ftype3.NF3REG,
                                                     36,
                                                     63,
                                                     71,
                                                     85,
                                                     (72L << 32) + 83L,
                                                     (81L << 32) + 66L,
                                                     new NFS_specdata3(55, 49),
                                                     (22L << 32) + 68L,
                                                     (99L << 32) + 163L,
                                                     new NFS_nfstime3(43, 7),
                                                     new NFS_nfstime3(31, 48),
                                                     new NFS_nfstime3(12, 8)));
    resfail1 = new COMMIT3resfail(new NFS_wcc_data(pre_attr1, post_attr1));
    assert(resfail1.getFileWCC().equals(new NFS_wcc_data(pre_attr1,
                                                         post_attr1)));
    assert(resfail1.equals(resfail1));

    // Test 2
    pre_attr2 = new NFS_pre_op_attr(true,
                                    new
                                    NFS_wcc_attr(4563,
                                                 new NFS_nfstime3(78, 80),
                                                 new NFS_nfstime3(23, 12)));
    resfail2 = new COMMIT3resfail(new NFS_wcc_data(pre_attr2, post_attr1));
    assert(resfail2.getFileWCC().equals(new NFS_wcc_data(pre_attr2,
                                                         post_attr1)));
    assert(resfail2.equals(resfail2));
    assert(!resfail2.equals(resfail1));
    assert(!resfail1.equals(resfail2));
    assert(resfail2.hashCode() != resfail1.hashCode());

    // Test 3
    resfail3 = new COMMIT3resfail(new NFS_wcc_data(pre_attr1, post_attr1));
    assert(resfail3.getFileWCC().equals(new NFS_wcc_data(pre_attr1,
                                                         post_attr1)));
    assert(resfail3.equals(resfail3));
    assert(resfail3.equals(resfail1));
    assert(resfail1.equals(resfail3));
    assert(!resfail3.equals(resfail2));
    assert(!resfail2.equals(resfail3));
    assert(resfail3.hashCode() == resfail1.hashCode());
    assert(resfail3.hashCode() != resfail2.hashCode());
  }

 /** 
 *  Test the COMMIT3res class 
 **/ 
  private static void
  testCOMMIT3res(){
    COMMIT3res res1 = null;
    COMMIT3res res2 = null;
    COMMIT3res res3 = null;
    COMMIT3resok resok = null;
    COMMIT3resfail resfail = null;
    NFS_entryplus3 entry = null;

    // Test 1
    resok = new COMMIT3resok(new NFS_wcc_data(new NFS_pre_op_attr(false, null),
                                              new NFS_post_op_attr(false,
                                                                   null)),
                             new NFS_writeverf3(new byte[8]));
    res1 = new COMMIT3res(NFS_nfsstat3.NFS3_OK, resok, null);
    assert(res1.getStatus() == NFS_nfsstat3.NFS3_OK);
    assert(res1.getResOk().equals(resok));
    assert(res1.equals(res1));

    // Test 2
    resfail = new COMMIT3resfail(new NFS_wcc_data(new NFS_pre_op_attr(false,
                                                                      null),
                                                  new NFS_post_op_attr(false,
                                                                       null)));
    res2 = new COMMIT3res(NFS_nfsstat3.NFS3ERR_IO, null, resfail);
    assert(res2.getStatus() == NFS_nfsstat3.NFS3ERR_IO);
    assert(res2.getResFail().equals(resfail));
    assert(res2.equals(res2));
    assert(!res2.equals(res1));
    assert(!res1.equals(res2));
    assert(res2.hashCode() != res1.hashCode());

    // Test 3
    res3 = new COMMIT3res(NFS_nfsstat3.NFS3_OK, resok, null);
    assert(res3.getStatus() == NFS_nfsstat3.NFS3_OK);
    assert(res3.getResOk().equals(resok));
    assert(res3.equals(res3));
    assert(res3.equals(res1));
    assert(res1.equals(res3));
    assert(!res3.equals(res2));
    assert(!res2.equals(res3));
    assert(res3.hashCode() == res1.hashCode());
    assert(res3.hashCode() != res2.hashCode());
  }
}

 /** 
 *  $Log: COMMIT3.java,v $ 
 *  Revision 1.1  2006/06/12 20:07:19  nayate 
 *  First version of the Java NFS library 
 *  
 **/ 
