 /** 
 *  Represent the data structures used by the NFS FSINFO 3 call 
 **/ 

 /** 
 *  Represent the arguments to the NFS FSINFO 3 call 
 **/ 
class FSINFO3args{

 /** 
 *  Data members 
 **/ 
  private final NFS_nfs_fh3 fsroot;

 /** 
 *  Constructor 
 **/ 
  public
  FSINFO3args(NFS_nfs_fh3 newFSRoot){
    this.fsroot = newFSRoot;
  }

 /** 
 *  Return the file system root 
 **/ 
  public NFS_nfs_fh3
  getFSRoot(){
    return(this.fsroot);
  }

 /** 
 *  Return true if "obj" equals "this" 
 **/ 
  public final boolean
  equals(Object obj){
    boolean eq = false;
    FSINFO3args args = null;

    // 2 Java-declared fields, 1 self-declared field
    assert(this.getClass().getDeclaredFields().length == 3);
    if(obj instanceof FSINFO3args){
      args = (FSINFO3args)obj;
      eq = this.fsroot.equals(args.fsroot);
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Compute and return a hashcode for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 1 self-declared field
    assert(this.getClass().getDeclaredFields().length == 3);
    code = this.fsroot.hashCode();

    return(code);
  }
}

 /** 
 *  Represent the results of  NFS FSINFO 3 call if successful 
 **/ 
class FSINFO3resok{

 /** 
 *  Data members 
 **/ 
  private final NFS_post_op_attr objAttributes;
  private final int rtmax;
  private final int rtpref;
  private final int rtmult;
  private final int wtmax;
  private final int wtpref;
  private final int wtmult;
  private final int dtpref;

 /** 
 *  Constructor 
 **/ 
  public
  FSINFO3resok(NFS_post_op_attr newObjAttributes,
               int newRTMax,
               int newRTPref,
               int newRTMult,
               int newWTMax,
               int newWTPref,
               int newWTMult,
               int newDTPref){
    this.objAttributes = newObjAttributes;
    this.rtmax = newRTMax;
    this.rtpref = newRTPref;
    this.rtmult = newRTMult;
    this.wtmax = newWTMax;
    this.wtpref = newWTPref;
    this.wtmult = newWTMult;
    this.dtpref = newDTPref;
  }

 /** 
 *  Return the object attributes 
 **/ 
  public NFS_post_op_attr
  getObjAttributes(){
    return(this.objAttributes);
  }

 /** 
 *  Return the rtmax value 
 **/ 
  public int
  getRTMax(){
    return(this.rtmax);
  }

 /** 
 *  Return the rtpref value 
 **/ 
  public int
  getRTPref(){
    return(this.rtpref);
  }

 /** 
 *  Return the rtmult value 
 **/ 
  public int
  getRTMult(){
    return(this.rtmult);
  }

 /** 
 *  Return the wtMax value 
 **/ 
  public int
  getWTMax(){
    return(this.wtmax);
  }

 /** 
 *  Return the wtPref value 
 **/ 
  public int
  getWTPref(){
    return(this.wtpref);
  }

 /** 
 *  Return the wtMult value 
 **/ 
  public int
  getWTMult(){
    return(this.wtmult);
  }

 /** 
 *  Return the invarsec value 
 **/ 
  public int
  getDTPref(){
    return(this.dtpref);
  }

 /** 
 *  Return true if "obj" equals "this" 
 **/ 
  public final boolean
  equals(Object obj){
    boolean eq = false;
    FSINFO3resok resok = null;

    // 2 Java-declared fields, 8 self-declared field
    assert(this.getClass().getDeclaredFields().length == 10);
    if(obj instanceof FSINFO3resok){
      resok = (FSINFO3resok)obj;
      eq = (this.objAttributes.equals(resok.objAttributes) &&
            (this.rtmax == resok.rtmax) &&
            (this.rtpref == resok.rtpref) &&
            (this.rtmult == resok.rtmult) &&
            (this.wtmax == resok.wtmax) &&
            (this.wtpref == resok.wtpref) &&
            (this.wtmult == resok.wtmult) &&
            (this.dtpref == resok.dtpref));
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Compute and return a hashcode for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 8 self-declared field
    assert(this.getClass().getDeclaredFields().length == 10);
    code = (this.objAttributes.hashCode() ^
            (new Long(this.rtmax)).hashCode() ^
            (new Long(this.rtpref)).hashCode() ^
            (new Long(this.rtmult)).hashCode() ^
            (new Long(this.wtmax)).hashCode() ^
            (new Long(this.wtpref)).hashCode() ^
            (new Long(this.wtmult)).hashCode() ^
            (new Long(this.dtpref)).hashCode());

    return(code);
  }
}

 /** 
 *  Represent the results of  NFS FSINFO 3 call if unsuccessful 
 **/ 
class FSINFO3resfail{

 /** 
 *  Data members 
 **/ 
  private final NFS_post_op_attr objAttributes;

 /** 
 *  Constructor 
 **/ 
  public
  FSINFO3resfail(NFS_post_op_attr newObjAttributes){
    this.objAttributes = newObjAttributes;
  }

 /** 
 *  Return the object attributes 
 **/ 
  public NFS_post_op_attr
  getObjAttributes(){
    return(this.objAttributes);
  }

 /** 
 *  Return true if "obj" equals "this" 
 **/ 
  public final boolean
  equals(Object obj){
    boolean eq = false;
    FSINFO3resfail resfail = null;

    // 2 Java-declared fields, 1 self-declared field
    assert(this.getClass().getDeclaredFields().length == 3);
    if(obj instanceof FSINFO3resfail){
      resfail = (FSINFO3resfail)obj;
      eq = this.objAttributes.equals(resfail.objAttributes);
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Compute and return a hashcode for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 1 self-declared field
    assert(this.getClass().getDeclaredFields().length == 3);
    code = this.objAttributes.hashCode();

    return(code);
  }
}

 /** 
 *  Represent the results to the NFS 3 FSINFO call 
 **/ 
class FSINFO3res implements Immutable{

 /** 
 *  Data members 
 **/ 
  private final int status;
  private final FSINFO3resok resok;
  private final FSINFO3resfail resfail;

 /** 
 *  Constructor 
 **/ 
  public
  FSINFO3res(int newStatus,
             FSINFO3resok newResOk,
             FSINFO3resfail newResFail){
    this.status = newStatus;
    this.resok = newResOk;
    this.resfail = newResFail;
    assert(((this.status == NFS_nfsstat3.NFS3_OK) && (this.resok != null)) ||
           ((this.status != NFS_nfsstat3.NFS3_OK) && (this.resfail != null)));
  }

 /** 
 *  Return the status 
 **/ 
  public int
  getStatus(){
    return(this.status);
  }

 /** 
 *  Return the result data if successful 
 **/ 
  public
  FSINFO3resok getResOk(){
    assert(this.status == NFS_nfsstat3.NFS3_OK);
    return(this.resok);
  }

 /** 
 *  Return the result data if the call failed 
 **/ 
  public
  FSINFO3resfail getResFail(){
    assert(this.status != NFS_nfsstat3.NFS3_OK);
    return(this.resfail);
  }

 /** 
 *  Return true if "obj" equals "this" 
 **/ 
  public final boolean
  equals(Object obj){
    boolean eq = false;
    FSINFO3res res = null;

    // 2 Java-declared fields, 3 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 5);
    if(obj instanceof FSINFO3res){
      res = (FSINFO3res)obj;
      if(this.status == res.status){
        if(this.status == NFS_nfsstat3.NFS3_OK){
          eq = this.resok.equals(res.resok);
        }else{
          eq = this.resfail.equals(res.resfail);
        }
      }else{
        eq = false;
      }
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Compute and return a hashcode for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 3 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 5);
    if(this.status == NFS_nfsstat3.NFS3_OK){
      code = (new Integer(this.status)).hashCode() ^ this.resok.hashCode();
    }else{
      code = (new Integer(this.status)).hashCode() ^ this.resfail.hashCode();
    }
    return(code);
  }
}

 /** 
 *  Used for testing 
 **/ 
public class FSINFO3{

 /** 
 *  Constants 
 **/ 
  public static final int FSF3_LINK = 0x0001;
  public static final int FSF3_SYMLINK = 0x0002;
  public static final int FSF3_HOMOGENOUS = 0x0008;
  public static final int FSF3_CANSETTIME = 0x0010;

 /** 
 *  Used for testing 
 **/ 
  public static void
  main(String[] argv){
    Env.verifyAssertEnabled();
    System.err.println("FSINFO3 self test...");
    FSINFO3.testFSINFO3args();
    FSINFO3.testFSINFO3resok();
    FSINFO3.testFSINFO3resfail();
    FSINFO3.testFSINFO3res();
    System.err.println("...FSINFO3 self test succeeds");
    System.exit(0);
  }

 /** 
 *  Test the FSINFO3args class 
 **/ 
  private static void
  testFSINFO3args(){
    FSINFO3args args1 = null;
    FSINFO3args args2 = null;
    FSINFO3args args3 = null;
    byte[] b1 = null;
    byte[] b2 = null;

    // Test 1
    b1 = new byte[64];
    b1[0] = 1;
    args1 = new FSINFO3args(NFS_nfs_fh3.makeHandle(b1));
    assert(args1.getFSRoot().equals(NFS_nfs_fh3.makeHandle(b1)));
    assert(args1.equals(args1));

    // Test 2
    b2 = new byte[64];
    b2[0] = 2;
    args2 = new FSINFO3args(NFS_nfs_fh3.makeHandle(b2));
    assert(args2.getFSRoot().equals(NFS_nfs_fh3.makeHandle(b2)));
    assert(args2.equals(args2));
    assert(!args2.equals(args1));
    assert(!args1.equals(args2));
    assert(args2.hashCode() != args1.hashCode());

    // Test 3
    args3 = new FSINFO3args(NFS_nfs_fh3.makeHandle(b1));
    assert(args3.getFSRoot().equals(NFS_nfs_fh3.makeHandle(b1)));
    assert(args3.equals(args3));
    assert(args3.equals(args1));
    assert(args1.equals(args3));
    assert(!args3.equals(args2));
    assert(!args2.equals(args3));
    assert(args3.hashCode() == args1.hashCode());
    assert(args3.hashCode() != args2.hashCode());
  }

 /** 
 *  Test the FSINFO3resok class 
 **/ 
  private static void
  testFSINFO3resok(){
    FSINFO3resok resok1 = null;
    FSINFO3resok resok2 = null;
    FSINFO3resok resok3 = null;

    // Test 1
    resok1 = new FSINFO3resok(new NFS_post_op_attr(false, null),
                              5,
                              6,
                              7,
                              8,
                              9,
                              10,
                              11);
    assert(resok1.getObjAttributes().equals(new NFS_post_op_attr(false,
                                                                 null)));
    assert(resok1.getRTMax() == 5);
    assert(resok1.getRTPref() == 6);
    assert(resok1.getRTMult() == 7);
    assert(resok1.getWTMax() == 8);
    assert(resok1.getWTPref() == 9);
    assert(resok1.getWTMult() == 10);
    assert(resok1.getDTPref() == 11);
    assert(resok1.equals(resok1));

    // Test 2
    resok2 = new FSINFO3resok(new NFS_post_op_attr(false, null),
                              1,
                              2,
                              3,
                              4,
                              5,
                              6,
                              7);
    assert(resok2.getRTMax() == 1);
    assert(resok2.getRTPref() == 2);
    assert(resok2.getRTMult() == 3);
    assert(resok2.getWTMax() == 4);
    assert(resok2.getWTPref() == 5);
    assert(resok2.getWTMult() == 6);
    assert(resok2.getDTPref() == 7);
    assert(resok2.equals(resok2));
    assert(!resok2.equals(resok1));
    assert(!resok1.equals(resok2));
    assert(resok2.hashCode() != resok1.hashCode());

    // Test 3
    resok3 = new FSINFO3resok(new NFS_post_op_attr(false, null),
                              5,
                              6,
                              7,
                              8,
                              9,
                              10,
                              11);
    assert(resok3.getObjAttributes().equals(new NFS_post_op_attr(false,
                                                                 null)));
    assert(resok3.getRTMax() == 5);
    assert(resok3.getRTPref() == 6);
    assert(resok3.getRTMult() == 7);
    assert(resok3.getWTMax() == 8);
    assert(resok3.getWTPref() == 9);
    assert(resok3.getWTMult() == 10);
    assert(resok3.getDTPref() == 11);
    assert(resok3.equals(resok3));
    assert(resok3.equals(resok1));
    assert(resok1.equals(resok3));
    assert(!resok3.equals(resok2));
    assert(!resok2.equals(resok3));
    assert(resok3.hashCode() == resok1.hashCode());
    assert(resok3.hashCode() != resok2.hashCode());
  }

 /** 
 *  Test the FSINFO3resfail class 
 **/ 
  private static void
  testFSINFO3resfail(){
    FSINFO3resfail resfail1 = null;
    FSINFO3resfail resfail2 = null;
    FSINFO3resfail resfail3 = null;
    NFS_post_op_attr postAttr1 = null;
    NFS_post_op_attr postAttr2 = null;

    // Test 1
    postAttr1 = new NFS_post_op_attr(true,
                                     new NFS_fattr3(NFS_ftype3.NF3REG,
                                                    36,
                                                    63,
                                                    71,
                                                    85,
                                                    (72L << 32) + 83L,
                                                    (81L << 32) + 66L,
                                                    new NFS_specdata3(55, 49),
                                                    (22L << 32) + 68L,
                                                    (99L << 32) + 163L,
                                                    new NFS_nfstime3(43, 7),
                                                    new NFS_nfstime3(31, 48),
                                                    new NFS_nfstime3(12, 8)));
    postAttr2 = new NFS_post_op_attr(true,
                                     new NFS_fattr3(NFS_ftype3.NF3REG,
                                                    63,
                                                    36,
                                                    17,
                                                    58,
                                                    (27L << 23) + 38L,
                                                    (18L << 23) + 66L,
                                                    new NFS_specdata3(55, 94),
                                                    (22L << 23) + 86L,
                                                    (99L << 23) + 361L,
                                                    new NFS_nfstime3(34, 70),
                                                    new NFS_nfstime3(14, 84),
                                                    new NFS_nfstime3(21, 80)));
    resfail1 = new FSINFO3resfail(postAttr1);
    assert(resfail1.getObjAttributes().equals(postAttr1));
    assert(resfail1.equals(resfail1));

    // Test 2
    resfail2 = new FSINFO3resfail(postAttr2);
    assert(resfail2.getObjAttributes().equals(postAttr2));
    assert(resfail2.equals(resfail2));
    assert(!resfail2.equals(resfail1));
    assert(!resfail1.equals(resfail2));
    assert(resfail2.hashCode() != resfail1.hashCode());

    // Test 3
    resfail3 = new FSINFO3resfail(postAttr1);
    assert(resfail3.getObjAttributes().equals(postAttr1));
    assert(resfail3.equals(resfail3));
    assert(resfail3.equals(resfail1));
    assert(resfail1.equals(resfail3));
    assert(!resfail3.equals(resfail2));
    assert(!resfail2.equals(resfail3));
    assert(resfail3.hashCode() == resfail1.hashCode());
    assert(resfail3.hashCode() != resfail2.hashCode());
  }

 /** 
 *  Test the FSINFO3res class 
 **/ 
  private static void
  testFSINFO3res(){
    FSINFO3res res1 = null;
    FSINFO3res res2 = null;
    FSINFO3res res3 = null;
    FSINFO3resok resok = null;
    FSINFO3resfail resfail = null;
    NFS_entryplus3 entry = null;

    // Test 1
    resok = new FSINFO3resok(new NFS_post_op_attr(false, null),
                             5,
                             6,
                             7,
                             8,
                             9,
                             10,
                             11);
    res1 = new FSINFO3res(NFS_nfsstat3.NFS3_OK, resok, null);
    assert(res1.getStatus() == NFS_nfsstat3.NFS3_OK);
    assert(res1.getResOk().equals(resok));
    assert(res1.equals(res1));

    // Test 2
    resfail = new FSINFO3resfail(new NFS_post_op_attr(false, null));
    res2 = new FSINFO3res(NFS_nfsstat3.NFS3ERR_IO, null, resfail);
    assert(res2.getStatus() == NFS_nfsstat3.NFS3ERR_IO);
    assert(res2.getResFail().equals(resfail));
    assert(res2.equals(res2));
    assert(!res2.equals(res1));
    assert(!res1.equals(res2));
    assert(res2.hashCode() != res1.hashCode());

    // Test 3
    res3 = new FSINFO3res(NFS_nfsstat3.NFS3_OK, resok, null);
    assert(res3.getStatus() == NFS_nfsstat3.NFS3_OK);
    assert(res3.getResOk().equals(resok));
    assert(res3.equals(res3));
    assert(res3.equals(res1));
    assert(res1.equals(res3));
    assert(!res3.equals(res2));
    assert(!res2.equals(res3));
    assert(res3.hashCode() == res1.hashCode());
    assert(res3.hashCode() != res2.hashCode());
  }
}

 /** 
 *  $Log: FSINFO3.java,v $ 
 *  Revision 1.1  2006/06/12 20:07:19  nayate 
 *  First version of the Java NFS library 
 *  
 **/ 
