 /** 
 *  Represent the data structures used by the NFS FSSTAT 3 call 
 **/ 

 /** 
 *  Represent the arguments to the NFS FSSTAT 3 call 
 **/ 
class FSSTAT3args{

 /** 
 *  Data members 
 **/ 
  private final NFS_nfs_fh3 fsroot;

 /** 
 *  Constructor 
 **/ 
  public
  FSSTAT3args(NFS_nfs_fh3 newFSRoot){
    this.fsroot = newFSRoot;
  }

 /** 
 *  Return the file system root 
 **/ 
  public NFS_nfs_fh3
  getFSRoot(){
    return(this.fsroot);
  }

 /** 
 *  Return true if "obj" equals "this" 
 **/ 
  public final boolean
  equals(Object obj){
    boolean eq = false;
    FSSTAT3args args = null;

    // 2 Java-declared fields, 1 self-declared field
    assert(this.getClass().getDeclaredFields().length == 3);
    if(obj instanceof FSSTAT3args){
      args = (FSSTAT3args)obj;
      eq = this.fsroot.equals(args.fsroot);
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Compute and return a hashcode for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 1 self-declared field
    assert(this.getClass().getDeclaredFields().length == 3);
    code = this.fsroot.hashCode();

    return(code);
  }
}

 /** 
 *  Represent the results of  NFS FSSTAT 3 call if successful 
 **/ 
class FSSTAT3resok{

 /** 
 *  Data members 
 **/ 
  private final NFS_post_op_attr objAttributes;
  private final long tbytes;
  private final long fbytes;
  private final long abytes;
  private final long tfiles;
  private final long ffiles;
  private final long afiles;
  private final int invarsec;

 /** 
 *  Constructor 
 **/ 
  public
  FSSTAT3resok(NFS_post_op_attr newObjAttributes,
               long newTBytes,
               long newFBytes,
               long newABytes,
               long newTFiles,
               long newFFiles,
               long newAFiles,
               int newInvarsec){
    this.objAttributes = newObjAttributes;
    this.tbytes = newTBytes;
    this.fbytes = newFBytes;
    this.abytes = newABytes;
    this.tfiles = newTFiles;
    this.ffiles = newFFiles;
    this.afiles = newAFiles;
    this.invarsec = newInvarsec;
  }

 /** 
 *  Return the object attributes 
 **/ 
  public NFS_post_op_attr
  getObjAttributes(){
    return(this.objAttributes);
  }

 /** 
 *  Return the tbytes value 
 **/ 
  public long
  getTBytes(){
    return(this.tbytes);
  }

 /** 
 *  Return the fbytes value 
 **/ 
  public long
  getFBytes(){
    return(this.fbytes);
  }

 /** 
 *  Return the abytes value 
 **/ 
  public long
  getABytes(){
    return(this.abytes);
  }

 /** 
 *  Return the tfiles value 
 **/ 
  public long
  getTFiles(){
    return(this.tfiles);
  }

 /** 
 *  Return the ffiles value 
 **/ 
  public long
  getFFiles(){
    return(this.ffiles);
  }

 /** 
 *  Return the afiles value 
 **/ 
  public long
  getAFiles(){
    return(this.afiles);
  }

 /** 
 *  Return the invarsec value 
 **/ 
  public int
  getInvarsec(){
    return(this.invarsec);
  }

 /** 
 *  Return true if "obj" equals "this" 
 **/ 
  public final boolean
  equals(Object obj){
    boolean eq = false;
    FSSTAT3resok resok = null;

    // 2 Java-declared fields, 8 self-declared field
    assert(this.getClass().getDeclaredFields().length == 10);
    if(obj instanceof FSSTAT3resok){
      resok = (FSSTAT3resok)obj;
      eq = (this.objAttributes.equals(resok.objAttributes) &&
            (this.tbytes == resok.tbytes) &&
            (this.fbytes == resok.fbytes) &&
            (this.abytes == resok.abytes) &&
            (this.tfiles == resok.tfiles) &&
            (this.ffiles == resok.ffiles) &&
            (this.afiles == resok.afiles) &&
            (this.invarsec == resok.invarsec));
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Compute and return a hashcode for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 8 self-declared field
    assert(this.getClass().getDeclaredFields().length == 10);
    code = (this.objAttributes.hashCode() ^
            (new Long(this.tbytes)).hashCode() ^
            (new Long(this.fbytes)).hashCode() ^
            (new Long(this.abytes)).hashCode() ^
            (new Long(this.tfiles)).hashCode() ^
            (new Long(this.ffiles)).hashCode() ^
            (new Long(this.afiles)).hashCode() ^
            (new Integer(this.invarsec)).hashCode());

    return(code);
  }
}

 /** 
 *  Represent the results of  NFS FSSTAT 3 call if unsuccessful 
 **/ 
class FSSTAT3resfail{

 /** 
 *  Data members 
 **/ 
  private final NFS_post_op_attr objAttributes;

 /** 
 *  Constructor 
 **/ 
  public
  FSSTAT3resfail(NFS_post_op_attr newObjAttributes){
    this.objAttributes = newObjAttributes;
  }

 /** 
 *  Return the object attributes 
 **/ 
  public NFS_post_op_attr
  getObjAttributes(){
    return(this.objAttributes);
  }

 /** 
 *  Return true if "obj" equals "this" 
 **/ 
  public final boolean
  equals(Object obj){
    boolean eq = false;
    FSSTAT3resfail resfail = null;

    // 2 Java-declared fields, 1 self-declared field
    assert(this.getClass().getDeclaredFields().length == 3);
    if(obj instanceof FSSTAT3resfail){
      resfail = (FSSTAT3resfail)obj;
      eq = this.objAttributes.equals(resfail.objAttributes);
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Compute and return a hashcode for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 1 self-declared field
    assert(this.getClass().getDeclaredFields().length == 3);
    code = this.objAttributes.hashCode();

    return(code);
  }
}

 /** 
 *  Represent the results to the NFS 3 FSSTAT call 
 **/ 
class FSSTAT3res implements Immutable{

 /** 
 *  Data members 
 **/ 
  private final int status;
  private final FSSTAT3resok resok;
  private final FSSTAT3resfail resfail;

 /** 
 *  Constructor 
 **/ 
  public
  FSSTAT3res(int newStatus,
             FSSTAT3resok newResOk,
             FSSTAT3resfail newResFail){
    this.status = newStatus;
    this.resok = newResOk;
    this.resfail = newResFail;
    assert(((this.status == NFS_nfsstat3.NFS3_OK) && (this.resok != null)) ||
           ((this.status != NFS_nfsstat3.NFS3_OK) && (this.resfail != null)));
  }

 /** 
 *  Return the status 
 **/ 
  public int
  getStatus(){
    return(this.status);
  }

 /** 
 *  Return the result data if successful 
 **/ 
  public
  FSSTAT3resok getResOk(){
    assert(this.status == NFS_nfsstat3.NFS3_OK);
    return(this.resok);
  }

 /** 
 *  Return the result data if the call failed 
 **/ 
  public
  FSSTAT3resfail getResFail(){
    assert(this.status != NFS_nfsstat3.NFS3_OK);
    return(this.resfail);
  }

 /** 
 *  Return true if "obj" equals "this" 
 **/ 
  public final boolean
  equals(Object obj){
    boolean eq = false;
    FSSTAT3res res = null;

    // 2 Java-declared fields, 3 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 5);
    if(obj instanceof FSSTAT3res){
      res = (FSSTAT3res)obj;
      if(this.status == res.status){
        if(this.status == NFS_nfsstat3.NFS3_OK){
          eq = this.resok.equals(res.resok);
        }else{
          eq = this.resfail.equals(res.resfail);
        }
      }else{
        eq = false;
      }
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Compute and return a hashcode for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 3 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 5);
    if(this.status == NFS_nfsstat3.NFS3_OK){
      code = (new Integer(this.status)).hashCode() ^ this.resok.hashCode();
    }else{
      code = (new Integer(this.status)).hashCode() ^ this.resfail.hashCode();
    }
    return(code);
  }
}

 /** 
 *  Used for testing 
 **/ 
public class FSSTAT3{

 /** 
 *  Used for testing 
 **/ 
  public static void
  main(String[] argv){
    Env.verifyAssertEnabled();
    System.err.println("FSSTAT3 self test...");
    FSSTAT3.testFSSTAT3args();
    FSSTAT3.testFSSTAT3resok();
    FSSTAT3.testFSSTAT3resfail();
    FSSTAT3.testFSSTAT3res();
    System.err.println("...FSSTAT3 self test succeeds");
    System.exit(0);
  }

 /** 
 *  Test the FSSTAT3args class 
 **/ 
  private static void
  testFSSTAT3args(){
    FSSTAT3args args1 = null;
    FSSTAT3args args2 = null;
    FSSTAT3args args3 = null;
    byte[] b1 = null;
    byte[] b2 = null;

    // Test 1
    b1 = new byte[64];
    b1[0] = 1;
    args1 = new FSSTAT3args(NFS_nfs_fh3.makeHandle(b1));
    assert(args1.getFSRoot().equals(NFS_nfs_fh3.makeHandle(b1)));
    assert(args1.equals(args1));

    // Test 2
    b2 = new byte[64];
    b2[0] = 2;
    args2 = new FSSTAT3args(NFS_nfs_fh3.makeHandle(b2));
    assert(args2.getFSRoot().equals(NFS_nfs_fh3.makeHandle(b2)));
    assert(args2.equals(args2));
    assert(!args2.equals(args1));
    assert(!args1.equals(args2));
    assert(args2.hashCode() != args1.hashCode());

    // Test 3
    args3 = new FSSTAT3args(NFS_nfs_fh3.makeHandle(b1));
    assert(args3.getFSRoot().equals(NFS_nfs_fh3.makeHandle(b1)));
    assert(args3.equals(args3));
    assert(args3.equals(args1));
    assert(args1.equals(args3));
    assert(!args3.equals(args2));
    assert(!args2.equals(args3));
    assert(args3.hashCode() == args1.hashCode());
    assert(args3.hashCode() != args2.hashCode());
  }

 /** 
 *  Test the FSSTAT3resok class 
 **/ 
  private static void
  testFSSTAT3resok(){
    FSSTAT3resok resok1 = null;
    FSSTAT3resok resok2 = null;
    FSSTAT3resok resok3 = null;

    // Test 1
    resok1 = new FSSTAT3resok(new NFS_post_op_attr(false, null),
                              5,
                              6,
                              7,
                              8,
                              9,
                              10,
                              11);
    assert(resok1.getObjAttributes().equals(new NFS_post_op_attr(false,
                                                                 null)));
    assert(resok1.getTBytes() == 5);
    assert(resok1.getFBytes() == 6);
    assert(resok1.getABytes() == 7);
    assert(resok1.getTFiles() == 8);
    assert(resok1.getFFiles() == 9);
    assert(resok1.getAFiles() == 10);
    assert(resok1.getInvarsec() == 11);
    assert(resok1.equals(resok1));

    // Test 2
    resok2 = new FSSTAT3resok(new NFS_post_op_attr(false, null),
                              1,
                              2,
                              3,
                              4,
                              5,
                              6,
                              7);
    assert(resok2.getTBytes() == 1);
    assert(resok2.getFBytes() == 2);
    assert(resok2.getABytes() == 3);
    assert(resok2.getTFiles() == 4);
    assert(resok2.getFFiles() == 5);
    assert(resok2.getAFiles() == 6);
    assert(resok2.getInvarsec() == 7);
    assert(resok2.equals(resok2));
    assert(!resok2.equals(resok1));
    assert(!resok1.equals(resok2));
    assert(resok2.hashCode() != resok1.hashCode());

    // Test 3
    resok3 = new FSSTAT3resok(new NFS_post_op_attr(false, null),
                              5,
                              6,
                              7,
                              8,
                              9,
                              10,
                              11);
    assert(resok3.getObjAttributes().equals(new NFS_post_op_attr(false,
                                                                 null)));
    assert(resok3.getTBytes() == 5);
    assert(resok3.getFBytes() == 6);
    assert(resok3.getABytes() == 7);
    assert(resok3.getTFiles() == 8);
    assert(resok3.getFFiles() == 9);
    assert(resok3.getAFiles() == 10);
    assert(resok3.getInvarsec() == 11);
    assert(resok3.equals(resok3));
    assert(resok3.equals(resok1));
    assert(resok1.equals(resok3));
    assert(!resok3.equals(resok2));
    assert(!resok2.equals(resok3));
    assert(resok3.hashCode() == resok1.hashCode());
    assert(resok3.hashCode() != resok2.hashCode());
  }

 /** 
 *  Test the FSSTAT3resfail class 
 **/ 
  private static void
  testFSSTAT3resfail(){
    FSSTAT3resfail resfail1 = null;
    FSSTAT3resfail resfail2 = null;
    FSSTAT3resfail resfail3 = null;
    NFS_post_op_attr postAttr1 = null;
    NFS_post_op_attr postAttr2 = null;

    // Test 1
    postAttr1 = new NFS_post_op_attr(true,
                                     new NFS_fattr3(NFS_ftype3.NF3REG,
                                                    36,
                                                    63,
                                                    71,
                                                    85,
                                                    (72L << 32) + 83L,
                                                    (81L << 32) + 66L,
                                                    new NFS_specdata3(55, 49),
                                                    (22L << 32) + 68L,
                                                    (99L << 32) + 163L,
                                                    new NFS_nfstime3(43, 7),
                                                    new NFS_nfstime3(31, 48),
                                                    new NFS_nfstime3(12, 8)));
    postAttr2 = new NFS_post_op_attr(true,
                                     new NFS_fattr3(NFS_ftype3.NF3REG,
                                                    63,
                                                    36,
                                                    17,
                                                    58,
                                                    (27L << 23) + 38L,
                                                    (18L << 23) + 66L,
                                                    new NFS_specdata3(55, 94),
                                                    (22L << 23) + 86L,
                                                    (99L << 23) + 361L,
                                                    new NFS_nfstime3(34, 70),
                                                    new NFS_nfstime3(14, 84),
                                                    new NFS_nfstime3(21, 80)));
    resfail1 = new FSSTAT3resfail(postAttr1);
    assert(resfail1.getObjAttributes().equals(postAttr1));
    assert(resfail1.equals(resfail1));

    // Test 2
    resfail2 = new FSSTAT3resfail(postAttr2);
    assert(resfail2.getObjAttributes().equals(postAttr2));
    assert(resfail2.equals(resfail2));
    assert(!resfail2.equals(resfail1));
    assert(!resfail1.equals(resfail2));
    assert(resfail2.hashCode() != resfail1.hashCode());

    // Test 3
    resfail3 = new FSSTAT3resfail(postAttr1);
    assert(resfail3.getObjAttributes().equals(postAttr1));
    assert(resfail3.equals(resfail3));
    assert(resfail3.equals(resfail1));
    assert(resfail1.equals(resfail3));
    assert(!resfail3.equals(resfail2));
    assert(!resfail2.equals(resfail3));
    assert(resfail3.hashCode() == resfail1.hashCode());
    assert(resfail3.hashCode() != resfail2.hashCode());
  }

 /** 
 *  Test the FSSTAT3res class 
 **/ 
  private static void
  testFSSTAT3res(){
    FSSTAT3res res1 = null;
    FSSTAT3res res2 = null;
    FSSTAT3res res3 = null;
    FSSTAT3resok resok = null;
    FSSTAT3resfail resfail = null;
    NFS_entryplus3 entry = null;

    // Test 1
    resok = new FSSTAT3resok(new NFS_post_op_attr(false, null),
                              5,
                              6,
                              7,
                              8,
                              9,
                              10,
                              11);
    res1 = new FSSTAT3res(NFS_nfsstat3.NFS3_OK, resok, null);
    assert(res1.getStatus() == NFS_nfsstat3.NFS3_OK);
    assert(res1.getResOk().equals(resok));
    assert(res1.equals(res1));

    // Test 2
    resfail = new FSSTAT3resfail(new NFS_post_op_attr(false, null));
    res2 = new FSSTAT3res(NFS_nfsstat3.NFS3ERR_IO, null, resfail);
    assert(res2.getStatus() == NFS_nfsstat3.NFS3ERR_IO);
    assert(res2.getResFail().equals(resfail));
    assert(res2.equals(res2));
    assert(!res2.equals(res1));
    assert(!res1.equals(res2));
    assert(res2.hashCode() != res1.hashCode());

    // Test 3
    res3 = new FSSTAT3res(NFS_nfsstat3.NFS3_OK, resok, null);
    assert(res3.getStatus() == NFS_nfsstat3.NFS3_OK);
    assert(res3.getResOk().equals(resok));
    assert(res3.equals(res3));
    assert(res3.equals(res1));
    assert(res1.equals(res3));
    assert(!res3.equals(res2));
    assert(!res2.equals(res3));
    assert(res3.hashCode() == res1.hashCode());
    assert(res3.hashCode() != res2.hashCode());
  }
}