 /** 
 *  Represent the data structures used by the the GETATTR NFS 3 method 
 **/ 

 /** 
 *  Represent the arguments to the GETATTR NFS 3 call 
 **/ 
class GETATTR3args implements Immutable{

 /** 
 *  Data members 
 **/ 
  private final NFS_nfs_fh3 object;

 /** 
 *  Constructor 
 **/ 
  public
  GETATTR3args(NFS_nfs_fh3 newObject){
    this.object = newObject;
  }

 /** 
 *  Return the stored file handle 
 **/ 
  public NFS_nfs_fh3
  getObject(){
    return(this.object);
  }

 /** 
 *  Return true if "obj" equals "this" (note: currently unimplemented) 
 **/ 
  public final boolean
  equals(Object obj){
    assert false : "Unimplemented!";
    return(false);
  }

 /** 
 *  Compute and return a hashcode for this object 
 **/ 
  public int
  hashCode(){
    assert false : "Unimplemented!";
    return(0);
  }
}

 /** 
 *  Represent the results to the NFS 3 GETATTR call 
 **/ 
class GETATTR3res implements Immutable{

 /** 
 *  Data members 
 **/ 
  private final int status;
  private final GETATTR3resok resok;

 /** 
 *  Constructor 
 **/ 
  public
  GETATTR3res(int newStatus, GETATTR3resok newResOk){
    this.status = newStatus;
    this.resok = newResOk;
  }

 /** 
 *  Return the status 
 **/ 
  public
  int getStatus(){
    return(this.status);
  }

 /** 
 *  Return the result data 
 **/ 
  public
  GETATTR3resok getResOk(){
    assert(this.status == NFS_nfsstat3.NFS3_OK);
    return(this.resok);
  }

 /** 
 *  Return true if "obj" equals "this" (note: currently unimplemented) 
 **/ 
  public final boolean
  equals(Object obj){
    assert false : "Unimplemented!";
    return(false);
  }

 /** 
 *  Compute and return a hashcode for this object 
 **/ 
  public int
  hashCode(){
    assert false : "Unimplemented!";
    return(0);
  }
}

 /** 
 *  Represent the results to the NFS 3 GETATTR call when successful 
 **/ 
class GETATTR3resok implements Immutable{

 /** 
 *  Data members 
 **/ 
  private final NFS_fattr3 objAttributes;

 /** 
 *  Constructor 
 **/ 
  public
  GETATTR3resok(NFS_fattr3 newObjAttributes){
    this.objAttributes = newObjAttributes;
  }

 /** 
 *  Return the stored object attributes 
 **/ 
  public NFS_fattr3
  getObjAttributes(){
    return(this.objAttributes);
  }

 /** 
 *  Return true if "obj" equals "this" 
 **/ 
  public final boolean
  equals(Object obj){
    boolean eq = false;
    GETATTR3resok resok = null;

    // 2 Java-declared fields, 1 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 3);
    if(obj instanceof GETATTR3resok){
      resok = (GETATTR3resok)obj;
      eq = (this.objAttributes.equals(resok.objAttributes));
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Compute and return a hashcode for this object 
 **/ 
  public int
  hashCode(){
    assert false : "Unimplemented!";
    return(0);
  }
}

 /** 
 *  Used for testing 
 **/ 
public class GETATTR3{

 /** 
 *  Used for testing 
 **/ 
  public static void
  main(String[] argv){
    Env.verifyAssertEnabled();
    System.err.println("GETATTR3 self test...");
    GETATTR3.testNFS_nfs_fh3();
    GETATTR3.testGETATTR3args();
    GETATTR3.testGETATTR3resok();
    GETATTR3.testGETATTR3res();
    System.err.println("...GETATTR3 self test succeeds");
    System.exit(0);
  }

 /** 
 *  Used for testing 
 **/ 
  private static void
  testNFS_nfs_fh3(){
    byte[] data1 = null;
    NFS_nfs_fh3 fh1 = null;
    GETATTR3args args1 = null;

    data1 = new byte[NFS_nfs_fh3.NFS3_FHSIZE];
    for(int i = 0; i < data1.length; i++){
      data1[i] = (byte)i;
    }
    fh1 = NFS_nfs_fh3.makeHandle(data1);
    args1 = new GETATTR3args(fh1);
    assert(fh1.equals(args1.getObject()));
  }

 /** 
 *  Used for testing 
 **/ 
  private static void
  testGETATTR3args(){
    NFS_nfs_fh3 fh1 = null;
    GETATTR3args args1 = null;

    fh1 = NFS_nfs_fh3.makeAllZeroHandle();
    args1 = new GETATTR3args(fh1);
    assert(fh1.equals(args1.getObject()));
  }

 /** 
 *  Used for testing 
 **/ 
  private static void
  testGETATTR3resok(){
    NFS_fattr3 attr1 = null;
    NFS_fattr3 attr2 = null;
    NFS_fattr3 attr3 = null;
    GETATTR3resok resok1 = null;
    GETATTR3resok resok2 = null;
    GETATTR3resok resok3 = null;

    // Test 1: Simple methods + self comparison
    attr1 = new NFS_fattr3(NFS_ftype3.NF3REG,
                           36,
                           63,
                           71,
                           85,
                           ((long)72) << 32 + 83,
                           ((long)81) << 32 + 66,
                           new NFS_specdata3(55, 49),
                           ((long)22) << 32 + 68,
                           ((long)99) << 32 + 163,
                           new NFS_nfstime3(43, 7),
                           new NFS_nfstime3(31, 48),
                           new NFS_nfstime3(12, 8));
    resok1 = new GETATTR3resok(attr1);
    assert(attr1.equals(resok1.getObjAttributes()));
    assert(resok1.equals(resok1));

    // Test 2: Simple methods + non-equal comparison
    attr2 = new NFS_fattr3(NFS_ftype3.NF3REG,
                           95,
                           63,
                           71,
                           85,
                           ((long)72) << 32 + 83,
                           ((long)81) << 32 + 66,
                           new NFS_specdata3(55, 49),
                           ((long)22) << 32 + 68,
                           ((long)99) << 32 + 163,
                           new NFS_nfstime3(43, 7),
                           new NFS_nfstime3(31, 48),
                           new NFS_nfstime3(12, 8));
    resok2 = new GETATTR3resok(attr2);
    assert(attr2.equals(resok2.getObjAttributes()));
    assert(resok2.equals(resok2));
    assert(!resok1.equals(resok2));
    assert(!resok2.equals(resok1));

    // Test 3: Simple methods + equal comparison
    attr3 = new NFS_fattr3(NFS_ftype3.NF3REG,
                           95,
                           63,
                           71,
                           85,
                           ((long)72) << 32 + 83,
                           ((long)81) << 32 + 66,
                           new NFS_specdata3(55, 49),
                           ((long)22) << 32 + 68,
                           ((long)99) << 32 + 163,
                           new NFS_nfstime3(43, 7),
                           new NFS_nfstime3(31, 48),
                           new NFS_nfstime3(12, 8));
    resok3 = new GETATTR3resok(attr3);
    assert(attr3.equals(resok3.getObjAttributes()));
    assert(resok3.equals(resok3));
    assert(!resok1.equals(resok3));
    assert(!resok3.equals(resok1));
    assert(resok2.equals(resok3));
    assert(resok3.equals(resok2));
  }

 /** 
 *  Used for testing 
 **/ 
  private static void
  testGETATTR3res(){
    GETATTR3res res1 = null;
    GETATTR3res res2 = null;
    NFS_fattr3 attr1 = null;
    GETATTR3resok resok1 = null;

    res1 = new GETATTR3res(NFS_nfsstat3.NFS3ERR_IO, null);
    assert(res1.getStatus() == NFS_nfsstat3.NFS3ERR_IO);

    attr1 = new NFS_fattr3(NFS_ftype3.NF3REG,
                           63,
                           36,
                           17,
                           58,
                           ((long)27) << 32 + 83,
                           ((long)18) << 32 + 66,
                           new NFS_specdata3(55, 94),
                           ((long)22) << 32 + 86,
                           ((long)99) << 32 + 361,
                           new NFS_nfstime3(34, 7),
                           new NFS_nfstime3(13, 84),
                           new NFS_nfstime3(21, 8));
    resok1 = new GETATTR3resok(attr1);
    res2 = new GETATTR3res(NFS_nfsstat3.NFS3_OK, resok1);
    assert(res2.getStatus() == NFS_nfsstat3.NFS3_OK);
    assert(res2.getResOk().equals(resok1));
  }
}


 /** 
 *  $Log: GETATTR3.java,v $ 
 *  Revision 1.1  2006/06/12 20:07:19  nayate 
 *  First version of the Java NFS library 
 *  
 **/ 
