 /** 
 *  Exception that is thrown when trying to read from a non-directory 
 *  as a directory 
 **/ 

public class IsNotDirectoryException extends Exception{

 /** 
 *  Data members 
 **/ 
  private final String msg;

 /** 
 *  Constructor 
 **/ 
  public
  IsNotDirectoryException(String newMsgString){
    this.msg = newMsgString;
  }

 /** 
 *  Return the message string 
 **/ 
  public String
  getMsg(){
    return(this.msg);
  }

 /** 
 *  Return true if "obj" equals "this" (note: currently unimplemented) 
 **/ 
  public final boolean
  equals(Object obj){
    boolean eq = false;
    IsNotDirectoryException inde = null;

    // 2 Java-declared fields, 1 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 3);
    if(obj instanceof IsNotDirectoryException){
      inde = (IsNotDirectoryException)obj;
      eq = this.msg.equals(inde.msg);
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Compute and return a hashcode for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 1 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 3);
    code = this.msg.hashCode();

    return(code);
  }

 /** 
 *  Used for testing 
 **/ 
  public static void
  main(String[] argv){
    Env.verifyAssertEnabled();
    System.out.println("Testing IsNotDirectoryException.java...");
    IsNotDirectoryException.testSimple();
    System.out.println("...IsNotDirectoryException");
  }

 /** 
 *  Test the class 
 **/ 
  private static void
  testSimple(){
    IsNotDirectoryException inde1 = null;
    IsNotDirectoryException inde2 = null;
    IsNotDirectoryException inde3 = null;

    // Test 1
    inde1 = new IsNotDirectoryException("asdf");
    assert(inde1.getMsg().equals("asdf"));
    assert(inde1.equals(inde1));

    // Test 2
    inde2 = new IsNotDirectoryException("abcd");
    assert(inde2.getMsg().equals("abcd"));
    assert(inde2.equals(inde2));
    assert(!inde2.equals(inde1));
    assert(!inde1.equals(inde2));
    assert(inde2.hashCode() != inde1.hashCode());

    // Test 3
    inde3 = new IsNotDirectoryException("asdf");
    assert(inde3.getMsg().equals("asdf"));
    assert(inde3.equals(inde3));
    assert(inde3.equals(inde1));
    assert(inde1.equals(inde3));
    assert(!inde3.equals(inde2));
    assert(!inde2.equals(inde3));
    assert(inde3.hashCode() == inde1.hashCode());
    assert(inde3.hashCode() != inde2.hashCode());
  }
}