 /** 
 *  Store the data structures related the NFS3 LOOKUP calls 
 **/ 

 /** 
 *  Represent the arguments to the NFS3 LOOKUP call 
 **/ 
class LOOKUP3args{

 /** 
 *  Data members 
 **/ 
  private final NFS_diropargs3 what;

 /** 
 *  Constructor 
 **/ 
  public
  LOOKUP3args(NFS_diropargs3 newWhat){
    this.what = newWhat;
  }

 /** 
 *  Return the location of the operation 
 **/ 
  public NFS_diropargs3
  getWhat(){
    return(this.what);
  }

 /** 
 *  Return true if "obj" equals "this" 
 **/ 
  public final boolean
  equals(Object obj){
    boolean eq = false;
    LOOKUP3args args = null;

    // 2 Java-declared fields, 1 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 3);
    if(obj instanceof LOOKUP3args){
      args = (LOOKUP3args)obj;
      eq = (this.what.equals(args.what));
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Return a hash code for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 1 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 3);
    code = this.what.hashCode();

    return(code);
  }
}

 /** 
 *  Represent the return from the LOOKUP call if successful 
 **/ 
class LOOKUP3resok{

 /** 
 *  Data members 
 **/ 
  private final NFS_nfs_fh3 object;
  private final NFS_post_op_attr objAttributes;
  private final NFS_post_op_attr dirAttributes;

 /** 
 *  Constructor 
 **/ 
  public
  LOOKUP3resok(NFS_nfs_fh3 newObject,
               NFS_post_op_attr newObjAttributes,
               NFS_post_op_attr newDirAttributes){
    this.object = newObject;
    this.objAttributes = newObjAttributes;
    this.dirAttributes = newDirAttributes;
  }

 /** 
 *  Return the new file handle 
 **/ 
  public NFS_nfs_fh3
  getObject(){
    return(this.object);
  }

 /** 
 *  Return the new object attributes 
 **/ 
  public NFS_post_op_attr
  getObjAttributes(){
    return(this.objAttributes);
  }

 /** 
 *  Return the new directory attributes 
 **/ 
  public NFS_post_op_attr
  getDirAttributes(){
    return(this.dirAttributes);
  }

 /** 
 *  Return true if "obj" equals "this" 
 **/ 
  public final boolean
  equals(Object obj){
    boolean eq = false;
    LOOKUP3resok resok = null;

    // 2 Java-declared fields, 3 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 5);
    if(obj instanceof LOOKUP3resok){
      resok = (LOOKUP3resok)obj;
      eq = (this.object.equals(resok.object) &&
            this.objAttributes.equals(resok.objAttributes) &&
            this.dirAttributes.equals(resok.dirAttributes));
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Return a hash code for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 3 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 5);
    code = (this.object.hashCode() ^
            this.objAttributes.hashCode() ^
            this.dirAttributes.hashCode());
    return(code);
  }
}

 /** 
 *  Represent the return from the LOOKUP call if failed 
 **/ 
class LOOKUP3resfail{

 /** 
 *  Data members 
 **/ 
  private final NFS_post_op_attr dirAttributes;

 /** 
 *  Constructor 
 **/ 
  public
  LOOKUP3resfail(NFS_post_op_attr newDirAttributes){
    this.dirAttributes = newDirAttributes;
  }

 /** 
 *  Return the directory attributes 
 **/ 
  public NFS_post_op_attr
  getDirAttributes(){
    return(this.dirAttributes);
  }

 /** 
 *  Return true if "obj" equals "this" 
 **/ 
  public final boolean
  equals(Object obj){
    boolean eq = false;
    LOOKUP3resfail resfail = null;

    // 2 Java-declared fields, 1 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 3);
    if(obj instanceof LOOKUP3resfail){
      resfail = (LOOKUP3resfail)obj;
      eq = this.dirAttributes.equals(resfail.dirAttributes);
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Return a hash code for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 1 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 3);
    code = this.dirAttributes.hashCode();
    return(code);
  }
}

 /** 
 *  Represent the return from the LOOKUP call 
 **/ 
class LOOKUP3res{

 /** 
 *  Data members 
 **/ 
  private final int status;
  private final LOOKUP3resok resok;
  private final LOOKUP3resfail resfail;

 /** 
 *  Constructor 
 **/ 
  public
  LOOKUP3res(int newStatus, LOOKUP3resok newResOk, LOOKUP3resfail newResFail){
    this.status = newStatus;
    this.resok = newResOk;
    this.resfail = newResFail;
  }

 /** 
 *  Return the status 
 **/ 
  public int
  getStatus(){
    return(this.status);
  }

 /** 
 *  Return the result if the call was successful 
 **/ 
  public LOOKUP3resok
  getResOk(){
    assert(this.status == NFS_nfsstat3.NFS3_OK);
    return(this.resok);
  }

 /** 
 *  Return the result if the call was unsuccessful 
 **/ 
  public LOOKUP3resfail
  getResFail(){
    assert(this.status != NFS_nfsstat3.NFS3_OK);
    return(this.resfail);
  }

 /** 
 *  Return true if "obj" equals "this" 
 **/ 
  public final boolean
  equals(Object obj){
    boolean eq = false;
    LOOKUP3res res = null;

    // 2 Java-declared fields, 3 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 5);
    if(obj instanceof LOOKUP3res){
      res = (LOOKUP3res)obj;
      if(this.status == res.status){
        if(this.status == NFS_nfsstat3.NFS3_OK){
          eq = this.resok.equals(res.resok);
        }else{
          eq = this.resfail.equals(res.resfail);
        }
      }else{
        eq = false;
      }
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Return a hash code for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 3 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 5);
    if(this.status == NFS_nfsstat3.NFS3_OK){
      code = this.status ^ this.resok.hashCode();
    }else{
      code = this.status ^ this.resfail.hashCode();
    }
    return(code);
  }
}

 /** 
 *  Used for testing 
 **/ 
public class LOOKUP3{

 /** 
 *  Used for testing 
 **/ 
  public static void
  main(String[] argv){
    Env.verifyAssertEnabled();
    System.err.println("LOOKUP3 self test...");
    LOOKUP3.testLOOKUP3args();
    LOOKUP3.testLOOKUP3resok();
    LOOKUP3.testLOOKUP3resfail();
    LOOKUP3.testLOOKUP3res();
    System.err.println("...LOOKUP3 self test succeeds");
    System.exit(0);
  }

 /** 
 *  Test the LOOKUP3args class 
 **/ 
  public static void
  testLOOKUP3args(){
    LOOKUP3args args1 = null;
    LOOKUP3args args2 = null;
    LOOKUP3args args3 = null;

    // Test 1
    args1 = new LOOKUP3args(new NFS_diropargs3(NFS_nfs_fh3.makeAllZeroHandle(),
                                               "a"));
    assert(args1.getWhat().equals(new
                                  NFS_diropargs3(
                                    NFS_nfs_fh3.makeAllZeroHandle(), "a")));
    assert(args1.equals(args1));

    // Test 2
    args2 = new LOOKUP3args(new NFS_diropargs3(NFS_nfs_fh3.makeAllZeroHandle(),
                                               "b"));
    assert(args2.getWhat().equals(new
                                  NFS_diropargs3(
                                    NFS_nfs_fh3.makeAllZeroHandle(), "b")));
    assert(args2.equals(args2));
    assert(!args2.equals(args1));
    assert(!args1.equals(args2));
    assert(args2.hashCode() != args1.hashCode());

    // Test 3
    args3 = new LOOKUP3args(new NFS_diropargs3(NFS_nfs_fh3.makeAllZeroHandle(),
                                               "a"));
    assert(args3.getWhat().equals(new
                                  NFS_diropargs3(
                                    NFS_nfs_fh3.makeAllZeroHandle(), "a")));
    assert(args3.equals(args3));
    assert(args3.equals(args1));
    assert(args1.equals(args3));
    assert(!args3.equals(args2));
    assert(!args2.equals(args3));
    assert(args3.hashCode() == args1.hashCode());
    assert(args3.hashCode() != args2.hashCode());
  }

 /** 
 *  Test the LOOKUP3resok class 
 **/ 
  public static void
  testLOOKUP3resok(){
    LOOKUP3resok resok1 = null;
    LOOKUP3resok resok2 = null;
    LOOKUP3resok resok3 = null;
    NFS_post_op_attr postAttr1 = null;
    NFS_post_op_attr postAttr2 = null;
    byte[] fh = null;
    NFS_fattr3 attr = null;

    // Test 1
    attr = new NFS_fattr3(NFS_ftype3.NF3REG,
                          36,
                          63,
                          71,
                          85,
                          (72L << 32) + 83L,
                          (81L << 32) + 66L,
                          new NFS_specdata3(55, 49),
                          (22L << 32) + 68L,
                          (99L << 32) + 163L,
                          new NFS_nfstime3(43, 7),
                          new NFS_nfstime3(31, 48),
                          new NFS_nfstime3(12, 8));
    postAttr1 = new NFS_post_op_attr(true, attr);
    postAttr2 = new NFS_post_op_attr(false, null);
    resok1 = new LOOKUP3resok(NFS_nfs_fh3.makeAllZeroHandle(),
                              postAttr1,
                              postAttr2);
    assert(resok1.getObject().equals(NFS_nfs_fh3.makeAllZeroHandle()));
    assert(resok1.getObjAttributes().equals(postAttr1));
    assert(resok1.getDirAttributes().equals(postAttr2));
    assert(resok1.equals(resok1));

    // Test 2
    fh = new byte[64];
    fh[0] = (byte)1;
    resok2 = new LOOKUP3resok(NFS_nfs_fh3.makeHandle(fh),
                              postAttr1,
                              postAttr2);
    assert(resok2.getObject().equals(NFS_nfs_fh3.makeHandle(fh)));
    assert(resok2.getObjAttributes().equals(postAttr1));
    assert(resok2.getDirAttributes().equals(postAttr2));
    assert(resok2.equals(resok2));
    assert(!resok2.equals(resok1));
    assert(!resok1.equals(resok2));
    assert(resok1.hashCode() != resok2.hashCode());

    // Test 3
    resok3 = new LOOKUP3resok(NFS_nfs_fh3.makeAllZeroHandle(),
                              postAttr1,
                              postAttr2);
    assert(resok3.getObject().equals(NFS_nfs_fh3.makeAllZeroHandle()));
    assert(resok3.getObjAttributes().equals(postAttr1));
    assert(resok3.getDirAttributes().equals(postAttr2));
    assert(resok3.equals(resok3));
    assert(resok3.equals(resok1));
    assert(resok1.equals(resok3));
    assert(!resok3.equals(resok2));
    assert(!resok2.equals(resok3));
    assert(resok3.hashCode() != resok2.hashCode());
    assert(resok3.hashCode() == resok1.hashCode());
  }

 /** 
 *  Test the LOOKUP3resfail class 
 **/ 
  public static void
  testLOOKUP3resfail(){
    LOOKUP3resfail resfail1 = null;
    LOOKUP3resfail resfail2 = null;
    LOOKUP3resfail resfail3 = null;
    NFS_fattr3 attr = null;
    NFS_post_op_attr postAttr1 = null;
    NFS_post_op_attr postAttr2 = null;

    // Test 1
    attr = new NFS_fattr3(NFS_ftype3.NF3REG,
                          36,
                          63,
                          71,
                          85,
                          (72L << 32) + 83L,
                          (81L << 32) + 66L,
                          new NFS_specdata3(55, 49),
                          (22L << 32) + 68L,
                          (99L << 32) + 163L,
                          new NFS_nfstime3(43, 7),
                          new NFS_nfstime3(31, 48),
                          new NFS_nfstime3(12, 8));
    postAttr1 = new NFS_post_op_attr(true, attr);
    resfail1 = new LOOKUP3resfail(postAttr1);
    assert(resfail1.getDirAttributes().equals(postAttr1));
    assert(resfail1.equals(resfail1));

    // Test 2
    postAttr2 = new NFS_post_op_attr(false, null);
    resfail2 = new LOOKUP3resfail(postAttr2);
    assert(resfail2.getDirAttributes().equals(postAttr2));
    assert(resfail2.equals(resfail2));
    assert(!resfail2.equals(resfail1));
    assert(resfail2.hashCode() != resfail1.hashCode());

    // Test 3
    resfail3 = new LOOKUP3resfail(postAttr1);
    assert(resfail3.getDirAttributes().equals(postAttr1));
    assert(resfail3.equals(resfail3));
    assert(resfail3.equals(resfail1));
    assert(resfail1.equals(resfail3));
    assert(!resfail3.equals(resfail2));
    assert(!resfail2.equals(resfail3));
    assert(resfail3.hashCode() == resfail1.hashCode());
    assert(resfail3.hashCode() != resfail2.hashCode());
  }

 /** 
 *  Test the LOOKUP3res class 
 **/ 
  public static void
  testLOOKUP3res(){
    LOOKUP3res res1 = null;
    LOOKUP3res res2 = null;
    LOOKUP3res res3 = null;
    NFS_fattr3 attr = null;
    LOOKUP3resok resok = null;
    LOOKUP3resfail resfail = null;
    NFS_post_op_attr postAttr1 = null;
    NFS_post_op_attr postAttr2 = null;

    // Test 1
    attr = new NFS_fattr3(NFS_ftype3.NF3DIR,
                          36,
                          63,
                          71,
                          85,
                          (72L << 32) + 83L,
                          (81L << 32) + 66L,
                          new NFS_specdata3(55, 49),
                          (22L << 32) + 68L,
                          (99L << 32) + 163L,
                          new NFS_nfstime3(43, 7),
                          new NFS_nfstime3(31, 48),
                          new NFS_nfstime3(12, 8));
    postAttr1 = new NFS_post_op_attr(true, attr);
    postAttr2 = new NFS_post_op_attr(false, null);
    resok = new LOOKUP3resok(NFS_nfs_fh3.makeAllZeroHandle(),
                             postAttr1,
                             postAttr2);
    res1 = new LOOKUP3res(NFS_nfsstat3.NFS3_OK, resok, null);
    assert(res1.getStatus() == NFS_nfsstat3.NFS3_OK);
    assert(res1.getResOk().equals(resok));
    assert(res1.equals(res1));

    // Test 2
    resfail = new LOOKUP3resfail(postAttr2);
    res2 = new LOOKUP3res(NFS_nfsstat3.NFS3ERR_IO, null, resfail);
    assert(res2.getStatus() == NFS_nfsstat3.NFS3ERR_IO);
    assert(res2.getResFail().equals(resfail));
    assert(res2.equals(res2));
    assert(!res2.equals(res1));
    assert(!res1.equals(res2));
    assert(res2.hashCode() != res1.hashCode());

    // Test 3
    res3 = new LOOKUP3res(NFS_nfsstat3.NFS3_OK, resok, null);
    assert(res3.getStatus() == NFS_nfsstat3.NFS3_OK);
    assert(res3.getResOk().equals(resok));
    assert(res3.equals(res3));
    assert(res3.equals(res1));
    assert(res1.equals(res3));
    assert(!res3.equals(res2));
    assert(!res2.equals(res3));
    assert(res3.hashCode() == res1.hashCode());
    assert(res3.hashCode() != res2.hashCode());
  }
}
