 /** 
 *  Represent data structures used by the NFS 3 MKDIR call 
 **/ 

 /** 
 *  Store the arguments to the MKDIR NFS 3 call 
 **/ 
class MKDIR3args{

 /** 
 *  Data members 
 **/ 
  private final NFS_diropargs3 where;
  private final NFS_sattr3 attributes;

 /** 
 *  Constructor 
 **/ 
  public
  MKDIR3args(NFS_diropargs3 newWhere, NFS_sattr3 newAttributes){
    this.where = newWhere;
    this.attributes = newAttributes;
  }

 /** 
 *  Return the directory operations 
 **/ 
  public NFS_diropargs3
  getWhere(){
    return(this.where);
  }

 /** 
 *  Return the attributes 
 **/ 
  public NFS_sattr3
  getAttributes(){
    return(this.attributes);
  }

 /** 
 *  Return true if "obj" equals "this" 
 **/ 
  public final boolean
  equals(Object obj){
    MKDIR3args args = null;
    boolean eq = false;

    // 2 Java-declared fields, 2 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 4);
    if(obj instanceof MKDIR3args){
      args = (MKDIR3args)obj;
      eq = (this.where.equals(args.where) &&
            this.attributes.equals(args.attributes));
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Compute and return a hashcode for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 2 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 4);
    code = this.where.hashCode() ^ this.attributes.hashCode();
    return(code);
  }
}

 /** 
 *  Store the results of the MKDIR NFS 3 call if successful 
 **/ 
class MKDIR3resok{

 /** 
 *  Data members 
 **/ 
  private final NFS_post_op_fh3 obj;
  private final NFS_post_op_attr objAttributes;
  private final NFS_wcc_data dirWCC;

 /** 
 *  Constructor 
 **/ 
  public
  MKDIR3resok(NFS_post_op_fh3 newObj, 
              NFS_post_op_attr newObjAttributes,
              NFS_wcc_data newDirWCC){
    this.obj = newObj;
    this.objAttributes = newObjAttributes;
    this.dirWCC = newDirWCC;
  }

 /** 
 *  (Possibly) return the object handle 
 **/ 
  public NFS_post_op_fh3
  getObj(){
    return(this.obj);
  }

 /** 
 *  (Possibly) return the object attributes 
 **/ 
  public NFS_post_op_attr
  getObjAttributes(){
    return(this.objAttributes);
  }

 /** 
 *  (Possibly) return the directory weak-cache-consistency data 
 **/ 
  public NFS_wcc_data
  getDirWCC(){
    return(this.dirWCC);
  }

 /** 
 *  Return true if "obj" equals "this" 
 **/ 
  public final boolean
  equals(Object obj){
    MKDIR3resok resok = null;
    boolean eq = false;

    // 2 Java-declared fields, 3 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 5);
    if(obj instanceof MKDIR3resok){
      resok = (MKDIR3resok)obj;
      eq = (this.obj.equals(resok.obj) &&
            this.objAttributes.equals(resok.objAttributes) &&
            this.dirWCC.equals(resok.dirWCC));
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Compute and return a hashcode for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 3 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 5);
    code = (this.obj.hashCode() ^
            this.objAttributes.hashCode() ^
            this.dirWCC.hashCode());
    return(code);
  }
}

 /** 
 *  Store the results of the MKDIR NFS 3 call if unsuccessful 
 **/ 
class MKDIR3resfail{

 /** 
 *  Data member 
 **/ 
  private final NFS_wcc_data dirWCC;

 /** 
 *  Constructor 
 **/ 
  public
  MKDIR3resfail(NFS_wcc_data newDirWCC){
    this.dirWCC = newDirWCC;
  }

 /** 
 *  Return the directory weak-cache-consistency data 
 **/ 
  public NFS_wcc_data
  getDirWCC(){
    return(this.dirWCC);
  }

 /** 
 *  Return true if "obj" equals "this" 
 **/ 
  public final boolean
  equals(Object obj){
    MKDIR3resfail resfail = null;
    boolean eq = false;

    // 2 Java-declared fields, 1 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 3);
    if(obj instanceof MKDIR3resfail){
      resfail = (MKDIR3resfail)obj;
      eq = this.dirWCC.equals(resfail.dirWCC);
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Compute and return a hashcode for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 1 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 3);
    code = this.dirWCC.hashCode();
    return(code);
  }
}

 /** 
 *  Store the results of the MKDIR NFS 3 call 
 **/ 
class MKDIR3res{

 /** 
 *  Data members 
 **/ 
  private final int status;
  private final MKDIR3resok resok;
  private final MKDIR3resfail resfail;

 /** 
 *  Constructor 
 **/ 
  public
  MKDIR3res(int newStatus, MKDIR3resok newResOk, MKDIR3resfail newResFail){
    this.status = newStatus;
    this.resok = newResOk;
    this.resfail = newResFail;
  }

 /** 
 *  Return the status 
 **/ 
  public int
  getStatus(){
    return(this.status);
  }

 /** 
 *  Return the result of the operation if successful 
 **/ 
  public MKDIR3resok
  getResOk(){
    assert(this.status == NFS_nfsstat3.NFS3_OK);
    return(this.resok);
  }

 /** 
 *  Return the result of the operation if unsuccessful 
 **/ 
  public MKDIR3resfail
  getResFail(){
    assert(this.status != NFS_nfsstat3.NFS3_OK);
    return(this.resfail);
  }

 /** 
 *  Return true if "obj" equals "this" 
 **/ 
  public boolean
  equals(Object obj){
    boolean eq = false;
    MKDIR3res res = null;

    // 2 Java-declared fields, 3 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 5);
    if(obj instanceof MKDIR3res){
      res = (MKDIR3res)obj;
      if(this.status == res.status){
        if(this.status == NFS_nfsstat3.NFS3_OK){
          eq = this.resok.equals(res.resok);
        }else{
          eq = this.resfail.equals(resfail);
        }
      }else{
        eq = false;
      }
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Return a hash code for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 3 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 5);
    if(this.status == NFS_nfsstat3.NFS3_OK){
      code = (new Integer(this.status)).hashCode() ^ this.resok.hashCode();
    }else{
      code = (new Integer(this.status)).hashCode() ^ this.resfail.hashCode();
    }
    return(code);
  }
}

 /** 
 *  Used for testing 
 **/ 
public class MKDIR3{

 /** 
 *  Used for testing 
 **/ 
  public static void
  main(String[] argv){
    Env.verifyAssertEnabled();
    System.err.println("MKDIR3 self test...");
    MKDIR3.testMKDIR3args();
    MKDIR3.testMKDIRresok();
    MKDIR3.testMKDIRresfail();
    MKDIR3.testMKDIRresfail();
    MKDIR3.testMKDIRres();
    System.err.println("...MKDIR3 self test succeeds");
    System.exit(0);
  }

 /** 
 *  Test the MKDIR3args class 
 **/ 
  public static void
  testMKDIR3args(){
    MKDIR3args args1 = null;
    MKDIR3args args2 = null;
    MKDIR3args args3 = null;
    NFS_diropargs3 dirOpArgs1 = null;
    NFS_diropargs3 dirOpArgs2 = null;
    NFS_sattr3 sattr = null;

    // Test 1
    dirOpArgs1 = new NFS_diropargs3(NFS_nfs_fh3.makeAllZeroHandle(), "a");
    sattr = new NFS_sattr3(new NFS_set_mode3(false, 1),
                           new NFS_set_uid3(false, 2),
                           new NFS_set_gid3(false, 3),
                           new NFS_set_size3(false, 4),
                           new NFS_set_atime(NFS_time_how.SET_TO_SERVER_TIME,
                                             new NFS_nfstime3(55, 48)),
                           new NFS_set_mtime(NFS_time_how.SET_TO_CLIENT_TIME,
                                             new NFS_nfstime3(59, 88)));
    args1 = new MKDIR3args(dirOpArgs1, sattr);
    assert(args1.getWhere().equals(dirOpArgs1));
    assert(args1.getAttributes().equals(sattr));
    assert(args1.equals(args1));

    // Test 2
    dirOpArgs2 = new NFS_diropargs3(NFS_nfs_fh3.makeAllZeroHandle(), "b");
    args2 = new MKDIR3args(dirOpArgs2, sattr);
    assert(args2.getWhere().equals(dirOpArgs2));
    assert(args2.getAttributes().equals(sattr));
    assert(args2.equals(args2));
    assert(!args2.equals(args1));
    assert(!args1.equals(args2));
    assert(args2.hashCode() != args1.hashCode());

    // Test 3
    args3 = new MKDIR3args(dirOpArgs1, sattr);
    assert(args3.getWhere().equals(dirOpArgs1));
    assert(args3.getAttributes().equals(sattr));
    assert(args3.equals(args3));
    assert(args3.equals(args1));
    assert(args1.equals(args3));
    assert(!args3.equals(args2));
    assert(!args2.equals(args3));
    assert(args3.hashCode() == args1.hashCode());
    assert(args3.hashCode() != args2.hashCode());
  }

 /** 
 *  Test the MKDIR3resok class 
 **/ 
  public static void 
  testMKDIRresok(){
    MKDIR3resok resok1 = null;
    MKDIR3resok resok2 = null;
    MKDIR3resok resok3 = null;
    NFS_wcc_data wccData = null;
    NFS_pre_op_attr preAttr1 = null;
    NFS_pre_op_attr preAttr2 = null;

    // Test 1
    preAttr1 = new NFS_pre_op_attr(true,
                                   new NFS_wcc_attr(10,
                                                    new NFS_nfstime3(1, 2),
                                                    new NFS_nfstime3(3, 4)));
    resok1 = new MKDIR3resok(new NFS_post_op_fh3(false, null),
                             new NFS_post_op_attr(false, null),
                             new NFS_wcc_data(preAttr1,
                                              new NFS_post_op_attr(false,
                                                                   null)));
    assert(resok1.getObj().equals(new NFS_post_op_fh3(false, null)));
    assert(resok1.getObjAttributes().equals(new NFS_post_op_attr(false,
                                                                 null)));
    assert(resok1.getDirWCC().equals(new
                                     NFS_wcc_data(preAttr1,
                                                  new
                                                  NFS_post_op_attr(false,
                                                                   null))));
    assert(resok1.equals(resok1));

    // Test 2
    preAttr2 = new NFS_pre_op_attr(true,
                                   new NFS_wcc_attr(20,
                                                    new NFS_nfstime3(1, 2),
                                                    new NFS_nfstime3(3, 4)));
    resok2 = new MKDIR3resok(new NFS_post_op_fh3(false, null),
                             new NFS_post_op_attr(false, null),
                             new NFS_wcc_data(preAttr2,
                                              new NFS_post_op_attr(false,
                                                                   null)));
    assert(resok2.getObj().equals(new NFS_post_op_fh3(false, null)));
    assert(resok2.getObjAttributes().equals(new NFS_post_op_attr(false,
                                                                 null)));
    assert(resok2.getDirWCC().equals(new
                                     NFS_wcc_data(preAttr2,
                                                  new
                                                  NFS_post_op_attr(false,
                                                                   null))));
    assert(resok2.equals(resok2));
    assert(!resok2.equals(resok1));
    assert(!resok1.equals(resok2));
    assert(resok2.hashCode() != resok1.hashCode());

    // Test 3
    resok3 = new MKDIR3resok(new NFS_post_op_fh3(false, null),
                             new NFS_post_op_attr(false, null),
                             new NFS_wcc_data(preAttr1,
                                              new NFS_post_op_attr(false,
                                                                   null)));
    assert(resok3.getObj().equals(new NFS_post_op_fh3(false, null)));
    assert(resok3.getObjAttributes().equals(new NFS_post_op_attr(false,
                                                                 null)));
    assert(resok3.getDirWCC().equals(new
                                     NFS_wcc_data(preAttr1,
                                                  new
                                                  NFS_post_op_attr(false,
                                                                   null))));
    assert(resok3.equals(resok3));
    assert(resok3.equals(resok1));
    assert(resok1.equals(resok3));
    assert(!resok3.equals(resok2));
    assert(!resok2.equals(resok3));
    assert(resok3.hashCode() == resok1.hashCode());
    assert(resok3.hashCode() != resok2.hashCode());
  }

 /** 
 *  Test the MKDIR3resfail class 
 **/ 
  public static void 
  testMKDIRresfail(){
    MKDIR3resfail resfail1 = null;
    MKDIR3resfail resfail2 = null;
    MKDIR3resfail resfail3 = null;
    NFS_pre_op_attr preAttr1 = null;
    NFS_pre_op_attr preAttr2 = null;
    NFS_post_op_attr postAttr = null;

    // Test 1
    preAttr1 = new NFS_pre_op_attr(false, null);
    postAttr = new NFS_post_op_attr(false, null);
    resfail1 = new MKDIR3resfail(new NFS_wcc_data(preAttr1, postAttr));
    assert(resfail1.getDirWCC().equals(new NFS_wcc_data(preAttr1, postAttr)));
    assert(resfail1.equals(resfail1));

    // Test 2
    preAttr2 = new NFS_pre_op_attr(true,
                                   new
                                   NFS_wcc_attr(5000,
                                                new NFS_nfstime3(78, 80),
                                                new NFS_nfstime3(23, 12)));
    resfail2 = new MKDIR3resfail(new NFS_wcc_data(preAttr2, postAttr));
    assert(resfail2.getDirWCC().equals(new NFS_wcc_data(preAttr2, postAttr)));
    assert(resfail2.equals(resfail2));
    assert(!resfail2.equals(resfail1));
    assert(!resfail1.equals(resfail2));
    assert(resfail2.hashCode() != resfail1.hashCode());

    // Test 3
    preAttr1 = new NFS_pre_op_attr(false, null);
    postAttr = new NFS_post_op_attr(false, null);
    resfail3 = new MKDIR3resfail(new NFS_wcc_data(preAttr1, postAttr));
    assert(resfail3.getDirWCC().equals(new NFS_wcc_data(preAttr1, postAttr)));
    assert(resfail3.equals(resfail3));
    assert(resfail3.equals(resfail1));
    assert(resfail1.equals(resfail3));
    assert(!resfail3.equals(resfail2));
    assert(!resfail2.equals(resfail3));
    assert(resfail3.hashCode() == resfail1.hashCode());
    assert(resfail3.hashCode() != resfail2.hashCode());
  }

 /** 
 *  Test the MKDIR3res class 
 **/ 
  public static void 
  testMKDIRres(){
    MKDIR3res res1 = null;
    MKDIR3res res2 = null;
    MKDIR3res res3 = null;
    MKDIR3resok resok = null;
    MKDIR3resfail resfail = null;
    NFS_pre_op_attr preAttr = null;

    // Test 1
    preAttr = new NFS_pre_op_attr(true,
                                  new NFS_wcc_attr(10,
                                                   new NFS_nfstime3(1, 2),
                                                   new NFS_nfstime3(3, 4)));
    resok = new MKDIR3resok(new NFS_post_op_fh3(false, null),
                            new NFS_post_op_attr(false, null),
                            new NFS_wcc_data(preAttr,
                                             new NFS_post_op_attr(false,
                                                                  null)));
    res1 = new MKDIR3res(NFS_nfsstat3.NFS3_OK, resok, null);
    assert(res1.getStatus() == NFS_nfsstat3.NFS3_OK);
    assert(res1.getResOk().equals(resok));
    assert(res1.equals(res1));

    // Test 2
    resfail = new
      MKDIR3resfail(new NFS_wcc_data(new NFS_pre_op_attr(false, null),
                                     new NFS_post_op_attr(false, null)));
    res2 = new MKDIR3res(NFS_nfsstat3.NFS3ERR_IO, null, resfail);
    assert(res2.getStatus() == NFS_nfsstat3.NFS3ERR_IO);
    assert(res2.getResFail().equals(resfail));
    assert(res2.equals(res2));
    assert(!res2.equals(res1));
    assert(!res1.equals(res2));
    assert(res2.hashCode() != res1.hashCode());

    // Test 3
    res3 = new MKDIR3res(NFS_nfsstat3.NFS3_OK, resok, null);
    assert(res3.getStatus() == NFS_nfsstat3.NFS3_OK);
    assert(res3.getResOk().equals(resok));
    assert(res3.equals(res3));
    assert(res3.equals(res1));
    assert(res1.equals(res3));
    assert(!res3.equals(res2));
    assert(!res2.equals(res3));
    assert(res3.hashCode() == res1.hashCode());
    assert(res3.hashCode() != res2.hashCode());
  }
}

 /** 
 *  $Log: MKDIR3.java,v $ 
 *  Revision 1.1  2006/06/12 20:07:19  nayate 
 *  First version of the Java NFS library 
 *  
 **/ 
