 /** 
 *  Represent the data structures used for the NFS 3 MKNOD call 
 **/ 

 /** 
 *  Represent device data used by the MKNOD NFS 3 arguments 
 **/ 
class NFS_devicedata3{

 /** 
 *  Data members 
 **/ 
  private final NFS_sattr3 devAttributes;
  private final NFS_specdata3 spec;

 /** 
 *  Constructor 
 **/ 
  public
  NFS_devicedata3(NFS_sattr3 newDevAttributes, NFS_specdata3 newSpec){
    this.devAttributes = newDevAttributes;
    this.spec = newSpec;
  }

 /** 
 *  Return the device attributes 
 **/ 
  public NFS_sattr3
  getDevAttributes(){
    return(this.devAttributes);
  }

 /** 
 *  Return the related spec data 
 **/ 
  public NFS_specdata3
  getSpec(){
    return(this.spec);
  }

 /** 
 *  Return true if "obj" equals "this" 
 **/ 
  public final boolean
  equals(Object obj){
    NFS_devicedata3 devData = null;
    boolean eq = false;

    // 2 Java-declared fields, 2 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 4);
    if(obj instanceof NFS_devicedata3){
      devData = (NFS_devicedata3)obj;
      eq = (this.devAttributes.equals(devData.devAttributes) &&
            this.spec.equals(devData.spec));
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Compute and return a hashcode for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 2 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 4);
    code = this.devAttributes.hashCode() ^ this.spec.hashCode();
    return(code);
  }
}

 /** 
 *  Represent some parameters used by the MKNOD NFS 3 arguments 
 **/ 
class NFS_mknoddata3{

 /** 
 *  Data members 
 **/ 
  private final int type;
  private final NFS_devicedata3 device;
  private final NFS_sattr3 pipeAttributes;

 /** 
 *  Constructor 
 **/ 
  public
  NFS_mknoddata3(int newType,
                 NFS_devicedata3 newDevice,
                 NFS_sattr3 newPipeAttributes){
    this.type = newType;
    this.device = newDevice;
    this.pipeAttributes = newPipeAttributes;
  }

 /** 
 *  Return the type 
 **/ 
  public int
  getType(){
    return(this.type);
  }

 /** 
 *  Return the device data 
 **/ 
  public NFS_devicedata3
  getDevice(){
    return(this.device);
  }

 /** 
 *  Return the pipe attributes 
 **/ 
  public NFS_sattr3
  getPipeAttributes(){
    return(this.pipeAttributes);
  }


 /** 
 *  Return true if "obj" equals "this" 
 **/ 
  public final boolean
  equals(Object obj){
    NFS_mknoddata3 nodeData = null;
    boolean eq = false;

    // 2 Java-declared fields, 3 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 5);
    if(obj instanceof NFS_mknoddata3){
      nodeData = (NFS_mknoddata3)obj;
      eq = ((this.type == nodeData.type) &&
            this.device.equals(nodeData.device) &&
            this.pipeAttributes.equals(nodeData.pipeAttributes));
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Compute and return a hashcode for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 2 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 5);
    code = ((new Integer(this.type)).hashCode() ^
            this.device.hashCode() ^
            this.pipeAttributes.hashCode());
    return(code);
  }
}

 /** 
 *  Represent the arguments to the NFS 3 MKNOD call 
 **/ 
class MKNOD3args{

 /** 
 *  Data members 
 **/ 
  private final NFS_diropargs3 where;
  private final NFS_mknoddata3 what;

 /** 
 *  Constructor 
 **/ 
  public
  MKNOD3args(NFS_diropargs3 newWhere, NFS_mknoddata3 newWhat){
    this.where = newWhere;
    this.what = newWhat;
  }

 /** 
 *  Return the directory operation arguments 
 **/ 
  public NFS_diropargs3
  getWhere(){
    return(this.where);
  }

 /** 
 *  Return the mknoddata information 
 **/ 
  public NFS_mknoddata3
  getWhat(){
    return(this.what);
  }
 /** 
 *  Return true if "obj" equals "this" 
 **/ 
  public final boolean
  equals(Object obj){
    MKNOD3args args = null;
    boolean eq = false;

    // 2 Java-declared fields, 2 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 4);
    if(obj instanceof MKNOD3args){
      args = (MKNOD3args)obj;
      eq = (this.where.equals(args.where) && this.what.equals(args.what));
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Compute and return a hashcode for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 2 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 4);
    code = this.where.hashCode() ^ this.what.hashCode();
    return(code);
  }
}

 /** 
 *  Represents the results of the NFS 3 MKNOD call if successful 
 **/ 
class MKNOD3resok{

 /** 
 *  Data members 
 **/ 
  private final NFS_post_op_fh3 obj;
  private final NFS_post_op_attr objAttributes;
  private final NFS_wcc_data dirWCC;

 /** 
 *  Constructor 
 **/ 
  public
  MKNOD3resok(NFS_post_op_fh3 newObj, 
              NFS_post_op_attr newObjAttributes,
              NFS_wcc_data newDirWCC){
    this.obj = newObj;
    this.objAttributes = newObjAttributes;
    this.dirWCC = newDirWCC;
  }

 /** 
 *  (Possibly) return the object handle 
 **/ 
  public NFS_post_op_fh3
  getObj(){
    return(this.obj);
  }

 /** 
 *  (Possibly) return the object attributes 
 **/ 
  public NFS_post_op_attr
  getObjAttributes(){
    return(this.objAttributes);
  }

 /** 
 *  (Possibly) return the directory weak-cache-consistency data 
 **/ 
  public NFS_wcc_data
  getDirWCC(){
    return(this.dirWCC);
  }

 /** 
 *  Return true if "obj" equals "this" 
 **/ 
  public final boolean
  equals(Object obj){
    MKNOD3resok resok = null;
    boolean eq = false;

    // 2 Java-declared fields, 3 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 5);
    if(obj instanceof MKNOD3resok){
      resok = (MKNOD3resok)obj;
      eq = (this.obj.equals(resok.obj) &&
            this.objAttributes.equals(resok.objAttributes) &&
            this.dirWCC.equals(resok.dirWCC));
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Compute and return a hashcode for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 3 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 5);
    code = (this.obj.hashCode() ^
            this.objAttributes.hashCode() ^
            this.dirWCC.hashCode());
    return(code);
  }
}

 /** 
 *  Store the results of the MKNOD NFS 3 call if unsuccessful 
 **/ 
class MKNOD3resfail{

 /** 
 *  Data member 
 **/ 
  private final NFS_wcc_data dirWCC;

 /** 
 *  Constructor 
 **/ 
  public
  MKNOD3resfail(NFS_wcc_data newDirWCC){
    this.dirWCC = newDirWCC;
  }

 /** 
 *  Return the directory weak-cache-consistency data 
 **/ 
  public NFS_wcc_data
  getDirWCC(){
    return(this.dirWCC);
  }

 /** 
 *  Return true if "obj" equals "this" 
 **/ 
  public final boolean
  equals(Object obj){
    MKNOD3resfail resfail = null;
    boolean eq = false;

    // 2 Java-declared fields, 1 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 3);
    if(obj instanceof MKNOD3resfail){
      resfail = (MKNOD3resfail)obj;
      eq = this.dirWCC.equals(resfail.dirWCC);
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Compute and return a hashcode for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 1 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 3);
    code = this.dirWCC.hashCode();
    return(code);
  }
}

 /** 
 *  Store the results of the MKNOD NFS 3 call 
 **/ 
class MKNOD3res{

 /** 
 *  Data members 
 **/ 
  private final int status;
  private final MKNOD3resok resok;
  private final MKNOD3resfail resfail;

 /** 
 *  Constructor 
 **/ 
  public
  MKNOD3res(int newStatus,
            MKNOD3resok newResOk,
            MKNOD3resfail newResFail){
    this.status = newStatus;
    this.resok = newResOk;
    this.resfail = newResFail;
  }

 /** 
 *  Return the status 
 **/ 
  public int
  getStatus(){
    return(this.status);
  }

 /** 
 *  Return the result of the operation if successful 
 **/ 
  public MKNOD3resok
  getResOk(){
    assert(this.status == NFS_nfsstat3.NFS3_OK);
    return(this.resok);
  }

 /** 
 *  Return the result of the operation if unsuccessful 
 **/ 
  public MKNOD3resfail
  getResFail(){
    assert(this.status != NFS_nfsstat3.NFS3_OK);
    return(this.resfail);
  }

 /** 
 *  Return true if "obj" equals "this" 
 **/ 
  public boolean
  equals(Object obj){
    boolean eq = false;
    MKNOD3res res = null;

    // 2 Java-declared fields, 3 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 5);
    if(obj instanceof MKNOD3res){
      res = (MKNOD3res)obj;
      if(this.status == res.status){
        if(this.status == NFS_nfsstat3.NFS3_OK){
          eq = this.resok.equals(res.resok);
        }else{
          eq = this.resfail.equals(resfail);
        }
      }else{
        eq = false;
      }
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Return a hash code for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 3 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 5);
    if(this.status == NFS_nfsstat3.NFS3_OK){
      code = (new Integer(this.status)).hashCode() ^ this.resok.hashCode();
    }else{
      code = (new Integer(this.status)).hashCode() ^ this.resfail.hashCode();
    }
    return(code);
  }
}

 /** 
 *  Represent the arguments to the NFS 3 MKNOD call 
 **/ 
public class MKNOD3{

 /** 
 *  Used for testing 
 **/ 
  public static void
  main(String[] argv){
    Env.verifyAssertEnabled();
    System.err.println("MKNOD3 self test...");
    MKNOD3.testNFS_devicedata3();
    MKNOD3.testNFS_mknoddata3();
    MKNOD3.testMKNOD3args();
    MKNOD3.testMKNODresok();
    MKNOD3.testMKNODresfail();
    MKNOD3.testMKNODres();
    System.err.println("...MKNOD3 self test succeeds");
    System.exit(0);
  }

 /** 
 *  Test the NFS_devicedata3 class 
 **/ 
  private static void
  testNFS_devicedata3(){
    NFS_devicedata3 data1 = null;
    NFS_devicedata3 data2 = null;
    NFS_devicedata3 data3 = null;
    NFS_sattr3 sattr = null;

    // Test 1
    sattr = new NFS_sattr3(new NFS_set_mode3(true, 53),
                           new NFS_set_uid3(false, 2),
                           new NFS_set_gid3(true, 11),
                           new NFS_set_size3(true, (1L << 32) + 58L),
                           new NFS_set_atime(NFS_time_how.DONT_CHANGE,
                                             new NFS_nfstime3(66, 67)),
                           new NFS_set_mtime(NFS_time_how.SET_TO_CLIENT_TIME,
                                             new NFS_nfstime3(5, 15)));
    data1 = new NFS_devicedata3(sattr, new NFS_specdata3(1, 2));
    assert(data1.getDevAttributes().equals(sattr));
    assert(data1.getSpec().equals(new NFS_specdata3(1, 2)));
    assert(data1.equals(data1));

    // Test 2
    data2 = new NFS_devicedata3(sattr, new NFS_specdata3(2, 3));
    assert(data2.getDevAttributes().equals(sattr));
    assert(data2.getSpec().equals(new NFS_specdata3(2, 3)));
    assert(data2.equals(data2));
    assert(!data2.equals(data1));
    assert(!data1.equals(data2));
    assert(data2.hashCode() != data1.hashCode());

    // Test 3
    data3 = new NFS_devicedata3(sattr, new NFS_specdata3(1, 2));
    assert(data3.getDevAttributes().equals(sattr));
    assert(data3.getSpec().equals(new NFS_specdata3(1, 2)));
    assert(data3.equals(data3));
    assert(data3.equals(data1));
    assert(data1.equals(data3));
    assert(!data3.equals(data2));
    assert(!data2.equals(data3));
    assert(data3.hashCode() == data1.hashCode());
    assert(data3.hashCode() != data2.hashCode());
  }

 /** 
 *  Test the NFS_mknoddata3 class 
 **/ 
  private static void
  testNFS_mknoddata3(){
    NFS_mknoddata3 data1 = null;
    NFS_mknoddata3 data2 = null;
    NFS_mknoddata3 data3 = null;
    NFS_devicedata3 deviceData1 = null;
    NFS_devicedata3 deviceData2 = null;
    NFS_sattr3 sattr = null;

    // Test 1
    sattr = new NFS_sattr3(new NFS_set_mode3(true, 53),
                           new NFS_set_uid3(false, 2),
                           new NFS_set_gid3(true, 11),
                           new NFS_set_size3(true, (1L << 32) + 58L),
                           new NFS_set_atime(NFS_time_how.DONT_CHANGE,
                                             new NFS_nfstime3(66, 67)),
                           new NFS_set_mtime(NFS_time_how.SET_TO_CLIENT_TIME,
                                             new NFS_nfstime3(5, 15)));
    deviceData1 = new NFS_devicedata3(sattr, new NFS_specdata3(1, 2));
    data1 = new NFS_mknoddata3(NFS_ftype3.NF3REG, deviceData1, sattr);
    assert(data1.getType() == NFS_ftype3.NF3REG);
    assert(data1.getDevice().equals(deviceData1));
    assert(data1.getPipeAttributes().equals(sattr));
    assert(data1.equals(data1));

    // Test 2
    deviceData2 = new NFS_devicedata3(sattr, new NFS_specdata3(2, 3));
    data2 = new NFS_mknoddata3(NFS_ftype3.NF3DIR, deviceData2, sattr);
    assert(data2.getType() == NFS_ftype3.NF3DIR);
    assert(data2.getDevice().equals(deviceData2));
    assert(data2.getPipeAttributes().equals(sattr));
    assert(data2.equals(data2));
    assert(!data2.equals(data1));
    assert(!data1.equals(data2));
    assert(data2.hashCode() != data1.hashCode());

    // Test 3
    data3 = new NFS_mknoddata3(NFS_ftype3.NF3REG, deviceData1, sattr);
    assert(data3.getType() == NFS_ftype3.NF3REG);
    assert(data3.getDevice().equals(deviceData1));
    assert(data3.getPipeAttributes().equals(sattr));
    assert(data3.equals(data3));
    assert(data3.equals(data1));
    assert(data1.equals(data3));
    assert(!data3.equals(data2));
    assert(!data2.equals(data3));
    assert(data3.hashCode() == data1.hashCode());
    assert(data3.hashCode() != data2.hashCode());
  }

 /** 
 *  Test the MKNOD3args class 
 **/ 
  private static void
  testMKNOD3args(){
    MKNOD3args args1 = null;
    MKNOD3args args2 = null;
    MKNOD3args args3 = null;
    NFS_mknoddata3 data = null;
    NFS_devicedata3 deviceData = null;
    NFS_sattr3 sattr = null;

    // Test 1
    sattr = new NFS_sattr3(new NFS_set_mode3(true, 53),
                           new NFS_set_uid3(false, 2),
                           new NFS_set_gid3(true, 11),
                           new NFS_set_size3(true, (1L << 32) + 58L),
                           new NFS_set_atime(NFS_time_how.DONT_CHANGE,
                                             new NFS_nfstime3(66, 67)),
                           new NFS_set_mtime(NFS_time_how.SET_TO_CLIENT_TIME,
                                             new NFS_nfstime3(5, 15)));
    deviceData = new NFS_devicedata3(sattr, new NFS_specdata3(1, 2));
    data = new NFS_mknoddata3(NFS_ftype3.NF3REG, deviceData, sattr);
    args1 = new MKNOD3args(new NFS_diropargs3(NFS_nfs_fh3.makeAllZeroHandle(),
                                              "a"),
                           data);
    assert(args1.getWhere().equals(new NFS_diropargs3(
                                     NFS_nfs_fh3.makeAllZeroHandle(), "a")));
    assert(args1.getWhat().equals(data));
    assert(args1.equals(args1));

    // Test 2
    args2 = new MKNOD3args(new NFS_diropargs3(NFS_nfs_fh3.makeAllZeroHandle(),
                                              "b"),
                           data);
    assert(args2.getWhere().equals(new NFS_diropargs3(
                                     NFS_nfs_fh3.makeAllZeroHandle(), "b")));
    assert(args2.getWhat().equals(data));
    assert(args2.equals(args2));
    assert(!args2.equals(args1));
    assert(!args1.equals(args2));
    assert(args2.hashCode() != args1.hashCode());

    // Test 3
    args3 = new MKNOD3args(new NFS_diropargs3(NFS_nfs_fh3.makeAllZeroHandle(),
                                              "a"),
                           data);
    assert(args3.getWhere().equals(new NFS_diropargs3(
                                     NFS_nfs_fh3.makeAllZeroHandle(), "a")));
    assert(args3.getWhat().equals(data));
    assert(args3.equals(args3));
    assert(args3.equals(args1));
    assert(args1.equals(args3));
    assert(!args3.equals(args2));
    assert(!args2.equals(args3));
    assert(args3.hashCode() == args1.hashCode());
    assert(args3.hashCode() != args2.hashCode());
  }

 /** 
 *  Test the MKNOD3resok class 
 **/ 
  public static void 
  testMKNODresok(){
    MKNOD3resok resok1 = null;
    MKNOD3resok resok2 = null;
    MKNOD3resok resok3 = null;
    NFS_wcc_data wccData = null;
    NFS_pre_op_attr preAttr1 = null;
    NFS_pre_op_attr preAttr2 = null;

    // Test 1
    preAttr1 = new NFS_pre_op_attr(true,
                                   new NFS_wcc_attr(10,
                                                    new NFS_nfstime3(1, 2),
                                                    new NFS_nfstime3(3, 4)));
    resok1 = new MKNOD3resok(new NFS_post_op_fh3(false, null),
                             new NFS_post_op_attr(false, null),
                             new NFS_wcc_data(preAttr1,
                                              new NFS_post_op_attr(false,
                                                                   null)));
    assert(resok1.getObj().equals(new NFS_post_op_fh3(false, null)));
    assert(resok1.getObjAttributes().equals(new NFS_post_op_attr(false,
                                                                 null)));
    assert(resok1.getDirWCC().equals(new
                                     NFS_wcc_data(preAttr1,
                                                  new
                                                  NFS_post_op_attr(false,
                                                                   null))));
    assert(resok1.equals(resok1));

    // Test 2
    preAttr2 = new NFS_pre_op_attr(true,
                                   new NFS_wcc_attr(20,
                                                    new NFS_nfstime3(1, 2),
                                                    new NFS_nfstime3(3, 4)));
    resok2 = new MKNOD3resok(new NFS_post_op_fh3(false, null),
                             new NFS_post_op_attr(false, null),
                             new NFS_wcc_data(preAttr2,
                                              new NFS_post_op_attr(false,
                                                                   null)));
    assert(resok2.getObj().equals(new NFS_post_op_fh3(false, null)));
    assert(resok2.getObjAttributes().equals(new NFS_post_op_attr(false,
                                                                 null)));
    assert(resok2.getDirWCC().equals(new
                                     NFS_wcc_data(preAttr2,
                                                  new
                                                  NFS_post_op_attr(false,
                                                                   null))));
    assert(resok2.equals(resok2));
    assert(!resok2.equals(resok1));
    assert(!resok1.equals(resok2));
    assert(resok2.hashCode() != resok1.hashCode());

    // Test 3
    resok3 = new MKNOD3resok(new NFS_post_op_fh3(false, null),
                             new NFS_post_op_attr(false, null),
                             new NFS_wcc_data(preAttr1,
                                              new NFS_post_op_attr(false,
                                                                   null)));
    assert(resok3.getObj().equals(new NFS_post_op_fh3(false, null)));
    assert(resok3.getObjAttributes().equals(new NFS_post_op_attr(false,
                                                                 null)));
    assert(resok3.getDirWCC().equals(new
                                     NFS_wcc_data(preAttr1,
                                                  new
                                                  NFS_post_op_attr(false,
                                                                   null))));
    assert(resok3.equals(resok3));
    assert(resok3.equals(resok1));
    assert(resok1.equals(resok3));
    assert(!resok3.equals(resok2));
    assert(!resok2.equals(resok3));
    assert(resok3.hashCode() == resok1.hashCode());
    assert(resok3.hashCode() != resok2.hashCode());
  }

 /** 
 *  Test the MKNOD3resfail class 
 **/ 
  public static void 
  testMKNODresfail(){
    MKNOD3resfail resfail1 = null;
    MKNOD3resfail resfail2 = null;
    MKNOD3resfail resfail3 = null;
    NFS_pre_op_attr preAttr1 = null;
    NFS_pre_op_attr preAttr2 = null;
    NFS_post_op_attr postAttr = null;

    // Test 1
    preAttr1 = new NFS_pre_op_attr(false, null);
    postAttr = new NFS_post_op_attr(false, null);
    resfail1 = new MKNOD3resfail(new NFS_wcc_data(preAttr1, postAttr));
    assert(resfail1.getDirWCC().equals(new NFS_wcc_data(preAttr1, postAttr)));
    assert(resfail1.equals(resfail1));

    // Test 2
    preAttr2 = new NFS_pre_op_attr(true,
                                   new
                                   NFS_wcc_attr(5000,
                                                new NFS_nfstime3(78, 80),
                                                new NFS_nfstime3(23, 12)));
    resfail2 = new MKNOD3resfail(new NFS_wcc_data(preAttr2, postAttr));
    assert(resfail2.getDirWCC().equals(new NFS_wcc_data(preAttr2, postAttr)));
    assert(resfail2.equals(resfail2));
    assert(!resfail2.equals(resfail1));
    assert(!resfail1.equals(resfail2));
    assert(resfail2.hashCode() != resfail1.hashCode());

    // Test 3
    preAttr1 = new NFS_pre_op_attr(false, null);
    postAttr = new NFS_post_op_attr(false, null);
    resfail3 = new MKNOD3resfail(new NFS_wcc_data(preAttr1, postAttr));
    assert(resfail3.getDirWCC().equals(new NFS_wcc_data(preAttr1, postAttr)));
    assert(resfail3.equals(resfail3));
    assert(resfail3.equals(resfail1));
    assert(resfail1.equals(resfail3));
    assert(!resfail3.equals(resfail2));
    assert(!resfail2.equals(resfail3));
    assert(resfail3.hashCode() == resfail1.hashCode());
    assert(resfail3.hashCode() != resfail2.hashCode());
  }

 /** 
 *  Test the MKNOD3res class 
 **/ 
  public static void 
  testMKNODres(){
    MKNOD3res res1 = null;
    MKNOD3res res2 = null;
    MKNOD3res res3 = null;
    MKNOD3resok resok = null;
    MKNOD3resfail resfail = null;
    NFS_pre_op_attr preAttr = null;

    // Test 1
    preAttr = new NFS_pre_op_attr(true,
                                  new NFS_wcc_attr(10,
                                                   new NFS_nfstime3(1, 2),
                                                   new NFS_nfstime3(3, 4)));
    resok = new MKNOD3resok(new NFS_post_op_fh3(false, null),
                            new NFS_post_op_attr(false, null),
                            new NFS_wcc_data(preAttr,
                                             new NFS_post_op_attr(false,
                                                                  null)));
    res1 = new MKNOD3res(NFS_nfsstat3.NFS3_OK, resok, null);
    assert(res1.getStatus() == NFS_nfsstat3.NFS3_OK);
    assert(res1.getResOk().equals(resok));
    assert(res1.equals(res1));

    // Test 2
    resfail = new
      MKNOD3resfail(new NFS_wcc_data(new NFS_pre_op_attr(false, null),
                                     new NFS_post_op_attr(false, null)));
    res2 = new MKNOD3res(NFS_nfsstat3.NFS3ERR_IO, null, resfail);
    assert(res2.getStatus() == NFS_nfsstat3.NFS3ERR_IO);
    assert(res2.getResFail().equals(resfail));
    assert(res2.equals(res2));
    assert(!res2.equals(res1));
    assert(!res1.equals(res2));
    assert(res2.hashCode() != res1.hashCode());

    // Test 3
    res3 = new MKNOD3res(NFS_nfsstat3.NFS3_OK, resok, null);
    assert(res3.getStatus() == NFS_nfsstat3.NFS3_OK);
    assert(res3.getResOk().equals(resok));
    assert(res3.equals(res3));
    assert(res3.equals(res1));
    assert(res1.equals(res3));
    assert(!res3.equals(res2));
    assert(!res2.equals(res3));
    assert(res3.hashCode() == res1.hashCode());
    assert(res3.hashCode() != res2.hashCode());
  }
}