 /** 
 *  Represent the cookieverf data structure used by NFS 3 
 **/ 
import java.util.Arrays;

public class NFS_cookieverf3 implements Immutable{

 /** 
 *  Constants 
 **/ 
  public static final int NFS3_COOKIEVERFSIZE = 8;

 /** 
 *  Data members 
 **/ 
  private final byte[] data;

 /** 
 *  Constructor 
 **/ 
  public
  NFS_cookieverf3(byte[] newData){
    byte[] b = null;

    b = new byte[NFS3_COOKIEVERFSIZE];
    for(int i = 0; i < NFS3_COOKIEVERFSIZE; i++){
      b[i] = newData[i];
    }
    this.data = b;
  }

 /** 
 *  Return the data 
 **/ 
  public byte[]
  getData(){
    return(this.data);
  }

 /** 
 *  Return true if "obj" equals "this" 
 **/ 
  public final boolean
  equals(Object obj){
    boolean eq = false;
    NFS_cookieverf3 verf = null;

    // 2 Java-declared fields, 2 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 4);
    if(obj instanceof NFS_cookieverf3){
      verf = (NFS_cookieverf3)obj;
      eq = (this.data.length == verf.data.length);
      for(int i = 0; eq && (i < this.data.length); i++){
        eq = (this.data[i] == verf.data[i]);
      }
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Compute and return a hashcode for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 2 self-declared field
    assert(this.getClass().getDeclaredFields().length == 4);
    code = Arrays.hashCode(this.data);

    return(code);
  }

 /** 
 *  Used for testing 
 **/ 
  public static void
  main(String[] argv){
    Env.verifyAssertEnabled();
    System.err.println("NFS_cookieverf3 self test...");
    NFS_cookieverf3.testSimple();
    System.err.println("...NFS_cookieverf3 self test succeeds");
    System.exit(0);
  }

 /** 
 *  Test the NFS_cookieverf3 class 
 **/ 
  private static void
  testSimple(){
    NFS_cookieverf3 verf1 = null;
    NFS_cookieverf3 verf2 = null;
    NFS_cookieverf3 verf3 = null;
    byte[] b1 = null;
    byte[] b2 = null;

    // Test 1
    b1 = new byte[8];
    b1[0] = 1;
    verf1 = new NFS_cookieverf3(b1);
    assert(Arrays.equals(verf1.getData(), b1));
    assert(verf1.equals(verf1));

    // Test 2
    b2 = new byte[8];
    b2[0] = 2;
    verf2 = new NFS_cookieverf3(b2);
    assert(Arrays.equals(verf2.getData(), b2));
    assert(verf2.equals(verf2));
    assert(!verf2.equals(verf1));
    assert(!verf1.equals(verf2));
    assert(verf2.hashCode() != verf1.hashCode());

    // Test 3
    verf3 = new NFS_cookieverf3(b1);
    assert(Arrays.equals(verf1.getData(), b1));
    assert(verf3.equals(verf3));
    assert(verf3.equals(verf1));
    assert(verf1.equals(verf3));
    assert(!verf3.equals(verf2));
    assert(!verf2.equals(verf3));
    assert(verf3.hashCode() == verf1.hashCode());
    assert(verf3.hashCode() != verf2.hashCode());
  }
}
