 /** 
 *  Store NFS operations to directories 
 **/ 

public class NFS_diropargs3{

 /** 
 *  Data members 
 **/ 
  private final NFS_nfs_fh3 dir;
  private final String name;

 /** 
 *  Constructor 
 **/ 
  public
  NFS_diropargs3(NFS_nfs_fh3 newDir, String newName){
    this.dir = newDir;
    this.name = newName;
  }

 /** 
 *  Return the directory handle 
 **/ 
  public NFS_nfs_fh3
  getDir(){
    return(this.dir);
  }

 /** 
 *  Return the file name 
 **/ 
  public String
  getName(){
    return(this.name);
  }

 /** 
 *  Return true if "this" equals "obj" 
 **/ 
  public final boolean
  equals(Object obj){
    boolean eq = false;
    NFS_diropargs3 args = null;

    // 2 Java-declared fields, 2 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 4);
    if(obj instanceof NFS_diropargs3){
      args = (NFS_diropargs3)obj;
      eq = (this.dir.equals(args.dir) && this.name.equals(args.name));
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Return a hash code for this object 
 **/ 
  public final int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 2 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 4);
    code = this.dir.hashCode() ^ this.name.hashCode();
    return(code);
  }

 /** 
 *  Used for testing 
 **/ 
  public static void
  main(String[] argv){
    Env.verifyAssertEnabled();
    System.err.println("NFS_diropargs3 self test...");
    NFS_diropargs3.test();
    System.err.println("...NFS_diropargs3 self test succeeds");
    System.exit(0);
  }

 /** 
 *  Used for testing 
 **/ 
  private static void
  test(){
    NFS_diropargs3 args1 = null;
    NFS_diropargs3 args2 = null;
    NFS_diropargs3 args3 = null;

    // Test 1
    args1 = new NFS_diropargs3(NFS_nfs_fh3.makeAllZeroHandle(), "abcd");
    assert(args1.getDir().equals(NFS_nfs_fh3.makeAllZeroHandle()));
    assert(args1.getName().equals("abcd"));
    assert(args1.equals(args1));

    // Test 2
    args2 = new NFS_diropargs3(NFS_nfs_fh3.makeAllZeroHandle(), "asdf");
    assert(args2.getDir().equals(NFS_nfs_fh3.makeAllZeroHandle()));
    assert(args2.getName().equals("asdf"));
    assert(args2.equals(args2));
    assert(!args1.equals(args2));
    assert(!args2.equals(args1));
    assert(args1.hashCode() != args2.hashCode());

    // Test 3
    args3 = new NFS_diropargs3(NFS_nfs_fh3.makeAllZeroHandle(), "abcd");
    assert(args3.getDir().equals(NFS_nfs_fh3.makeAllZeroHandle()));
    assert(args3.getName().equals("abcd"));
    assert(args3.equals(args3));
    assert(args1.equals(args3));
    assert(args3.equals(args1));
    assert(!args2.equals(args3));
    assert(!args3.equals(args2));
    assert(args1.hashCode() == args3.hashCode());
    assert(args2.hashCode() != args3.hashCode());
  }
}