 /** 
 *  Store the NFS file attribute data structure 
 **/ 
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;

// Used for testing
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

public class NFS_fattr3{

 /** 
 *  Constants 
 **/ 
  private static byte MAGIC_NUM = 4;

 /** 
 *  Data members 
 **/ 
  private int type;
  private int mode;
  private int nlink;
  private int uid;
  private int gid;
  private long size;
  private long used;
  private NFS_specdata3 rdev;
  private long fsid;
  private long fileid;
  private NFS_nfstime3 atime;
  private NFS_nfstime3 mtime;
  private NFS_nfstime3 ctime;

 /** 
 *  Constructor 
 **/ 
  public
  NFS_fattr3(int newType,
             int newMode,
             int newNlink,
             int newUID,
             int newGID,
             long newSize,
             long newUsed,
             NFS_specdata3 newRdev,
             long newFsid,
             long newFileid,
             NFS_nfstime3 newAtime,
             NFS_nfstime3 newMtime,
             NFS_nfstime3 newCtime){
    this.type = newType;
    this.mode = newMode;
    this.nlink = newNlink;
    this.uid = newUID;
    this.gid = newGID;
    this.size = newSize;
    this.used = newUsed;
    this.rdev = newRdev;
    this.fsid = newFsid;
    this.fileid = newFileid;
    this.atime = newAtime;
    this.mtime = newMtime;
    this.ctime = newCtime;
  }

 /** 
 *  Constructor 
 *  Read this object from the input stream 
 **/ 
  public
  NFS_fattr3(InputStream is) throws IOException{
    DataInputStream dis = null;
    byte magicNum = (byte)0;

    dis = new DataInputStream(is);
    magicNum = dis.readByte();
    assert(magicNum == NFS_fattr3.MAGIC_NUM);
    this.type = dis.readInt();
    this.mode = dis.readInt();
    this.nlink = dis.readInt();
    this.uid = dis.readInt();
    this.gid = dis.readInt();
    this.size = dis.readLong();
    this.used = dis.readLong();
    this.rdev = new NFS_specdata3(dis);
    this.fsid = dis.readLong();
    this.fileid = dis.readLong();
    this.atime = new NFS_nfstime3(dis);
    this.mtime = new NFS_nfstime3(dis);
    this.ctime = new NFS_nfstime3(dis);
  }

 /** 
 *  Write this object to the OutputStream 
 **/ 
  public void
  toOutputStream(OutputStream os) throws IOException{
    DataOutputStream dos = null;

    dos = new DataOutputStream(os);
    dos.writeByte(NFS_fattr3.MAGIC_NUM);
    dos.writeInt(this.type);
    dos.writeInt(this.mode);
    dos.writeInt(this.nlink);
    dos.writeInt(this.uid);
    dos.writeInt(this.gid);
    dos.writeLong(this.size);
    dos.writeLong(this.used);
    this.rdev.toOutputStream(dos);
    dos.writeLong(this.fsid);
    dos.writeLong(this.fileid);
    this.atime.toOutputStream(dos);
    this.mtime.toOutputStream(dos);
    this.ctime.toOutputStream(dos);
  }

 /** 
 *  Return the type 
 **/ 
  public int
  getType(){
    return(this.type);
  }

 /** 
 *  Return the mode 
 **/ 
  public int
  getMode(){
    return(this.mode);
  }

 /** 
 *  Return nlink 
 **/ 
  public int
  getNLink(){
    return(this.nlink);
  }

 /** 
 *  Return the uid 
 **/ 
  public int
  getUID(){
    return(this.uid);
  }

 /** 
 *  Return the gid 
 **/ 
  public int
  getGID(){
    return(this.gid);
  }

 /** 
 *  Return the size 
 **/ 
  public long
  getSize(){
    return(this.size);
  }

 /** 
 *  Return the value of "used" 
 **/ 
  public long
  getUsed(){
    return(this.used);
  }

 /** 
 *  Return the specdata 
 **/ 
  public NFS_specdata3
  getRDev(){
    return(this.rdev);
  }

 /** 
 *  Return the fsid 
 **/ 
  public long
  getFSID(){
    return(this.fsid);
  }

 /** 
 *  Return the fileid 
 **/ 
  public long
  getFileId(){
    return(this.fileid);
  }

 /** 
 *  Return the atime 
 **/ 
  public NFS_nfstime3
  getATime(){
    return(this.atime);
  }

 /** 
 *  Return the mtime 
 **/ 
  public NFS_nfstime3
  getMTime(){
    return(this.mtime);
  }

 /** 
 *  Return the ctime 
 **/ 
  public NFS_nfstime3
  getCTime(){
    return(this.ctime);
  }

 /** 
 *  Set the mode 
 **/ 
  public void
  setMode(int newMode){
    this.mode = newMode;
  }

 /** 
 *  Set the uid 
 **/ 
  public void
  setUID(int newUID){
    this.uid = newUID;
  }

 /** 
 *  Set the gid 
 **/ 
  public void
  setGID(int newGID){
    this.gid = newGID;
  }

 /** 
 *  Set the size 
 **/ 
  public void
  setSize(long newSize){
    this.size = newSize;
  }

 /** 
 *  Set the atime 
 **/ 
  public void
  setATime(NFS_nfstime3 newATime){
    this.atime = newATime;
  }

 /** 
 *  Set the mtime 
 **/ 
  public void
  setMTime(NFS_nfstime3 newMTime){
    this.mtime = newMTime;
  }

 /** 
 *  Return true if "obj" equals "this" (note: currently unimplemented) 
 **/ 
  public final boolean
  equals(Object obj){
    boolean eq = false;
    NFS_fattr3 attr = null;

    // 2 Java-declared fields, 14 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 16);
    if(obj instanceof NFS_fattr3){
      attr = (NFS_fattr3)obj;
      eq = ((this.type == attr.type) &&
            (this.mode == attr.mode) &&
            (this.nlink == attr.nlink) &&
            (this.uid == attr.uid) &&
            (this.gid == attr.gid) &&
            (this.size == attr.size) &&
            (this.used == attr.used) &&
            (this.rdev.equals(attr.rdev)) &&
            (this.fsid == attr.fsid) &&
            (this.fileid == attr.fileid) &&
            (this.atime.equals(attr.atime)) &&
            (this.mtime.equals(attr.mtime)) &&
            (this.ctime.equals(attr.ctime)));
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Compute and return a hashcode for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 14 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 16);
    code = ((new Integer(this.type)).hashCode() ^
            (new Integer(this.mode)).hashCode() ^
            (new Integer(this.nlink)).hashCode() ^
            (new Integer(this.uid)).hashCode() ^
            (new Integer(this.gid)).hashCode() ^
            (new Long(this.size)).hashCode() ^
            (new Long(this.used)).hashCode() ^
            (this.rdev.hashCode()) ^
            (new Long(this.fsid)).hashCode() ^
            (new Long(this.fileid)).hashCode() ^
            (this.atime.hashCode()) ^
            (this.mtime.hashCode()) ^
            (this.ctime.hashCode()));
    return(code);
  }

 /** 
 *  Used for testing 
 **/ 
  public static void
  main(String[] argv){
    Env.verifyAssertEnabled();
    System.out.println("Testing NFS_fattr3.java...");
    NFS_fattr3.testSimple();
    NFS_fattr3.testEqualsHashCode();
    NFS_fattr3.testSerialize();
    System.out.println("...Finished");
  }

 /** 
 *  Run simple tests 
 **/ 
  private static void
  testSimple(){
    NFS_fattr3 attr1 = null;

    // Test get methods
    attr1 = new NFS_fattr3(NFS_ftype3.NF3REG,
                           36,
                           63,
                           71,
                           85,
                           (72L << 32) + 83L,
                           (81L << 32) + 66L,
                           new NFS_specdata3(55, 49),
                           (22L << 32) + 68L,
                           (99L << 32) + 163L,
                           new NFS_nfstime3(43, 7),
                           new NFS_nfstime3(31, 48),
                           new NFS_nfstime3(12, 8));
    assert(attr1.getType() == NFS_ftype3.NF3REG);
    assert(attr1.getMode() == 36);
    assert(attr1.getNLink() == 63);
    assert(attr1.getUID() == 71);
    assert(attr1.getGID() == 85);
    assert(attr1.getSize() == ((72L << 32) + 83L));
    assert(attr1.getUsed() == ((81L << 32) + 66L));
    assert(attr1.getRDev().equals(new NFS_specdata3(55, 49)));
    assert(attr1.getFSID() == ((22L << 32) + 68L));
    assert(attr1.getFileId() == ((99L << 32) + 163L));
    assert(attr1.getATime().equals(new NFS_nfstime3(43, 7)));
    assert(attr1.getMTime().equals(new NFS_nfstime3(31, 48)));
    assert(attr1.getCTime().equals(new NFS_nfstime3(12, 8)));

    // Test set methods
    attr1.setMode(48);
    assert(attr1.getMode() == 48);
    attr1.setUID(49);
    assert(attr1.getUID() == 49);
    attr1.setGID(92);
    assert(attr1.getGID() == 92);
    attr1.setSize((23L << 32) + 2L);
    assert(attr1.getSize() == ((23L << 32) + 2L));
    attr1.setATime(new NFS_nfstime3(33, 78));
    assert(attr1.getATime().equals(new NFS_nfstime3(33, 78)));
    attr1.setMTime(new NFS_nfstime3(76, 21));
    assert(attr1.getMTime().equals(new NFS_nfstime3(76, 21)));
  }

 /** 
 *  Test the equals() method 
 **/ 
  private static void
  testEqualsHashCode(){
    NFS_fattr3 attr1 = null;
    NFS_fattr3 attr2 = null;
    NFS_fattr3 attr3 = null;

    // Test1: Self comparison
    attr1 = new NFS_fattr3(NFS_ftype3.NF3REG,
                           36,
                           63,
                           71,
                           85,
                           (72L << 32) + 83L,
                           (81L << 32) + 66L,
                           new NFS_specdata3(55, 49),
                           (22L << 32) + 68L,
                           (99L << 32) + 163L,
                           new NFS_nfstime3(43, 7),
                           new NFS_nfstime3(31, 48),
                           new NFS_nfstime3(12, 8));
    assert(attr1.equals(attr1));

    // Test 2: Compare to another, equal object
    attr2 = new NFS_fattr3(NFS_ftype3.NF3REG,
                           36,
                           63,
                           71,
                           85,
                           (72L << 32) + 83L,
                           (81L << 32) + 66L,
                           new NFS_specdata3(55, 49),
                           (22L << 32) + 68L,
                           (99L << 32) + 163L,
                           new NFS_nfstime3(43, 7),
                           new NFS_nfstime3(31, 48),
                           new NFS_nfstime3(12, 8));
    assert(attr2.equals(attr2));
    assert(attr1.equals(attr2));
    assert(attr2.equals(attr1));
    assert(attr1.hashCode() == attr2.hashCode());

    // Test 3: Compare to a (slightly) unequal object
    attr3 = new NFS_fattr3(NFS_ftype3.NF3DIR,
                           36,
                           63,
                           71,
                           85,
                           (72L << 32) + 83L,
                           (81L << 32) + 66L,
                           new NFS_specdata3(55, 49),
                           (22L << 32) + 68L,
                           (99L << 32) + 163L,
                           new NFS_nfstime3(43, 7),
                           new NFS_nfstime3(31, 48),
                           new NFS_nfstime3(12, 8));
    assert(!attr1.equals(attr3));
    assert(!attr3.equals(attr1));
    assert(!attr2.equals(attr3));
    assert(!attr3.equals(attr2));
    assert(attr3.hashCode() != attr1.hashCode());
    assert(attr3.hashCode() != attr2.hashCode());
    assert(attr3.equals(attr3));
  }

 /** 
 *  Test serialization/deserialization 
 **/ 
  private static void
  testSerialize(){
    NFS_fattr3 fattr1 = null;
    NFS_fattr3 fattr2 = null;
    ByteArrayInputStream bais = null;
    ByteArrayOutputStream baos = null;
    byte[] b = null;

    try{
      // Serialize an object and then de-serialize this
      baos = new ByteArrayOutputStream();
      fattr1 = new NFS_fattr3(NFS_ftype3.NF3REG,
                              36,
                              63,
                              71,
                              85,
                              (72L << 32) + 83L,
                              (81L << 32) + 66L,
                              new NFS_specdata3(55, 49),
                              (22L << 32) + 68L,
                              (99L << 32) + 163L,
                              new NFS_nfstime3(43, 7),
                              new NFS_nfstime3(31, 48),
                              new NFS_nfstime3(12, 8));
      fattr1.toOutputStream(baos);
      baos.flush();
      b = baos.toByteArray();
      bais = new ByteArrayInputStream(b);
      fattr2 = new NFS_fattr3(bais);
      assert(fattr1.equals(fattr2));
      assert(fattr2.equals(fattr1));
      assert(fattr1 != fattr2);

      // Serialize an object and then de-serialize this
      baos = new ByteArrayOutputStream();
      fattr1 = new NFS_fattr3(NFS_ftype3.NF3DIR,
                              63,
                              36,
                              17,
                              58,
                              (27L << 23) + 38L,
                              (18L << 23) + 66L,
                              new NFS_specdata3(55, 94),
                              (22L << 23) + 86L,
                              (99L << 23) + 361L,
                              new NFS_nfstime3(34, 70),
                              new NFS_nfstime3(13, 84),
                              new NFS_nfstime3(21, 80));
      fattr1.toOutputStream(baos);
      baos.flush();
      b = baos.toByteArray();
      bais = new ByteArrayInputStream(b);
      fattr2 = new NFS_fattr3(bais);
      assert(fattr1.equals(fattr2));
      assert(fattr2.equals(fattr1));
      assert(fattr1 != fattr2);
    }catch(IOException e){
      assert false : ("" + e);
    }
  }
}