 /** 
 *  Store constants used as status values 
 **/ 
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;

// Used for testing
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

public class NFS_nfstime3{

 /** 
 *  Constants 
 **/ 
  public static byte MAGIC_NUM = 3;

 /** 
 *  Data members 
 **/ 
  private final int seconds;
  private final int nseconds;

 /** 
 *  Constructor 
 **/ 
  public
  NFS_nfstime3(int newSeconds, int newNSeconds){
    this.seconds = newSeconds;
    this.nseconds = newNSeconds;
  }

 /** 
 *  Constructor 
 **/ 
  public
  NFS_nfstime3(long timeMS){
    this.seconds = (int)(timeMS / 1000L);
    this.nseconds = (int)((timeMS % 1000) * 1000L);
  }

 /** 
 *  Constructor 
 **/ 
  public
  NFS_nfstime3(InputStream is) throws IOException{
    DataInputStream dis = null;
    byte magicNum = 0;

    dis = new DataInputStream(is);
    magicNum = dis.readByte();
    assert(magicNum == NFS_nfstime3.MAGIC_NUM);
    this.seconds = dis.readInt();
    this.nseconds = dis.readInt();
  }

 /** 
 *  Write out this object to the OutputStream 
 **/ 
  public void
  toOutputStream(OutputStream os) throws IOException{
    DataOutputStream dos = null;

    dos = new DataOutputStream(os);
    dos.writeByte(NFS_nfstime3.MAGIC_NUM);
    dos.writeInt(this.seconds);
    dos.writeInt(this.nseconds);
    dos.flush();
  }

 /** 
 *  Return the seconds field 
 **/ 
  public final int
  getSeconds(){
    return(this.seconds);
  }

 /** 
 *  Return the nseconds field 
 **/ 
  public final int
  getNSeconds(){
    return(this.nseconds);
  }

 /** 
 *  Return true if "obj" equals "this" (note: currently unimplemented) 
 **/ 
  public final boolean
  equals(Object obj){
    NFS_nfstime3 val = null;
    boolean eq = false;

    // 2 Java-declared fields, 3 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 5);
    if(obj instanceof NFS_nfstime3){
      val = (NFS_nfstime3)obj;
      eq = ((this.seconds == val.seconds) && (this.nseconds == val.nseconds));
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Compute and return a hashcode for this object 
 **/ 
  public final int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 3 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 5);
    code = ((new Integer(this.seconds)).hashCode() ^
            (new Integer(this.nseconds)).hashCode());
    return(code);
  }

 /** 
 *  Used for testing 
 **/ 
  public static void
  main(String[] argv){
    Env.verifyAssertEnabled();
    System.out.println("Testing NFS_nfstime3.java...");
    NFS_nfstime3.testSimple();
    NFS_nfstime3.testSerialize();
    System.out.println("...Finished");
  }

 /** 
 *  Run simple tests 
 **/ 
  private static void
  testSimple(){
    NFS_nfstime3 time1 = null;
    NFS_nfstime3 time2 = null;
    NFS_nfstime3 time3 = null;
    NFS_nfstime3 time4 = null;

    // Test 1: Random
    time1 = new NFS_nfstime3(23, 12);
    assert(time1.getSeconds() == 23);
    assert(time1.getNSeconds() == 12);
    assert(time1.equals(time1));

    // Test 2: Swapped
    time2 = new NFS_nfstime3(12, 23);
    assert(time2.getSeconds() == 12);
    assert(time2.getNSeconds() == 23);
    assert(time2.equals(time2));
    assert(!time1.equals(time2));
    assert(!time2.equals(time1));

    // Test 3: Equal
    time3 = new NFS_nfstime3(12, 23);
    assert(!time3.equals(time1));
    assert(!time1.equals(time3));
    assert(time3.equals(time2));
    assert(time2.equals(time3));
    assert(time3.equals(time3));

    // Test 4: Other constructor
    time4 = new NFS_nfstime3(7892345699L);
    assert(time4.getSeconds() == 7892345L);
    assert(time4.getNSeconds() == 699000L);
  }

 /** 
 *  Test serialization/deserialization 
 **/ 
  private static void
  testSerialize(){
    NFS_nfstime3 nfstime1 = null;
    NFS_nfstime3 nfstime2 = null;
    ByteArrayInputStream bais = null;
    ByteArrayOutputStream baos = null;
    byte[] b = null;

    try{
      // Serialize an object and then de-serialize this
      baos = new ByteArrayOutputStream();
      nfstime1 = new NFS_nfstime3(23, 12);
      nfstime1.toOutputStream(baos);
      baos.flush();
      b = baos.toByteArray();
      bais = new ByteArrayInputStream(b);
      nfstime2 = new NFS_nfstime3(bais);
      assert(nfstime1.equals(nfstime2));
      assert(nfstime2.equals(nfstime1));
      assert(nfstime1 != nfstime2);

      // Serialize an object and then de-serialize this
      baos = new ByteArrayOutputStream();
      nfstime1 = new NFS_nfstime3(1978, 1980);
      nfstime1.toOutputStream(baos);
      baos.flush();
      b = baos.toByteArray();
      bais = new ByteArrayInputStream(b);
      nfstime2 = new NFS_nfstime3(bais);
      assert(nfstime1.equals(nfstime2));
      assert(nfstime2.equals(nfstime1));
      assert(nfstime1 != nfstime2);
    }catch(IOException e){
      assert false : ("" + e);
    }
  }
}