 /** 
 *  (Possibly) store file attributes after an operation 
 **/ 

public class NFS_post_op_attr implements Immutable{

 /** 
 *  Data members 
 **/ 
  private final boolean attributesFollow;
  private final NFS_fattr3 attributes;

 /** 
 *  Constructor 
 **/ 
  public
  NFS_post_op_attr(boolean newAttributesFollow, NFS_fattr3 newAttributes){
    this.attributesFollow = newAttributesFollow;
    this.attributes = newAttributes;
  }

 /** 
 *  Return the attributesFollow flag 
 **/ 
  public boolean
  getAttributesFollow(){
    return(this.attributesFollow);
  }

 /** 
 *  Return the attributes 
 **/ 
  public NFS_fattr3
  getAttributes(){
    return(this.attributes);
  }

 /** 
 *  Return true if "obj" equals "this" (note: currently unimplemented) 
 **/ 
  public final boolean
  equals(Object obj){
    boolean eq = false;
    NFS_post_op_attr attr = null;

    // 2 Java-declared fields, 2 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 4);
    if(obj instanceof NFS_post_op_attr){
      attr = (NFS_post_op_attr)obj;
      if(this.attributes != null){
        eq = ((this.attributesFollow == attr.attributesFollow) &&
              this.attributes.equals(attr.attributes));
      }else{
        eq = ((this.attributesFollow == attr.attributesFollow) &&
              (attr.attributes == null));
      }
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Compute and return a hashcode for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 2 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 4);
    if(this.attributes != null){
      code = ((new Boolean(this.attributesFollow)).hashCode() ^
              this.attributes.hashCode());
    }else{
      code = (new Boolean(this.attributesFollow)).hashCode() ^ 0;
    }
    return(code);
  }

 /** 
 *  Used for testing 
 **/ 
  public static void
  main(String[] argv){
    Env.verifyAssertEnabled();
    System.out.println("Testing NFS_post_op_attr.java...");
    NFS_post_op_attr.testSimple();
    System.out.println("...Finished");
  }

 /** 
 *  Run simple tests 
 **/ 
  private static void
  testSimple(){
    NFS_fattr3 attr = null;
    NFS_post_op_attr postAttr1 = null;
    NFS_post_op_attr postAttr2 = null;
    NFS_post_op_attr postAttr3 = null;

    // Test 1
    attr = new NFS_fattr3(NFS_ftype3.NF3REG,
                          36,
                          63,
                          71,
                          85,
                          (72L << 32) + 83L,
                          (81L << 32) + 66L,
                          new NFS_specdata3(55, 49),
                          (22L << 32) + 68L,
                          (99L << 32) + 163L,
                          new NFS_nfstime3(43, 7),
                          new NFS_nfstime3(31, 48),
                          new NFS_nfstime3(12, 8));
    postAttr1 = new NFS_post_op_attr(true, attr);
    assert(postAttr1.getAttributesFollow());
    assert(postAttr1.getAttributes().equals(attr));
    assert(postAttr1.equals(postAttr1));

    // Test 2
    postAttr2 = new NFS_post_op_attr(false, null);
    assert(!postAttr2.getAttributesFollow());
    assert(postAttr2.getAttributes() == null);
    assert(postAttr2.equals(postAttr2));
    assert(!postAttr1.equals(postAttr2));
    assert(!postAttr2.equals(postAttr1));
    assert(postAttr1.hashCode() != postAttr2.hashCode());

    // Test 3
    postAttr3 = new NFS_post_op_attr(true, attr);
    assert(postAttr3.getAttributesFollow());
    assert(postAttr3.getAttributes().equals(attr));
    assert(postAttr3.equals(postAttr3));
    assert(postAttr1.equals(postAttr3));
    assert(postAttr3.equals(postAttr1));
    assert(!postAttr2.equals(postAttr3));
    assert(!postAttr3.equals(postAttr2));
    assert(postAttr3.hashCode() == postAttr1.hashCode());
    assert(postAttr3.hashCode() != postAttr2.hashCode());
  }
}