 /** 
 *  (Possibly) store a file handle after an operation 
 **/ 

public class NFS_post_op_fh3 implements Immutable{

 /** 
 *  Data members 
 **/ 
  private final boolean handleFollows;
  private final NFS_nfs_fh3 handle;

 /** 
 *  Constructor 
 **/ 
  public
  NFS_post_op_fh3(boolean newHandleFollows, NFS_nfs_fh3 newHandle){
    this.handleFollows = newHandleFollows;
    this.handle = newHandle;
  }

 /** 
 *  Return the attributesFollow flag 
 **/ 
  public boolean
  getHandleFollows(){
    return(this.handleFollows);
  }

 /** 
 *  Return the attributes 
 **/ 
  public NFS_nfs_fh3
  getHandle(){
    assert(this.handleFollows);
    return(this.handle);
  }

 /** 
 *  Return true if "obj" equals "this" 
 **/ 
  public final boolean
  equals(Object obj){
    boolean eq = false;
    NFS_post_op_fh3 postOpHandle = null;

    // 2 Java-declared fields, 2 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 4);
    if(obj instanceof NFS_post_op_fh3){
      postOpHandle = (NFS_post_op_fh3)obj;
      if(this.handleFollows == postOpHandle.handleFollows){
        if(this.handleFollows){
          assert(this.handle != null);
          eq = (postOpHandle.handleFollows &&
                this.handle.equals(postOpHandle.handle));
        }else{
          eq = !postOpHandle.handleFollows;
        }
      }else{
        eq = false;
      }
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Compute and return a hashcode for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 2 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 4);
    code = (new Boolean(this.handleFollows)).hashCode();
    if(this.handleFollows){
      assert(this.handle != null);
      code = code ^ this.handle.hashCode();
    }
    return(code);
  }

 /** 
 *  Used for testing 
 **/ 
  public static void
  main(String[] argv){
    Env.verifyAssertEnabled();
    System.out.println("Testing NFS_post_op_fh3.java...");
    NFS_post_op_fh3.testSimple();
    System.out.println("...Finished");
  }

 /** 
 *  Run simple tests 
 **/ 
  private static void
  testSimple(){
    NFS_post_op_fh3 postOpHandle1 = null;
    NFS_post_op_fh3 postOpHandle2 = null;
    NFS_post_op_fh3 postOpHandle3 = null;
    byte data[] = null;

    // Test 1
    data = new byte[64];
    data[0] = 38;
    postOpHandle1 = new NFS_post_op_fh3(true, NFS_nfs_fh3.makeHandle(data));
    assert(postOpHandle1.getHandleFollows());
    assert(postOpHandle1.getHandle().equals(NFS_nfs_fh3.makeHandle(data)));
    assert(postOpHandle1.equals(postOpHandle1));

    // Test 2
    postOpHandle2 = new NFS_post_op_fh3(false, null);
    assert(!postOpHandle2.getHandleFollows());
    assert(postOpHandle2.equals(postOpHandle2));
    assert(!postOpHandle1.equals(postOpHandle2));
    assert(!postOpHandle2.equals(postOpHandle1));
    assert(postOpHandle1.hashCode() != postOpHandle2.hashCode());

    // Test 3
    postOpHandle3 = new NFS_post_op_fh3(true, NFS_nfs_fh3.makeHandle(data));
    assert(postOpHandle3.getHandleFollows());
    assert(postOpHandle3.getHandle().equals(NFS_nfs_fh3.makeHandle(data)));
    assert(postOpHandle3.equals(postOpHandle3));
    assert(postOpHandle1.equals(postOpHandle3));
    assert(postOpHandle3.equals(postOpHandle1));
    assert(!postOpHandle2.equals(postOpHandle3));
    assert(!postOpHandle3.equals(postOpHandle2));
    assert(postOpHandle3.hashCode() == postOpHandle1.hashCode());
    assert(postOpHandle3.hashCode() != postOpHandle2.hashCode());
  }
}