 /** 
 *  Store the NFS file attribute data structure used when setting values 
 **/ 

// TODO: Confirm that a "short" is 16 bits and an "int" is 32 bits
// TODO: Check if there is an "unsigned" in java

 /** 
 *  Constants used by sattr3 
 **/ 
class NFS_time_how{

 /** 
 *  Constants 
 **/ 
  public static final int DONT_CHANGE = 0;
  public static final int SET_TO_SERVER_TIME = 1;
  public static final int SET_TO_CLIENT_TIME = 2;
}

 /** 
 *  Class to (possibly) hold a new value for the mode 
 **/ 
class NFS_set_mode3 implements Immutable{

 /** 
 *  Data members 
 **/ 
  private final boolean setIt;
  private final int mode;

 /** 
 *  Constructor 
 **/ 
  public
  NFS_set_mode3(boolean newSetIt, int newMode){
    this.setIt = newSetIt;
    this.mode = newMode;
  }

 /** 
 *  Return the setIt flag 
 **/ 
  public boolean
  getSetIt(){
    return(this.setIt);
  }

 /** 
 *  Return the new mode 
 **/ 
  public int
  getMode(){
    return(this.mode);
  }

 /** 
 *  Return true if "obj" is equal to "this" 
 **/ 
  public boolean
  equals(Object obj){
    boolean eq = false;
    NFS_set_mode3 setMode = null;

    // 2 Java-declared fields, 2 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 4);
    if(obj instanceof NFS_set_mode3){
      setMode = (NFS_set_mode3)obj;
      eq = ((this.setIt == setMode.setIt) && (this.mode == setMode.mode));
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Return a hash code for this class 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 2 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 4);
    code = ((new Boolean(this.setIt).hashCode()) ^
            (new Integer(this.mode)).hashCode());
    return(code);
  }
}

 /** 
 *  Class to (possibly) hold a new value for the uid 
 **/ 
class NFS_set_uid3 implements Immutable{

 /** 
 *  Data members 
 **/ 
  private final boolean setIt;
  private final int uid;

 /** 
 *  Constructor 
 **/ 
  public
  NFS_set_uid3(boolean newSetIt, int newUID){
    this.setIt = newSetIt;
    this.uid = newUID;
  }

 /** 
 *  Return the setIt flag 
 **/ 
  public boolean
  getSetIt(){
    return(this.setIt);
  }

 /** 
 *  Return the new uid 
 **/ 
  public int
  getUID(){
    return(this.uid);
  }

 /** 
 *  Return true if "obj" is equal to "this" 
 **/ 
  public boolean
  equals(Object obj){
    boolean eq = false;
    NFS_set_uid3 setUID = null;

    // 2 Java-declared fields, 2 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 4);
    if(obj instanceof NFS_set_uid3){
      setUID = (NFS_set_uid3)obj;
      eq = ((this.setIt == setUID.setIt) && (this.uid == setUID.uid));
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Return a hash code for this class 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 2 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 4);
    code = ((new Boolean(this.setIt).hashCode()) ^
            (new Integer(this.uid)).hashCode());
    return(code);
  }
}

 /** 
 *  Class to (possibly) hold a new value for the gid 
 **/ 
class NFS_set_gid3 implements Immutable{

 /** 
 *  Data members 
 **/ 
  private final boolean setIt;
  private final int gid;

 /** 
 *  Constructor 
 **/ 
  public
  NFS_set_gid3(boolean newSetIt, int newGID){
    this.setIt = newSetIt;
    this.gid = newGID;
  }

 /** 
 *  Return the setIt flag 
 **/ 
  public boolean
  getSetIt(){
    return(this.setIt);
  }

 /** 
 *  Return the new gid 
 **/ 
  public int
  getGID(){
    return(this.gid);
  }

 /** 
 *  Return true if "obj" is equal to "this" 
 **/ 
  public boolean
  equals(Object obj){
    boolean eq = false;
    NFS_set_gid3 setGID = null;

    // 2 Java-declared fields, 2 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 4);
    if(obj instanceof NFS_set_gid3){
      setGID = (NFS_set_gid3)obj;
      eq = ((this.setIt == setGID.setIt) && (this.gid == setGID.gid));
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Return a hash code for this class 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 2 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 4);
    code = ((new Boolean(this.setIt).hashCode()) ^
            (new Integer(this.gid)).hashCode());
    return(code);
  }
}

 /** 
 *  Class to (possibly) hold a new value for the size 
 **/ 
class NFS_set_size3 implements Immutable{

 /** 
 *  Data members 
 **/ 
  private final boolean setIt;
  private final long size;

 /** 
 *  Constructor 
 **/ 
  public
  NFS_set_size3(boolean newSetIt, long newSize){
    this.setIt = newSetIt;
    this.size = newSize;
  }

 /** 
 *  Return the setIt flag 
 **/ 
  public boolean
  getSetIt(){
    return(this.setIt);
  }

 /** 
 *  Return the new size 
 **/ 
  public long
  getSize(){
    return(this.size);
  }

 /** 
 *  Return true if "obj" is equal to "this" 
 **/ 
  public boolean
  equals(Object obj){
    boolean eq = false;
    NFS_set_size3 setSize = null;

    // 2 Java-declared fields, 2 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 4);
    if(obj instanceof NFS_set_size3){
      setSize = (NFS_set_size3)obj;
      eq = ((this.setIt == setSize.setIt) && (this.size == setSize.size));
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Return a hash code for this class 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 2 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 4);
    code = ((new Boolean(this.setIt).hashCode()) ^
            (new Long(this.size)).hashCode());
    return(code);
  }
}

 /** 
 *  Class to (possibly) hold a new value for atime 
 **/ 
class NFS_set_atime implements Immutable{

 /** 
 *  Data members 
 **/ 
  private final int setIt;
  private final NFS_nfstime3 atime;

 /** 
 *  Constructor 
 **/ 
  public
  NFS_set_atime(int newSetIt, NFS_nfstime3 newATime){
    assert((newSetIt >= NFS_time_how.DONT_CHANGE) &&
           (newSetIt <= NFS_time_how.SET_TO_CLIENT_TIME));
    this.setIt = newSetIt;
    this.atime = newATime;
  }

 /** 
 *  Return the value of setIt 
 **/ 
  public int
  getSetIt(){
    return(this.setIt);
  }

 /** 
 *  Return the new atime 
 **/ 
  public NFS_nfstime3
  getATime(){
    return(this.atime);
  }

 /** 
 *  Return true if "obj" is equal to "this" 
 **/ 
  public boolean
  equals(Object obj){
    boolean eq = false;
    NFS_set_atime setATime = null;

    // 2 Java-declared fields, 2 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 4);
    if(obj instanceof NFS_set_atime){
      setATime = (NFS_set_atime)obj;
      eq = ((this.setIt == setATime.setIt) &&
            (this.atime.equals(setATime.atime)));
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Return a hash code for this class 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 2 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 4);
    code = ((new Integer(this.setIt).hashCode()) ^ this.atime.hashCode());
    return(code);
  }
}

 /** 
 *  Class to (possibly) hold a new value for mtime 
 **/ 
class NFS_set_mtime implements Immutable{

 /** 
 *  Data members 
 **/ 
  private final int setIt;
  private final NFS_nfstime3 mtime;

 /** 
 *  Constructor 
 **/ 
  public
  NFS_set_mtime(int newSetIt, NFS_nfstime3 newMTime){
    assert((newSetIt >= NFS_time_how.DONT_CHANGE) &&
           (newSetIt <= NFS_time_how.SET_TO_CLIENT_TIME));
    this.setIt = newSetIt;
    this.mtime = newMTime;
  }

 /** 
 *  Return the value of setIt 
 **/ 
  public int
  getSetIt(){
    return(this.setIt);
  }

 /** 
 *  Return the new mtime 
 **/ 
  public NFS_nfstime3
  getMTime(){
    return(this.mtime);
  }

 /** 
 *  Return true if "obj" is equal to "this" 
 **/ 
  public boolean
  equals(Object obj){
    boolean eq = false;
    NFS_set_mtime setMTime = null;

    // 2 Java-declared fields, 2 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 4);
    if(obj instanceof NFS_set_mtime){
      setMTime = (NFS_set_mtime)obj;
      eq = ((this.setIt == setMTime.setIt) &&
            (this.mtime.equals(setMTime.mtime)));
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Return a hash code for this class 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 2 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 4);
    code = ((new Integer(this.setIt).hashCode()) ^ this.mtime.hashCode());
    return(code);
  }
}

 /** 
 *  Implement the sattr3 class of NFS 3 
 **/ 
public class NFS_sattr3 implements Immutable{

 /** 
 *  Data members 
 **/ 
  private final NFS_set_mode3 mode;
  private final NFS_set_uid3 uid;
  private final NFS_set_gid3 gid;
  private final NFS_set_size3 size;
  private final NFS_set_atime atime;
  private final NFS_set_mtime mtime;

 /** 
 *  Constructor 
 **/ 
  public
  NFS_sattr3(NFS_set_mode3 newMode,
             NFS_set_uid3 newUID,
             NFS_set_gid3 newGID,
             NFS_set_size3 newSize,
             NFS_set_atime newATime,
             NFS_set_mtime newMTime){
    this.mode = newMode;
    this.uid = newUID;
    this.gid = newGID;
    this.size = newSize;
    this.atime = newATime;
    this.mtime = newMTime;
  }

 /** 
 *  Return the mode 
 **/ 
  public NFS_set_mode3
  getMode(){
    return(this.mode);
  }

 /** 
 *  Return the uid 
 **/ 
  public NFS_set_uid3
  getUID(){
    return(this.uid);
  }

 /** 
 *  Return the gid 
 **/ 
  public NFS_set_gid3
  getGID(){
    return(this.gid);
  }

 /** 
 *  Return the size 
 **/ 
  public NFS_set_size3
  getSize(){
    return(this.size);
  }

 /** 
 *  Return the atime 
 **/ 
  public NFS_set_atime
  getATime(){
    return(this.atime);
  }

 /** 
 *  Return the mtime 
 **/ 
  public NFS_set_mtime
  getMTime(){
    return(this.mtime);
  }

 /** 
 *  Return true if "obj" equals "this" (note: currently unimplemented) 
 **/ 
  public final boolean
  equals(Object obj){
    boolean eq = false;
    NFS_sattr3 attr = null;

    // 2 Java-declared fields, 6 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 8);
    if(obj instanceof NFS_sattr3){
      attr = (NFS_sattr3)obj;
      eq = ((this.mode.equals(attr.mode)) &&
            (this.uid.equals(attr.uid)) &&
            (this.gid.equals(attr.gid)) &&
            (this.size.equals(attr.size)) &&
            (this.atime.equals(attr.atime)) &&
            (this.mtime.equals(attr.mtime)));
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Compute and return a hashcode for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 6 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 8);
    code = (this.mode.hashCode() ^
            this.uid.hashCode() ^
            this.gid.hashCode() ^
            this.size.hashCode() ^
            this.atime.hashCode() ^
            this.mtime.hashCode());
    return(code);
  }

 /** 
 *  Used for testing 
 **/ 
  public static void
  main(String[] argv){
    Env.verifyAssertEnabled();
    System.out.println("Testing NFS_sattr3.java...");
    NFS_sattr3.testNFS_set_mode3();
    NFS_sattr3.testNFS_set_uid3();
    NFS_sattr3.testNFS_set_gid3();
    NFS_sattr3.testNFS_set_size3();
    NFS_sattr3.testNFS_set_atime();
    NFS_sattr3.testNFS_set_mtime();
    NFS_sattr3.testNFS_sattr3();
    /*
      NFS_sattr3.testSimple();
      NFS_sattr3.testEqualsHashCode();
    */
    System.out.println("...Finished");
  }

 /** 
 *  Test the NFS_set_mode3 class 
 **/ 
  private static void
  testNFS_set_mode3(){
    NFS_set_mode3 mode1 = null;
    NFS_set_mode3 mode2 = null;
    NFS_set_mode3 mode3 = null;

    // Test 1
    mode1 = new NFS_set_mode3(true, 78);
    assert(mode1.getSetIt());
    assert(mode1.getMode() == 78);
    assert(mode1.equals(mode1));

    // Test 2: Compare with unequal
    mode2 = new NFS_set_mode3(true, 80);
    assert(mode2.getSetIt());
    assert(mode2.getMode() == 80);
    assert(mode2.equals(mode2));
    assert(!mode1.equals(mode2));
    assert(!mode2.equals(mode1));

    // Test 3: Compare with equal
    mode3 = new NFS_set_mode3(true, 78);
    assert(mode3.getSetIt());
    assert(mode3.getMode() == 78);
    assert(mode3.equals(mode3));
    assert(mode1.equals(mode3));
    assert(mode3.equals(mode1));
    assert(!mode2.equals(mode3));
    assert(!mode3.equals(mode2));
  }

 /** 
 *  Test the NFS_set_uid3 class 
 **/ 
  private static void
  testNFS_set_uid3(){
    NFS_set_uid3 uid1 = null;
    NFS_set_uid3 uid2 = null;
    NFS_set_uid3 uid3 = null;

    // Test 1
    uid1 = new NFS_set_uid3(true, 25);
    assert(uid1.getSetIt());
    assert(uid1.getUID() == 25);
    assert(uid1.equals(uid1));

    // Test 2: Compare with unequal
    uid2 = new NFS_set_uid3(true, 10);
    assert(uid2.getSetIt());
    assert(uid2.getUID() == 10);
    assert(uid2.equals(uid2));
    assert(!uid1.equals(uid2));
    assert(!uid2.equals(uid1));

    // Test 3: Compare with equal
    uid3 = new NFS_set_uid3(true, 25);
    assert(uid3.getSetIt());
    assert(uid3.getUID() == 25);
    assert(uid3.equals(uid3));
    assert(uid1.equals(uid3));
    assert(uid3.equals(uid1));
    assert(!uid2.equals(uid3));
    assert(!uid3.equals(uid2));
  }

 /** 
 *  Test the NFS_set_gid3 class 
 **/ 
  private static void
  testNFS_set_gid3(){
    NFS_set_gid3 gid1 = null;
    NFS_set_gid3 gid2 = null;
    NFS_set_gid3 gid3 = null;

    // Test 1
    gid1 = new NFS_set_gid3(true, 25);
    assert(gid1.getSetIt());
    assert(gid1.getGID() == 25);
    assert(gid1.equals(gid1));

    // Test 2: Compare with unequal
    gid2 = new NFS_set_gid3(true, 10);
    assert(gid2.getSetIt());
    assert(gid2.getGID() == 10);
    assert(gid2.equals(gid2));
    assert(!gid1.equals(gid2));
    assert(!gid2.equals(gid1));

    // Test 3: Compare with equal
    gid3 = new NFS_set_gid3(true, 25);
    assert(gid3.getSetIt());
    assert(gid3.getGID() == 25);
    assert(gid3.equals(gid3));
    assert(gid1.equals(gid3));
    assert(gid3.equals(gid1));
    assert(!gid2.equals(gid3));
    assert(!gid3.equals(gid2));
  }

 /** 
 *  Test the NFS_set_size3 class 
 **/ 
  private static void
  testNFS_set_size3(){
    NFS_set_size3 size1 = null;
    NFS_set_size3 size2 = null;
    NFS_set_size3 size3 = null;

    // Test 1
    size1 = new NFS_set_size3(false, (109L << 32) + 258L);
    assert(!size1.getSetIt());
    assert(size1.getSize() == ((109L << 32) + 258L));
    assert(size1.equals(size1));

    // Test 2: Compare with unequal
    size2 = new NFS_set_size3(true, (156L << 32) + 7L);
    assert(size2.getSetIt());
    assert(size2.getSize() == ((156L << 32) + 7L));
    assert(size2.equals(size2));
    assert(!size1.equals(size2));
    assert(!size2.equals(size1));

    // Test 3: Compare with equal
    size3 = new NFS_set_size3(false, (109L << 32) + 258L);
    assert(!size3.getSetIt());
    assert(size3.getSize() == ((109L << 32) + 258L));
    assert(size3.equals(size3));
    assert(size1.equals(size3));
    assert(size3.equals(size1));
    assert(!size2.equals(size3));
    assert(!size3.equals(size2));
  }

 /** 
 *  Test the NFS_set_atime class 
 **/ 
  private static void
  testNFS_set_atime(){
    NFS_set_atime atime1 = null;
    NFS_set_atime atime2 = null;
    NFS_set_atime atime3 = null;

    // Test 1
    atime1 = new NFS_set_atime(NFS_time_how.DONT_CHANGE,
                               new NFS_nfstime3(99, 88));
    assert(atime1.getSetIt() == NFS_time_how.DONT_CHANGE);
    assert(atime1.getATime().equals(new NFS_nfstime3(99, 88)));
    assert(atime1.equals(atime1));

    // Test 2: Compare with unequal
    atime2 = new NFS_set_atime(NFS_time_how.SET_TO_SERVER_TIME,
                               new NFS_nfstime3(70, 50));
    assert(atime2.getSetIt() == NFS_time_how.SET_TO_SERVER_TIME);
    assert(atime2.getATime().equals(new NFS_nfstime3(70, 50)));
    assert(atime2.equals(atime2));
    assert(!atime1.equals(atime2));
    assert(!atime2.equals(atime1));

    // Test 3: Compare with equal
    atime3 = new NFS_set_atime(NFS_time_how.DONT_CHANGE,
                               new NFS_nfstime3(99, 88));
    assert(atime3.getSetIt() == NFS_time_how.DONT_CHANGE);
    assert(atime3.getATime().equals(new NFS_nfstime3(99, 88)));
    assert(atime3.equals(atime3));
    assert(atime1.equals(atime3));
    assert(atime3.equals(atime1));
    assert(!atime2.equals(atime3));
    assert(!atime3.equals(atime2));
  }

 /** 
 *  Test the NFS_set_mtime class 
 **/ 
  private static void
  testNFS_set_mtime(){
    NFS_set_mtime mtime1 = null;
    NFS_set_mtime mtime2 = null;
    NFS_set_mtime mtime3 = null;

    // Test 1
    mtime1 = new NFS_set_mtime(NFS_time_how.DONT_CHANGE,
                               new NFS_nfstime3(87, 78));
    assert(mtime1.getSetIt() == NFS_time_how.DONT_CHANGE);
    assert(mtime1.getMTime().equals(new NFS_nfstime3(87, 78)));
    assert(mtime1.equals(mtime1));

    // Test 2: Compare with unequal
    mtime2 = new NFS_set_mtime(NFS_time_how.SET_TO_SERVER_TIME,
                               new NFS_nfstime3(75, 57));
    assert(mtime2.getSetIt() == NFS_time_how.SET_TO_SERVER_TIME);
    assert(mtime2.getMTime().equals(new NFS_nfstime3(75, 57)));
    assert(mtime2.equals(mtime2));
    assert(!mtime1.equals(mtime2));
    assert(!mtime2.equals(mtime1));

    // Test 3: Compare with equal
    mtime3 = new NFS_set_mtime(NFS_time_how.DONT_CHANGE,
                               new NFS_nfstime3(87, 78));
    assert(mtime3.getSetIt() == NFS_time_how.DONT_CHANGE);
    assert(mtime3.getMTime().equals(new NFS_nfstime3(87, 78)));
    assert(mtime3.equals(mtime3));
    assert(mtime1.equals(mtime3));
    assert(mtime3.equals(mtime1));
    assert(!mtime2.equals(mtime3));
    assert(!mtime3.equals(mtime2));
  }

 /** 
 *  Test the NFS_sattr3 class 
 **/ 
  private static void
  testNFS_sattr3(){
    NFS_sattr3 sattr1 = null;
    NFS_sattr3 sattr2 = null;
    NFS_sattr3 sattr3 = null;
    NFS_set_atime atime = null;
    NFS_set_mtime mtime = null;

    // Test 1
    sattr1 = new NFS_sattr3(new NFS_set_mode3(true, 53),
                            new NFS_set_uid3(false, 2),
                            new NFS_set_gid3(true, 11),
                            new NFS_set_size3(true, (1L << 32) + 58L),
                            new NFS_set_atime(NFS_time_how.DONT_CHANGE,
                                              new NFS_nfstime3(66, 67)),
                            new NFS_set_mtime(NFS_time_how.SET_TO_CLIENT_TIME,
                                              new NFS_nfstime3(5, 15)));
    assert(sattr1.getMode().equals(new NFS_set_mode3(true, 53)));
    assert(sattr1.getUID().equals(new NFS_set_uid3(false, 2)));
    assert(sattr1.getGID().equals(new NFS_set_gid3(true, 11)));
    assert(sattr1.getSize().equals(new NFS_set_size3(true, (1L << 32) + 58)));
    atime = sattr1.getATime();
    assert(atime.equals(new NFS_set_atime(NFS_time_how.DONT_CHANGE,
                                          new NFS_nfstime3(66, 67))));
    mtime = sattr1.getMTime();
    assert(mtime.equals(new NFS_set_mtime(NFS_time_how.SET_TO_CLIENT_TIME,
                                          new NFS_nfstime3(5, 15))));
    assert(sattr1.equals(sattr1));

    // Test 2
    sattr2 = new NFS_sattr3(new NFS_set_mode3(false, 151),
                            new NFS_set_uid3(true, 221),
                            new NFS_set_gid3(false, 751),
                            new NFS_set_size3(false, (800L << 32) + 581L),
                            new NFS_set_atime(NFS_time_how.SET_TO_SERVER_TIME,
                                              new NFS_nfstime3(851, 100)),
                            new NFS_set_mtime(NFS_time_how.DONT_CHANGE,
                                              new NFS_nfstime3(101, 8)));
    assert(sattr2.getMode().equals(new NFS_set_mode3(false, 151)));
    assert(sattr2.getUID().equals(new NFS_set_uid3(true, 221)));
    assert(sattr2.getGID().equals(new NFS_set_gid3(false, 751)));
    assert(sattr2.getSize().equals(new NFS_set_size3(false,
                                                     (800L << 32) + 581L)));
    atime = sattr2.getATime();
    assert(atime.equals(new NFS_set_atime(NFS_time_how.SET_TO_SERVER_TIME,
                                          new NFS_nfstime3(851, 100))));
    mtime = sattr2.getMTime();
    assert(mtime.equals(new NFS_set_mtime(NFS_time_how.DONT_CHANGE,
                                          new NFS_nfstime3(101, 8))));
    assert(sattr2.equals(sattr2));
    assert(!sattr1.equals(sattr2));
    assert(!sattr2.equals(sattr1));

    // Test 3
    sattr3 = new NFS_sattr3(new NFS_set_mode3(true, 53),
                            new NFS_set_uid3(false, 2),
                            new NFS_set_gid3(true, 11),
                            new NFS_set_size3(true, (1L << 32) + 58),
                            new NFS_set_atime(NFS_time_how.DONT_CHANGE,
                                              new NFS_nfstime3(66, 67)),
                            new NFS_set_mtime(NFS_time_how.SET_TO_CLIENT_TIME,
                                              new NFS_nfstime3(5, 15)));
    assert(sattr3.getMode().equals(new NFS_set_mode3(true, 53)));
    assert(sattr3.getUID().equals(new NFS_set_uid3(false, 2)));
    assert(sattr3.getGID().equals(new NFS_set_gid3(true, 11)));
    assert(sattr3.getSize().equals(new NFS_set_size3(true, (1L << 32) + 58L)));
    atime = sattr3.getATime();
    assert(atime.equals(new NFS_set_atime(NFS_time_how.DONT_CHANGE,
                                          new NFS_nfstime3(66, 67))));
    mtime = sattr3.getMTime();
    assert(mtime.equals(new NFS_set_mtime(NFS_time_how.SET_TO_CLIENT_TIME,
                                          new NFS_nfstime3(5, 15))));
    assert(sattr3.equals(sattr3));
    assert(sattr1.equals(sattr3));
    assert(sattr3.equals(sattr1));
    assert(!sattr1.equals(sattr2));
    assert(!sattr2.equals(sattr1));
  }
}
