 /** 
 *  Represent the specdata3 data structure used by NFS3 
 **/ 
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;

// Used for testing
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

public class NFS_specdata3{

 /** 
 *  Constants 
 **/ 
  public static final byte MAGIC_NUM = 2;

 /** 
 *  Data members 
 **/ 
  private int specdata1;
  private int specdata2;

 /** 
 *  Constructor 
 **/ 
  public
  NFS_specdata3(int newSpecData1, int newSpecData2){
    this.specdata1 = newSpecData1;
    this.specdata2 = newSpecData2;
  }

 /** 
 *  Constructor 
 *  Read data from an input stream 
 **/ 
  public
  NFS_specdata3(InputStream is) throws IOException{
    DataInputStream dis = null;
    byte magicNum = 0;

    dis = new DataInputStream(is);
    magicNum = dis.readByte();
    assert(magicNum == NFS_specdata3.MAGIC_NUM);
    this.specdata1 = dis.readInt();
    this.specdata2 = dis.readInt();
  }

 /** 
 *  Write this object to an output stream 
 **/ 
  public void
  toOutputStream(OutputStream os) throws IOException{
    DataOutputStream dos = null;

    dos = new DataOutputStream(os);
    dos.writeByte(NFS_specdata3.MAGIC_NUM);
    dos.writeInt(this.specdata1);
    dos.writeInt(this.specdata2);
    dos.flush();
  }

 /** 
 *  Get the first specdata value 
 **/ 
  public final int
  getSpecData1(){
    return(this.specdata1);
  }

 /** 
 *  Get the second specdata value 
 **/ 
  public final int
  getSpecData2(){
    return(this.specdata2);
  }

 /** 
 *  Return true if "obj" equals "this" (note: currently unimplemented) 
 **/ 
  public final boolean
  equals(Object obj){
    NFS_specdata3 val = null;
    boolean eq = false;

    // 2 Java-declared fields, 3 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 5);
    if(obj instanceof NFS_specdata3){
      val = (NFS_specdata3)obj;
      eq = ((this.specdata1 == val.specdata1) &&
            (this.specdata2 == val.specdata2));
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Compute and return a hashcode for this object 
 **/ 
  public final int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 3 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 5);
    code = ((new Integer(this.specdata1)).hashCode() ^
            (new Integer(this.specdata2)).hashCode());
    return(code);
  }

 /** 
 *  Used for testing 
 **/ 
  public static void
  main(String[] argv){
    Env.verifyAssertEnabled();
    System.out.println("Testing NFS_specdata3.java...");
    NFS_specdata3.testSimple();
    NFS_specdata3.testSerialize();
    System.out.println("...Finished");
  }

 /** 
 *  Test simple methods 
 **/ 
  private static void
  testSimple(){
    NFS_specdata3 val1 = null;
    NFS_specdata3 val2 = null;
    NFS_specdata3 val3 = null;
    NFS_specdata3 val4 = null;

    // Test 1: Random
    val1 = new NFS_specdata3(101, 53);
    assert(val1.getSpecData1() == 101);
    assert(val1.getSpecData2() == 53);
    assert(val1.equals(val1));
    assert(val1.hashCode() == val1.hashCode());

    // Test 2: Compare to unequal, but values swapped case
    val2 = new NFS_specdata3(53, 101);
    assert(val2.getSpecData1() == 53);
    assert(val2.getSpecData2() == 101);
    assert(val2.equals(val2));
    assert(!val1.equals(val2));
    assert(!val2.equals(val1));
    assert(val2.hashCode() == val2.hashCode());

    // Test 3: Compare to equal
    val3 = new NFS_specdata3(53, 101);
    assert(val3.getSpecData1() == 53);
    assert(val3.getSpecData2() == 101);
    assert(val3.equals(val3));
    assert(!val1.equals(val3));
    assert(!val3.equals(val1));
    assert(val2.equals(val3));
    assert(val3.equals(val2));
    assert(val3.hashCode() == val2.hashCode());

    // Test 4: Compare to slightly different
    val4 = new NFS_specdata3(78, 101);
    assert(val4.getSpecData1() == 78);
    assert(val4.getSpecData2() == 101);
    assert(val4.equals(val4));
    assert(!val1.equals(val4));
    assert(!val4.equals(val1));
    assert(!val2.equals(val4));
    assert(!val4.equals(val2));
    assert(!val3.equals(val4));
    assert(!val4.equals(val3));
    assert(val4.hashCode() != val3.hashCode());
    assert(val4.hashCode() != val1.hashCode());
  }

 /** 
 *  Test serialization/deserialization 
 **/ 
  private static void
  testSerialize(){
    NFS_specdata3 specdata1 = null;
    NFS_specdata3 specdata2 = null;
    ByteArrayOutputStream baos = null;
    ByteArrayInputStream bais = null;
    byte[] b = null;

    try{
      // Serialize an object and then de-serialize this
      baos = new ByteArrayOutputStream();
      specdata1 = new NFS_specdata3(5, 7);
      specdata1.toOutputStream(baos);
      baos.flush();
      b = baos.toByteArray();
      bais = new ByteArrayInputStream(b);
      specdata2 = new NFS_specdata3(bais);
      assert(specdata1.equals(specdata2));
      assert(specdata2.equals(specdata1));
      assert(specdata1 != specdata2);

      // Serialize an object and then de-serialize this
      baos = new ByteArrayOutputStream();
      specdata1 = new NFS_specdata3(345, 789);
      specdata1.toOutputStream(baos);
      baos.flush();
      b = baos.toByteArray();
      bais = new ByteArrayInputStream(b);
      specdata2 = new NFS_specdata3(bais);
      assert(specdata1.equals(specdata2));
      assert(specdata2.equals(specdata1));
      assert(specdata1 != specdata2);
    }catch(IOException e){
      assert false : ("" + e);
    }
  }
}