 /** 
 *  Represent the NFS3 data structure used to verify writes 
 **/ 
import java.util.Arrays;

public class NFS_writeverf3 implements Immutable{

 /** 
 *  Constants 
 **/ 
  public static final int NFS3_WRITEVERFSIZE = 8;

 /** 
 *  Local data members 
 **/ 
  private final byte[] data;

 /** 
 *  Constructor 
 **/ 
  public
  NFS_writeverf3(byte[] newData){
    byte[] dataCopy = null;

    assert(newData.length == NFS3_WRITEVERFSIZE);
    dataCopy = new byte[NFS3_WRITEVERFSIZE];
    for(int i = 0; i < NFS3_WRITEVERFSIZE; i++){
      dataCopy[i] = newData[i];
    }
    this.data = dataCopy;
  }

 /** 
 *  Return the data 
 **/ 
  public byte[]
  getData(){
    byte[] dataCopy = null;

    dataCopy = new byte[NFS3_WRITEVERFSIZE];
    for(int i = 0; i < NFS3_WRITEVERFSIZE; i++){
      dataCopy[i] = this.data[i];
    }
    return(dataCopy);
  }

 /** 
 *  Return true if "obj" equals "this" (note: currently unimplemented) 
 **/ 
  public final boolean
  equals(Object obj){
    NFS_writeverf3 verf = null;
    boolean eq = false;

    // 2 Java-declared fields, 2 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 4);
    if(obj instanceof NFS_writeverf3){
      verf = (NFS_writeverf3)obj;
      if(verf.data.length == NFS3_WRITEVERFSIZE){
        eq = true;
        for(int i = 0; (i < NFS3_WRITEVERFSIZE) && eq; i++){
          eq = (this.data[i] == verf.data[i]);
        }
      }else{
        eq = false;
      }
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Compute and return a hashcode for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 2 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 4);
    code = Arrays.hashCode(this.data);
    return(code);
  }

 /** 
 *  Used for testing 
 **/ 
  public static void
  main(String[] argv){
    Env.verifyAssertEnabled();
    System.err.println("NFS_writeverf3 self test...");
    NFS_writeverf3.testSimple();
    System.err.println("...NFS_writeverf3 self test succeeds");
    System.exit(0);
  }

 /** 
 *  Used for testing 
 **/ 
  private static void
  testSimple(){
    byte[] data1 = null;
    byte[] data2 = null;
    byte[] data3 = null;
    NFS_writeverf3 wv1 = null;    
    NFS_writeverf3 wv2 = null;    
    NFS_writeverf3 wv3 = null;    

    // Test 1
    data1 = new byte[NFS_writeverf3.NFS3_WRITEVERFSIZE];
    for(int i = 0; i < NFS_writeverf3.NFS3_WRITEVERFSIZE; i++){
      data1[i] = (byte)i;
    }
    wv1 = new NFS_writeverf3(data1);
    assert(wv1.equals(wv1));

    // Test 2
    data2 = new byte[NFS_writeverf3.NFS3_WRITEVERFSIZE];
    for(int i = 0; i < NFS_writeverf3.NFS3_WRITEVERFSIZE; i++){
      data2[i] = (byte)i;
    }
    wv2 = new NFS_writeverf3(data2);
    assert(wv2.equals(wv2));
    assert(wv1.equals(wv2));
    assert(wv2.equals(wv1));
    assert(wv1.hashCode() == wv2.hashCode());

    // Test 3
    data3 = new byte[NFS_writeverf3.NFS3_WRITEVERFSIZE];
    for(int i = 0; i < NFS_writeverf3.NFS3_WRITEVERFSIZE; i++){
      data3[i] = (byte)(NFS_writeverf3.NFS3_WRITEVERFSIZE - i);
    }
    data3[5] = 10; // Random change
    wv3 = new NFS_writeverf3(data3);
    assert(wv3.equals(wv3));
    assert(!wv1.equals(wv3));
    assert(!wv3.equals(wv1));
    assert(!wv2.equals(wv3));
    assert(!wv3.equals(wv2));
    assert(wv1.hashCode() != wv3.hashCode());
    assert(wv2.hashCode() != wv3.hashCode());
  }
}