 /** 
 *  Represent the data structures used by the NFS PATHCONF 3 call 
 **/ 

 /** 
 *  Represent the arguments to the NFS PATHCONF 3 call 
 **/ 
class PATHCONF3args{

 /** 
 *  Data members 
 **/ 
  private final NFS_nfs_fh3 fsroot;

 /** 
 *  Constructor 
 **/ 
  public
  PATHCONF3args(NFS_nfs_fh3 newFSRoot){
    this.fsroot = newFSRoot;
  }

 /** 
 *  Return the file system root 
 **/ 
  public NFS_nfs_fh3
  getFSRoot(){
    return(this.fsroot);
  }

 /** 
 *  Return true if "obj" equals "this" 
 **/ 
  public final boolean
  equals(Object obj){
    boolean eq = false;
    PATHCONF3args args = null;

    // 2 Java-declared fields, 1 self-declared field
    assert(this.getClass().getDeclaredFields().length == 3);
    if(obj instanceof PATHCONF3args){
      args = (PATHCONF3args)obj;
      eq = this.fsroot.equals(args.fsroot);
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Compute and return a hashcode for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 1 self-declared field
    assert(this.getClass().getDeclaredFields().length == 3);
    code = this.fsroot.hashCode();

    return(code);
  }
}

 /** 
 *  Represent the results of  NFS PATHCONF 3 call if successful 
 **/ 
class PATHCONF3resok{

 /** 
 *  Data members 
 **/ 
  private final NFS_post_op_attr objAttributes;
  private final int linkmax;
  private final int nameMax;
  private final boolean noTrunc;
  private final boolean chownRestricted;
  private final boolean caseInsensitive;
  private final boolean casePreserving;

 /** 
 *  Constructor 
 **/ 
  public
  PATHCONF3resok(NFS_post_op_attr newObjAttributes,
                 int newLinkmax,
                 int newNameMax,
                 boolean newNoTrunc,
                 boolean newChownRestricted,
                 boolean newCaseInsensitive,
                 boolean newCasePreserving){
    this.objAttributes = newObjAttributes;
    this.linkmax = newLinkmax;
    this.nameMax = newNameMax;
    this.noTrunc = newNoTrunc;
    this.chownRestricted = newChownRestricted;
    this.caseInsensitive = newCaseInsensitive;
    this.casePreserving = newCasePreserving;
  }

 /** 
 *  Return the object attributes 
 **/ 
  public NFS_post_op_attr
  getObjAttributes(){
    return(this.objAttributes);
  }

 /** 
 *  Return the linkmax value 
 **/ 
  public int
  getLinkmax(){
    return(this.linkmax);
  }

 /** 
 *  Return the nameMax value 
 **/ 
  public int
  getNameMax(){
    return(this.nameMax);
  }

 /** 
 *  Return the value of the noTrunc flag 
 **/ 
  public boolean
  getNoTrunc(){
    return(this.noTrunc);
  }

 /** 
 *  Return the value of the chownRestricted flag 
 **/ 
  public boolean
  getChownRestricted(){
    return(this.chownRestricted);
  }

 /** 
 *  Return the value of the caseInsensitive flag 
 **/ 
  public boolean
  getCaseInsensitive(){
    return(this.caseInsensitive);
  }

 /** 
 *  Return the value of the casePreserving flag 
 **/ 
  public boolean
  getCasePreserving(){
    return(this.casePreserving);
  }

 /** 
 *  Return true if "obj" equals "this" 
 **/ 
  public final boolean
  equals(Object obj){
    boolean eq = false;
    PATHCONF3resok resok = null;

    // 2 Java-declared fields, 7 self-declared field
    assert(this.getClass().getDeclaredFields().length == 9);
    if(obj instanceof PATHCONF3resok){
      resok = (PATHCONF3resok)obj;
      eq = (this.objAttributes.equals(resok.objAttributes) &&
            (this.linkmax == resok.linkmax) &&
            (this.nameMax == resok.nameMax) &&
            (this.noTrunc == resok.noTrunc) &&
            (this.chownRestricted == resok.chownRestricted) &&
            (this.caseInsensitive == resok.caseInsensitive) &&
            (this.casePreserving == resok.casePreserving));
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Compute and return a hashcode for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 7 self-declared field
    assert(this.getClass().getDeclaredFields().length == 9);
    code = (this.objAttributes.hashCode() ^
            (new Integer(this.linkmax)).hashCode() ^
            (new Integer(this.nameMax)).hashCode() ^
            (new Boolean(this.noTrunc)).hashCode() ^
            (new Boolean(this.chownRestricted)).hashCode() ^
            (new Boolean(this.caseInsensitive)).hashCode() ^
            (new Boolean(this.casePreserving)).hashCode());

    return(code);
  }
}

 /** 
 *  Represent the results of  NFS PATHCONF 3 call if unsuccessful 
 **/ 
class PATHCONF3resfail{

 /** 
 *  Data members 
 **/ 
  private final NFS_post_op_attr objAttributes;

 /** 
 *  Constructor 
 **/ 
  public
  PATHCONF3resfail(NFS_post_op_attr newObjAttributes){
    this.objAttributes = newObjAttributes;
  }

 /** 
 *  Return the object attributes 
 **/ 
  public NFS_post_op_attr
  getObjAttributes(){
    return(this.objAttributes);
  }

 /** 
 *  Return true if "obj" equals "this" 
 **/ 
  public final boolean
  equals(Object obj){
    boolean eq = false;
    PATHCONF3resfail resfail = null;

    // 2 Java-declared fields, 1 self-declared field
    assert(this.getClass().getDeclaredFields().length == 3);
    if(obj instanceof PATHCONF3resfail){
      resfail = (PATHCONF3resfail)obj;
      eq = this.objAttributes.equals(resfail.objAttributes);
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Compute and return a hashcode for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 1 self-declared field
    assert(this.getClass().getDeclaredFields().length == 3);
    code = this.objAttributes.hashCode();

    return(code);
  }
}

 /** 
 *  Represent the results to the NFS 3 PATHCONF call 
 **/ 
class PATHCONF3res implements Immutable{

 /** 
 *  Data members 
 **/ 
  private final int status;
  private final PATHCONF3resok resok;
  private final PATHCONF3resfail resfail;

 /** 
 *  Constructor 
 **/ 
  public
  PATHCONF3res(int newStatus,
             PATHCONF3resok newResOk,
             PATHCONF3resfail newResFail){
    this.status = newStatus;
    this.resok = newResOk;
    this.resfail = newResFail;
    assert(((this.status == NFS_nfsstat3.NFS3_OK) && (this.resok != null)) ||
           ((this.status != NFS_nfsstat3.NFS3_OK) && (this.resfail != null)));
  }

 /** 
 *  Return the status 
 **/ 
  public int
  getStatus(){
    return(this.status);
  }

 /** 
 *  Return the result data if successful 
 **/ 
  public
  PATHCONF3resok getResOk(){
    assert(this.status == NFS_nfsstat3.NFS3_OK);
    return(this.resok);
  }

 /** 
 *  Return the result data if the call failed 
 **/ 
  public
  PATHCONF3resfail getResFail(){
    assert(this.status != NFS_nfsstat3.NFS3_OK);
    return(this.resfail);
  }

 /** 
 *  Return true if "obj" equals "this" 
 **/ 
  public final boolean
  equals(Object obj){
    boolean eq = false;
    PATHCONF3res res = null;

    // 2 Java-declared fields, 3 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 5);
    if(obj instanceof PATHCONF3res){
      res = (PATHCONF3res)obj;
      if(this.status == res.status){
        if(this.status == NFS_nfsstat3.NFS3_OK){
          eq = this.resok.equals(res.resok);
        }else{
          eq = this.resfail.equals(res.resfail);
        }
      }else{
        eq = false;
      }
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Compute and return a hashcode for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 3 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 5);
    if(this.status == NFS_nfsstat3.NFS3_OK){
      code = (new Integer(this.status)).hashCode() ^ this.resok.hashCode();
    }else{
      code = (new Integer(this.status)).hashCode() ^ this.resfail.hashCode();
    }
    return(code);
  }
}

 /** 
 *  Used for testing 
 **/ 
public class PATHCONF3{

 /** 
 *  Used for testing 
 **/ 
  public static void
  main(String[] argv){
    Env.verifyAssertEnabled();
    System.err.println("PATHCONF3 self test...");
    PATHCONF3.testPATHCONF3args();
    PATHCONF3.testPATHCONF3resok();
    PATHCONF3.testPATHCONF3resfail();
    PATHCONF3.testPATHCONF3res();
    System.err.println("...PATHCONF3 self test succeeds");
    System.exit(0);
  }

 /** 
 *  Test the PATHCONF3args class 
 **/ 
  private static void
  testPATHCONF3args(){
    PATHCONF3args args1 = null;
    PATHCONF3args args2 = null;
    PATHCONF3args args3 = null;
    byte[] b1 = null;
    byte[] b2 = null;

    // Test 1
    b1 = new byte[64];
    b1[0] = 1;
    args1 = new PATHCONF3args(NFS_nfs_fh3.makeHandle(b1));
    assert(args1.getFSRoot().equals(NFS_nfs_fh3.makeHandle(b1)));
    assert(args1.equals(args1));

    // Test 2
    b2 = new byte[64];
    b2[0] = 2;
    args2 = new PATHCONF3args(NFS_nfs_fh3.makeHandle(b2));
    assert(args2.getFSRoot().equals(NFS_nfs_fh3.makeHandle(b2)));
    assert(args2.equals(args2));
    assert(!args2.equals(args1));
    assert(!args1.equals(args2));
    assert(args2.hashCode() != args1.hashCode());

    // Test 3
    args3 = new PATHCONF3args(NFS_nfs_fh3.makeHandle(b1));
    assert(args3.getFSRoot().equals(NFS_nfs_fh3.makeHandle(b1)));
    assert(args3.equals(args3));
    assert(args3.equals(args1));
    assert(args1.equals(args3));
    assert(!args3.equals(args2));
    assert(!args2.equals(args3));
    assert(args3.hashCode() == args1.hashCode());
    assert(args3.hashCode() != args2.hashCode());
  }

 /** 
 *  Test the PATHCONF3resok class 
 **/ 
  private static void
  testPATHCONF3resok(){
    PATHCONF3resok resok1 = null;
    PATHCONF3resok resok2 = null;
    PATHCONF3resok resok3 = null;

    // Test 1
    resok1 = new PATHCONF3resok(new NFS_post_op_attr(false, null),
                                78,
                                80,
                                true,
                                false,
                                true,
                                false);
    assert(resok1.getObjAttributes().equals(new NFS_post_op_attr(false,
                                                                 null)));
    assert(resok1.getLinkmax() == 78);
    assert(resok1.getNameMax() == 80);
    assert(resok1.getNoTrunc());
    assert(!resok1.getChownRestricted());
    assert(resok1.getCaseInsensitive());
    assert(!resok1.getCasePreserving());
    assert(resok1.equals(resok1));

    // Test 2
    resok2 = new PATHCONF3resok(new NFS_post_op_attr(false, null),
                                23,
                                12,
                                false,
                                true,
                                false,
                                true);
    assert(resok2.getObjAttributes().equals(new NFS_post_op_attr(false,
                                                                 null)));
    assert(resok2.getLinkmax() == 23);
    assert(resok2.getNameMax() == 12);
    assert(!resok2.getNoTrunc());
    assert(resok2.getChownRestricted());
    assert(!resok2.getCaseInsensitive());
    assert(resok2.getCasePreserving());
    assert(resok2.equals(resok2));
    assert(!resok2.equals(resok1));
    assert(!resok1.equals(resok2));
    assert(resok2.hashCode() != resok1.hashCode());

    // Test 3
    resok3 = new PATHCONF3resok(new NFS_post_op_attr(false, null),
                                78,
                                80,
                                true,
                                false,
                                true,
                                false);
    assert(resok3.getObjAttributes().equals(new NFS_post_op_attr(false,
                                                                 null)));
    assert(resok3.getLinkmax() == 78);
    assert(resok3.getNameMax() == 80);
    assert(resok3.getNoTrunc());
    assert(!resok3.getChownRestricted());
    assert(resok3.getCaseInsensitive());
    assert(!resok3.getCasePreserving());
    assert(resok3.equals(resok3));
    assert(resok3.equals(resok1));
    assert(resok1.equals(resok3));
    assert(!resok3.equals(resok2));
    assert(!resok2.equals(resok3));
    assert(resok3.hashCode() == resok1.hashCode());
    assert(resok3.hashCode() != resok2.hashCode());
 }

 /** 
 *  Test the PATHCONF3resfail class 
 **/ 
  private static void
  testPATHCONF3resfail(){
    PATHCONF3resfail resfail1 = null;
    PATHCONF3resfail resfail2 = null;
    PATHCONF3resfail resfail3 = null;
    NFS_post_op_attr postAttr1 = null;
    NFS_post_op_attr postAttr2 = null;

    // Test 1
    postAttr1 = new NFS_post_op_attr(true,
                                     new NFS_fattr3(NFS_ftype3.NF3REG,
                                                    36,
                                                    63,
                                                    71,
                                                    85,
                                                    (72L << 32) + 83L,
                                                    (81L << 32) + 66L,
                                                    new NFS_specdata3(55, 49),
                                                    (22L << 32) + 68L,
                                                    (99L << 32) + 163L,
                                                    new NFS_nfstime3(43, 7),
                                                    new NFS_nfstime3(31, 48),
                                                    new NFS_nfstime3(12, 8)));
    postAttr2 = new NFS_post_op_attr(true,
                                     new NFS_fattr3(NFS_ftype3.NF3REG,
                                                    63,
                                                    36,
                                                    17,
                                                    58,
                                                    (27L << 23) + 38L,
                                                    (18L << 23) + 66L,
                                                    new NFS_specdata3(55, 94),
                                                    (22L << 23) + 86L,
                                                    (99L << 23) + 361L,
                                                    new NFS_nfstime3(34, 70),
                                                    new NFS_nfstime3(14, 84),
                                                    new NFS_nfstime3(21, 80)));
    resfail1 = new PATHCONF3resfail(postAttr1);
    assert(resfail1.getObjAttributes().equals(postAttr1));
    assert(resfail1.equals(resfail1));

    // Test 2
    resfail2 = new PATHCONF3resfail(postAttr2);
    assert(resfail2.getObjAttributes().equals(postAttr2));
    assert(resfail2.equals(resfail2));
    assert(!resfail2.equals(resfail1));
    assert(!resfail1.equals(resfail2));
    assert(resfail2.hashCode() != resfail1.hashCode());

    // Test 3
    resfail3 = new PATHCONF3resfail(postAttr1);
    assert(resfail3.getObjAttributes().equals(postAttr1));
    assert(resfail3.equals(resfail3));
    assert(resfail3.equals(resfail1));
    assert(resfail1.equals(resfail3));
    assert(!resfail3.equals(resfail2));
    assert(!resfail2.equals(resfail3));
    assert(resfail3.hashCode() == resfail1.hashCode());
    assert(resfail3.hashCode() != resfail2.hashCode());
  }

 /** 
 *  Test the PATHCONF3res class 
 **/ 
  private static void
  testPATHCONF3res(){
    PATHCONF3res res1 = null;
    PATHCONF3res res2 = null;
    PATHCONF3res res3 = null;
    PATHCONF3resok resok = null;
    PATHCONF3resfail resfail = null;
    NFS_entryplus3 entry = null;

    // Test 1
    resok = new PATHCONF3resok(new NFS_post_op_attr(false, null),
                               78,
                               80,
                               true,
                               false,
                               true,
                               false);
    res1 = new PATHCONF3res(NFS_nfsstat3.NFS3_OK, resok, null);
    assert(res1.getStatus() == NFS_nfsstat3.NFS3_OK);
    assert(res1.getResOk().equals(resok));
    assert(res1.equals(res1));

    // Test 2
    resfail = new PATHCONF3resfail(new NFS_post_op_attr(false, null));
    res2 = new PATHCONF3res(NFS_nfsstat3.NFS3ERR_IO, null, resfail);
    assert(res2.getStatus() == NFS_nfsstat3.NFS3ERR_IO);
    assert(res2.getResFail().equals(resfail));
    assert(res2.equals(res2));
    assert(!res2.equals(res1));
    assert(!res1.equals(res2));
    assert(res2.hashCode() != res1.hashCode());

    // Test 3
    res3 = new PATHCONF3res(NFS_nfsstat3.NFS3_OK, resok, null);
    assert(res3.getStatus() == NFS_nfsstat3.NFS3_OK);
    assert(res3.getResOk().equals(resok));
    assert(res3.equals(res3));
    assert(res3.equals(res1));
    assert(res1.equals(res3));
    assert(!res3.equals(res2));
    assert(!res2.equals(res3));
    assert(res3.hashCode() == res1.hashCode());
    assert(res3.hashCode() != res2.hashCode());
  }
}

 /** 
 *  $Log: PATHCONF3.java,v $ 
 *  Revision 1.1  2006/06/12 20:07:20  nayate 
 *  First version of the Java NFS library 
 *  
 **/ 
