 /** 
 *  Represents a read lock token used by the PRACTI FS local interface 
 **/ 

public class PRACTIFSReadLockToken{

 /** 
 *  Data members 
 **/ 
  private ObjId objId;
  private boolean acquired;

 /** 
 *  Constructor 
 **/ 
  public
  PRACTIFSReadLockToken(ObjId newObjId, boolean newAcquired){
    this.objId = newObjId;
    this.acquired = newAcquired;
  }

 /** 
 *  Return whether the lock is acquired 
 **/ 
  public boolean
  isAcquired(){
    return(this.acquired);
  }

 /** 
 *  Set the status about whether the lock is acquired 
 **/ 
  public void
  setIsAcquired(boolean newAcquired){
    this.acquired = newAcquired;
  }

 /** 
 *  Return the object ID 
 **/ 
  public ObjId
  getObjId(){
    return(this.objId);
  }

 /** 
 *  Return true if this object equals "obj" (Note: unimplemented) 
 **/ 
  public boolean
  equals(Object obj){
    assert false : "Unimplemented";
    return(false);
  }

 /** 
 *  Return a hash code for this object 
 **/ 
  public int
  hashCode(){
    assert false : "Unimplemented";
    return(0);
  }

 /** 
 *  Used for testing 
 **/ 
  public static void
  main(String[] argv){
    Env.verifyAssertEnabled();
    System.out.println("Testing PRACTIFSReadLockToken.java...");
    PRACTIFSReadLockToken.testSimple();
    System.out.println("...Finished");
  }

 /** 
 *  Run simple tests 
 **/ 
  private static void
  testSimple(){
    PRACTIFSReadLockToken token = null;

    // Test 1
    token = new PRACTIFSReadLockToken(new ObjId(""), true);
    assert(token.isAcquired());
    assert(token.getObjId().equals(new ObjId("")));
    token.setIsAcquired(false);
    assert(!token.isAcquired());
  }
}