 /** 
 *  Represents the data structures used by the READ NFS call 
 **/ 
import java.util.Arrays;

 /** 
 *  Represents the arguments to the READ NFS call 
 **/ 
class READ3args{

 /** 
 *  Data members 
 **/ 
  private final NFS_nfs_fh3 file;
  private final long offset;
  private final int count;

 /** 
 *  Constructor 
 **/ 
  public
  READ3args(NFS_nfs_fh3 newFile, long newOffset, int newCount){
    this.file = newFile;
    this.offset = newOffset;
    this.count = newCount;
  }

 /** 
 *  Return the file 
 **/ 
  public NFS_nfs_fh3
  getFile(){
    return(this.file);
  }

 /** 
 *  Return the offset 
 **/ 
  public long
  getOffset(){
    return(this.offset);
  }

 /** 
 *  Return the count 
 **/ 
  public int
  getCount(){
    return(this.count);
  }

 /** 
 *  Return true if "obj" equals "this" 
 **/ 
  public boolean
  equals(Object obj){
    boolean eq = false;
    READ3args args = null;

    // 2 Java-declared fields, 3 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 5);
    if(obj instanceof READ3args){
      args = (READ3args)obj;
      eq = (this.file.equals(args.file) &&
            (this.offset == args.offset) &&
            (this.count == args.count));
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Return a hash code for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 3 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 5);
    code = (this.file.hashCode() ^
            (new Long(this.offset)).hashCode() ^
            (new Integer(this.count)).hashCode());

    return(code);
  }
}

 /** 
 *  Represents the result of the READ NFS call if successful 
 **/ 
class READ3resok{

 /** 
 *  Data members 
 **/ 
  private final NFS_post_op_attr fileAttributes;
  private final int count;
  private final boolean eof;
  private final byte[] data;

 /** 
 *  Constructor 
 **/ 
  public
  READ3resok(NFS_post_op_attr newFileAttributes,
             int newCount,
             boolean newEOF,
             byte[] newData){
    this.fileAttributes = newFileAttributes;
    this.count = newCount;
    this.eof = newEOF;
    this.data = newData;
  }

 /** 
 *  Return the file attributes 
 **/ 
  public NFS_post_op_attr
  getFileAttributes(){
    return(this.fileAttributes);
  }

 /** 
 *  Return the count 
 **/ 
  public int
  getCount(){
    return(this.count);
  }

 /** 
 *  Return the eof flag 
 **/ 
  public boolean
  getEOF(){
    return(this.eof);
  }

 /** 
 *  Return the data 
 **/ 
  public byte[]
  getData(){
    return(this.data);
  }

 /** 
 *  Return true if "obj" equals "this" 
 **/ 
  public boolean
  equals(Object obj){
    boolean eq = false;
    READ3resok resok = null;

    // 2 Java-declared fields, 4 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 6);
    if(obj instanceof READ3resok){
      resok = (READ3resok)obj;
      eq = (this.fileAttributes.equals(resok.fileAttributes) &&
            (this.count == resok.count) &&
            (this.eof == resok.eof) &&
            (this.data.length == resok.data.length));
      if(eq){
        for(int i = 0; (i < this.data.length) && eq; i++){
          eq = (this.data[i] == resok.data[i]);
        }
      }
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Return a hash code for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 4 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 6);
    code = (this.fileAttributes.hashCode() ^
            (new Integer(this.count)).hashCode() ^
            (new Boolean(this.eof)).hashCode() ^
            Arrays.hashCode(this.data));

    return(code);
  }
}

 /** 
 *  Represents the result of the READ NFS call if unsuccessful 
 **/ 
class READ3resfail{

 /** 
 *  Data members 
 **/ 
  private final NFS_post_op_attr fileAttributes;

 /** 
 *  Constructor 
 **/ 
  public
  READ3resfail(NFS_post_op_attr newFileAttributes){
    this.fileAttributes = newFileAttributes;
  }

 /** 
 *  Return the attributes 
 **/ 
  public NFS_post_op_attr
  getFileAttributes(){
    return(this.fileAttributes);
  }

 /** 
 *  Return true if "obj" equals "this" 
 **/ 
  public boolean
  equals(Object obj){
    boolean eq = false;
    READ3resfail resfail = null;

    // 2 Java-declared fields, 1 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 3);
    if(obj instanceof READ3resfail){
      resfail = (READ3resfail)obj;
      eq = this.fileAttributes.equals(resfail.fileAttributes);
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Return a hash code for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 1 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 3);
    code = this.fileAttributes.hashCode();
    return(code);
  }
}

 /** 
 *  Represents the result of the READ NFS call 
 **/ 
class READ3res{

 /** 
 *  Data members 
 **/ 
  private final int status;
  private final READ3resok resok;
  private final READ3resfail resfail;

 /** 
 *  Constructor 
 **/ 
  public
  READ3res(int newStatus, READ3resok newResOk, READ3resfail newResFail){
    this.status = newStatus;
    this.resok = newResOk;
    this.resfail = newResFail;
  }

 /** 
 *  Return the status 
 **/ 
  public int
  getStatus(){
    return(this.status);
  }

 /** 
 *  Return the result if the call was successful 
 **/ 
  public READ3resok
  getResOk(){
    assert(this.status == NFS_nfsstat3.NFS3_OK);
    return(this.resok);
  }

 /** 
 *  Return the result if the call was unsuccessful 
 **/ 
  public READ3resfail
  getResFail(){
    assert(this.status != NFS_nfsstat3.NFS3_OK);
    return(this.resfail);
  }

 /** 
 *  Return true if "obj" equals "this" 
 **/ 
  public boolean
  equals(Object obj){
    boolean eq = false;
    READ3res res = null;

    // 2 Java-declared fields, 3 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 5);
    if(obj instanceof READ3res){
      res = (READ3res)obj;
      if(this.status == res.status){
        if(this.status == NFS_nfsstat3.NFS3_OK){
          eq = this.resok.equals(res.resok);
        }else{
          eq = this.resfail.equals(res.resfail);
        }
      }else{
        eq = false;
      }
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Return a hash code for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 3 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 5);
    if(this.status == NFS_nfsstat3.NFS3_OK){
      code = (new Integer(this.status)).hashCode() ^ this.resok.hashCode();
    }else{
      code = (new Integer(this.status)).hashCode() ^ this.resfail.hashCode();
    }
    return(code);
  }
}

 /** 
 *  Used for testing 
 **/ 
public class READ3{

 /** 
 *  Used for testing 
 **/ 
  public static void
  main(String[] argv){
    Env.verifyAssertEnabled();
    System.err.println("READ3 self test...");
    READ3.testREAD3args();
    READ3.testREAD3resok();
    READ3.testREAD3resfail();
    READ3.testREAD3res();
    System.err.println("...READ3 self test succeeds");
    System.exit(0);
  }

 /** 
 *  Test the READ3args method 
 **/ 
  private static void
  testREAD3args(){
    READ3args args1 = null;
    READ3args args2 = null;
    READ3args args3 = null;

    // Test 1
    args1 = new READ3args(NFS_nfs_fh3.makeAllZeroHandle(), 15, 73);
    assert(args1.getFile().equals(NFS_nfs_fh3.makeAllZeroHandle()));
    assert(args1.getOffset() == 15);
    assert(args1.getCount() == 73);
    assert(args1.equals(args1));

    // Test 2
    args2 = new READ3args(NFS_nfs_fh3.makeAllZeroHandle(), 68, 77);
    assert(args2.getFile().equals(NFS_nfs_fh3.makeAllZeroHandle()));
    assert(args2.getOffset() == 68);
    assert(args2.getCount() == 77);
    assert(args2.equals(args2));
    assert(!args2.equals(args1));
    assert(!args1.equals(args2));
    assert(args2.hashCode() != args1.hashCode());

    // Test 3
    args3 = new READ3args(NFS_nfs_fh3.makeAllZeroHandle(), 15, 73);
    assert(args3.getFile().equals(NFS_nfs_fh3.makeAllZeroHandle()));
    assert(args3.getOffset() == 15);
    assert(args3.getCount() == 73);
    assert(args3.equals(args3));
    assert(args3.equals(args1));
    assert(args1.equals(args3));
    assert(!args3.equals(args2));
    assert(!args2.equals(args3));
    assert(args3.hashCode() == args1.hashCode());
    assert(args3.hashCode() != args2.hashCode());
  }

 /** 
 *  Test the READ3resok method 
 **/ 
  private static void
  testREAD3resok(){
    READ3resok resok1 = null;
    READ3resok resok2 = null;
    READ3resok resok3 = null;
    byte[] data = null;

    // Test 1
    resok1 = new READ3resok(new NFS_post_op_attr(false, null),
                            82,
                            false,
                            new byte[82]);
    assert(resok1.getFileAttributes().equals(new
                                             NFS_post_op_attr(false, null)));
    assert(resok1.getCount() == 82);
    assert(!resok1.getEOF());
    assert(resok1.getData().length == 82);
    data = resok1.getData();
    for(int i = 0; i < data.length; i++){
      assert(data[i] == 0);
    }
    assert(resok1.equals(resok1));

    // Test 2
    resok2 = new READ3resok(new NFS_post_op_attr(false, null),
                            81,
                            true,
                            new byte[81]);
    assert(resok2.getFileAttributes().equals(new
                                             NFS_post_op_attr(false, null)));
    assert(resok2.getCount() == 81);
    assert(resok2.getEOF());
    assert(resok2.getData().length == 81);
    data = resok2.getData();
    for(int i = 0; i < data.length; i++){
      assert(data[i] == 0);
    }
    assert(resok2.equals(resok2));
    assert(!resok2.equals(resok1));
    assert(!resok1.equals(resok2));
    assert(resok2.hashCode() != resok1.hashCode());

    // Test 3
    resok3 = new READ3resok(new NFS_post_op_attr(false, null),
                            82,
                            false,
                            new byte[82]);
    assert(resok3.getFileAttributes().equals(new
                                             NFS_post_op_attr(false, null)));
    assert(resok3.getCount() == 82);
    assert(!resok3.getEOF());
    assert(resok3.getData().length == 82);
    data = resok3.getData();
    for(int i = 0; i < data.length; i++){
      assert(data[i] == 0);
    }
    assert(resok3.equals(resok3));
    assert(resok3.equals(resok1));
    assert(resok1.equals(resok3));
    assert(!resok3.equals(resok2));
    assert(!resok2.equals(resok3));
    assert(resok3.hashCode() == resok1.hashCode());
    assert(resok3.hashCode() != resok2.hashCode());
  }

 /** 
 *  Test the READ3resfail method 
 **/ 
  private static void
  testREAD3resfail(){
    READ3resfail resfail1 = null;
    READ3resfail resfail2 = null;
    READ3resfail resfail3 = null;
    NFS_fattr3 fattr = null;

    // Test 1
    resfail1 = new READ3resfail(new NFS_post_op_attr(false, null));
    assert(resfail1.getFileAttributes().equals(new NFS_post_op_attr(false,
                                                                    null)));
    assert(resfail1.equals(resfail1));

    // Test 2
    fattr = new NFS_fattr3(NFS_ftype3.NF3REG,
                           36,
                           63,
                           71,
                           85,
                           (72L << 32) + 83L,
                           (81L << 32) + 66L,
                           new NFS_specdata3(55, 49),
                           (22L << 32) + 68L,
                           (99L << 32) + 163L,
                           new NFS_nfstime3(43, 7),
                           new NFS_nfstime3(31, 48),
                           new NFS_nfstime3(12, 8));
    resfail2 = new READ3resfail(new NFS_post_op_attr(true, fattr));
    assert(resfail2.getFileAttributes().equals(new NFS_post_op_attr(true,
                                                                    fattr)));
    assert(resfail2.equals(resfail2));
    assert(!resfail2.equals(resfail1));
    assert(resfail2.hashCode() != resfail1.hashCode());

    // Test 3
    resfail3 = new READ3resfail(new NFS_post_op_attr(false, null));
    assert(resfail3.getFileAttributes().equals(new NFS_post_op_attr(false,
                                                                    null)));
    assert(resfail3.equals(resfail3));
    assert(resfail3.equals(resfail1));
    assert(resfail1.equals(resfail3));
    assert(!resfail3.equals(resfail2));
    assert(!resfail2.equals(resfail3));
    assert(resfail3.hashCode() == resfail1.hashCode());
    assert(resfail3.hashCode() != resfail2.hashCode());
  }

 /** 
 *  Test the READ3res method 
 **/ 
  private static void
  testREAD3res(){
    READ3res res1 = null;
    READ3res res2 = null;
    READ3res res3 = null;

    // Test 1
    res1 = new READ3res(NFS_nfsstat3.NFS3_OK,
                        new READ3resok(new NFS_post_op_attr(false, null),
                                       75,
                                       false,
                                       new byte[75]),
                        null);
    assert(res1.getStatus() == NFS_nfsstat3.NFS3_OK);
    assert(res1.getResOk().equals(new READ3resok(new NFS_post_op_attr(false,
                                                                      null),
                                                 75,
                                                 false,
                                                 new byte[75])));
    assert(res1.equals(res1));

    // Test 2
    res2 = new READ3res(NFS_nfsstat3.NFS3ERR_IO,
                        null,
                        new READ3resfail(new NFS_post_op_attr(false, null)));
    assert(res2.getStatus() == NFS_nfsstat3.NFS3ERR_IO);
    assert(res2.getResFail().equals(new READ3resfail(new
                                                     NFS_post_op_attr(false,
                                                                      null))));
    assert(res2.equals(res2));
    assert(!res2.equals(res1));
    assert(!res1.equals(res2));
    assert(res2.hashCode() != res1.hashCode());

    // Test 3
    res3 = new READ3res(NFS_nfsstat3.NFS3_OK,
                        new READ3resok(new NFS_post_op_attr(false, null),
                                       75,
                                       false,
                                       new byte[75]),
                        null);
    assert(res3.getStatus() == NFS_nfsstat3.NFS3_OK);
    assert(res3.getResOk().equals(new READ3resok(new NFS_post_op_attr(false,
                                                                      null),
                                                 75,
                                                 false,
                                                 new byte[75])));
    assert(res3.equals(res3));
    assert(res3.equals(res1));
    assert(res1.equals(res3));
    assert(!res3.equals(res2));
    assert(!res2.equals(res3));
    assert(res3.hashCode() == res1.hashCode());
    assert(res3.hashCode() != res2.hashCode());
  }
}