 /** 
 *  Data structures used by the NFS READLINK call 
 **/ 

 /** 
 *  Represent the argeuments used by the READLINK method 
 **/ 
class READLINK3args{

 /** 
 *  Data members 
 **/ 
  private final NFS_nfs_fh3 symlink;

 /** 
 *  Constructor 
 **/ 
  public
  READLINK3args(NFS_nfs_fh3 newSymLink){
    this.symlink = newSymLink;
  }

 /** 
 *  Return the handle 
 **/ 
  public NFS_nfs_fh3
  getSymLink(){
    return(this.symlink);
  }

 /** 
 *  Return true if "obj" equals "this" 
 **/ 
  public final boolean
  equals(Object obj){
    boolean eq = false;
    READLINK3args args = null;

    // 2 Java-declared fields, 1 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 3);
    if(obj instanceof READLINK3args){
      args = (READLINK3args)obj;
      eq = this.symlink.equals(args.symlink);
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Compute and return a hashcode for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 1 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 3);
    code = this.symlink.hashCode();
    return(code);
  }
}

 /** 
 *  Store the results of the READLINK NFS call when successful 
 **/ 
class READLINK3resok{

 /** 
 *  Data members 
 **/ 
  private final NFS_post_op_attr symlinkAttributes;
  private final String data;

 /** 
 *  Constructor 
 **/ 
  public
  READLINK3resok(NFS_post_op_attr newSymlinkAttributes, String newData){
    this.symlinkAttributes = newSymlinkAttributes;
    this.data = newData;
  }

 /** 
 *  Return the attributes 
 **/ 
  public NFS_post_op_attr
  getSymlinkAttributes(){
    return(this.symlinkAttributes);
  }

 /** 
 *  Return the data 
 **/ 
  public String
  getData(){
    return(this.data);
  }

 /** 
 *  Return true if "obj" equals "this" 
 **/ 
  public final boolean
  equals(Object obj){
    boolean eq = false;
    READLINK3resok resok = null;

    // 2 Java-declared fields, 2 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 4);
    if(obj instanceof READLINK3resok){
      resok = (READLINK3resok)obj;
      eq = (this.symlinkAttributes.equals(resok.symlinkAttributes) &&
            this.data.equals(resok.data));
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Compute and return a hashcode for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 2 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 4);
    code = this.symlinkAttributes.hashCode() ^ this.data.hashCode();
    return(code);
  }
}

 /** 
 *  Store the results of the READLINK NFS call when unsuccessful 
 **/ 
class READLINK3resfail{

 /** 
 *  Data members 
 **/ 
  private final NFS_post_op_attr symlinkAttributes;

 /** 
 *  Constructor 
 **/ 
  public
  READLINK3resfail(NFS_post_op_attr newSymlinkAttributes){
    this.symlinkAttributes = newSymlinkAttributes;
  }

 /** 
 *  Return the attributes 
 **/ 
  public NFS_post_op_attr
  getSymlinkAttributes(){
    return(this.symlinkAttributes);
  }

 /** 
 *  Return true if "obj" equals "this" 
 **/ 
  public final boolean
  equals(Object obj){
    boolean eq = false;
    READLINK3resfail resfail = null;

    // 2 Java-declared fields, 1 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 3);
    if(obj instanceof READLINK3resfail){
      resfail = (READLINK3resfail)obj;
      eq = this.symlinkAttributes.equals(resfail.symlinkAttributes);
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Compute and return a hashcode for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 1 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 3);
    code = this.symlinkAttributes.hashCode();
    return(code);
  }
}

 /** 
 *  Store the results of the READLINK NFS call 
 **/ 
class READLINK3res{

 /** 
 *  Data members 
 **/ 
  private int status;
  private READLINK3resok resok;
  private READLINK3resfail resfail;

 /** 
 *  Constructor 
 **/ 
  public
  READLINK3res(int newStatus,
               READLINK3resok newResOk,
               READLINK3resfail newResFail){
    this.status = newStatus;
    this.resok = newResOk;
    this.resfail = newResFail;
  }

 /** 
 *  Return the status 
 **/ 
  public int
  getStatus(){
    return(this.status);
  }

 /** 
 *  Return the result if the call was successful 
 **/ 
  public READLINK3resok
  getResOk(){
    assert(this.status == NFS_nfsstat3.NFS3_OK);
    return(this.resok);
  }

 /** 
 *  Return the result if the call was unsuccessful 
 **/ 
  public READLINK3resfail
  getResFail(){
    assert(this.status != NFS_nfsstat3.NFS3_OK);
    return(this.resfail);
  }

 /** 
 *  Return true if "obj" equals "this" 
 **/ 
  public final boolean
  equals(Object obj){
    boolean eq = false;
    READLINK3res res = null;

    // 2 Java-declared fields, 3 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 5);
    if(obj instanceof READLINK3res){
      res = (READLINK3res)obj;
      if(this.status == res.status){
        if(this.status == NFS_nfsstat3.NFS3_OK){
          eq = this.resok.equals(res.resok);
        }else{
          eq = this.resfail.equals(res.resfail);
        }
      }else{
        eq = false;
      }
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Compute and return a hashcode for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 3 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 5);
    if(this.status == NFS_nfsstat3.NFS3_OK){
      code = (new Integer(this.status)).hashCode() ^ this.resok.hashCode();
    }else{
      code = (new Integer(this.status)).hashCode() ^ this.resfail.hashCode();
    }
    return(code);
  }
}

 /** 
 *  Used for testing 
 **/ 
public class READLINK3{

 /** 
 *  Used for testing 
 **/ 
  public static void
  main(String[] argv){
    Env.verifyAssertEnabled();
    System.err.println("READLINK3 self test...");
    READLINK3.testREADLINK3args();
    READLINK3.testREADLINK3resok();
    READLINK3.testREADLINK3resfail();
    READLINK3.testREADLINK3res();
    System.err.println("...READLINK3 self test succeeds");
    System.exit(0);
  }

 /** 
 *  Test the READLINK3args class 
 **/ 
  private static void
  testREADLINK3args(){
    READLINK3args args1 = null;
    READLINK3args args2 = null;
    READLINK3args args3 = null;
    byte[] fhData = null;

    // Test 1
    fhData = new byte[64];
    fhData[0] = 1;
    args1 = new READLINK3args(NFS_nfs_fh3.makeHandle(fhData));
    assert(args1.getSymLink().equals(NFS_nfs_fh3.makeHandle(fhData)));
    assert(args1.equals(args1));

    // Test 2
    args2 = new READLINK3args(NFS_nfs_fh3.makeAllZeroHandle());
    assert(args2.getSymLink().equals(NFS_nfs_fh3.makeAllZeroHandle()));
    assert(args2.equals(args2));
    assert(!args2.equals(args1));
    assert(!args1.equals(args2));
    assert(args2.hashCode() != args1.hashCode());

    // Test 3
    args3 = new READLINK3args(NFS_nfs_fh3.makeHandle(fhData));
    assert(args3.getSymLink().equals(NFS_nfs_fh3.makeHandle(fhData)));
    assert(args3.equals(args3));
    assert(args3.equals(args1));
    assert(args1.equals(args3));
    assert(!args3.equals(args2));
    assert(!args2.equals(args3));
    assert(args3.hashCode() == args1.hashCode());
    assert(args3.hashCode() != args2.hashCode());
  }

 /** 
 *  Test the READLINK3resok class 
 **/ 
  private static void
  testREADLINK3resok(){
    READLINK3resok resok1 = null;
    READLINK3resok resok2 = null;
    READLINK3resok resok3 = null;

    // Test 1
    resok1 = new READLINK3resok(new NFS_post_op_attr(false, null), "a");
    assert(resok1.getSymlinkAttributes().equals(new NFS_post_op_attr(false,
                                                                     null)));
    assert(resok1.getData().equals("a"));
    assert(resok1.equals(resok1));

    // Test 2
    resok2 = new READLINK3resok(new NFS_post_op_attr(false, null), "b");
    assert(resok2.getSymlinkAttributes().equals(new NFS_post_op_attr(false,
                                                                     null)));
    assert(resok2.getData().equals("b"));
    assert(resok2.equals(resok2));
    assert(!resok2.equals(resok1));
    assert(!resok1.equals(resok2));
    assert(resok2.hashCode() != resok1.hashCode());

    // Test 3
    resok3 = new READLINK3resok(new NFS_post_op_attr(false, null), "a");
    assert(resok3.getSymlinkAttributes().equals(new NFS_post_op_attr(false,
                                                                     null)));
    assert(resok3.getData().equals("a"));
    assert(resok3.equals(resok3));
    assert(resok3.equals(resok1));
    assert(resok1.equals(resok3));
    assert(!resok3.equals(resok2));
    assert(!resok2.equals(resok3));
    assert(resok3.hashCode() == resok1.hashCode());
    assert(resok3.hashCode() != resok2.hashCode());
  }

 /** 
 *  Test the READLINK3resfail class 
 **/ 
  private static void
  testREADLINK3resfail(){
    READLINK3resfail resfail1 = null;
    READLINK3resfail resfail2 = null;
    READLINK3resfail resfail3 = null;
    NFS_fattr3 attr = null;

    // Test 1
    resfail1 = new READLINK3resfail(new NFS_post_op_attr(false, null));
    assert(resfail1.getSymlinkAttributes().equals(new NFS_post_op_attr(false,
                                                                       null)));
    assert(resfail1.equals(resfail1));

    // Test 2
    attr = new NFS_fattr3(NFS_ftype3.NF3REG,
                          36,
                          63,
                          71,
                          85,
                          (72L << 32) + 83L,
                          (81L << 32) + 66L,
                          new NFS_specdata3(55, 49),
                          (22L << 32) + 68L,
                          (99L << 32) + 163L,
                          new NFS_nfstime3(43, 7),
                          new NFS_nfstime3(31, 48),
                          new NFS_nfstime3(12, 8));
    resfail2 = new READLINK3resfail(new NFS_post_op_attr(true, attr));
    assert(resfail2.getSymlinkAttributes().equals(new NFS_post_op_attr(true,
                                                                       attr)));
    assert(resfail2.equals(resfail2));
    assert(!resfail2.equals(resfail1));
    assert(!resfail1.equals(resfail2));
    assert(resfail2.hashCode() != resfail1.hashCode());

    // Test 3
    resfail3 = new READLINK3resfail(new NFS_post_op_attr(false, null));
    assert(resfail3.getSymlinkAttributes().equals(new NFS_post_op_attr(false,
                                                                       null)));
    assert(resfail3.equals(resfail3));
    assert(resfail3.equals(resfail1));
    assert(resfail1.equals(resfail3));
    assert(!resfail3.equals(resfail2));
    assert(!resfail2.equals(resfail3));
    assert(resfail3.hashCode() == resfail1.hashCode());
    assert(resfail3.hashCode() != resfail2.hashCode());
  }

 /** 
 *  Test the READLINK3res class 
 **/ 
  private static void
  testREADLINK3res(){
    READLINK3res res1 = null;
    READLINK3res res2 = null;
    READLINK3res res3 = null;
    NFS_post_op_attr postAttr1 = null;

    // Test 1
    postAttr1 = new NFS_post_op_attr(false, null);
    res1 = new READLINK3res(NFS_nfsstat3.NFS3_OK,
                            new READLINK3resok(postAttr1, "a"),
                            null);
    assert(res1.getStatus() == NFS_nfsstat3.NFS3_OK);
    assert(res1.getResOk().equals(new READLINK3resok(postAttr1, "a")));
    assert(res1.equals(res1));

    // Test 2
    res2 = new READLINK3res(NFS_nfsstat3.NFS3ERR_IO,
                            null,
                            new READLINK3resfail(postAttr1));
    assert(res2.getStatus() == NFS_nfsstat3.NFS3ERR_IO);
    assert(res2.getResFail().equals(new READLINK3resfail(postAttr1)));
    assert(res2.equals(res2));
    assert(!res2.equals(res1));
    assert(!res1.equals(res2));
    assert(res2.hashCode() != res1.hashCode());

    // Test 3
    res3 = new READLINK3res(NFS_nfsstat3.NFS3_OK,
                            new READLINK3resok(postAttr1, "a"),
                            null);
    assert(res3.getStatus() == NFS_nfsstat3.NFS3_OK);
    assert(res3.getResOk().equals(new READLINK3resok(postAttr1, "a")));
    assert(res3.equals(res3));
    assert(res3.equals(res1));
    assert(res1.equals(res3));
    assert(!res3.equals(res2));
    assert(!res2.equals(res3));
    assert(res3.hashCode() == res1.hashCode());
    assert(res3.hashCode() != res2.hashCode());
  }
}