 /** 
 *  Represent the data structures used by the the REMOVE NFS 3 method 
 **/ 

 /** 
 *  Represent the arguments to the REMOVE NFS 3 call 
 **/ 
class REMOVE3args implements Immutable{

 /** 
 *  Data members 
 **/ 
  private final NFS_diropargs3 object;

 /** 
 *  Constructor 
 **/ 
  public
  REMOVE3args(NFS_diropargs3 newObject){
    this.object = newObject;
  }

 /** 
 *  Return the stored file handle 
 **/ 
  public NFS_diropargs3
  getObject(){
    return(this.object);
  }

 /** 
 *  Return true if "obj" equals "this" (note: currently unimplemented) 
 **/ 
  public final boolean
  equals(Object obj){
    boolean eq = false;
    REMOVE3args args = null;

    // 2 Java-declared fields, 1 self-declared field
    assert(this.getClass().getDeclaredFields().length == 3);
    if(obj instanceof REMOVE3args){
      args = (REMOVE3args)obj;
      eq = this.object.equals(args.object);
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Compute and return a hashcode for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 1 self-declared field
    assert(this.getClass().getDeclaredFields().length == 3);
    code = this.object.hashCode();

    return(code);
  }
}

 /** 
 *  Represent the results to the NFS 3 REMOVE call when successful 
 **/ 
class REMOVE3resok implements Immutable{

 /** 
 *  Data members 
 **/ 
  private final NFS_wcc_data objWCC;

 /** 
 *  Constructor 
 **/ 
  public
  REMOVE3resok(NFS_wcc_data newObjWCC){
    this.objWCC = newObjWCC;
  }

 /** 
 *  Return the stored object attributes 
 **/ 
  public NFS_wcc_data
  getObjWCC(){
    return(this.objWCC);
  }

 /** 
 *  Return true if "obj" equals "this" (note: currently unimplemented) 
 **/ 
  public final boolean
  equals(Object obj){
    boolean eq = false;
    REMOVE3resok resok = null;

    // 2 Java-declared fields, 1 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 3);
    if(obj instanceof REMOVE3resok){
      resok = (REMOVE3resok)obj;
      eq = (this.objWCC.equals(resok.objWCC));
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Compute and return a hashcode for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 1 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 3);
    code = this.objWCC.hashCode();
    return(code);
  }
}

 /** 
 *  Represent the results to the NFS 3 REMOVE call when it fails 
 **/ 
class REMOVE3resfail implements Immutable{

 /** 
 *  Data members 
 **/ 
  private final NFS_wcc_data objWCC;

 /** 
 *  Constructor 
 **/ 
  public
  REMOVE3resfail(NFS_wcc_data newObjWCC){
    this.objWCC = newObjWCC;
  }

 /** 
 *  Return the stored object attributes 
 **/ 
  public NFS_wcc_data
  getObjWCC(){
    return(this.objWCC);
  }

 /** 
 *  Return true if "obj" equals "this" (note: currently unimplemented) 
 **/ 
  public final boolean
  equals(Object obj){
    boolean eq = false;
    REMOVE3resfail resfail = null;

    // 2 Java-declared fields, 1 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 3);
    if(obj instanceof REMOVE3resfail){
      resfail = (REMOVE3resfail)obj;
      eq = (this.objWCC.equals(resfail.objWCC));
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Compute and return a hashcode for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 1 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 3);
    code = this.objWCC.hashCode();
    return(code);
  }
}

 /** 
 *  Represent the results to the NFS 3 REMOVE call 
 **/ 
class REMOVE3res implements Immutable{

 /** 
 *  Data members 
 **/ 
  private final int status;
  private final REMOVE3resok resok;
  private final REMOVE3resfail resfail;

 /** 
 *  Constructor 
 **/ 
  public
  REMOVE3res(int newStatus,
              REMOVE3resok newResOk,
              REMOVE3resfail newResFail){
    this.status = newStatus;
    this.resok = newResOk;
    this.resfail = newResFail;
    assert(((this.status == NFS_nfsstat3.NFS3_OK) && (this.resok != null)) ||
           ((this.status != NFS_nfsstat3.NFS3_OK) && (this.resfail != null)));
  }

 /** 
 *  Return the status 
 **/ 
  public int
  getStatus(){
    return(this.status);
  }

 /** 
 *  Return the result data if successful 
 **/ 
  public
  REMOVE3resok getResOk(){
    assert(this.status == NFS_nfsstat3.NFS3_OK);
    return(this.resok);
  }

 /** 
 *  Return the result data if the call failed 
 **/ 
  public
  REMOVE3resfail getResFail(){
    assert(this.status != NFS_nfsstat3.NFS3_OK);
    return(this.resfail);
  }

 /** 
 *  Return true if "obj" equals "this" 
 **/ 
  public final boolean
  equals(Object obj){
    boolean eq = false;
    REMOVE3res res = null;

    // 2 Java-declared fields, 3 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 5);
    if(obj instanceof REMOVE3res){
      res = (REMOVE3res)obj;
      if(this.status == res.status){
        if(this.status == NFS_nfsstat3.NFS3_OK){
          eq = this.resok.equals(res.resok);
        }else{
          eq = this.resfail.equals(res.resfail);
        }
      }else{
        eq = false;
      }
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Compute and return a hashcode for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 3 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 5);
    if(this.status == NFS_nfsstat3.NFS3_OK){
      code = (new Integer(this.status)).hashCode() ^ this.resok.hashCode();
    }else{
      code = (new Integer(this.status)).hashCode() ^ this.resfail.hashCode();
    }
    return(code);
  }
}

 /** 
 *  Used for testing 
 **/ 
public class REMOVE3{

 /** 
 *  Used for testing 
 **/ 
  public static void
  main(String[] argv){
    Env.verifyAssertEnabled();
    System.err.println("REMOVE3 self test...");
    REMOVE3.testREMOVE3args();
    REMOVE3.testREMOVE3resok();
    REMOVE3.testREMOVE3resfail();
    REMOVE3.testREMOVE3res();
    System.err.println("...REMOVE3 self test succeeds");
    System.exit(0);
  }

 /** 
 *  Test the REMOVE3args 
 **/ 
  private static void
  testREMOVE3args(){
    REMOVE3args args1 = null;
    REMOVE3args args2 = null;
    REMOVE3args args3 = null;

    // Test 1
    args1 = new REMOVE3args(new NFS_diropargs3(NFS_nfs_fh3.makeAllZeroHandle(),
                                               "a"));
    assert(args1.getObject().equals(new
                                    NFS_diropargs3(
                                      NFS_nfs_fh3.makeAllZeroHandle(), "a")));
    assert(args1.equals(args1));

    // Test 2
    args2 = new REMOVE3args(new NFS_diropargs3(NFS_nfs_fh3.makeAllZeroHandle(),
                                               "b"));
    assert(args2.getObject().equals(new
                                    NFS_diropargs3(
                                      NFS_nfs_fh3.makeAllZeroHandle(), "b")));
    assert(args2.equals(args2));
    assert(!args2.equals(args1));
    assert(!args1.equals(args2));
    assert(args2.hashCode() != args1.hashCode());

    // Test 3
    args3 = new REMOVE3args(new NFS_diropargs3(NFS_nfs_fh3.makeAllZeroHandle(),
                                               "a"));
    assert(args3.getObject().equals(new
                                    NFS_diropargs3(
                                      NFS_nfs_fh3.makeAllZeroHandle(), "a")));
    assert(args3.equals(args3));
    assert(args3.equals(args1));
    assert(args1.equals(args3));
    assert(!args3.equals(args2));
    assert(!args2.equals(args3));
    assert(args3.hashCode() == args1.hashCode());
    assert(args3.hashCode() != args2.hashCode());
  }

 /** 
 *  Used for testing 
 **/ 
  private static void
  testREMOVE3resok(){
    REMOVE3resok resok1 = null;
    REMOVE3resok resok2 = null;
    REMOVE3resok resok3 = null;
    NFS_wcc_data data1 = null;
    NFS_wcc_data data2 = null;
    NFS_pre_op_attr pre_attr1 = null;
    NFS_pre_op_attr pre_attr2 = null;
    NFS_post_op_attr post_attr1 = null;

    // Test 1
    pre_attr1 = new NFS_pre_op_attr(true,
                                    new
                                    NFS_wcc_attr(54,
                                                 new NFS_nfstime3(78, 80),
                                                 new NFS_nfstime3(23, 12)));
    post_attr1 = new NFS_post_op_attr(true,
                                      new NFS_fattr3(NFS_ftype3.NF3REG,
                                                     36,
                                                     63,
                                                     71,
                                                     85,
                                                     (72L << 32) + 83L,
                                                     (81L << 32) + 66L,
                                                     new NFS_specdata3(55, 49),
                                                     (22L << 32) + 68L,
                                                     (99L << 32) + 163L,
                                                     new NFS_nfstime3(43, 7),
                                                     new NFS_nfstime3(31, 48),
                                                     new NFS_nfstime3(12, 8)));
    data1 = new NFS_wcc_data(pre_attr1, post_attr1);
    resok1 = new REMOVE3resok(data1);
    assert(resok1.getObjWCC().equals(data1));
    assert(resok1.equals(resok1));

    // Test 2
    pre_attr2 = new NFS_pre_op_attr(true,
                                    new
                                    NFS_wcc_attr(4563,
                                                 new NFS_nfstime3(78, 80),
                                                 new NFS_nfstime3(23, 12)));
    data2 = new NFS_wcc_data(pre_attr2, post_attr1);
    resok2 = new REMOVE3resok(data2);
    assert(resok2.getObjWCC().equals(data2));
    assert(resok2.equals(resok2));
    assert(!resok2.equals(resok1));
    assert(!resok1.equals(resok2));
    assert(resok2.hashCode() != resok1.hashCode());

    // Test 3
    resok3 = new REMOVE3resok(data1);
    assert(resok3.getObjWCC().equals(data1));
    assert(resok3.equals(resok3));
    assert(resok3.equals(resok1));
    assert(resok1.equals(resok3));
    assert(!resok3.equals(resok2));
    assert(!resok2.equals(resok3));
    assert(resok3.hashCode() == resok1.hashCode());
    assert(resok3.hashCode() != resok2.hashCode());
  }

 /** 
 *  Used for testing 
 *  Note: Same tests as for the previous class 
 **/ 
  private static void
  testREMOVE3resfail(){
    REMOVE3resfail resfail1 = null;
    REMOVE3resfail resfail2 = null;
    REMOVE3resfail resfail3 = null;
    NFS_wcc_data data1 = null;
    NFS_wcc_data data2 = null;
    NFS_pre_op_attr pre_attr1 = null;
    NFS_post_op_attr post_attr1 = null;
    NFS_post_op_attr post_attr2 = null;

    // Test 1
    pre_attr1 = new NFS_pre_op_attr(true,
                                    new
                                    NFS_wcc_attr(54,
                                                 new NFS_nfstime3(78, 80),
                                                 new NFS_nfstime3(23, 12)));
    post_attr1 = new NFS_post_op_attr(true,
                                      new NFS_fattr3(NFS_ftype3.NF3REG,
                                                     36,
                                                     63,
                                                     71,
                                                     85,
                                                     (72L << 32) + 83L,
                                                     (81L << 32) + 66L,
                                                     new NFS_specdata3(55, 49),
                                                     (22L << 32) + 68L,
                                                     (99L << 32) + 163L,
                                                     new NFS_nfstime3(43, 7),
                                                     new NFS_nfstime3(31, 48),
                                                     new NFS_nfstime3(12, 8)));
    data1 = new NFS_wcc_data(pre_attr1, post_attr1);
    resfail1 = new REMOVE3resfail(data1);
    assert(resfail1.getObjWCC().equals(data1));
    assert(resfail1.equals(resfail1));

    // Test 2
    post_attr2 = new NFS_post_op_attr(true,
                                      new NFS_fattr3(NFS_ftype3.NF3REG,
                                                     46,
                                                     63,
                                                     71,
                                                     85,
                                                     (72L << 32) + 83L,
                                                     (81L << 32) + 66L,
                                                     new NFS_specdata3(55, 49),
                                                     (22L << 32) + 68L,
                                                     (99L << 32) + 163L,
                                                     new NFS_nfstime3(43, 7),
                                                     new NFS_nfstime3(31, 48),
                                                     new NFS_nfstime3(12, 8)));
    data2 = new NFS_wcc_data(pre_attr1, post_attr2);
    resfail2 = new REMOVE3resfail(data2);
    assert(resfail2.getObjWCC().equals(data2));
    assert(resfail2.equals(resfail2));
    assert(!resfail2.equals(resfail1));
    assert(!resfail1.equals(resfail2));
    assert(resfail2.hashCode() != resfail1.hashCode());

    // Test 3
    resfail3 = new REMOVE3resfail(data1);
    assert(resfail3.getObjWCC().equals(data1));
    assert(resfail3.equals(resfail3));
    assert(resfail3.equals(resfail1));
    assert(resfail1.equals(resfail3));
    assert(!resfail3.equals(resfail2));
    assert(!resfail2.equals(resfail3));
    assert(resfail3.hashCode() == resfail1.hashCode());
    assert(resfail3.hashCode() != resfail2.hashCode());
  }

 /** 
 *  Used for testing 
 **/ 
  private static void
  testREMOVE3res(){
    REMOVE3res res1 = null;
    REMOVE3res res2 = null;
    REMOVE3res res3 = null;
    REMOVE3resok resok = null;
    REMOVE3resfail resfail = null;
    NFS_wcc_data data = null;
    NFS_pre_op_attr pre_attr = null;
    NFS_post_op_attr post_attr = null;

    // Test 1
    pre_attr = new NFS_pre_op_attr(true,
                                   new
                                   NFS_wcc_attr(54,
                                                new NFS_nfstime3(78, 80),
                                                new NFS_nfstime3(23, 12)));
    post_attr = new NFS_post_op_attr(true,
                                     new NFS_fattr3(NFS_ftype3.NF3REG,
                                                    36,
                                                    63,
                                                    71,
                                                    85,
                                                    (72L << 32) + 83L,
                                                    (81L << 32) + 66L,
                                                    new NFS_specdata3(55, 49),
                                                    (22L << 32) + 68L,
                                                    (99L << 32) + 163L,
                                                    new NFS_nfstime3(43, 7),
                                                    new NFS_nfstime3(31, 48),
                                                    new NFS_nfstime3(12, 8)));
    data = new NFS_wcc_data(pre_attr, post_attr);
    resok = new REMOVE3resok(data);
    res1 = new REMOVE3res(NFS_nfsstat3.NFS3_OK, resok, null);
    assert(res1.getStatus() == NFS_nfsstat3.NFS3_OK);
    assert(res1.getResOk().equals(resok));
    assert(res1.equals(res1));

    // Test 2
    resfail = new REMOVE3resfail(data);
    res2 = new REMOVE3res(NFS_nfsstat3.NFS3ERR_IO, null, resfail);
    assert(res2.getStatus() == NFS_nfsstat3.NFS3ERR_IO);
    assert(res2.getResFail().equals(resfail));
    assert(res2.equals(res2));
    assert(!res2.equals(res1));
    assert(!res1.equals(res2));
    assert(res2.hashCode() != res1.hashCode());

    // Test 3
    resok = new REMOVE3resok(data);
    res3 = new REMOVE3res(NFS_nfsstat3.NFS3_OK, resok, null);
    assert(res3.getStatus() == NFS_nfsstat3.NFS3_OK);
    assert(res3.getResOk().equals(resok));
    assert(res3.equals(res3));
    assert(res3.equals(res1));
    assert(res1.equals(res3));
    assert(!res3.equals(res2));
    assert(!res2.equals(res3));
    assert(res3.hashCode() == res1.hashCode());
    assert(res3.hashCode() != res2.hashCode());
  }
}

 /** 
 *  $Log: REMOVE3.java,v $ 
 *  Revision 1.1  2006/06/12 20:07:20  nayate 
 *  First version of the Java NFS library 
 *  
 **/ 
