 /** 
 *  Represent the data structures used by the the RENAME NFS 3 method 
 **/ 

 /** 
 *  Represent the arguments to the RENAME NFS 3 call 
 **/ 
class RENAME3args implements Immutable{

 /** 
 *  Data members 
 **/ 
  private final NFS_diropargs3 from;
  private final NFS_diropargs3 to;

 /** 
 *  Constructor 
 **/ 
  public
  RENAME3args(NFS_diropargs3 newFrom, NFS_diropargs3 newTo){
    this.from = newFrom;
    this.to = newTo;
  }

 /** 
 *  Return the original directory operations information 
 **/ 
  public NFS_diropargs3
  getFrom(){
    return(this.from);
  }

 /** 
 *  Return the target directory operations information 
 **/ 
  public NFS_diropargs3
  getTo(){
    return(this.to);
  }

 /** 
 *  Return true if "obj" equals "this" (note: currently unimplemented) 
 **/ 
  public final boolean
  equals(Object obj){
    boolean eq = false;
    RENAME3args args = null;

    // 2 Java-declared fields, 2 self-declared field
    assert(this.getClass().getDeclaredFields().length == 4);
    if(obj instanceof RENAME3args){
      args = (RENAME3args)obj;
      eq = (this.from.equals(args.from) && this.to.equals(args.to));
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Compute and return a hashcode for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 2 self-declared field
    assert(this.getClass().getDeclaredFields().length == 4);
    code = (this.from.hashCode() ^ this.to.hashCode());

    return(code);
  }
}

 /** 
 *  Represent the results to the NFS 3 RENAME call when successful 
 **/ 
class RENAME3resok implements Immutable{

 /** 
 *  Data members 
 **/ 
  private final NFS_wcc_data fromDirWCC;
  private final NFS_wcc_data toDirWCC;

 /** 
 *  Constructor 
 **/ 
  public
  RENAME3resok(NFS_wcc_data newFromDirWCC, NFS_wcc_data newToDirWCC){
    this.fromDirWCC = newFromDirWCC;
    this.toDirWCC = newToDirWCC;
  }

 /** 
 *  Return the stored object attributes 
 **/ 
  public NFS_wcc_data
  getFromDirWCC(){
    return(this.fromDirWCC);
  }

 /** 
 *  Return the stored object attributes 
 **/ 
  public NFS_wcc_data
  getToDirWCC(){
    return(this.toDirWCC);
  }

 /** 
 *  Return true if "obj" equals "this" (note: currently unimplemented) 
 **/ 
  public final boolean
  equals(Object obj){
    boolean eq = false;
    RENAME3resok resok = null;

    // 2 Java-declared fields, 2 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 4);
    if(obj instanceof RENAME3resok){
      resok = (RENAME3resok)obj;
      eq = (this.fromDirWCC.equals(resok.fromDirWCC) &&
            this.toDirWCC.equals(resok.toDirWCC));
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Compute and return a hashcode for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 2 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 4);
    code = this.fromDirWCC.hashCode() ^ this.toDirWCC.hashCode();
    return(code);
  }
}

 /** 
 *  Represent the results to the NFS 3 RENAME call when it fails 
 **/ 
class RENAME3resfail implements Immutable{

 /** 
 *  Data members 
 **/ 
  private final NFS_wcc_data fromDirWCC;
  private final NFS_wcc_data toDirWCC;

 /** 
 *  Constructor 
 **/ 
  public
  RENAME3resfail(NFS_wcc_data newFromDirWCC, NFS_wcc_data newToDirWCC){
    this.fromDirWCC = newFromDirWCC;
    this.toDirWCC = newToDirWCC;
  }

 /** 
 *  Return the stored object attributes 
 **/ 
  public NFS_wcc_data
  getFromDirWCC(){
    return(this.fromDirWCC);
  }

 /** 
 *  Return the stored object attributes 
 **/ 
  public NFS_wcc_data
  getToDirWCC(){
    return(this.toDirWCC);
  }

 /** 
 *  Return true if "obj" equals "this" (note: currently unimplemented) 
 **/ 
  public final boolean
  equals(Object obj){
    boolean eq = false;
    RENAME3resfail resfail = null;

    // 2 Java-declared fields, 2 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 4);
    if(obj instanceof RENAME3resfail){
      resfail = (RENAME3resfail)obj;
      eq = (this.fromDirWCC.equals(resfail.fromDirWCC) &&
            this.toDirWCC.equals(resfail.toDirWCC));
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Compute and return a hashcode for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 2 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 4);
    code = this.fromDirWCC.hashCode() ^ this.toDirWCC.hashCode();
    return(code);
  }
}

 /** 
 *  Represent the results to the NFS 3 RENAME call 
 **/ 
class RENAME3res implements Immutable{

 /** 
 *  Data members 
 **/ 
  private final int status;
  private final RENAME3resok resok;
  private final RENAME3resfail resfail;

 /** 
 *  Constructor 
 **/ 
  public
  RENAME3res(int newStatus,
            RENAME3resok newResOk,
            RENAME3resfail newResFail){
    this.status = newStatus;
    this.resok = newResOk;
    this.resfail = newResFail;
    assert(((this.status == NFS_nfsstat3.NFS3_OK) && (this.resok != null)) ||
           ((this.status != NFS_nfsstat3.NFS3_OK) && (this.resfail != null)));
  }

 /** 
 *  Return the status 
 **/ 
  public int
  getStatus(){
    return(this.status);
  }

 /** 
 *  Return the result data if successful 
 **/ 
  public
  RENAME3resok getResOk(){
    assert(this.status == NFS_nfsstat3.NFS3_OK);
    return(this.resok);
  }

 /** 
 *  Return the result data if the call failed 
 **/ 
  public
  RENAME3resfail getResFail(){
    assert(this.status != NFS_nfsstat3.NFS3_OK);
    return(this.resfail);
  }

 /** 
 *  Return true if "obj" equals "this" 
 **/ 
  public final boolean
  equals(Object obj){
    boolean eq = false;
    RENAME3res res = null;

    // 2 Java-declared fields, 3 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 5);
    if(obj instanceof RENAME3res){
      res = (RENAME3res)obj;
      if(this.status == res.status){
        if(this.status == NFS_nfsstat3.NFS3_OK){
          eq = this.resok.equals(res.resok);
        }else{
          eq = this.resfail.equals(res.resfail);
        }
      }else{
        eq = false;
      }
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Compute and return a hashcode for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 3 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 5);
    if(this.status == NFS_nfsstat3.NFS3_OK){
      code = (new Integer(this.status)).hashCode() ^ this.resok.hashCode();
    }else{
      code = (new Integer(this.status)).hashCode() ^ this.resfail.hashCode();
    }
    return(code);
  }
}

 /** 
 *  Used for testing 
 **/ 
public class RENAME3{

 /** 
 *  Used for testing 
 **/ 
  public static void
  main(String[] argv){
    Env.verifyAssertEnabled();
    System.err.println("RENAME3 self test...");
    RENAME3.testRENAME3args();
    RENAME3.testRENAME3resok();
    RENAME3.testRENAME3resfail();
    RENAME3.testRENAME3res();
    System.err.println("...RENAME3 self test succeeds");
    System.exit(0);
  }

 /** 
 *  Test the RENAME3args 
 **/ 
  private static void
  testRENAME3args(){
    RENAME3args args1 = null;
    RENAME3args args2 = null;
    RENAME3args args3 = null;
    byte[] b1 = null;
    byte[] b2 = null;

    // Test 1
    b1 = new byte[64];
    b2 = new byte[64];
    b2[0] = (byte)1;
    args1 = new RENAME3args(new NFS_diropargs3(NFS_nfs_fh3.makeHandle(b1),
                                               "a"),
                            new NFS_diropargs3(NFS_nfs_fh3.makeHandle(b2),
                                               "c"));
    assert(args1.getFrom().equals(new NFS_diropargs3(
                                    NFS_nfs_fh3.makeHandle(b1), "a")));
    assert(args1.getTo().equals(new NFS_diropargs3(NFS_nfs_fh3.makeHandle(b2),
                                                   "c")));
    assert(args1.equals(args1));

    // Test 2
    args2 = new RENAME3args(new NFS_diropargs3(NFS_nfs_fh3.makeHandle(b2),
                                               "b"),
                            new NFS_diropargs3(NFS_nfs_fh3.makeHandle(b1),
                                               "a"));
    assert(args2.getFrom().equals(new NFS_diropargs3(
                                    NFS_nfs_fh3.makeHandle(b2), "b")));
    assert(args2.getTo().equals(new NFS_diropargs3(NFS_nfs_fh3.makeHandle(b1),
                                                   "a")));
    assert(args2.equals(args2));
    assert(!args2.equals(args1));
    assert(!args1.equals(args2));
    assert(args2.hashCode() != args1.hashCode());

    // Test 3
    args3 = new RENAME3args(new NFS_diropargs3(NFS_nfs_fh3.makeHandle(b1),
                                               "a"),
                            new NFS_diropargs3(NFS_nfs_fh3.makeHandle(b2),
                                               "c"));
    assert(args3.getFrom().equals(new NFS_diropargs3(
                                    NFS_nfs_fh3.makeHandle(b1), "a")));
    assert(args3.getTo().equals(new NFS_diropargs3(NFS_nfs_fh3.makeHandle(b2),
                                                   "c")));
    assert(args3.equals(args3));
    assert(args3.equals(args1));
    assert(args1.equals(args3));
    assert(!args3.equals(args2));
    assert(!args2.equals(args3));
    assert(args3.hashCode() == args1.hashCode());
    assert(args3.hashCode() != args2.hashCode());
  }

 /** 
 *  Used for testing 
 **/ 
  private static void
  testRENAME3resok(){
    RENAME3resok resok1 = null;
    RENAME3resok resok2 = null;
    RENAME3resok resok3 = null;
    NFS_wcc_data data1 = null;
    NFS_wcc_data data2 = null;
    NFS_wcc_data data3 = null;
    NFS_pre_op_attr pre_attr1 = null;
    NFS_pre_op_attr pre_attr2 = null;
    NFS_pre_op_attr pre_attr3 = null;
    NFS_post_op_attr post_attr1 = null;

    // Test 1
    pre_attr1 = new NFS_pre_op_attr(true,
                                    new
                                    NFS_wcc_attr(54,
                                                 new NFS_nfstime3(78, 80),
                                                 new NFS_nfstime3(23, 12)));
    post_attr1 = new NFS_post_op_attr(true,
                                      new NFS_fattr3(NFS_ftype3.NF3REG,
                                                     36,
                                                     63,
                                                     71,
                                                     85,
                                                     (72L << 32) + 83L,
                                                     (81L << 32) + 66L,
                                                     new NFS_specdata3(55, 49),
                                                     (22L << 32) + 68L,
                                                     (99L << 32) + 163L,
                                                     new NFS_nfstime3(43, 7),
                                                     new NFS_nfstime3(31, 48),
                                                     new NFS_nfstime3(12, 8)));
    data1 = new NFS_wcc_data(pre_attr1, post_attr1);
    pre_attr2 = new NFS_pre_op_attr(true,
                                    new
                                    NFS_wcc_attr(4563,
                                                 new NFS_nfstime3(78, 80),
                                                 new NFS_nfstime3(23, 12)));
    data2 = new NFS_wcc_data(pre_attr2, post_attr1);
    resok1 = new RENAME3resok(data1, data2);
    assert(resok1.getFromDirWCC().equals(data1));
    assert(resok1.getToDirWCC().equals(data2));
    assert(resok1.equals(resok1));

    // Test 2
    pre_attr3 = new NFS_pre_op_attr(true,
                                    new
                                    NFS_wcc_attr(59,
                                                 new NFS_nfstime3(78, 80),
                                                 new NFS_nfstime3(23, 12)));
    data3 = new NFS_wcc_data(pre_attr3, post_attr1);
    resok2 = new RENAME3resok(data3, data1);
    assert(resok2.getFromDirWCC().equals(data3));
    assert(resok2.getToDirWCC().equals(data1));
    assert(resok2.equals(resok2));
    assert(!resok2.equals(resok1));
    assert(!resok1.equals(resok2));
    assert(resok2.hashCode() != resok1.hashCode());

    // Test 3
    resok3 = new RENAME3resok(data1, data2);
    assert(resok3.getFromDirWCC().equals(data1));
    assert(resok3.getToDirWCC().equals(data2));
    assert(resok3.equals(resok3));
    assert(resok3.equals(resok1));
    assert(resok1.equals(resok3));
    assert(!resok3.equals(resok2));
    assert(!resok2.equals(resok3));
    assert(resok3.hashCode() == resok1.hashCode());
    assert(resok3.hashCode() != resok2.hashCode());
  }

 /** 
 *  Used for testing 
 **/ 
  private static void
  testRENAME3resfail(){
    RENAME3resfail resfail1 = null;
    RENAME3resfail resfail2 = null;
    RENAME3resfail resfail3 = null;
    NFS_wcc_data data1 = null;
    NFS_wcc_data data2 = null;
    NFS_wcc_data data3 = null;
    NFS_pre_op_attr pre_attr1 = null;
    NFS_pre_op_attr pre_attr2 = null;
    NFS_pre_op_attr pre_attr3 = null;
    NFS_post_op_attr post_attr1 = null;

    // Test 1
    pre_attr1 = new NFS_pre_op_attr(true,
                                    new
                                    NFS_wcc_attr(54,
                                                 new NFS_nfstime3(78, 80),
                                                 new NFS_nfstime3(23, 12)));
    post_attr1 = new NFS_post_op_attr(true,
                                      new NFS_fattr3(NFS_ftype3.NF3REG,
                                                     36,
                                                     63,
                                                     71,
                                                     85,
                                                     (72L << 32) + 83L,
                                                     (81L << 32) + 66L,
                                                     new NFS_specdata3(55, 49),
                                                     (22L << 32) + 68L,
                                                     (99L << 32) + 163L,
                                                     new NFS_nfstime3(43, 7),
                                                     new NFS_nfstime3(31, 48),
                                                     new NFS_nfstime3(12, 8)));
    data1 = new NFS_wcc_data(pre_attr1, post_attr1);
    pre_attr2 = new NFS_pre_op_attr(true,
                                    new
                                    NFS_wcc_attr(4563,
                                                 new NFS_nfstime3(78, 80),
                                                 new NFS_nfstime3(23, 12)));
    data2 = new NFS_wcc_data(pre_attr2, post_attr1);
    resfail1 = new RENAME3resfail(data1, data2);
    assert(resfail1.getFromDirWCC().equals(data1));
    assert(resfail1.getToDirWCC().equals(data2));
    assert(resfail1.equals(resfail1));

    // Test 2
    pre_attr3 = new NFS_pre_op_attr(true,
                                    new
                                    NFS_wcc_attr(59,
                                                 new NFS_nfstime3(78, 80),
                                                 new NFS_nfstime3(23, 12)));
    data3 = new NFS_wcc_data(pre_attr3, post_attr1);
    resfail2 = new RENAME3resfail(data3, data1);
    assert(resfail2.getFromDirWCC().equals(data3));
    assert(resfail2.getToDirWCC().equals(data1));
    assert(resfail2.equals(resfail2));
    assert(!resfail2.equals(resfail1));
    assert(!resfail1.equals(resfail2));
    assert(resfail2.hashCode() != resfail1.hashCode());

    // Test 3
    resfail3 = new RENAME3resfail(data1, data2);
    assert(resfail3.getFromDirWCC().equals(data1));
    assert(resfail3.getToDirWCC().equals(data2));
    assert(resfail3.equals(resfail3));
    assert(resfail3.equals(resfail1));
    assert(resfail1.equals(resfail3));
    assert(!resfail3.equals(resfail2));
    assert(!resfail2.equals(resfail3));
    assert(resfail3.hashCode() == resfail1.hashCode());
    assert(resfail3.hashCode() != resfail2.hashCode());
  }

 /** 
 *  Used for testing 
 **/ 
  private static void
  testRENAME3res(){
    RENAME3res res1 = null;
    RENAME3res res2 = null;
    RENAME3res res3 = null;
    RENAME3resok resok = null;
    RENAME3resfail resfail = null;
    NFS_wcc_data data = null;
    NFS_pre_op_attr pre_attr = null;
    NFS_post_op_attr post_attr = null;

    // Test 1
    pre_attr = new NFS_pre_op_attr(true,
                                   new
                                   NFS_wcc_attr(54,
                                                new NFS_nfstime3(78, 80),
                                                new NFS_nfstime3(23, 12)));
    post_attr = new NFS_post_op_attr(true,
                                     new NFS_fattr3(NFS_ftype3.NF3REG,
                                                    36,
                                                    63,
                                                    71,
                                                    85,
                                                    (72L << 32) + 83L,
                                                    (81L << 32) + 66L,
                                                    new NFS_specdata3(55, 49),
                                                    (22L << 32) + 68L,
                                                    (99L << 32) + 163L,
                                                    new NFS_nfstime3(43, 7),
                                                    new NFS_nfstime3(31, 48),
                                                    new NFS_nfstime3(12, 8)));
    data = new NFS_wcc_data(pre_attr, post_attr);
    resok = new RENAME3resok(data, data);
    res1 = new RENAME3res(NFS_nfsstat3.NFS3_OK, resok, null);
    assert(res1.getStatus() == NFS_nfsstat3.NFS3_OK);
    assert(res1.getResOk().equals(resok));
    assert(res1.equals(res1));

    // Test 2
    resfail = new RENAME3resfail(data, data);
    res2 = new RENAME3res(NFS_nfsstat3.NFS3ERR_IO, null, resfail);
    assert(res2.getStatus() == NFS_nfsstat3.NFS3ERR_IO);
    assert(res2.getResFail().equals(resfail));
    assert(res2.equals(res2));
    assert(!res2.equals(res1));
    assert(!res1.equals(res2));
    assert(res2.hashCode() != res1.hashCode());

    // Test 3
    resok = new RENAME3resok(data, data);
    res3 = new RENAME3res(NFS_nfsstat3.NFS3_OK, resok, null);
    assert(res3.getStatus() == NFS_nfsstat3.NFS3_OK);
    assert(res3.getResOk().equals(resok));
    assert(res3.equals(res3));
    assert(res3.equals(res1));
    assert(res1.equals(res3));
    assert(!res3.equals(res2));
    assert(!res2.equals(res3));
    assert(res3.hashCode() == res1.hashCode());
    assert(res3.hashCode() != res2.hashCode());
  }
}

 /** 
 *  $Log: RENAME3.java,v $ 
 *  Revision 1.1  2006/06/12 20:07:20  nayate 
 *  First version of the Java NFS library 
 *  
 **/ 
