 /** 
 *  Represent the data structures used by the the RMDIR NFS 3 method 
 **/ 

 /** 
 *  Represent the arguments to the RMDIR NFS 3 call 
 **/ 
class RMDIR3args implements Immutable{

 /** 
 *  Data members 
 **/ 
  private final NFS_diropargs3 object;

 /** 
 *  Constructor 
 **/ 
  public
  RMDIR3args(NFS_diropargs3 newObject){
    this.object = newObject;
  }

 /** 
 *  Return the stored file handle 
 **/ 
  public NFS_diropargs3
  getObject(){
    return(this.object);
  }

 /** 
 *  Return true if "obj" equals "this" (note: currently unimplemented) 
 **/ 
  public final boolean
  equals(Object obj){
    boolean eq = false;
    RMDIR3args args = null;

    // 2 Java-declared fields, 1 self-declared field
    assert(this.getClass().getDeclaredFields().length == 3);
    if(obj instanceof RMDIR3args){
      args = (RMDIR3args)obj;
      eq = this.object.equals(args.object);
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Compute and return a hashcode for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 1 self-declared field
    assert(this.getClass().getDeclaredFields().length == 3);
    code = this.object.hashCode();

    return(code);
  }
}

 /** 
 *  Represent the results to the NFS 3 RMDIR call when successful 
 **/ 
class RMDIR3resok implements Immutable{

 /** 
 *  Data members 
 **/ 
  private final NFS_wcc_data objWCC;

 /** 
 *  Constructor 
 **/ 
  public
  RMDIR3resok(NFS_wcc_data newObjWCC){
    this.objWCC = newObjWCC;
  }

 /** 
 *  Return the stored object attributes 
 **/ 
  public NFS_wcc_data
  getObjWCC(){
    return(this.objWCC);
  }

 /** 
 *  Return true if "obj" equals "this" (note: currently unimplemented) 
 **/ 
  public final boolean
  equals(Object obj){
    boolean eq = false;
    RMDIR3resok resok = null;

    // 2 Java-declared fields, 1 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 3);
    if(obj instanceof RMDIR3resok){
      resok = (RMDIR3resok)obj;
      eq = (this.objWCC.equals(resok.objWCC));
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Compute and return a hashcode for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 1 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 3);
    code = this.objWCC.hashCode();
    return(code);
  }
}

 /** 
 *  Represent the results to the NFS 3 RMDIR call when it fails 
 **/ 
class RMDIR3resfail implements Immutable{

 /** 
 *  Data members 
 **/ 
  private final NFS_wcc_data objWCC;

 /** 
 *  Constructor 
 **/ 
  public
  RMDIR3resfail(NFS_wcc_data newObjWCC){
    this.objWCC = newObjWCC;
  }

 /** 
 *  Return the stored object attributes 
 **/ 
  public NFS_wcc_data
  getObjWCC(){
    return(this.objWCC);
  }

 /** 
 *  Return true if "obj" equals "this" (note: currently unimplemented) 
 **/ 
  public final boolean
  equals(Object obj){
    boolean eq = false;
    RMDIR3resfail resfail = null;

    // 2 Java-declared fields, 1 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 3);
    if(obj instanceof RMDIR3resfail){
      resfail = (RMDIR3resfail)obj;
      eq = (this.objWCC.equals(resfail.objWCC));
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Compute and return a hashcode for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 1 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 3);
    code = this.objWCC.hashCode();
    return(code);
  }
}

 /** 
 *  Represent the results to the NFS 3 RMDIR call 
 **/ 
class RMDIR3res implements Immutable{

 /** 
 *  Data members 
 **/ 
  private final int status;
  private final RMDIR3resok resok;
  private final RMDIR3resfail resfail;

 /** 
 *  Constructor 
 **/ 
  public
  RMDIR3res(int newStatus,
            RMDIR3resok newResOk,
            RMDIR3resfail newResFail){
    this.status = newStatus;
    this.resok = newResOk;
    this.resfail = newResFail;
    assert(((this.status == NFS_nfsstat3.NFS3_OK) && (this.resok != null)) ||
           ((this.status != NFS_nfsstat3.NFS3_OK) && (this.resfail != null)));
  }

 /** 
 *  Return the status 
 **/ 
  public int
  getStatus(){
    return(this.status);
  }

 /** 
 *  Return the result data if successful 
 **/ 
  public
  RMDIR3resok getResOk(){
    assert(this.status == NFS_nfsstat3.NFS3_OK);
    return(this.resok);
  }

 /** 
 *  Return the result data if the call failed 
 **/ 
  public
  RMDIR3resfail getResFail(){
    assert(this.status != NFS_nfsstat3.NFS3_OK);
    return(this.resfail);
  }

 /** 
 *  Return true if "obj" equals "this" 
 **/ 
  public final boolean
  equals(Object obj){
    boolean eq = false;
    RMDIR3res res = null;

    // 2 Java-declared fields, 3 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 5);
    if(obj instanceof RMDIR3res){
      res = (RMDIR3res)obj;
      if(this.status == res.status){
        if(this.status == NFS_nfsstat3.NFS3_OK){
          eq = this.resok.equals(res.resok);
        }else{
          eq = this.resfail.equals(res.resfail);
        }
      }else{
        eq = false;
      }
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Compute and return a hashcode for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 3 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 5);
    if(this.status == NFS_nfsstat3.NFS3_OK){
      code = (new Integer(this.status)).hashCode() ^ this.resok.hashCode();
    }else{
      code = (new Integer(this.status)).hashCode() ^ this.resfail.hashCode();
    }
    return(code);
  }
}

 /** 
 *  Used for testing 
 **/ 
public class RMDIR3{

 /** 
 *  Used for testing 
 **/ 
  public static void
  main(String[] argv){
    Env.verifyAssertEnabled();
    System.err.println("RMDIR3 self test...");
    RMDIR3.testRMDIR3args();
    RMDIR3.testRMDIR3resok();
    RMDIR3.testRMDIR3resfail();
    RMDIR3.testRMDIR3res();
    System.err.println("...RMDIR3 self test succeeds");
    System.exit(0);
  }

 /** 
 *  Test the RMDIR3args 
 **/ 
  private static void
  testRMDIR3args(){
    RMDIR3args args1 = null;
    RMDIR3args args2 = null;
    RMDIR3args args3 = null;

    // Test 1
    args1 = new RMDIR3args(new NFS_diropargs3(NFS_nfs_fh3.makeAllZeroHandle(),
                                              "a"));
    assert(args1.getObject().equals(new
                                    NFS_diropargs3(
                                      NFS_nfs_fh3.makeAllZeroHandle(), "a")));
    assert(args1.equals(args1));

    // Test 2
    args2 = new RMDIR3args(new NFS_diropargs3(NFS_nfs_fh3.makeAllZeroHandle(),
                                              "b"));
    assert(args2.getObject().equals(new
                                    NFS_diropargs3(
                                      NFS_nfs_fh3.makeAllZeroHandle(), "b")));
    assert(args2.equals(args2));
    assert(!args2.equals(args1));
    assert(!args1.equals(args2));
    assert(args2.hashCode() != args1.hashCode());

    // Test 3
    args3 = new RMDIR3args(new NFS_diropargs3(NFS_nfs_fh3.makeAllZeroHandle(),
                                              "a"));
    assert(args3.getObject().equals(new
                                    NFS_diropargs3(
                                      NFS_nfs_fh3.makeAllZeroHandle(), "a")));
    assert(args3.equals(args3));
    assert(args3.equals(args1));
    assert(args1.equals(args3));
    assert(!args3.equals(args2));
    assert(!args2.equals(args3));
    assert(args3.hashCode() == args1.hashCode());
    assert(args3.hashCode() != args2.hashCode());
  }

 /** 
 *  Used for testing 
 **/ 
  private static void
  testRMDIR3resok(){
    RMDIR3resok resok1 = null;
    RMDIR3resok resok2 = null;
    RMDIR3resok resok3 = null;
    NFS_wcc_data data1 = null;
    NFS_wcc_data data2 = null;
    NFS_pre_op_attr pre_attr1 = null;
    NFS_pre_op_attr pre_attr2 = null;
    NFS_post_op_attr post_attr1 = null;

    // Test 1
    pre_attr1 = new NFS_pre_op_attr(true,
                                    new
                                    NFS_wcc_attr(54,
                                                 new NFS_nfstime3(78, 80),
                                                 new NFS_nfstime3(23, 12)));
    post_attr1 = new NFS_post_op_attr(true,
                                      new NFS_fattr3(NFS_ftype3.NF3REG,
                                                     36,
                                                     63,
                                                     71,
                                                     85,
                                                     (72L << 32) + 83L,
                                                     (81L << 32) + 66L,
                                                     new NFS_specdata3(55, 49),
                                                     (22L << 32) + 68L,
                                                     (99L << 32) + 163L,
                                                     new NFS_nfstime3(43, 7),
                                                     new NFS_nfstime3(31, 48),
                                                     new NFS_nfstime3(12, 8)));
    data1 = new NFS_wcc_data(pre_attr1, post_attr1);
    resok1 = new RMDIR3resok(data1);
    assert(resok1.getObjWCC().equals(data1));
    assert(resok1.equals(resok1));

    // Test 2
    pre_attr2 = new NFS_pre_op_attr(true,
                                    new
                                    NFS_wcc_attr(4563,
                                                 new NFS_nfstime3(78, 80),
                                                 new NFS_nfstime3(23, 12)));
    data2 = new NFS_wcc_data(pre_attr2, post_attr1);
    resok2 = new RMDIR3resok(data2);
    assert(resok2.getObjWCC().equals(data2));
    assert(resok2.equals(resok2));
    assert(!resok2.equals(resok1));
    assert(!resok1.equals(resok2));
    assert(resok2.hashCode() != resok1.hashCode());

    // Test 3
    resok3 = new RMDIR3resok(data1);
    assert(resok3.getObjWCC().equals(data1));
    assert(resok3.equals(resok3));
    assert(resok3.equals(resok1));
    assert(resok1.equals(resok3));
    assert(!resok3.equals(resok2));
    assert(!resok2.equals(resok3));
    assert(resok3.hashCode() == resok1.hashCode());
    assert(resok3.hashCode() != resok2.hashCode());
  }

 /** 
 *  Used for testing 
 **/ 
  private static void
  testRMDIR3resfail(){
    RMDIR3resfail resfail1 = null;
    RMDIR3resfail resfail2 = null;
    RMDIR3resfail resfail3 = null;
    NFS_wcc_data data1 = null;
    NFS_wcc_data data2 = null;
    NFS_pre_op_attr pre_attr1 = null;
    NFS_post_op_attr post_attr1 = null;
    NFS_post_op_attr post_attr2 = null;

    // Test 1
    pre_attr1 = new NFS_pre_op_attr(true,
                                    new
                                    NFS_wcc_attr(54,
                                                 new NFS_nfstime3(78, 80),
                                                 new NFS_nfstime3(23, 12)));
    post_attr1 = new NFS_post_op_attr(true,
                                      new NFS_fattr3(NFS_ftype3.NF3REG,
                                                     36,
                                                     63,
                                                     71,
                                                     85,
                                                     (72L << 32) + 83L,
                                                     (81L << 32) + 66L,
                                                     new NFS_specdata3(55, 49),
                                                     (22L << 32) + 68L,
                                                     (99L << 32) + 163L,
                                                     new NFS_nfstime3(43, 7),
                                                     new NFS_nfstime3(31, 48),
                                                     new NFS_nfstime3(12, 8)));
    data1 = new NFS_wcc_data(pre_attr1, post_attr1);
    resfail1 = new RMDIR3resfail(data1);
    assert(resfail1.getObjWCC().equals(data1));
    assert(resfail1.equals(resfail1));

    // Test 2
    post_attr2 = new NFS_post_op_attr(true,
                                      new NFS_fattr3(NFS_ftype3.NF3REG,
                                                     46,
                                                     63,
                                                     71,
                                                     85,
                                                     (72L << 32) + 83L,
                                                     (81L << 32) + 66L,
                                                     new NFS_specdata3(55, 49),
                                                     (22L << 32) + 68L,
                                                     (99L << 32) + 163L,
                                                     new NFS_nfstime3(43, 7),
                                                     new NFS_nfstime3(31, 48),
                                                     new NFS_nfstime3(12, 8)));
    data2 = new NFS_wcc_data(pre_attr1, post_attr2);
    resfail2 = new RMDIR3resfail(data2);
    assert(resfail2.getObjWCC().equals(data2));
    assert(resfail2.equals(resfail2));
    assert(!resfail2.equals(resfail1));
    assert(!resfail1.equals(resfail2));
    assert(resfail2.hashCode() != resfail1.hashCode());

    // Test 3
    resfail3 = new RMDIR3resfail(data1);
    assert(resfail3.getObjWCC().equals(data1));
    assert(resfail3.equals(resfail3));
    assert(resfail3.equals(resfail1));
    assert(resfail1.equals(resfail3));
    assert(!resfail3.equals(resfail2));
    assert(!resfail2.equals(resfail3));
    assert(resfail3.hashCode() == resfail1.hashCode());
    assert(resfail3.hashCode() != resfail2.hashCode());
  }

 /** 
 *  Used for testing 
 **/ 
  private static void
  testRMDIR3res(){
    RMDIR3res res1 = null;
    RMDIR3res res2 = null;
    RMDIR3res res3 = null;
    RMDIR3resok resok = null;
    RMDIR3resfail resfail = null;
    NFS_wcc_data data = null;
    NFS_pre_op_attr pre_attr = null;
    NFS_post_op_attr post_attr = null;

    // Test 1
    pre_attr = new NFS_pre_op_attr(true,
                                   new
                                   NFS_wcc_attr(54,
                                                new NFS_nfstime3(78, 80),
                                                new NFS_nfstime3(23, 12)));
    post_attr = new NFS_post_op_attr(true,
                                     new NFS_fattr3(NFS_ftype3.NF3REG,
                                                    36,
                                                    63,
                                                    71,
                                                    85,
                                                    (72L << 32) + 83L,
                                                    (81L << 32) + 66L,
                                                    new NFS_specdata3(55, 49),
                                                    (22L << 32) + 68L,
                                                    (99L << 32) + 163L,
                                                    new NFS_nfstime3(43, 7),
                                                    new NFS_nfstime3(31, 48),
                                                    new NFS_nfstime3(12, 8)));
    data = new NFS_wcc_data(pre_attr, post_attr);
    resok = new RMDIR3resok(data);
    res1 = new RMDIR3res(NFS_nfsstat3.NFS3_OK, resok, null);
    assert(res1.getStatus() == NFS_nfsstat3.NFS3_OK);
    assert(res1.getResOk().equals(resok));
    assert(res1.equals(res1));

    // Test 2
    resfail = new RMDIR3resfail(data);
    res2 = new RMDIR3res(NFS_nfsstat3.NFS3ERR_IO, null, resfail);
    assert(res2.getStatus() == NFS_nfsstat3.NFS3ERR_IO);
    assert(res2.getResFail().equals(resfail));
    assert(res2.equals(res2));
    assert(!res2.equals(res1));
    assert(!res1.equals(res2));
    assert(res2.hashCode() != res1.hashCode());

    // Test 3
    resok = new RMDIR3resok(data);
    res3 = new RMDIR3res(NFS_nfsstat3.NFS3_OK, resok, null);
    assert(res3.getStatus() == NFS_nfsstat3.NFS3_OK);
    assert(res3.getResOk().equals(resok));
    assert(res3.equals(res3));
    assert(res3.equals(res1));
    assert(res1.equals(res3));
    assert(!res3.equals(res2));
    assert(!res2.equals(res3));
    assert(res3.hashCode() == res1.hashCode());
    assert(res3.hashCode() != res2.hashCode());
  }
}

 /** 
 *  $Log: RMDIR3.java,v $ 
 *  Revision 1.1  2006/06/12 20:07:20  nayate 
 *  First version of the Java NFS library 
 *  
 **/ 
