 /** 
 *  Represent the data structures used by the the SETATTR NFS 3 method 
 **/ 

 /** 
 *  Represent the guard used as an arguement to the SETATTR NFS 3 call 
 **/ 
class NFS_sattrguard3 implements Immutable{

 /** 
 *  Data members 
 **/ 
  private final boolean check;
  private final NFS_nfstime3 objCTime;

 /** 
 *  Constructor 
 **/ 
  public
  NFS_sattrguard3(boolean newCheck, NFS_nfstime3 newObjCTime){
    this.check = newCheck;
    this.objCTime = newObjCTime;
  }

 /** 
 *  Return the value of the check flag 
 **/ 
  public boolean
  getCheck(){
    return(this.check);
  }

 /** 
 *  Return the object time to check against (if the check flag is true) 
 **/ 
  public NFS_nfstime3
  getObjCTime(){
    return(this.objCTime);
  }

 /** 
 *  Return true if "obj" equals "this" 
 **/ 
  public boolean
  equals(Object obj){
    boolean eq = false;
    NFS_sattrguard3 guard = null;

    // 2 Java-declared fields, 2 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 4);
    if(obj instanceof NFS_sattrguard3){
      guard = (NFS_sattrguard3)obj;
      eq = ((this.check == guard.check) &&
            (this.objCTime.equals(guard.objCTime)));
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Return a hash code for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 2 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 4);
    code = (new Boolean(this.check)).hashCode() ^ (this.objCTime.hashCode());

    return(code);
  }
}

 /** 
 *  Represent the arguments to the SETATTR NFS 3 call 
 **/ 
class SETATTR3args implements Immutable{

 /** 
 *  Data members 
 **/ 
  private final NFS_nfs_fh3 object;
  private final NFS_sattr3 newAttributes;
  private final NFS_sattrguard3 guard;

 /** 
 *  Constructor 
 **/ 
  public
  SETATTR3args(NFS_nfs_fh3 newObject,
               NFS_sattr3 newNewAttributes,
               NFS_sattrguard3 newGuard){
    this.object = newObject;
    this.newAttributes = newNewAttributes;
    this.guard = newGuard;
  }

 /** 
 *  Return the stored file handle 
 **/ 
  public NFS_nfs_fh3
  getObject(){
    return(this.object);
  }

 /** 
 *  Return the new attributes 
 **/ 
  public NFS_sattr3
  getNewAttributes(){
    return(this.newAttributes);
  }

 /** 
 *  Return the new attributes 
 **/ 
  public NFS_sattrguard3
  getGuard(){
    return(this.guard);
  }

 /** 
 *  Return true if "obj" equals "this" (note: currently unimplemented) 
 **/ 
  public final boolean
  equals(Object obj){
    boolean eq = false;
    SETATTR3args args = null;

    // 2 Java-declared fields, 3 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 5);
    if(obj instanceof SETATTR3args){
      args = (SETATTR3args)obj;
      eq = ((this.object.equals(args.object)) &&
            (this.newAttributes.equals(args.newAttributes)) &&
            (this.guard.equals(args.guard)));
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Compute and return a hashcode for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 3 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 5);
    code = (this.object.hashCode() ^
            this.newAttributes.hashCode() ^
            this.guard.hashCode());

    return(code);
  }
}

 /** 
 *  Represent the results to the NFS 3 SETATTR call when successful 
 **/ 
class SETATTR3resok implements Immutable{

 /** 
 *  Data members 
 **/ 
  private final NFS_wcc_data objWCC;

 /** 
 *  Constructor 
 **/ 
  public
  SETATTR3resok(NFS_wcc_data newObjWCC){
    this.objWCC = newObjWCC;
  }

 /** 
 *  Return the stored object attributes 
 **/ 
  public NFS_wcc_data
  getObjWCC(){
    return(this.objWCC);
  }

 /** 
 *  Return true if "obj" equals "this" (note: currently unimplemented) 
 **/ 
  public final boolean
  equals(Object obj){
    boolean eq = false;
    SETATTR3resok resok = null;

    // 2 Java-declared fields, 1 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 3);
    if(obj instanceof SETATTR3resok){
      resok = (SETATTR3resok)obj;
      eq = (this.objWCC.equals(resok.objWCC));
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Compute and return a hashcode for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 1 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 3);
    code = this.objWCC.hashCode();
    return(code);
  }
}

 /** 
 *  Represent the results to the NFS 3 SETATTR call when it fails 
 **/ 
class SETATTR3resfail implements Immutable{

 /** 
 *  Data members 
 **/ 
  private final NFS_wcc_data objWCC;

 /** 
 *  Constructor 
 **/ 
  public
  SETATTR3resfail(NFS_wcc_data newObjWCC){
    this.objWCC = newObjWCC;
  }

 /** 
 *  Return the stored object attributes 
 **/ 
  public NFS_wcc_data
  getObjWCC(){
    return(this.objWCC);
  }

 /** 
 *  Return true if "obj" equals "this" (note: currently unimplemented) 
 **/ 
  public final boolean
  equals(Object obj){
    boolean eq = false;
    SETATTR3resfail resfail = null;

    // 2 Java-declared fields, 1 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 3);
    if(obj instanceof SETATTR3resfail){
      resfail = (SETATTR3resfail)obj;
      eq = (this.objWCC.equals(resfail.objWCC));
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Compute and return a hashcode for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 1 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 3);
    code = this.objWCC.hashCode();
    return(code);
  }
}

 /** 
 *  Represent the results to the NFS 3 SETATTR call 
 **/ 
class SETATTR3res implements Immutable{

 /** 
 *  Data members 
 **/ 
  private final int status;
  private final SETATTR3resok resok;
  private final SETATTR3resfail resfail;

 /** 
 *  Constructor 
 **/ 
  public
  SETATTR3res(int newStatus,
              SETATTR3resok newResOk,
              SETATTR3resfail newResFail){
    this.status = newStatus;
    this.resok = newResOk;
    this.resfail = newResFail;
    assert(((this.status == NFS_nfsstat3.NFS3_OK) && (this.resok != null)) ||
           ((this.status != NFS_nfsstat3.NFS3_OK) && (this.resfail != null)));
  }

 /** 
 *  Return the status 
 **/ 
  public int
  getStatus(){
    return(this.status);
  }

 /** 
 *  Return the result data if successful 
 **/ 
  public
  SETATTR3resok getResOk(){
    assert(this.status == NFS_nfsstat3.NFS3_OK);
    return(this.resok);
  }

 /** 
 *  Return the result data if the call failed 
 **/ 
  public
  SETATTR3resfail getResFail(){
    assert(this.status != NFS_nfsstat3.NFS3_OK);
    return(this.resfail);
  }

 /** 
 *  Return true if "obj" equals "this" 
 **/ 
  public final boolean
  equals(Object obj){
    boolean eq = false;
    SETATTR3res res = null;

    // 2 Java-declared fields, 3 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 5);
    if(obj instanceof SETATTR3res){
      res = (SETATTR3res)obj;
      if(this.status == res.status){
        if(this.status == NFS_nfsstat3.NFS3_OK){
          eq = this.resok.equals(res.resok);
        }else{
          eq = this.resfail.equals(res.resfail);
        }
      }else{
        eq = false;
      }
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Compute and return a hashcode for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 3 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 5);
    if(this.status == NFS_nfsstat3.NFS3_OK){
      code = (new Integer(this.status)).hashCode() ^ this.resok.hashCode();
    }else{
      code = (new Integer(this.status)).hashCode() ^ this.resfail.hashCode();
    }
    return(code);
  }
}

 /** 
 *  Used for testing 
 **/ 
public class SETATTR3{

 /** 
 *  Used for testing 
 **/ 
  public static void
  main(String[] argv){
    Env.verifyAssertEnabled();
    System.err.println("SETATTR3 self test...");
    SETATTR3.testNFS_sattrguard3();
    SETATTR3.testSETATTR3args();
    SETATTR3.testSETATTR3resok();
    SETATTR3.testSETATTR3resfail();
    SETATTR3.testSETATTR3res();
    System.err.println("...SETATTR3 self test succeeds");
    System.exit(0);
  }

 /** 
 *  Used for testing 
 **/ 
  private static void
  testNFS_sattrguard3(){
    NFS_sattrguard3 guard1 = null;
    NFS_sattrguard3 guard2 = null;
    NFS_sattrguard3 guard3 = null;

    // Test 1
    guard1 = new NFS_sattrguard3(true, new NFS_nfstime3(1978, 1980));
    assert(guard1.getCheck());
    assert(guard1.getObjCTime().equals(new NFS_nfstime3(1978, 1980)));
    assert(guard1.equals(guard1));

    // Test 2
    guard2 = new NFS_sattrguard3(false, new NFS_nfstime3(23, 12));
    assert(!guard2.getCheck());
    assert(guard2.getObjCTime().equals(new NFS_nfstime3(23, 12)));
    assert(guard2.equals(guard2));
    assert(!guard1.equals(guard2));
    assert(!guard2.equals(guard1));
    assert(guard1.hashCode() != guard2.hashCode());

    // Test 3
    guard3 = new NFS_sattrguard3(true, new NFS_nfstime3(1978, 1980));
    assert(guard3.getCheck());
    assert(guard3.getObjCTime().equals(new NFS_nfstime3(1978, 1980)));
    assert(guard3.equals(guard3));
    assert(guard1.equals(guard3));
    assert(guard3.equals(guard1));
    assert(!guard2.equals(guard3));
    assert(!guard3.equals(guard2));
    assert(guard1.hashCode() == guard3.hashCode());
    assert(guard2.hashCode() != guard3.hashCode());
  }

 /** 
 *  Used for testing 
 **/ 
  private static void
  testSETATTR3args(){
    SETATTR3args args1 = null;
    SETATTR3args args2 = null;
    SETATTR3args args3 = null;
    NFS_sattr3 sattr = null;
    NFS_sattrguard3 guard1 = null;
    NFS_sattrguard3 guard2 = null;
    NFS_sattrguard3 guard3 = null;

    // Test 1
    sattr = new NFS_sattr3(new NFS_set_mode3(true, 53),
                           new NFS_set_uid3(false, 2),
                           new NFS_set_gid3(true, 11),
                           new NFS_set_size3(true, (1L << 32) + 58L),
                           new NFS_set_atime(NFS_time_how.DONT_CHANGE,
                                             new NFS_nfstime3(66, 67)),
                           new NFS_set_mtime(NFS_time_how.SET_TO_CLIENT_TIME,
                                             new NFS_nfstime3(5, 15)));
    guard1 = new NFS_sattrguard3(true, new NFS_nfstime3(10, 20));
    args1 = new SETATTR3args(NFS_nfs_fh3.makeAllZeroHandle(),
                             sattr,
                             guard1);
    assert(args1.getObject().equals(NFS_nfs_fh3.makeAllZeroHandle()));
    assert(args1.getNewAttributes().equals(sattr));
    assert(args1.getGuard().equals(guard1));
    assert(args1.equals(args1));

    // Test 2
    guard2 = new NFS_sattrguard3(true, new NFS_nfstime3(20, 20));
    args2 = new SETATTR3args(NFS_nfs_fh3.makeAllZeroHandle(),
                             sattr,
                             guard2);
    assert(args2.getObject().equals(NFS_nfs_fh3.makeAllZeroHandle()));
    assert(args2.getNewAttributes().equals(sattr));
    assert(args2.getGuard().equals(guard2));
    assert(args2.equals(args2));
    assert(!args1.equals(args2));
    assert(args1.hashCode() != args2.hashCode());

    // Test 3
    guard3 = new NFS_sattrguard3(true, new NFS_nfstime3(20, 20));
    args3 = new SETATTR3args(NFS_nfs_fh3.makeAllZeroHandle(),
                             sattr,
                             guard3);
    assert(args3.getObject().equals(NFS_nfs_fh3.makeAllZeroHandle()));
    assert(args3.getNewAttributes().equals(sattr));
    assert(args3.getGuard().equals(guard3));
    assert(args3.equals(args3));
    assert(!args1.equals(args3));
    assert(args2.equals(args3));
    assert(args1.hashCode() != args3.hashCode());
    assert(args2.hashCode() == args3.hashCode());
  }

 /** 
 *  Used for testing 
 **/ 
  private static void
  testSETATTR3resok(){
    SETATTR3resok resok1 = null;
    SETATTR3resok resok2 = null;
    SETATTR3resok resok3 = null;
    NFS_wcc_data data1 = null;
    NFS_wcc_data data2 = null;
    NFS_pre_op_attr pre_attr1 = null;
    NFS_pre_op_attr pre_attr2 = null;
    NFS_post_op_attr post_attr1 = null;

    // Test 1
    pre_attr1 = new NFS_pre_op_attr(true,
                                    new
                                    NFS_wcc_attr(54,
                                                 new NFS_nfstime3(78, 80),
                                                 new NFS_nfstime3(23, 12)));
    post_attr1 = new NFS_post_op_attr(true,
                                      new NFS_fattr3(NFS_ftype3.NF3REG,
                                                     36,
                                                     63,
                                                     71,
                                                     85,
                                                     (72L << 32) + 83L,
                                                     (81L << 32) + 66L,
                                                     new NFS_specdata3(55, 49),
                                                     (22L << 32) + 68L,
                                                     (99L << 32) + 163L,
                                                     new NFS_nfstime3(43, 7),
                                                     new NFS_nfstime3(31, 48),
                                                     new NFS_nfstime3(12, 8)));
    data1 = new NFS_wcc_data(pre_attr1, post_attr1);
    resok1 = new SETATTR3resok(data1);
    assert(resok1.getObjWCC().equals(data1));
    assert(resok1.equals(resok1));

    // Test 2
    pre_attr2 = new NFS_pre_op_attr(true,
                                    new
                                    NFS_wcc_attr(4563,
                                                 new NFS_nfstime3(78, 80),
                                                 new NFS_nfstime3(23, 12)));
    data2 = new NFS_wcc_data(pre_attr2, post_attr1);
    resok2 = new SETATTR3resok(data2);
    assert(resok2.getObjWCC().equals(data2));
    assert(resok2.equals(resok2));
    assert(!resok2.equals(resok1));
    assert(!resok1.equals(resok2));
    assert(resok2.hashCode() != resok1.hashCode());

    // Test 3
    resok3 = new SETATTR3resok(data1);
    assert(resok3.getObjWCC().equals(data1));
    assert(resok3.equals(resok3));
    assert(resok3.equals(resok1));
    assert(resok1.equals(resok3));
    assert(!resok3.equals(resok2));
    assert(!resok2.equals(resok3));
    assert(resok3.hashCode() == resok1.hashCode());
    assert(resok3.hashCode() != resok2.hashCode());
  }

 /** 
 *  Used for testing 
 *  Note: Same tests as for the previous class 
 **/ 
  private static void
  testSETATTR3resfail(){
    SETATTR3resfail resfail1 = null;
    SETATTR3resfail resfail2 = null;
    SETATTR3resfail resfail3 = null;
    NFS_wcc_data data1 = null;
    NFS_wcc_data data2 = null;
    NFS_pre_op_attr pre_attr1 = null;
    NFS_post_op_attr post_attr1 = null;
    NFS_post_op_attr post_attr2 = null;

    // Test 1
    pre_attr1 = new NFS_pre_op_attr(true,
                                    new
                                    NFS_wcc_attr(54,
                                                 new NFS_nfstime3(78, 80),
                                                 new NFS_nfstime3(23, 12)));
    post_attr1 = new NFS_post_op_attr(true,
                                      new NFS_fattr3(NFS_ftype3.NF3REG,
                                                     36,
                                                     63,
                                                     71,
                                                     85,
                                                     (72L << 32) + 83L,
                                                     (81L << 32) + 66L,
                                                     new NFS_specdata3(55, 49),
                                                     (22L << 32) + 68L,
                                                     (99L << 32) + 163L,
                                                     new NFS_nfstime3(43, 7),
                                                     new NFS_nfstime3(31, 48),
                                                     new NFS_nfstime3(12, 8)));
    data1 = new NFS_wcc_data(pre_attr1, post_attr1);
    resfail1 = new SETATTR3resfail(data1);
    assert(resfail1.getObjWCC().equals(data1));
    assert(resfail1.equals(resfail1));

    // Test 2
    post_attr2 = new NFS_post_op_attr(true,
                                      new NFS_fattr3(NFS_ftype3.NF3REG,
                                                     46,
                                                     63,
                                                     71,
                                                     85,
                                                     (72L << 32) + 83L,
                                                     (81L << 32) + 66L,
                                                     new NFS_specdata3(55, 49),
                                                     (22L << 32) + 68L,
                                                     (99L << 32) + 163L,
                                                     new NFS_nfstime3(43, 7),
                                                     new NFS_nfstime3(31, 48),
                                                     new NFS_nfstime3(12, 8)));
    data2 = new NFS_wcc_data(pre_attr1, post_attr2);
    resfail2 = new SETATTR3resfail(data2);
    assert(resfail2.getObjWCC().equals(data2));
    assert(resfail2.equals(resfail2));
    assert(!resfail2.equals(resfail1));
    assert(!resfail1.equals(resfail2));
    assert(resfail2.hashCode() != resfail1.hashCode());

    // Test 3
    resfail3 = new SETATTR3resfail(data1);
    assert(resfail3.getObjWCC().equals(data1));
    assert(resfail3.equals(resfail3));
    assert(resfail3.equals(resfail1));
    assert(resfail1.equals(resfail3));
    assert(!resfail3.equals(resfail2));
    assert(!resfail2.equals(resfail3));
    assert(resfail3.hashCode() == resfail1.hashCode());
    assert(resfail3.hashCode() != resfail2.hashCode());
  }

 /** 
 *  Used for testing 
 **/ 
  private static void
  testSETATTR3res(){
    SETATTR3res res1 = null;
    SETATTR3res res2 = null;
    SETATTR3res res3 = null;
    SETATTR3resok resok = null;
    SETATTR3resfail resfail = null;
    NFS_wcc_data data = null;
    NFS_pre_op_attr pre_attr = null;
    NFS_post_op_attr post_attr = null;

    // Test 1
    pre_attr = new NFS_pre_op_attr(true,
                                   new
                                   NFS_wcc_attr(54,
                                                new NFS_nfstime3(78, 80),
                                                new NFS_nfstime3(23, 12)));
    post_attr = new NFS_post_op_attr(true,
                                     new NFS_fattr3(NFS_ftype3.NF3REG,
                                                    36,
                                                    63,
                                                    71,
                                                    85,
                                                    (72L << 32) + 83L,
                                                    (81L << 32) + 66L,
                                                    new NFS_specdata3(55, 49),
                                                    (22L << 32) + 68L,
                                                    (99L << 32) + 163L,
                                                    new NFS_nfstime3(43, 7),
                                                    new NFS_nfstime3(31, 48),
                                                    new NFS_nfstime3(12, 8)));
    data = new NFS_wcc_data(pre_attr, post_attr);
    resok = new SETATTR3resok(data);
    res1 = new SETATTR3res(NFS_nfsstat3.NFS3_OK, resok, null);
    assert(res1.getStatus() == NFS_nfsstat3.NFS3_OK);
    assert(res1.getResOk().equals(resok));
    assert(res1.equals(res1));

    // Test 2
    resfail = new SETATTR3resfail(data);
    res2 = new SETATTR3res(NFS_nfsstat3.NFS3ERR_IO, null, resfail);
    assert(res2.getStatus() == NFS_nfsstat3.NFS3ERR_IO);
    assert(res2.getResFail().equals(resfail));
    assert(res2.equals(res2));
    assert(!res2.equals(res1));
    assert(!res1.equals(res2));
    assert(res2.hashCode() != res1.hashCode());

    // Test 3
    resok = new SETATTR3resok(data);
    res3 = new SETATTR3res(NFS_nfsstat3.NFS3_OK, resok, null);
    assert(res3.getStatus() == NFS_nfsstat3.NFS3_OK);
    assert(res3.getResOk().equals(resok));
    assert(res3.equals(res3));
    assert(res3.equals(res1));
    assert(res1.equals(res3));
    assert(!res3.equals(res2));
    assert(!res2.equals(res3));
    assert(res3.hashCode() == res1.hashCode());
    assert(res3.hashCode() != res2.hashCode());
  }
}

 /** 
 *  $Log: SETATTR3.java,v $ 
 *  Revision 1.1  2006/06/12 20:07:20  nayate 
 *  First version of the Java NFS library 
 *  
 **/ 
