 /** 
 *  Store the NFS file attribute data structure 
 **/ 

 /** 
 *  Represent the data stored for a symbolic link 
 **/ 
class NFS_symlinkdata3{

 /** 
 *  Data members 
 **/ 
  private final NFS_sattr3 symlinkAttributes;
  private final String symlinkData;

 /** 
 *  Constructor 
 **/ 
  public
  NFS_symlinkdata3(NFS_sattr3 newSymlinkAttributes, String newSymlinkData){
    this.symlinkAttributes = newSymlinkAttributes;
    this.symlinkData = newSymlinkData;
  }

 /** 
 *  Return the attributes 
 **/ 
  public NFS_sattr3
  getSymlinkAttributes(){
    return(this.symlinkAttributes);
  }

 /** 
 *  Return the data 
 **/ 
  public String
  getSymlinkData(){
    return(this.symlinkData);
  }

 /** 
 *  Return true if "obj" equals "this" 
 **/ 
  public final boolean
  equals(Object obj){
    NFS_symlinkdata3 data = null;
    boolean eq = false;

    // 2 Java-declared fields, 2 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 4);
    if(obj instanceof NFS_symlinkdata3){
      data = (NFS_symlinkdata3)obj;
      eq = (this.symlinkAttributes.equals(data.symlinkAttributes) &&
            this.symlinkData.equals(data.symlinkData));
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Compute and return a hashcode for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 2 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 4);
    code = this.symlinkAttributes.hashCode() ^ this.symlinkData.hashCode();
    return(code);
  }
}

 /** 
 *  Represent the arguments to the SYMLINK3 NFS 3 call 
 **/ 
class SYMLINK3args{

 /** 
 *  Data members 
 **/ 
  private final NFS_diropargs3 where;
  private final NFS_symlinkdata3 symlink;

 /** 
 *  Constructor 
 **/ 
  public
  SYMLINK3args(NFS_diropargs3 newWhere, NFS_symlinkdata3 newSymlink){
    this.where = newWhere;
    this.symlink = newSymlink;
  }

 /** 
 *  Return the directory operation arguments 
 **/ 
  public NFS_diropargs3
  getWhere(){
    return(this.where);
  }

 /** 
 *  Return the symlink data 
 **/ 
  public NFS_symlinkdata3
  getSymlink(){
    return(this.symlink);
  }
 /** 
 *  Return true if "obj" equals "this" 
 **/ 
  public final boolean
  equals(Object obj){
    SYMLINK3args args = null;
    boolean eq = false;

    // 2 Java-declared fields, 2 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 4);
    if(obj instanceof SYMLINK3args){
      args = (SYMLINK3args)obj;
      eq = this.where.equals(args.where) && this.symlink.equals(args.symlink);
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Compute and return a hashcode for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 2 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 4);
    code = this.where.hashCode() ^ this.symlink.hashCode();
    return(code);
  }
}

 /** 
 *  Store the results of the SYMLINK NFS 3 call if successful 
 **/ 
class SYMLINK3resok{

 /** 
 *  Data members 
 **/ 
  private final NFS_post_op_fh3 obj;
  private final NFS_post_op_attr objAttributes;
  private final NFS_wcc_data dirWCC;

 /** 
 *  Constructor 
 **/ 
  public
  SYMLINK3resok(NFS_post_op_fh3 newObj, 
                NFS_post_op_attr newObjAttributes,
                NFS_wcc_data newDirWCC){
    this.obj = newObj;
    this.objAttributes = newObjAttributes;
    this.dirWCC = newDirWCC;
  }

 /** 
 *  (Possibly) return the object handle 
 **/ 
  public NFS_post_op_fh3
  getObj(){
    return(this.obj);
  }

 /** 
 *  (Possibly) return the object attributes 
 **/ 
  public NFS_post_op_attr
  getObjAttributes(){
    return(this.objAttributes);
  }

 /** 
 *  (Possibly) return the directory weak-cache-consistency data 
 **/ 
  public NFS_wcc_data
  getDirWCC(){
    return(this.dirWCC);
  }

 /** 
 *  Return true if "obj" equals "this" 
 **/ 
  public final boolean
  equals(Object obj){
    SYMLINK3resok resok = null;
    boolean eq = false;

    // 2 Java-declared fields, 3 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 5);
    if(obj instanceof SYMLINK3resok){
      resok = (SYMLINK3resok)obj;
      eq = (this.obj.equals(resok.obj) &&
            this.objAttributes.equals(resok.objAttributes) &&
            this.dirWCC.equals(resok.dirWCC));
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Compute and return a hashcode for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 3 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 5);
    code = (this.obj.hashCode() ^
            this.objAttributes.hashCode() ^
            this.dirWCC.hashCode());
    return(code);
  }
}

 /** 
 *  Store the results of the SYMLINK NFS 3 call if unsuccessful 
 **/ 
class SYMLINK3resfail{

 /** 
 *  Data member 
 **/ 
  private final NFS_wcc_data dirWCC;

 /** 
 *  Constructor 
 **/ 
  public
  SYMLINK3resfail(NFS_wcc_data newDirWCC){
    this.dirWCC = newDirWCC;
  }

 /** 
 *  Return the directory weak-cache-consistency data 
 **/ 
  public NFS_wcc_data
  getDirWCC(){
    return(this.dirWCC);
  }

 /** 
 *  Return true if "obj" equals "this" 
 **/ 
  public final boolean
  equals(Object obj){
    SYMLINK3resfail resfail = null;
    boolean eq = false;

    // 2 Java-declared fields, 1 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 3);
    if(obj instanceof SYMLINK3resfail){
      resfail = (SYMLINK3resfail)obj;
      eq = this.dirWCC.equals(resfail.dirWCC);
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Compute and return a hashcode for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 1 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 3);
    code = this.dirWCC.hashCode();
    return(code);
  }
}

 /** 
 *  Store the results of the SYMLINK NFS 3 call 
 **/ 
class SYMLINK3res{

 /** 
 *  Data members 
 **/ 
  private final int status;
  private final SYMLINK3resok resok;
  private final SYMLINK3resfail resfail;

 /** 
 *  Constructor 
 **/ 
  public
  SYMLINK3res(int newStatus,
              SYMLINK3resok newResOk,
              SYMLINK3resfail newResFail){
    this.status = newStatus;
    this.resok = newResOk;
    this.resfail = newResFail;
  }

 /** 
 *  Return the status 
 **/ 
  public int
  getStatus(){
    return(this.status);
  }

 /** 
 *  Return the result of the operation if successful 
 **/ 
  public SYMLINK3resok
  getResOk(){
    assert(this.status == NFS_nfsstat3.NFS3_OK);
    return(this.resok);
  }

 /** 
 *  Return the result of the operation if unsuccessful 
 **/ 
  public SYMLINK3resfail
  getResFail(){
    assert(this.status != NFS_nfsstat3.NFS3_OK);
    return(this.resfail);
  }

 /** 
 *  Return true if "obj" equals "this" 
 **/ 
  public boolean
  equals(Object obj){
    boolean eq = false;
    SYMLINK3res res = null;

    // 2 Java-declared fields, 3 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 5);
    if(obj instanceof SYMLINK3res){
      res = (SYMLINK3res)obj;
      if(this.status == res.status){
        if(this.status == NFS_nfsstat3.NFS3_OK){
          eq = this.resok.equals(res.resok);
        }else{
          eq = this.resfail.equals(resfail);
        }
      }else{
        eq = false;
      }
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Return a hash code for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 3 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 5);
    if(this.status == NFS_nfsstat3.NFS3_OK){
      code = (new Integer(this.status)).hashCode() ^ this.resok.hashCode();
    }else{
      code = (new Integer(this.status)).hashCode() ^ this.resfail.hashCode();
    }
    return(code);
  }
}

 /** 
 *  Used for testing 
 **/ 
public class SYMLINK3{

 /** 
 *  Used for testing 
 **/ 
  public static void
  main(String[] argv){
    Env.verifyAssertEnabled();
    System.err.println("SYMLINK3 self test...");
    SYMLINK3.testNFS_symlinkdata3();
    SYMLINK3.testSYMLINK3args();
    SYMLINK3.testSYMLINKresok();
    SYMLINK3.testSYMLINKresfail();
    SYMLINK3.testSYMLINKres();
    System.err.println("...SYMLINK3 self test succeeds");
    System.exit(0);
  }

 /** 
 *  Test the NFS_symlinkdata3 class 
 **/ 
  public static void
  testNFS_symlinkdata3(){
    NFS_symlinkdata3 data1 = null;
    NFS_symlinkdata3 data2 = null;
    NFS_symlinkdata3 data3 = null;
    NFS_sattr3 sattr = null;

    // Test 1
    sattr = new NFS_sattr3(new NFS_set_mode3(true, 53),
                           new NFS_set_uid3(false, 2),
                           new NFS_set_gid3(true, 11),
                           new NFS_set_size3(true, (1L << 32) + 58L),
                           new NFS_set_atime(NFS_time_how.DONT_CHANGE,
                                             new NFS_nfstime3(66, 67)),
                           new NFS_set_mtime(NFS_time_how.SET_TO_CLIENT_TIME,
                                             new NFS_nfstime3(5, 15)));
    data1 = new NFS_symlinkdata3(sattr, "a");
    assert(data1.getSymlinkAttributes().equals(sattr));
    assert(data1.getSymlinkData().equals("a"));
    assert(data1.equals(data1));

    // Test 2
    data2 = new NFS_symlinkdata3(sattr, "b");
    assert(data2.getSymlinkAttributes().equals(sattr));
    assert(data2.getSymlinkData().equals("b"));
    assert(data2.equals(data2));
    assert(!data2.equals(data1));
    assert(!data1.equals(data2));
    assert(data2.hashCode() != data1.hashCode());

    // Test 3
    data3 = new NFS_symlinkdata3(sattr, "a");
    assert(data3.getSymlinkAttributes().equals(sattr));
    assert(data3.getSymlinkData().equals("a"));
    assert(data3.equals(data3));
    assert(data3.equals(data1));
    assert(data1.equals(data3));
    assert(!data3.equals(data2));
    assert(!data2.equals(data3));
    assert(data3.hashCode() == data1.hashCode());
    assert(data3.hashCode() != data2.hashCode());
  }

 /** 
 *  Test the SYMLINK3args class 
 **/ 
  public static void
  testSYMLINK3args(){
    SYMLINK3args args1 = null;
    SYMLINK3args args2 = null;
    SYMLINK3args args3 = null;
    NFS_diropargs3 dirOpArgs1 = null;
    NFS_diropargs3 dirOpArgs2 = null;
    NFS_sattr3 sattr = null;

    // Test 1
    dirOpArgs1 = new NFS_diropargs3(NFS_nfs_fh3.makeAllZeroHandle(), "a");
    sattr = new NFS_sattr3(new NFS_set_mode3(true, 53),
                           new NFS_set_uid3(false, 2),
                           new NFS_set_gid3(true, 11),
                           new NFS_set_size3(true, (1L << 32) + 58L),
                           new NFS_set_atime(NFS_time_how.DONT_CHANGE,
                                             new NFS_nfstime3(66, 67)),
                           new NFS_set_mtime(NFS_time_how.SET_TO_CLIENT_TIME,
                                             new NFS_nfstime3(5, 15)));
    args1 = new SYMLINK3args(dirOpArgs1, new NFS_symlinkdata3(sattr, "a"));
    assert(args1.getWhere().equals(dirOpArgs1));
    assert(args1.getSymlink().equals(new NFS_symlinkdata3(sattr, "a")));
    assert(args1.equals(args1));

    // Test 2
    dirOpArgs2 = new NFS_diropargs3(NFS_nfs_fh3.makeAllZeroHandle(), "c");
    args2 = new SYMLINK3args(dirOpArgs2, new NFS_symlinkdata3(sattr, "b"));
    assert(args2.getWhere().equals(dirOpArgs2));
    assert(args2.getSymlink().equals(new NFS_symlinkdata3(sattr, "b")));
    assert(args2.equals(args2));
    assert(!args2.equals(args1));
    assert(!args1.equals(args2));
    assert(args2.hashCode() != args1.hashCode());

    // Test 3
    args3 = new SYMLINK3args(dirOpArgs1, new NFS_symlinkdata3(sattr, "a"));
    assert(args3.getWhere().equals(dirOpArgs1));
    assert(args3.getSymlink().equals(new NFS_symlinkdata3(sattr, "a")));
    assert(args3.equals(args3));
    assert(args3.equals(args1));
    assert(args1.equals(args3));
    assert(!args3.equals(args2));
    assert(!args2.equals(args3));
    assert(args3.hashCode() == args1.hashCode());
    assert(args3.hashCode() != args2.hashCode());
  }

 /** 
 *  Test the SYMLINK3resok class 
 **/ 
  public static void 
  testSYMLINKresok(){
    SYMLINK3resok resok1 = null;
    SYMLINK3resok resok2 = null;
    SYMLINK3resok resok3 = null;
    NFS_wcc_data wccData = null;
    NFS_pre_op_attr preAttr1 = null;
    NFS_pre_op_attr preAttr2 = null;

    // Test 1
    preAttr1 = new NFS_pre_op_attr(true,
                                   new NFS_wcc_attr(10,
                                                    new NFS_nfstime3(1, 2),
                                                    new NFS_nfstime3(3, 4)));
    resok1 = new SYMLINK3resok(new NFS_post_op_fh3(false, null),
                               new NFS_post_op_attr(false, null),
                               new NFS_wcc_data(preAttr1,
                                                new NFS_post_op_attr(false,
                                                                     null)));
    assert(resok1.getObj().equals(new NFS_post_op_fh3(false, null)));
    assert(resok1.getObjAttributes().equals(new NFS_post_op_attr(false,
                                                                 null)));
    assert(resok1.getDirWCC().equals(new
                                     NFS_wcc_data(preAttr1,
                                                  new
                                                  NFS_post_op_attr(false,
                                                                   null))));
    assert(resok1.equals(resok1));

    // Test 2
    preAttr2 = new NFS_pre_op_attr(true,
                                   new NFS_wcc_attr(20,
                                                    new NFS_nfstime3(1, 2),
                                                    new NFS_nfstime3(3, 4)));
    resok2 = new SYMLINK3resok(new NFS_post_op_fh3(false, null),
                               new NFS_post_op_attr(false, null),
                               new NFS_wcc_data(preAttr2,
                                                new NFS_post_op_attr(false,
                                                                     null)));
    assert(resok2.getObj().equals(new NFS_post_op_fh3(false, null)));
    assert(resok2.getObjAttributes().equals(new NFS_post_op_attr(false,
                                                                 null)));
    assert(resok2.getDirWCC().equals(new
                                     NFS_wcc_data(preAttr2,
                                                  new
                                                  NFS_post_op_attr(false,
                                                                   null))));
    assert(resok2.equals(resok2));
    assert(!resok2.equals(resok1));
    assert(!resok1.equals(resok2));
    assert(resok2.hashCode() != resok1.hashCode());

    // Test 3
    resok3 = new SYMLINK3resok(new NFS_post_op_fh3(false, null),
                               new NFS_post_op_attr(false, null),
                               new NFS_wcc_data(preAttr1,
                                                new NFS_post_op_attr(false,
                                                                     null)));
    assert(resok3.getObj().equals(new NFS_post_op_fh3(false, null)));
    assert(resok3.getObjAttributes().equals(new NFS_post_op_attr(false,
                                                                 null)));
    assert(resok3.getDirWCC().equals(new
                                     NFS_wcc_data(preAttr1,
                                                  new
                                                  NFS_post_op_attr(false,
                                                                   null))));
    assert(resok3.equals(resok3));
    assert(resok3.equals(resok1));
    assert(resok1.equals(resok3));
    assert(!resok3.equals(resok2));
    assert(!resok2.equals(resok3));
    assert(resok3.hashCode() == resok1.hashCode());
    assert(resok3.hashCode() != resok2.hashCode());
  }

 /** 
 *  Test the SYMLINK3resfail class 
 **/ 
  public static void 
  testSYMLINKresfail(){
    SYMLINK3resfail resfail1 = null;
    SYMLINK3resfail resfail2 = null;
    SYMLINK3resfail resfail3 = null;
    NFS_pre_op_attr preAttr1 = null;
    NFS_pre_op_attr preAttr2 = null;
    NFS_post_op_attr postAttr = null;

    // Test 1
    preAttr1 = new NFS_pre_op_attr(false, null);
    postAttr = new NFS_post_op_attr(false, null);
    resfail1 = new SYMLINK3resfail(new NFS_wcc_data(preAttr1, postAttr));
    assert(resfail1.getDirWCC().equals(new NFS_wcc_data(preAttr1, postAttr)));
    assert(resfail1.equals(resfail1));

    // Test 2
    preAttr2 = new NFS_pre_op_attr(true,
                                   new
                                   NFS_wcc_attr(5000,
                                                new NFS_nfstime3(78, 80),
                                                new NFS_nfstime3(23, 12)));
    resfail2 = new SYMLINK3resfail(new NFS_wcc_data(preAttr2, postAttr));
    assert(resfail2.getDirWCC().equals(new NFS_wcc_data(preAttr2, postAttr)));
    assert(resfail2.equals(resfail2));
    assert(!resfail2.equals(resfail1));
    assert(!resfail1.equals(resfail2));
    assert(resfail2.hashCode() != resfail1.hashCode());

    // Test 3
    preAttr1 = new NFS_pre_op_attr(false, null);
    postAttr = new NFS_post_op_attr(false, null);
    resfail3 = new SYMLINK3resfail(new NFS_wcc_data(preAttr1, postAttr));
    assert(resfail3.getDirWCC().equals(new NFS_wcc_data(preAttr1, postAttr)));
    assert(resfail3.equals(resfail3));
    assert(resfail3.equals(resfail1));
    assert(resfail1.equals(resfail3));
    assert(!resfail3.equals(resfail2));
    assert(!resfail2.equals(resfail3));
    assert(resfail3.hashCode() == resfail1.hashCode());
    assert(resfail3.hashCode() != resfail2.hashCode());
  }

 /** 
 *  Test the SYMLINK3res class 
 **/ 
  public static void 
  testSYMLINKres(){
    SYMLINK3res res1 = null;
    SYMLINK3res res2 = null;
    SYMLINK3res res3 = null;
    SYMLINK3resok resok = null;
    SYMLINK3resfail resfail = null;
    NFS_pre_op_attr preAttr = null;

    // Test 1
    preAttr = new NFS_pre_op_attr(true,
                                  new NFS_wcc_attr(10,
                                                   new NFS_nfstime3(1, 2),
                                                   new NFS_nfstime3(3, 4)));
    resok = new SYMLINK3resok(new NFS_post_op_fh3(false, null),
                              new NFS_post_op_attr(false, null),
                              new NFS_wcc_data(preAttr,
                                               new NFS_post_op_attr(false,
                                                                    null)));
    res1 = new SYMLINK3res(NFS_nfsstat3.NFS3_OK, resok, null);
    assert(res1.getStatus() == NFS_nfsstat3.NFS3_OK);
    assert(res1.getResOk().equals(resok));
    assert(res1.equals(res1));

    // Test 2
    resfail = new
      SYMLINK3resfail(new NFS_wcc_data(new NFS_pre_op_attr(false, null),
                                       new NFS_post_op_attr(false, null)));
    res2 = new SYMLINK3res(NFS_nfsstat3.NFS3ERR_IO, null, resfail);
    assert(res2.getStatus() == NFS_nfsstat3.NFS3ERR_IO);
    assert(res2.getResFail().equals(resfail));
    assert(res2.equals(res2));
    assert(!res2.equals(res1));
    assert(!res1.equals(res2));
    assert(res2.hashCode() != res1.hashCode());

    // Test 3
    res3 = new SYMLINK3res(NFS_nfsstat3.NFS3_OK, resok, null);
    assert(res3.getStatus() == NFS_nfsstat3.NFS3_OK);
    assert(res3.getResOk().equals(resok));
    assert(res3.equals(res3));
    assert(res3.equals(res1));
    assert(res1.equals(res3));
    assert(!res3.equals(res2));
    assert(!res2.equals(res3));
    assert(res3.hashCode() == res1.hashCode());
    assert(res3.hashCode() != res2.hashCode());
  }
}
