package code;
 /** 
 *  Exception that is thrown when searching for non-existant handles 
 **/ 

public class BadFileHandleException extends Exception{

 /** 
 *  Data members 
 **/ 
  private final String msg;

 /** 
 *  Constructor 
 **/ 
  public
  BadFileHandleException(String newMsgString){
    this.msg = newMsgString;
  }

 /** 
 *  Return the message string 
 **/ 
  public String
  getMsg(){
    return(this.msg);
  }

 /** 
 *  Return true if "obj" equals "this" (note: currently unimplemented) 
 **/ 
  public final boolean
  equals(Object obj){
    boolean eq = false;
    BadFileHandleException bfhe = null;

    // 2 Java-declared fields, 1 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 3);
    if(obj instanceof BadFileHandleException){
      bfhe = (BadFileHandleException)obj;
      eq = this.msg.equals(bfhe.msg);
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Compute and return a hashcode for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 1 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 3);
    code = this.msg.hashCode();

    return(code);
  }

 /** 
 *  Used for testing 
 **/ 
  public static void
  main(String[] argv){
    Env.verifyAssertEnabled();
    System.out.println("Testing BadFileHandleException.java...");
    BadFileHandleException.testSimple();
    System.out.println("...BadFileHandleException");
  }

 /** 
 *  Test the class 
 **/ 
  private static void
  testSimple(){
    BadFileHandleException bfhe1 = null;
    BadFileHandleException bfhe2 = null;
    BadFileHandleException bfhe3 = null;

    // Test 1
    bfhe1 = new BadFileHandleException("asdf");
    assert(bfhe1.getMsg().equals("asdf"));
    assert(bfhe1.equals(bfhe1));

    // Test 2
    bfhe2 = new BadFileHandleException("abcd");
    assert(bfhe2.getMsg().equals("abcd"));
    assert(bfhe2.equals(bfhe2));
    assert(!bfhe2.equals(bfhe1));
    assert(!bfhe1.equals(bfhe2));
    assert(bfhe2.hashCode() != bfhe1.hashCode());

    // Test 3
    bfhe3 = new BadFileHandleException("asdf");
    assert(bfhe3.getMsg().equals("asdf"));
    assert(bfhe3.equals(bfhe3));
    assert(bfhe3.equals(bfhe1));
    assert(bfhe1.equals(bfhe3));
    assert(!bfhe3.equals(bfhe2));
    assert(!bfhe2.equals(bfhe3));
    assert(bfhe3.hashCode() == bfhe1.hashCode());
    assert(bfhe3.hashCode() != bfhe2.hashCode());
  }
}