package code;
 /** 
 *  FSWriteEntry: Used to represent a single write event that is part 
 *  of a transaction of writes for the NFS interface 
 *   
 *   Similar to MultiWriteEntry but does not include any bound or  
 *   priority  parameter 
 **/ 

import java.io.*;

public class FSWriteEntry implements Immutable, Serializable {
  final ObjInvalTarget oit;
  final ImmutableBytes ib;
  final boolean delete;

 /** 
 *  Constructor 
 **/ 
  public
  FSWriteEntry(final ObjId objId,
               final long offset,
               final long length,
               final ImmutableBytes newIB,
               final boolean newDelete){
    this.oit = new ObjInvalTarget(objId, offset, length);
    this.ib = newIB;
    this.delete = newDelete;
  }

 /** 
 *  Return the ObjInvalTarget 
 **/ 
  public final ObjInvalTarget
  getObjInvalTarget(){
    return(this.oit);
  }

 /** 
 *  Return the data 
 **/ 
  public final ImmutableBytes
  getImmutableBytes(){
    return(this.ib);
  }

 /** 
 *  Return true if this entry is for a delete 
 **/ 
  public final boolean
  getDelete(){
    return(this.delete);
  }

 /** 
 *  Return a hash code for this object (note: not implemented) 
 **/ 
  public final int
  hashCode(){
    System.err.println("FSWriteEntry.hashCode() not implemented");
    assert(false);
    return(0);
  }

 /** 
 *  Return true if this equals "obj" 
 **/ 
  public final boolean
  equals(Object obj){
    boolean result = false;
    FSWriteEntry fwe = null;

    if(obj instanceof FSWriteEntry){
      fwe = (FSWriteEntry)obj;
      result = ((this.oit.equals(fwe.oit)) &&
                (this.ib.equals(fwe.ib)) &&
                (this.delete == fwe.delete));
    }else{
      result = false;
    }
    return(result);
  }
}

 /** 
/* $Log: FSWriteEntry.java,v $
/* Revision 1.2  2007/01/21 19:23:19  nalini
/* ChainReplication works with NFS -- needed change NFSlib so that chainRep node makes root locally
/*
/* Revision 1.1  2007/01/10 22:29:08  nalini
/* add FSWriteEntry
/*
*/
 **/ 
