package code;
 /** 
 *  Implement the Java version of the NFS loopback server interface 
 **/ 
public interface NFS2FS{

 /** 
 *  Implement the GETATTR NFS method 
 **/ 
  public attrstat
  getAttributes(fhandle fh);

 /** 
 *  Implement the SETATTR NFS method 
 **/ 
  public attrstat
  setAttributes(sattrargs args);

 /** 
 *  Implement the NFS ROOT method 
 *  
 *  Note: This method is now obsolete 
 **/ 
  public void
  root();

 /** 
 *  Implement the LOOKUP NFS method 
 **/ 
  public diropres
  lookup(diropargs args);

 /** 
 *  Implement the READLINK NFS method 
 **/ 
  public readlinkres
  readlink(fhandle fh);

 /** 
 *  Implement the READ NFS method 
 **/ 
  public readres
  read(readargs args);

 /** 
 *  Implement the WRITECACHE NFS method 
 *  
 *  Note: This method is now obsolete 
 **/ 
  public void
  writeCache();

 /** 
 *  Implement the WRITE NFS method 
 **/ 
  public attrstat
  write(fhandle file,
        long beginOffset,
        long offset,
        long totalCount,
        byte[] data);

 /** 
 *  Implement the CREATE NFS method 
 **/ 
  public diropres
  create(createargs args);

 /** 
 *  Implement the REMOVE NFS method 
 **/ 
  public int
  remove(diropargs args);

 /** 
 *  Implement the RENAME NFS method 
 **/ 
  public int
  rename(renameargs args);

 /** 
 *  Implement the LINK NFS method 
 **/ 
  public int
  link(linkargs args);

 /** 
 *  Implement the SYMLINK NFS method 
 **/ 
  public int
  symlink(symlinkargs args);

 /** 
 *  Implement the MKDIR NFS method 
 **/ 
  public diropres
  mkdir(createargs args);

 /** 
 *  Implement the RMDIR NFS method 
 **/ 
  public int
  rmdir(diropargs args);

 /** 
 *  Implement the READDIR NFS method 
 **/ 
  public readdirres
  readdir(readdirargs args);

 /** 
 *  Implement the FSSTAT NFS method 
 **/ 
  public statfsres
  statfs(fhandle fh);

}
 /** 
/* $Log: NFS2FS.java,v $
/* Revision 1.1  2006/11/01 19:26:46  zjiandan
/* Integrate PangaeaFS and NFS interface.
/* */
 **/ 
