package code;
 /** 
 *  Exception that is thrown when searching for non-existant handles 
 **/ 

public class NotEmptyException extends Exception{

 /** 
 *  Data members 
 **/ 
  private final String msg;

 /** 
 *  Constructor 
 **/ 
  public
  NotEmptyException(String newMsgString){
    this.msg = newMsgString;
  }

 /** 
 *  Return the message string 
 **/ 
  public String
  getMsg(){
    return(this.msg);
  }

 /** 
 *  Return true if "obj" equals "this" (note: currently unimplemented) 
 **/ 
  public final boolean
  equals(Object obj){
    boolean eq = false;
    NotEmptyException nee = null;

    // 2 Java-declared fields, 1 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 3);
    if(obj instanceof NotEmptyException){
      nee = (NotEmptyException)obj;
      eq = this.msg.equals(nee.msg);
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Compute and return a hashcode for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 1 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 3);
    code = this.msg.hashCode();

    return(code);
  }

 /** 
 *  Used for testing 
 **/ 
  public static void
  main(String[] argv){
    Env.verifyAssertEnabled();
    System.out.println("Testing NotEmptyException.java...");
    NotEmptyException.testSimple();
    System.out.println("...NotEmptyException");
  }

 /** 
 *  Test the class 
 **/ 
  private static void
  testSimple(){
    NotEmptyException nee1 = null;
    NotEmptyException nee2 = null;
    NotEmptyException nee3 = null;

    // Test 1
    nee1 = new NotEmptyException("asdf");
    assert(nee1.getMsg().equals("asdf"));
    assert(nee1.equals(nee1));

    // Test 2
    nee2 = new NotEmptyException("abcd");
    assert(nee2.getMsg().equals("abcd"));
    assert(nee2.equals(nee2));
    assert(!nee2.equals(nee1));
    assert(!nee1.equals(nee2));
    assert(nee2.hashCode() != nee1.hashCode());

    // Test 3
    nee3 = new NotEmptyException("asdf");
    assert(nee3.getMsg().equals("asdf"));
    assert(nee3.equals(nee3));
    assert(nee3.equals(nee1));
    assert(nee1.equals(nee3));
    assert(!nee3.equals(nee2));
    assert(!nee2.equals(nee3));
    assert(nee3.hashCode() == nee1.hashCode());
    assert(nee3.hashCode() != nee2.hashCode());
  }
}