package code;
 /** 
 *  Exception that is thrown when re-adding an existing file to a directory 
 **/ 

public class ObjAlreadyPresentException extends Exception{

 /** 
 *  Data members 
 **/ 
  private final String msg;

 /** 
 *  Constructor 
 **/ 
  public
  ObjAlreadyPresentException(String newMsgString){
    this.msg = newMsgString;
  }

 /** 
 *  Return the message string 
 **/ 
  public String
  getMsg(){
    return(this.msg);
  }

 /** 
 *  Return true if "obj" equals "this" (note: currently unimplemented) 
 **/ 
  public final boolean
  equals(Object obj){
    boolean eq = false;
    ObjAlreadyPresentException oape = null;

    // 2 Java-declared fields, 1 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 3);
    if(obj instanceof ObjAlreadyPresentException){
      oape = (ObjAlreadyPresentException)obj;
      eq = this.msg.equals(oape.msg);
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Compute and return a hashcode for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 1 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 3);
    code = this.msg.hashCode();

    return(code);
  }

 /** 
 *  Used for testing 
 **/ 
  public static void
  main(String[] argv){
    Env.verifyAssertEnabled();
    System.out.println("Testing ObjAlreadyPresentException.java...");
    ObjAlreadyPresentException.testSimple();
    System.out.println("...ObjAlreadyPresentException");
  }

 /** 
 *  Test the class 
 **/ 
  private static void
  testSimple(){
    ObjAlreadyPresentException oape1 = null;
    ObjAlreadyPresentException oape2 = null;
    ObjAlreadyPresentException oape3 = null;

    // Test 1
    oape1 = new ObjAlreadyPresentException("asdf");
    assert(oape1.getMsg().equals("asdf"));
    assert(oape1.equals(oape1));

    // Test 2
    oape2 = new ObjAlreadyPresentException("abcd");
    assert(oape2.getMsg().equals("abcd"));
    assert(oape2.equals(oape2));
    assert(!oape2.equals(oape1));
    assert(!oape1.equals(oape2));
    assert(oape2.hashCode() != oape1.hashCode());

    // Test 3
    oape3 = new ObjAlreadyPresentException("asdf");
    assert(oape3.getMsg().equals("asdf"));
    assert(oape3.equals(oape3));
    assert(oape3.equals(oape1));
    assert(oape1.equals(oape3));
    assert(!oape3.equals(oape2));
    assert(!oape2.equals(oape3));
    assert(oape3.hashCode() == oape1.hashCode());
    assert(oape3.hashCode() != oape2.hashCode());
  }
}