package code;
 /** 
 *  Exception that is thrown when looking for a file not in a directory 
 **/ 

public class ObjNotInDirectoryException extends Exception{

 /** 
 *  Data members 
 **/ 
  private final String msg;

 /** 
 *  Constructor 
 **/ 
  public
  ObjNotInDirectoryException(String newMsgString){
    this.msg = newMsgString;
  }

 /** 
 *  Return the message string 
 **/ 
  public String
  getMsg(){
    return(this.msg);
  }

 /** 
 *  Return true if "obj" equals "this" 
 **/ 
  public final boolean
  equals(Object obj){
    boolean eq = false;
    ObjNotInDirectoryException oape = null;

    // 2 Java-declared fields, 1 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 3);
    if(obj instanceof ObjNotInDirectoryException){
      oape = (ObjNotInDirectoryException)obj;
      eq = this.msg.equals(oape.msg);
    }else{
      eq = false;
    }
    return(eq);
  }

 /** 
 *  Compute and return a hashcode for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 1 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 3);
    code = this.msg.hashCode();

    return(code);
  }

 /** 
 *  Used for testing 
 **/ 
  public static void
  main(String[] argv){
    Env.verifyAssertEnabled();
    System.out.println("Testing ObjNotInDirectoryException.java...");
    ObjNotInDirectoryException.testSimple();
    System.out.println("...ObjNotInDirectoryException");
  }

 /** 
 *  Test the class 
 **/ 
  private static void
  testSimple(){
    ObjNotInDirectoryException onide1 = null;
    ObjNotInDirectoryException onide2 = null;
    ObjNotInDirectoryException onide3 = null;

    // Test 1
    onide1 = new ObjNotInDirectoryException("asdf");
    assert(onide1.getMsg().equals("asdf"));
    assert(onide1.equals(onide1));

    // Test 2
    onide2 = new ObjNotInDirectoryException("abcd");
    assert(onide2.getMsg().equals("abcd"));
    assert(onide2.equals(onide2));
    assert(!onide2.equals(onide1));
    assert(!onide1.equals(onide2));
    assert(onide2.hashCode() != onide1.hashCode());

    // Test 3
    onide3 = new ObjNotInDirectoryException("asdf");
    assert(onide3.getMsg().equals("asdf"));
    assert(onide3.equals(onide3));
    assert(onide3.equals(onide1));
    assert(onide1.equals(onide3));
    assert(!onide3.equals(onide2));
    assert(!onide2.equals(onide3));
    assert(onide3.hashCode() == onide1.hashCode());
    assert(onide3.hashCode() != onide2.hashCode());
  }
}