package code;
 /** 
/* PRACTIFSDirEntry.java
 *
 * PRACTI file system directory entry.
 *
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
 **/ 
import java.io.Serializable;

public class PRACTIFSDirEntry implements Serializable, Immutable{
  final private ObjId objIdPrefix;
  final private Object otherItem;
  public PRACTIFSDirEntry(final ObjId objIdPrefix, 
                          final Object otherItem){
    this.objIdPrefix = objIdPrefix;
    this.otherItem = otherItem; 
  }

  public ObjId getObjIdPrefix(){
    return this.objIdPrefix;
  }
  
  public Object getOtherItem(){
    return this.otherItem;
  }

  /*
  public boolean equals(Object obj){
    boolean eq = false;
    assert (this.getClass().getDeclaredFields().length == 4);
    if (obj instanceof PRACTIFSDirEntry){
      PRACTIFSDirEntry en = (PRACTIFSDirEntry)obj;
      eq = this.objIdPrefix.equals(en.getObjIdPrefix()) && this.otherItem.equals(en.getOtherItem());
    }
    return eq;
  }

  //-------------------------------------------------------------------------
  // Compute and return a hashcode for this object
  //-------------------------------------------------------------------------
  public int
  hashCode(){
    int code = 0;

    assert (this.getClass().getDeclaredFields().length == 4);
    code = (this.objIdPrefix.hashCode() ^
            (this.otherItem.hashCode()));
    return(code);
    }
  */
}