package code;
 /** 
/* PRACTIFSFileAttributes.java
 *
 * PRACTI file system file attributes
 *
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
 **/ 
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

public class PRACTIFSFileAttributes extends fattr{
  
  private Object otherAttr;
  public PRACTIFSFileAttributes(long newType,
                                long newMode,
                                long newNlink,
                                long newUID,
                                long newGID,
                                long newSize,
                                long newBlockSize,
                                long newRdev,
                                long newBlocks,
                                long newFsid,
                                long newFileid,
                                timeval newAtime,
                                timeval newMtime,
                                timeval newCtime,
                                Object otherAttr){
    super(newType, newMode,
          newNlink, newUID,
          newGID, newSize,
          newBlockSize, newRdev,
          newBlocks, newFsid,
          newFileid, newAtime,
          newMtime, newCtime);
    this.otherAttr = otherAttr; 
  }
  
 /** 
 *  Constructor 
 **/ 
  public
  PRACTIFSFileAttributes(sattr newAttr,
                         long newType,
                         long newMode,
                         long newNlink,
                         long newUID,
                         long newGID,
                         long newSize,
                         long newBlockSize,
                         long newRdev,
                         long newBlocks,
                         long newFsid,
                         long newFileid,
                         timeval newATime,
                         timeval newMTime,
                         timeval newCtime,
                         Object otherAttr){
    super(newAttr, 
          newType, newMode,
          newNlink, newUID,
          newGID, newSize,
          newBlockSize, newRdev,
          newBlocks, newFsid,
          newFileid, newATime,
          newMTime, newCtime);
    this.otherAttr = otherAttr; 
  }

  public Object getOtherAttr(){
    return this.otherAttr;
  }

  public void setOtherAttr(Object o){
    assert this.otherAttr == null || this.otherAttr.getClass().isInstance(o);
    this.otherAttr = o;   
  }

 /** 
 *  Constructor 
 *  Read this object from the input stream 
 **/ 
  public
  PRACTIFSFileAttributes(InputStream is) throws IOException{
    super(is);
    ObjectInputStream dis = null;
    byte magicNum = (byte)0;

    dis = new ObjectInputStream(is);
    try{
      this.otherAttr = dis.readObject();
    }catch(ClassNotFoundException e){
      //
      // Program bug. Halt and catch fire.
      // 
      e.printStackTrace();
      assert(false);
      System.exit(-1);

    }
    //dis.close();
  }
  
 /** 
 *  Write this object to the OutputStream 
 **/ 
  public void
  toOutputStream(OutputStream os) throws IOException{
    super.toOutputStream(os);
    ObjectOutputStream oos = null;
    oos = new ObjectOutputStream(os);
    oos.writeObject(this.otherAttr);
    //oos.close();
    //oos.flush();
  }

  public final boolean equals(Object obj){
    boolean eq = false;
    assert(this.getClass().getDeclaredFields().length == 3);
    if ((obj instanceof PRACTIFSFileAttributes) && (super.equals(obj))){
      if (this.otherAttr == null){
        if(((PRACTIFSFileAttributes)(obj)).getOtherAttr() == null){
          eq = true;
        }
      }else if (this.otherAttr.equals(((PRACTIFSFileAttributes)(obj)).getOtherAttr())){
        eq = true;
      }
    }
    return eq;
  }

 /** 
 *  Compute and return a hashcode for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 17 super fields and 1 self-declared fields
    assert(this.getClass().getDeclaredFields().length == 3);
    if(this.otherAttr == null){
      code = super.hashCode();
    }else{
      code = (super.hashCode() ^
              (this.otherAttr.hashCode()));
    }
    return(code);
  }
  
 /** 
 *  Used for testing 
 **/ 
  public static void
  main(String[] argv){
    Env.verifyAssertEnabled();
    System.out.println("Testing PRACTIFSFileAttributes.java...");
    testSimple();
    testEqualsHashCode();
    testSerialize();
    System.out.println("...Finished");
  }

 /** 
 *  Run simple tests 
 **/ 
  private static void
  testSimple(){
    PRACTIFSFileAttributes attr1 = null;
    PRACTIFSFileAttributes attr2 = null;
    sattr sat = null;
    ObjId dirPrefix1 = new ObjId("/dir1");
    ObjId dirPrefix2 = new ObjId("/dir2");
    
    // Test get methods
    attr1 = new PRACTIFSFileAttributes(ftype.NFREG,
                                       36,
                                       63,
                                       71,
                                       85,
                                       32,
                                       81,
                                       55,
                                       22,
                                       99,
                                       108,
                                       new timeval(43, 7),
                                       new timeval(31, 48),
                                       new timeval(12, 8), 
                                       dirPrefix1);
    assert(attr1.getType() == ftype.NFREG);
    assert(attr1.getMode() == 36);
    assert(attr1.getNLink() == 63);
    assert(attr1.getUID() == 71);
    assert(attr1.getGID() == 85);
    assert(attr1.getSize() == 32);
    assert(attr1.getBlockSize() == 81);
    assert(attr1.getRDev() == 55);
    assert(attr1.getBlocks() == 22);
    assert(attr1.getFSID() == 99);
    assert(attr1.getFileId() == 108);
    assert(attr1.getATime().equals(new timeval(43, 7)));
    assert(attr1.getMTime().equals(new timeval(31, 48)));
    assert(attr1.getCTime().equals(new timeval(12, 8)));
    assert(attr1.getOtherAttr().equals(new ObjId("/dir1")));

    // Test set methods
    attr1.setMode(48);
    assert(attr1.getMode() == 48);
    attr1.setUID(49);
    assert(attr1.getUID() == 49);
    attr1.setGID(92);
    assert(attr1.getGID() == 92);
    attr1.setSize(23);
    assert(attr1.getSize() == 23);
    attr1.setATime(new timeval(33, 78));
    assert(attr1.getATime().equals(new timeval(33, 78)));
    attr1.setMTime(new timeval(76, 21));
    assert(attr1.getMTime().equals(new timeval(76, 21)));
    attr1.setOtherAttr(dirPrefix2);
    assert(attr1.getOtherAttr().equals(new ObjId("/dir2")));

    
  }

 /** 
 *  Test the equals() method 
 **/ 
  private static void
  testEqualsHashCode(){
    PRACTIFSFileAttributes attr1 = null;
    PRACTIFSFileAttributes attr2 = null;
    PRACTIFSFileAttributes attr3 = null;
    PRACTIFSFileAttributes attr4 = null;
    
    ObjId dirPrefix1 = new ObjId("/dir1");
    ObjId dirPrefix2 = new ObjId("/dir2");

    // Test1: Self comparison
    attr1 = new PRACTIFSFileAttributes(ftype.NFREG,
                                       36,
                                       63,
                                       71,
                                       85,
                                       72,
                                       81,
                                       55,
                                       22,
                                       99,
                                       108,
                                       new timeval(43, 7),
                                       new timeval(31, 48),
                                       new timeval(12, 8),
                                       dirPrefix1);
    assert(attr1.equals(attr1));

    // Test 2: Compare to another, equal object
    attr2 = new PRACTIFSFileAttributes(ftype.NFREG,
                                       36,
                                       63,
                                       71,
                                       85,
                                       72,
                                       81,
                                       55,
                                       22,
                                       99,
                                       108,
                                       new timeval(43, 7),
                                       new timeval(31, 48),
                                       new timeval(12, 8),
                                       dirPrefix1);
    assert(attr2.equals(attr2));
    assert(attr1.equals(attr2));
    assert(attr2.equals(attr1));
    assert(attr1.hashCode() == attr2.hashCode());

    // Test 3: Compare to a (slightly) unequal object
    attr3 = new PRACTIFSFileAttributes(ftype.NFREG,
                                       36,
                                       63,
                                       71,
                                       85,
                                       72,
                                       81,
                                       55,
                                       22,
                                       99,
                                       108,
                                       new timeval(43, 7),
                                       new timeval(31, 48),
                                       new timeval(12, 8),
                                       dirPrefix2);
    assert(!attr1.equals(attr3));
    assert(!attr3.equals(attr1));
    assert(!attr2.equals(attr3));
    assert(!attr3.equals(attr2));
    assert(attr3.hashCode() != attr1.hashCode());
    assert(attr3.hashCode() != attr2.hashCode());
    assert(attr3.equals(attr3));

    // Test 4: test otherAttr = null
    attr4 = new PRACTIFSFileAttributes(ftype.NFREG,
                                       36,
                                       63,
                                       71,
                                       85,
                                       72,
                                       81,
                                       55,
                                       22,
                                       99,
                                       108,
                                       new timeval(43, 7),
                                       new timeval(31, 48),
                                       new timeval(12, 8),
                                       null);
    assert(!attr1.equals(attr4));
    assert(!attr4.equals(attr1));
    assert(!attr3.equals(attr4));
    assert(!attr4.equals(attr3));
    assert(attr4.hashCode() != attr1.hashCode());
    assert(attr4.hashCode() != attr3.hashCode());
    assert(attr4.equals(attr4));

    
  }

 /** 
 *  Test serialization/deserialization 
 **/ 
  private static void
  testSerialize(){
    PRACTIFSFileAttributes fa1 = null;
    PRACTIFSFileAttributes fa2 = null;
    ByteArrayInputStream bais = null;
    ByteArrayOutputStream baos = null;
    ObjId dirPrefix1 = new ObjId("/dir1");
    ObjId dirPrefix2 = null;

    byte[] b = null;

    try{
      // Serialize an object and then de-serialize this
      baos = new ByteArrayOutputStream();
      fa1 = new PRACTIFSFileAttributes(ftype.NFREG,
                                       36,
                                       63,
                                       71,
                                       85,
                                       72,
                                       81,
                                       55,
                                       22,
                                       99,
                                       108,
                                       new timeval(43, 7),
                                       new timeval(31, 48),
                                       new timeval(12, 8),
                                       dirPrefix1);
      fa1.toOutputStream(baos);
      baos.flush();
      b = baos.toByteArray();
      bais = new ByteArrayInputStream(b);
      fa2 = new PRACTIFSFileAttributes(bais);
      assert(fa1.equals(fa2));
      assert(fa2.equals(fa1));
      assert(fa1 != fa2);

      // Serialize an object and then de-serialize this
      baos = new ByteArrayOutputStream();
      fa1 = new PRACTIFSFileAttributes(ftype.NFDIR,
                                       63,
                                       36,
                                       17,
                                       58,
                                       27,
                                       18,
                                       55,
                                       22,
                                       99,
                                       108,
                                       new timeval(34, 70),
                                       new timeval(13, 84),
                                       new timeval(21, 80),
                                       dirPrefix2);
      fa1.toOutputStream(baos);
      baos.flush();
      b = baos.toByteArray();
      bais = new ByteArrayInputStream(b);
      fa2 = new PRACTIFSFileAttributes(bais);
      assert(fa1.equals(fa2));
      assert(fa2.equals(fa1));
      assert(fa1 != fa2);
    }catch(IOException e){
      assert false : ("" + e);
    }
  }
}