package code;
 /** 
 *  Represents a read lock token used by the PRACTI FS local interface 
 **/ 

public class PRACTIFSReadLockToken{

 /** 
 *  Constants 
 **/ 
  private static boolean PRINT_DEBUG = false;

 /** 
 *  Data members 
 **/ 
  protected ObjId objId;
  protected boolean acquired;

 /** 
 *  Constructor 
 **/ 
  public
  PRACTIFSReadLockToken(ObjId newObjId, boolean newAcquired){
    this.objId = newObjId;
    this.acquired = newAcquired;
  }

 /** 
 *  Return whether the lock is acquired 
 **/ 
  public boolean
  isAcquired(){
    return(this.acquired);
  }

 /** 
 *  Set the flag indicating whether this lock is acquired 
 **/ 
  public void
  setIsAcquired(boolean newAcquired){
    this.acquired = newAcquired;
    Env.dprinterrln(PRINT_DEBUG,
                    "PRACTIFSReadLockToken: Setting lock for " + this.objId +
                    " to " + this.acquired +
                    " by " + Thread.currentThread().getName());
  }

 /** 
 *  Return the object ID 
 **/ 
  public ObjId
  getObjId(){
    return(this.objId);
  }

 /** 
 *  Return true if this object equals "obj" 
 **/ 
  public boolean
  equals(Object obj){
    boolean eq = false;

    // A token is an unreplicatable object. Therefore, two tokens are equal
    // if and only if they are the same token
    eq = (this == obj);
    return(eq);
  }

 /** 
 *  Return a hash code for this object 
 **/ 
  public int
  hashCode(){
    int code = 0;

    // 2 Java-declared fields, 3 self-declared fields
    // Note: The line below causes problems with classes that inherit
    // from this one
    //assert(this.getClass().getDeclaredFields().length == 5);
    code = this.objId.hashCode();

    return(code);
  }

 /** 
 *  Used for testing 
 **/ 
  public static void
  main(String[] argv){
    Env.verifyAssertEnabled();
    System.out.println("Testing PRACTIFSReadLockToken.java...");
    PRACTIFSReadLockToken.testSimple();
    System.out.println("...Finished");
  }

 /** 
 *  Run simple tests 
 **/ 
  private static void
  testSimple(){
    PRACTIFSReadLockToken token = null;

    // Test 1
    token = new PRACTIFSReadLockToken(new ObjId(""), true);
    assert(token.isAcquired());
    assert(token.getObjId().equals(new ObjId("")));
    token.setIsAcquired(false);
    assert(!token.isAcquired());
  }
}
