package code;
 /** 
 *  Represent the attrstat NFS2 data structure 
 **/ 

public class attrstat implements Immutable{

 /** 
 *  Data members 
 **/ 
  private final int status;
  private final fattr attributes;

 /** 
 *  Constructor 
 **/ 
  public
  attrstat(int newStatus, fattr newAttributes){
    this.status = newStatus;
    this.attributes = newAttributes;
  }

 /** 
 *  Return the status 
 **/ 
  public int
  getStatus(){
    return(this.status);
  }

 /** 
 *  Return the attributes 
 **/ 
  public fattr
  getAttributes(){
    assert(this.status == stat.NFS_OK);
    return(this.attributes);
  }

 /** 
 *  Return true if "obj" equals "this" (note: currently unimplemented) 
 **/ 
  public final boolean
  equals(Object obj){
    assert false : "Unimplemented";
    return(false);
  }

 /** 
 *  Return a hashcode for this object (note: currently unimplemented) 
 **/ 
  public int
  hashCode(){
    assert false : "Unimplemented";
    return(0);
  }

 /** 
 *  Return a String representation of this object 
 **/ 
  public String
  toString(){
    String str = null;

    if(this.attributes != null){
      str = "(" + this.status + ", " + this.attributes + ")";
    }else{
      str = "(" + this.status + ", <error>)";
    }
    return(str);
  }

 /** 
 *  Used for testing 
 **/ 
  public static void
  main(String[] argv){
    Env.verifyAssertEnabled();
    System.err.println("attrstat self test...");
    attrstat.testSimple();
    System.err.println("...attrstat self test succeeds");
    System.exit(0);
  }

 /** 
 *  Used for testing 
 **/ 
  private static void
  testSimple(){
    attrstat as1 = null;
    attrstat as2 = null;
    fattr attr1 = null;
 
    as1 = new attrstat(stat.NFSERR_IO, null);
    assert(as1.getStatus() == stat.NFSERR_IO);

    attr1 = new fattr(ftype.NFREG,
                      63,
                      36,
                      17,
                      58,
                      27,
                      18,
                      55,
                      22,
                      99,
                      108,
                      new timeval(34, 7),
                      new timeval(13, 84),
                      new timeval(21, 8));
    as2 = new attrstat(stat.NFS_OK, attr1);
    assert(as2.getStatus() == stat.NFS_OK);
    assert(as2.getAttributes().equals(attr1));
    System.out.println("" + as1);
    System.out.println("" + as2);
  }
}

 /** 
 *  $Log: attrstat.java,v $ 
 *  Revision 1.2  2006/11/15 04:44:18  nayate 
 *  Added a toString() method 
 *  
 *  Revision 1.1  2006/07/15 02:54:21  nayate 
 *  Added version 1 of the Java library corresponding to NFS 2 
 *  
 **/ 
