package code;
 /** 
 *  Represent the createargs NFS2 data structure 
 **/ 

class createargs implements Immutable{

 /** 
 *  Data members 
 **/ 
  private final diropargs where;
  private final sattr attributes;

 /** 
 *  Constructor 
 **/ 
  public
  createargs(diropargs newWhere, sattr newAttributes){
    this.where = newWhere;
    this.attributes = newAttributes;
  }

  public String
  toString(){
    return "(diropargs=" + where.toString() + ", attr= " + attributes.toString();
  }
 /** 
 *  Return the directory operations argument 
 **/ 
  public diropargs
  getWhere(){
    return(this.where);
  }

 /** 
 *  Return the attributes 
 **/ 
  public sattr
  getAttributes(){
    return(this.attributes);
  }

 /** 
 *  Return true if "obj" equals "this" (note: currently unimplemented) 
 **/ 
  public final boolean
  equals(Object obj){
    assert false : "Unimplemented";
    return(false);
  }

 /** 
 *  Return a hashcode for this object (note: currently unimplemented) 
 **/ 
  public int
  hashCode(){
    assert false : "Unimplemented";
    return(0);
  }

 /** 
 *  Used for testing 
 **/ 
  public static void
  main(String[] argv){
    Env.verifyAssertEnabled();
    System.err.println("createargs self test...");
    createargs.testSimple();
    System.err.println("...createargs self test succeeds");
    System.exit(0);
  }

 /** 
 *  Used for testing 
 **/ 
  private static void
  testSimple(){
    createargs args1 = null;
    createargs args2 = null;
    sattr attr1 = null;
    diropargs where1 = null;
 
    where1 = new diropargs(fhandle.makeAllZeroHandle(), "abcd");
    attr1 = new sattr(10, 20, 30, 40, new timeval(4, 8), new timeval(1, 2));
    args1 = new createargs(where1, attr1);
    assert(args1.getWhere().equals(new diropargs(fhandle.makeAllZeroHandle(),
                                                 "abcd")));
    assert(args1.getAttributes().equals(new sattr(10,
                                                  20,
                                                  30,
                                                  40,
                                                  new timeval(4, 8),
                                                  new timeval(1, 2))));
  }
}

 /** 
 *  $Log: createargs.java,v $ 
 *  Revision 1.2  2007/02/23 20:54:29  zjiandan 
 *  Fixed mem leak problems in NFS2Interface and some other bugs. 
 *  Andrew benchmark passed, performance still needs to tune. 
 *  
 *  Revision 1.1  2006/07/15 02:54:21  nayate 
 *  Added version 1 of the Java library corresponding to NFS 2 
 *  
 **/ 
